/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.multitenancy;

import java.util.Arrays;
import java.util.Map;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.impl.cfg.multitenancy.TenantIdProvider;
import org.camunda.bpm.engine.impl.cfg.multitenancy.TenantIdProviderCaseInstanceContext;
import org.camunda.bpm.engine.impl.cfg.multitenancy.TenantIdProviderHistoricDecisionInstanceContext;
import org.camunda.bpm.engine.impl.cfg.multitenancy.TenantIdProviderProcessInstanceContext;
import org.camunda.bpm.engine.migration.MigrationPlan;
import org.camunda.bpm.engine.repository.ProcessDefinition;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.test.api.runtime.migration.models.ProcessModels;
import org.camunda.bpm.engine.test.util.ProcessEngineBootstrapRule;
import org.camunda.bpm.engine.test.util.ProcessEngineTestRule;
import org.camunda.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.camunda.bpm.engine.variable.Variables;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;

public class MultiTenancyMigrationTenantProviderTest {
    protected static final String TENANT_ONE = "tenant1";
    protected static final String TENANT_TWO = "tenant2";
    @ClassRule
    public static ProcessEngineBootstrapRule bootstrapRule = new ProcessEngineBootstrapRule(configuration -> {
        VariableBasedTenantIdProvider tenantIdProvider = new VariableBasedTenantIdProvider();
        configuration.setTenantIdProvider((TenantIdProvider)tenantIdProvider);
    });
    protected ProvidedProcessEngineRule engineRule = new ProvidedProcessEngineRule(bootstrapRule);
    protected ProcessEngineTestRule testHelper = new ProcessEngineTestRule(this.engineRule);
    @Rule
    public RuleChain tenantRuleChain = RuleChain.outerRule((TestRule)this.engineRule).around((TestRule)this.testHelper);

    @Test
    public void cannotMigrateInstanceBetweenDifferentTenants() {
        ProcessDefinition sharedDefinition = this.testHelper.deployAndGetDefinition(ProcessModels.ONE_TASK_PROCESS);
        ProcessDefinition tenantDefinition = this.testHelper.deployForTenantAndGetDefinition(TENANT_TWO, ProcessModels.ONE_TASK_PROCESS);
        ProcessInstance processInstance = this.startInstanceForTenant(sharedDefinition, TENANT_ONE);
        MigrationPlan migrationPlan = this.engineRule.getRuntimeService().createMigrationPlan(sharedDefinition.getId(), tenantDefinition.getId()).mapEqualActivities().build();
        try {
            this.engineRule.getRuntimeService().newMigration(migrationPlan).processInstanceIds(Arrays.asList(processInstance.getId())).execute();
            Assert.fail((String)"exception expected");
        }
        catch (ProcessEngineException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)("Cannot migrate process instance '" + processInstance.getId() + "' to a process definition of a different tenant ('tenant1' != 'tenant2')")));
        }
        Assert.assertNotNull((Object)migrationPlan);
    }

    @Test
    public void canMigrateInstanceBetweenSameTenantCase2() {
        ProcessDefinition sharedDefinition = this.testHelper.deployAndGetDefinition(ProcessModels.ONE_TASK_PROCESS);
        ProcessDefinition targetDefinition = this.testHelper.deployForTenantAndGetDefinition(TENANT_ONE, ProcessModels.ONE_TASK_PROCESS);
        ProcessInstance processInstance = this.startInstanceForTenant(sharedDefinition, TENANT_ONE);
        MigrationPlan migrationPlan = this.engineRule.getRuntimeService().createMigrationPlan(sharedDefinition.getId(), targetDefinition.getId()).mapEqualActivities().build();
        this.engineRule.getRuntimeService().newMigration(migrationPlan).processInstanceIds(Arrays.asList(processInstance.getId())).execute();
        this.assertInstanceOfDefinition(processInstance, targetDefinition);
    }

    @Test
    public void canMigrateWithProcessInstanceQueryAllInstancesOfAuthenticatedTenant() {
        ProcessDefinition sourceDefinition = this.testHelper.deployAndGetDefinition(ProcessModels.ONE_TASK_PROCESS);
        ProcessDefinition targetDefinition = this.testHelper.deployAndGetDefinition(ProcessModels.ONE_TASK_PROCESS);
        MigrationPlan migrationPlan = this.engineRule.getRuntimeService().createMigrationPlan(sourceDefinition.getId(), targetDefinition.getId()).mapEqualActivities().build();
        ProcessInstance processInstance1 = this.startInstanceForTenant(sourceDefinition, TENANT_ONE);
        ProcessInstance processInstance2 = this.startInstanceForTenant(sourceDefinition, TENANT_TWO);
        this.engineRule.getIdentityService().setAuthentication("user", null, Arrays.asList(TENANT_ONE));
        this.engineRule.getRuntimeService().newMigration(migrationPlan).processInstanceQuery(this.engineRule.getRuntimeService().createProcessInstanceQuery()).execute();
        this.engineRule.getIdentityService().clearAuthentication();
        this.assertInstanceOfDefinition(processInstance1, targetDefinition);
        this.assertInstanceOfDefinition(processInstance2, sourceDefinition);
    }

    @Test
    public void canMigrateWithProcessInstanceQueryAllInstancesOfAuthenticatedTenants() {
        ProcessDefinition sourceDefinition = this.testHelper.deployAndGetDefinition(ProcessModels.ONE_TASK_PROCESS);
        ProcessDefinition targetDefinition = this.testHelper.deployAndGetDefinition(ProcessModels.ONE_TASK_PROCESS);
        MigrationPlan migrationPlan = this.engineRule.getRuntimeService().createMigrationPlan(sourceDefinition.getId(), targetDefinition.getId()).mapEqualActivities().build();
        ProcessInstance processInstance1 = this.startInstanceForTenant(sourceDefinition, TENANT_ONE);
        ProcessInstance processInstance2 = this.startInstanceForTenant(sourceDefinition, TENANT_TWO);
        this.engineRule.getIdentityService().setAuthentication("user", null, Arrays.asList(TENANT_ONE, TENANT_TWO));
        this.engineRule.getRuntimeService().newMigration(migrationPlan).processInstanceQuery(this.engineRule.getRuntimeService().createProcessInstanceQuery()).execute();
        this.engineRule.getIdentityService().clearAuthentication();
        this.assertInstanceOfDefinition(processInstance1, targetDefinition);
        this.assertInstanceOfDefinition(processInstance2, targetDefinition);
    }

    protected void assertInstanceOfDefinition(ProcessInstance processInstance, ProcessDefinition targetDefinition) {
        Assert.assertEquals((long)1L, (long)this.engineRule.getRuntimeService().createProcessInstanceQuery().processInstanceId(processInstance.getId()).processDefinitionId(targetDefinition.getId()).count());
    }

    protected ProcessInstance startInstanceForTenant(ProcessDefinition processDefinition, String tenantId) {
        return this.engineRule.getRuntimeService().startProcessInstanceById(processDefinition.getId(), (Map)Variables.createVariables().putValue("tenantId", (Object)tenantId));
    }

    public static class VariableBasedTenantIdProvider
    implements TenantIdProvider {
        public static final String TENANT_VARIABLE = "tenantId";

        public String provideTenantIdForProcessInstance(TenantIdProviderProcessInstanceContext ctx) {
            return (String)ctx.getVariables().get((Object)TENANT_VARIABLE);
        }

        public String provideTenantIdForCaseInstance(TenantIdProviderCaseInstanceContext ctx) {
            return (String)ctx.getVariables().get((Object)TENANT_VARIABLE);
        }

        public String provideTenantIdForHistoricDecisionInstance(TenantIdProviderHistoricDecisionInstanceContext ctx) {
            return null;
        }
    }
}

