/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.multitenancy;

import java.util.Arrays;
import java.util.Collections;
import org.camunda.bpm.engine.BadUserRequestException;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.batch.Batch;
import org.camunda.bpm.engine.history.HistoricProcessInstanceQuery;
import org.camunda.bpm.engine.repository.Deployment;
import org.camunda.bpm.engine.repository.ProcessDefinition;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.runtime.ProcessInstanceQuery;
import org.camunda.bpm.engine.runtime.ProcessInstantiationBuilder;
import org.camunda.bpm.engine.runtime.RestartProcessInstanceBuilder;
import org.camunda.bpm.engine.test.RequiredHistoryLevel;
import org.camunda.bpm.engine.test.api.runtime.BatchRestartHelper;
import org.camunda.bpm.engine.test.util.PluggableProcessEngineTest;
import org.camunda.bpm.model.bpmn.Bpmn;
import org.camunda.bpm.model.bpmn.BpmnModelInstance;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;

public class MultiTenancyProcessInstantiationTest
extends PluggableProcessEngineTest {
    protected static final String TENANT_ONE = "tenant1";
    protected static final String TENANT_TWO = "tenant2";
    protected static final BpmnModelInstance PROCESS = Bpmn.createExecutableProcess((String)"testProcess").startEvent().userTask("userTask").endEvent().done();
    public BatchRestartHelper batchHelper = new BatchRestartHelper(this);

    @After
    public void tearDown() throws Exception {
        this.authorizationService.createAuthorizationQuery();
        this.batchHelper.removeAllRunningAndHistoricBatches();
    }

    @Test
    public void testStartProcessInstanceByKeyAndTenantId() {
        this.testRule.deployForTenant(TENANT_ONE, PROCESS);
        this.testRule.deployForTenant(TENANT_TWO, PROCESS);
        this.runtimeService.createProcessInstanceByKey("testProcess").processDefinitionTenantId(TENANT_ONE).execute();
        Assert.assertThat((Object)this.runtimeService.createProcessInstanceQuery().tenantIdIn(new String[]{TENANT_ONE}).count(), (Matcher)CoreMatchers.is((Object)1L));
    }

    @Test
    public void testStartProcessInstanceByKeyForAnyTenant() {
        this.testRule.deployForTenant(TENANT_ONE, PROCESS);
        this.runtimeService.createProcessInstanceByKey("testProcess").execute();
        Assert.assertThat((Object)this.runtimeService.createProcessInstanceQuery().tenantIdIn(new String[]{TENANT_ONE}).count(), (Matcher)CoreMatchers.is((Object)1L));
    }

    @Test
    public void testStartProcessInstanceByKeyWithoutTenantId() {
        this.testRule.deploy(PROCESS);
        this.testRule.deployForTenant(TENANT_ONE, PROCESS);
        this.runtimeService.createProcessInstanceByKey("testProcess").processDefinitionWithoutTenantId().execute();
        ProcessInstanceQuery query = this.runtimeService.createProcessInstanceQuery();
        Assert.assertThat((Object)query.count(), (Matcher)CoreMatchers.is((Object)1L));
        Assert.assertThat((Object)((ProcessInstance)query.singleResult()).getTenantId(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
    }

    @Test
    public void testFailToStartProcessInstanceByKeyForOtherTenant() {
        this.testRule.deployForTenant(TENANT_ONE, PROCESS);
        try {
            this.runtimeService.createProcessInstanceByKey("testProcess").processDefinitionTenantId(TENANT_TWO).execute();
            Assert.fail((String)"expected exception");
        }
        catch (ProcessEngineException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)"no processes deployed"));
        }
    }

    @Test
    public void testFailToStartProcessInstanceByKeyForMultipleTenants() {
        this.testRule.deployForTenant(TENANT_ONE, PROCESS);
        this.testRule.deployForTenant(TENANT_TWO, PROCESS);
        try {
            this.runtimeService.createProcessInstanceByKey("testProcess").execute();
            Assert.fail((String)"expected exception");
        }
        catch (ProcessEngineException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)"multiple tenants"));
        }
    }

    @Test
    public void testFailToStartProcessInstanceByIdAndTenantId() {
        this.testRule.deployForTenant(TENANT_ONE, PROCESS);
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().singleResult();
        try {
            this.runtimeService.createProcessInstanceById(processDefinition.getId()).processDefinitionTenantId(TENANT_ONE).execute();
            Assert.fail((String)"expected exception");
        }
        catch (BadUserRequestException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)"Cannot specify a tenant-id"));
        }
    }

    @Test
    public void testFailToStartProcessInstanceByIdWithoutTenantId() {
        this.testRule.deployForTenant(TENANT_ONE, PROCESS);
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().singleResult();
        try {
            this.runtimeService.createProcessInstanceById(processDefinition.getId()).processDefinitionWithoutTenantId().execute();
            Assert.fail((String)"expected exception");
        }
        catch (BadUserRequestException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)"Cannot specify a tenant-id"));
        }
    }

    @Test
    public void testStartProcessInstanceAtActivityByKeyAndTenantId() {
        this.testRule.deployForTenant(TENANT_ONE, PROCESS);
        this.testRule.deployForTenant(TENANT_TWO, PROCESS);
        ((ProcessInstantiationBuilder)this.runtimeService.createProcessInstanceByKey("testProcess").processDefinitionTenantId(TENANT_ONE).startBeforeActivity("userTask")).execute();
        Assert.assertThat((Object)this.runtimeService.createProcessInstanceQuery().tenantIdIn(new String[]{TENANT_ONE}).count(), (Matcher)CoreMatchers.is((Object)1L));
    }

    @Test
    public void testStartProcessInstanceAtActivityByKeyForAnyTenant() {
        this.testRule.deployForTenant(TENANT_ONE, PROCESS);
        ((ProcessInstantiationBuilder)this.runtimeService.createProcessInstanceByKey("testProcess").startBeforeActivity("userTask")).execute();
        Assert.assertThat((Object)this.runtimeService.createProcessInstanceQuery().tenantIdIn(new String[]{TENANT_ONE}).count(), (Matcher)CoreMatchers.is((Object)1L));
    }

    @Test
    public void testStartProcessInstanceAtActivityByKeyWithoutTenantId() {
        this.testRule.deploy(PROCESS);
        this.testRule.deployForTenant(TENANT_ONE, PROCESS);
        ((ProcessInstantiationBuilder)this.runtimeService.createProcessInstanceByKey("testProcess").processDefinitionWithoutTenantId().startBeforeActivity("userTask")).execute();
        ProcessInstanceQuery query = this.runtimeService.createProcessInstanceQuery();
        Assert.assertThat((Object)query.count(), (Matcher)CoreMatchers.is((Object)1L));
        Assert.assertThat((Object)((ProcessInstance)query.singleResult()).getTenantId(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
    }

    @Test
    public void testFailToStartProcessInstanceAtActivityByKeyForOtherTenant() {
        this.testRule.deployForTenant(TENANT_ONE, PROCESS);
        try {
            ((ProcessInstantiationBuilder)this.runtimeService.createProcessInstanceByKey("testProcess").processDefinitionTenantId(TENANT_TWO).startBeforeActivity("userTask")).execute();
            Assert.fail((String)"expected exception");
        }
        catch (ProcessEngineException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)"no processes deployed"));
        }
    }

    @Test
    public void testFailToStartProcessInstanceAtActivityByKeyForMultipleTenants() {
        this.testRule.deployForTenant(TENANT_ONE, PROCESS);
        this.testRule.deployForTenant(TENANT_TWO, PROCESS);
        try {
            ((ProcessInstantiationBuilder)this.runtimeService.createProcessInstanceByKey("testProcess").startBeforeActivity("userTask")).execute();
            Assert.fail((String)"expected exception");
        }
        catch (ProcessEngineException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)"multiple tenants"));
        }
    }

    @Test
    public void testFailToStartProcessInstanceAtActivityByIdAndTenantId() {
        this.testRule.deployForTenant(TENANT_ONE, PROCESS);
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().singleResult();
        try {
            ((ProcessInstantiationBuilder)this.runtimeService.createProcessInstanceById(processDefinition.getId()).processDefinitionTenantId(TENANT_ONE).startBeforeActivity("userTask")).execute();
            Assert.fail((String)"expected exception");
        }
        catch (BadUserRequestException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)"Cannot specify a tenant-id"));
        }
    }

    @Test
    public void testFailToStartProcessInstanceAtActivityByIdWithoutTenantId() {
        this.testRule.deploy(PROCESS);
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().singleResult();
        try {
            ((ProcessInstantiationBuilder)this.runtimeService.createProcessInstanceById(processDefinition.getId()).processDefinitionWithoutTenantId().startBeforeActivity("userTask")).execute();
            Assert.fail((String)"expected exception");
        }
        catch (BadUserRequestException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)"Cannot specify a tenant-id"));
        }
    }

    @Test
    public void testStartProcessInstanceByKeyWithoutTenantIdNoAuthenticatedTenants() {
        this.identityService.setAuthentication("user", null, null);
        this.testRule.deploy(PROCESS);
        this.runtimeService.createProcessInstanceByKey("testProcess").processDefinitionWithoutTenantId().execute();
        ProcessInstanceQuery query = this.runtimeService.createProcessInstanceQuery();
        Assert.assertThat((Object)query.count(), (Matcher)CoreMatchers.is((Object)1L));
    }

    @Test
    public void testFailToStartProcessInstanceByKeyNoAuthenticatedTenants() {
        this.identityService.setAuthentication("user", null, null);
        this.testRule.deployForTenant(TENANT_ONE, PROCESS);
        try {
            this.runtimeService.createProcessInstanceByKey("testProcess").execute();
            Assert.fail((String)"expected exception");
        }
        catch (ProcessEngineException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)"no processes deployed with key 'testProcess'"));
        }
    }

    @Test
    public void testFailToStartProcessInstanceByKeyWithTenantIdNoAuthenticatedTenants() {
        this.identityService.setAuthentication("user", null, null);
        this.testRule.deployForTenant(TENANT_ONE, PROCESS);
        try {
            this.runtimeService.createProcessInstanceByKey("testProcess").processDefinitionTenantId(TENANT_ONE).execute();
            Assert.fail((String)"expected exception");
        }
        catch (ProcessEngineException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)"Cannot create an instance of the process definition"));
        }
    }

    @Test
    public void testFailToStartProcessInstanceByIdNoAuthenticatedTenants() {
        this.testRule.deployForTenant(TENANT_ONE, PROCESS);
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().singleResult();
        this.identityService.setAuthentication("user", null, null);
        try {
            this.runtimeService.createProcessInstanceById(processDefinition.getId()).execute();
            Assert.fail((String)"expected exception");
        }
        catch (ProcessEngineException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)"Cannot create an instance of the process definition"));
        }
    }

    @Test
    public void testStartProcessInstanceByKeyWithTenantIdAuthenticatedTenant() {
        this.identityService.setAuthentication("user", null, Arrays.asList(TENANT_ONE));
        this.testRule.deployForTenant(TENANT_ONE, PROCESS);
        this.testRule.deployForTenant(TENANT_TWO, PROCESS);
        this.runtimeService.createProcessInstanceByKey("testProcess").processDefinitionTenantId(TENANT_ONE).execute();
        ProcessInstanceQuery query = this.runtimeService.createProcessInstanceQuery();
        Assert.assertThat((Object)query.count(), (Matcher)CoreMatchers.is((Object)1L));
        Assert.assertThat((Object)query.tenantIdIn(new String[]{TENANT_ONE}).count(), (Matcher)CoreMatchers.is((Object)1L));
    }

    @Test
    public void testStartProcessInstanceByIdAuthenticatedTenant() {
        this.testRule.deployForTenant(TENANT_ONE, PROCESS);
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().singleResult();
        this.identityService.setAuthentication("user", null, Arrays.asList(TENANT_ONE));
        this.runtimeService.createProcessInstanceById(processDefinition.getId()).execute();
        ProcessInstanceQuery query = this.runtimeService.createProcessInstanceQuery();
        Assert.assertThat((Object)query.count(), (Matcher)CoreMatchers.is((Object)1L));
        Assert.assertThat((Object)query.tenantIdIn(new String[]{TENANT_ONE}).count(), (Matcher)CoreMatchers.is((Object)1L));
    }

    @Test
    public void testStartProcessInstanceByKeyWithAuthenticatedTenant() {
        this.identityService.setAuthentication("user", null, Arrays.asList(TENANT_ONE));
        this.testRule.deployForTenant(TENANT_ONE, PROCESS);
        this.testRule.deployForTenant(TENANT_TWO, PROCESS);
        this.runtimeService.createProcessInstanceByKey("testProcess").execute();
        ProcessInstanceQuery query = this.runtimeService.createProcessInstanceQuery();
        Assert.assertThat((Object)query.count(), (Matcher)CoreMatchers.is((Object)1L));
        Assert.assertThat((Object)query.tenantIdIn(new String[]{TENANT_ONE}).count(), (Matcher)CoreMatchers.is((Object)1L));
    }

    @Test
    public void testStartProcessInstanceByKeyWithTenantIdDisabledTenantCheck() {
        this.processEngineConfiguration.setTenantCheckEnabled(false);
        this.identityService.setAuthentication("user", null, null);
        this.testRule.deployForTenant(TENANT_ONE, PROCESS);
        this.runtimeService.createProcessInstanceByKey("testProcess").processDefinitionTenantId(TENANT_ONE).execute();
        ProcessInstanceQuery query = this.runtimeService.createProcessInstanceQuery();
        Assert.assertThat((Object)query.count(), (Matcher)CoreMatchers.is((Object)1L));
        Assert.assertThat((Object)query.tenantIdIn(new String[]{TENANT_ONE}).count(), (Matcher)CoreMatchers.is((Object)1L));
    }

    @RequiredHistoryLevel(value="full")
    @Test
    public void testRestartProcessInstanceSyncWithTenantId() {
        ProcessInstance processInstance = this.startAndDeleteProcessInstance(TENANT_ONE, PROCESS);
        this.identityService.setAuthentication("user", null, Collections.singletonList(TENANT_ONE));
        ((RestartProcessInstanceBuilder)this.runtimeService.restartProcessInstances(processInstance.getProcessDefinitionId()).startBeforeActivity("userTask")).processInstanceIds(new String[]{processInstance.getId()}).execute();
        ProcessInstance restartedInstance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().active().processDefinitionId(processInstance.getProcessDefinitionId()).singleResult();
        Assert.assertNotNull((Object)restartedInstance);
        Assert.assertEquals((Object)restartedInstance.getTenantId(), (Object)TENANT_ONE);
    }

    @RequiredHistoryLevel(value="full")
    @Test
    public void testRestartProcessInstanceAsyncWithTenantId() {
        ProcessInstance processInstance = this.startAndDeleteProcessInstance(TENANT_ONE, PROCESS);
        this.identityService.setAuthentication("user", null, Collections.singletonList(TENANT_ONE));
        Batch batch = ((RestartProcessInstanceBuilder)this.runtimeService.restartProcessInstances(processInstance.getProcessDefinitionId()).startBeforeActivity("userTask")).processInstanceIds(new String[]{processInstance.getId()}).executeAsync();
        this.batchHelper.completeBatch(batch);
        ProcessInstance restartedInstance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().active().processDefinitionId(processInstance.getProcessDefinitionId()).singleResult();
        Assert.assertNotNull((Object)restartedInstance);
        Assert.assertEquals((Object)restartedInstance.getTenantId(), (Object)TENANT_ONE);
    }

    @RequiredHistoryLevel(value="full")
    @Test
    public void testFailToRestartProcessInstanceSyncWithOtherTenantId() {
        ProcessInstance processInstance = this.startAndDeleteProcessInstance(TENANT_ONE, PROCESS);
        this.identityService.setAuthentication("user", null, Collections.singletonList(TENANT_TWO));
        try {
            ((RestartProcessInstanceBuilder)this.runtimeService.restartProcessInstances(processInstance.getProcessDefinitionId()).startBeforeActivity("userTask")).processInstanceIds(new String[]{processInstance.getId()}).execute();
            Assert.fail((String)"expected exception");
        }
        catch (BadUserRequestException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)"Historic process instance cannot be found: historicProcessInstanceId is null"));
        }
    }

    @RequiredHistoryLevel(value="full")
    @Test
    public void testFailToRestartProcessInstanceAsyncWithOtherTenantId() {
        ProcessInstance processInstance = this.startAndDeleteProcessInstance(TENANT_ONE, PROCESS);
        this.identityService.setAuthentication("user", null, Collections.singletonList(TENANT_TWO));
        try {
            ((RestartProcessInstanceBuilder)this.runtimeService.restartProcessInstances(processInstance.getProcessDefinitionId()).startBeforeActivity("userTask")).processInstanceIds(new String[]{processInstance.getId()}).executeAsync();
        }
        catch (ProcessEngineException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)("Cannot restart process instances of process definition '" + processInstance.getProcessDefinitionId() + "' because it belongs to no authenticated tenant.")));
        }
    }

    @RequiredHistoryLevel(value="full")
    @Test
    public void testRestartProcessInstanceSyncWithTenantIdByHistoricProcessInstanceQuery() {
        ProcessInstance processInstance = this.startAndDeleteProcessInstance(TENANT_ONE, PROCESS);
        HistoricProcessInstanceQuery query = this.historyService.createHistoricProcessInstanceQuery().processDefinitionId(processInstance.getProcessDefinitionId());
        this.identityService.setAuthentication("user", null, Collections.singletonList(TENANT_ONE));
        ((RestartProcessInstanceBuilder)this.runtimeService.restartProcessInstances(processInstance.getProcessDefinitionId()).startBeforeActivity("userTask")).historicProcessInstanceQuery(query).execute();
        ProcessInstance restartedInstance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().active().processDefinitionId(processInstance.getProcessDefinitionId()).singleResult();
        Assert.assertNotNull((Object)restartedInstance);
        Assert.assertEquals((Object)restartedInstance.getTenantId(), (Object)TENANT_ONE);
    }

    @RequiredHistoryLevel(value="full")
    @Test
    public void testRestartProcessInstanceAsyncWithTenantIdByHistoricProcessInstanceQuery() {
        ProcessInstance processInstance = this.startAndDeleteProcessInstance(TENANT_ONE, PROCESS);
        HistoricProcessInstanceQuery query = this.historyService.createHistoricProcessInstanceQuery().processDefinitionId(processInstance.getProcessDefinitionId());
        this.identityService.setAuthentication("user", null, Collections.singletonList(TENANT_ONE));
        Batch batch = ((RestartProcessInstanceBuilder)this.runtimeService.restartProcessInstances(processInstance.getProcessDefinitionId()).startBeforeActivity("userTask")).historicProcessInstanceQuery(query).executeAsync();
        this.batchHelper.completeBatch(batch);
        ProcessInstance restartedInstance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().active().processDefinitionId(processInstance.getProcessDefinitionId()).singleResult();
        Assert.assertNotNull((Object)restartedInstance);
        Assert.assertEquals((Object)restartedInstance.getTenantId(), (Object)TENANT_ONE);
    }

    @RequiredHistoryLevel(value="full")
    @Test
    public void testFailToRestartProcessInstanceSyncWithOtherTenantIdByHistoricProcessInstanceQuery() {
        ProcessInstance processInstance = this.startAndDeleteProcessInstance(TENANT_ONE, PROCESS);
        HistoricProcessInstanceQuery query = this.historyService.createHistoricProcessInstanceQuery().processDefinitionId(processInstance.getProcessDefinitionId());
        this.identityService.setAuthentication("user", null, Collections.singletonList(TENANT_TWO));
        try {
            ((RestartProcessInstanceBuilder)this.runtimeService.restartProcessInstances(processInstance.getProcessDefinitionId()).startBeforeActivity("userTask")).historicProcessInstanceQuery(query).execute();
            Assert.fail((String)"expected exception");
        }
        catch (BadUserRequestException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)"processInstanceIds is empty"));
        }
    }

    @RequiredHistoryLevel(value="full")
    @Test
    public void testFailToRestartProcessInstanceAsyncWithOtherTenantIdByHistoricProcessInstanceQuery() {
        ProcessInstance processInstance = this.startAndDeleteProcessInstance(TENANT_ONE, PROCESS);
        HistoricProcessInstanceQuery query = this.historyService.createHistoricProcessInstanceQuery().processDefinitionId(processInstance.getProcessDefinitionId());
        this.identityService.setAuthentication("user", null, Collections.singletonList(TENANT_TWO));
        try {
            ((RestartProcessInstanceBuilder)this.runtimeService.restartProcessInstances(processInstance.getProcessDefinitionId()).startBeforeActivity("userTask")).historicProcessInstanceQuery(query).executeAsync();
        }
        catch (ProcessEngineException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)"processInstanceIds is empty"));
        }
    }

    public ProcessInstance startAndDeleteProcessInstance(String tenantId, BpmnModelInstance modelInstance) {
        Deployment deployment = this.testRule.deployForTenant(TENANT_ONE, PROCESS);
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().deploymentId(deployment.getId()).singleResult();
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceById(processDefinition.getId());
        this.runtimeService.deleteProcessInstance(processInstance.getId(), "test");
        return processInstance;
    }
}

