/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.multitenancy.query;

import java.util.Arrays;
import java.util.List;
import org.camunda.bpm.engine.exception.NullValueException;
import org.camunda.bpm.engine.externaltask.ExternalTask;
import org.camunda.bpm.engine.externaltask.ExternalTaskQuery;
import org.camunda.bpm.engine.repository.ProcessDefinition;
import org.camunda.bpm.engine.test.util.PluggableProcessEngineTest;
import org.camunda.bpm.model.bpmn.Bpmn;
import org.camunda.bpm.model.bpmn.BpmnModelInstance;
import org.camunda.bpm.model.bpmn.builder.ServiceTaskBuilder;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class MultiTenancyExternalTaskQueryTest
extends PluggableProcessEngineTest {
    protected static final String TENANT_ONE = "tenant1";
    protected static final String TENANT_TWO = "tenant2";

    @Before
    public void setUp() {
        BpmnModelInstance process = ((ServiceTaskBuilder)((ServiceTaskBuilder)Bpmn.createExecutableProcess().startEvent().serviceTask().camundaType("external")).camundaTopic("test")).endEvent().done();
        this.testRule.deployForTenant(TENANT_ONE, process);
        this.testRule.deployForTenant(TENANT_TWO, process);
        this.startProcessInstance(TENANT_ONE);
        this.startProcessInstance(TENANT_TWO);
    }

    @Test
    public void testQueryWithoutTenantId() {
        ExternalTaskQuery query = this.externalTaskService.createExternalTaskQuery();
        Assert.assertThat((Object)query.count(), (Matcher)CoreMatchers.is((Object)2L));
    }

    @Test
    public void testQueryByTenantId() {
        ExternalTaskQuery query = this.externalTaskService.createExternalTaskQuery().tenantIdIn(new String[]{TENANT_ONE});
        Assert.assertThat((Object)query.count(), (Matcher)CoreMatchers.is((Object)1L));
        query = this.externalTaskService.createExternalTaskQuery().tenantIdIn(new String[]{TENANT_TWO});
        Assert.assertThat((Object)query.count(), (Matcher)CoreMatchers.is((Object)1L));
    }

    @Test
    public void testQueryByTenantIds() {
        ExternalTaskQuery query = this.externalTaskService.createExternalTaskQuery().tenantIdIn(new String[]{TENANT_ONE, TENANT_TWO});
        Assert.assertThat((Object)query.count(), (Matcher)CoreMatchers.is((Object)2L));
    }

    @Test
    public void testQueryByNonExistingTenantId() {
        ExternalTaskQuery query = this.externalTaskService.createExternalTaskQuery().tenantIdIn(new String[]{"nonExisting"});
        Assert.assertThat((Object)query.count(), (Matcher)CoreMatchers.is((Object)0L));
    }

    @Test
    public void testFailQueryByTenantIdNull() {
        try {
            this.externalTaskService.createExternalTaskQuery().tenantIdIn(new String[]{null});
            Assert.fail((String)"expected exception");
        }
        catch (NullValueException nullValueException) {
            // empty catch block
        }
    }

    @Test
    public void testQuerySortingAsc() {
        List externalTasks = ((ExternalTaskQuery)this.externalTaskService.createExternalTaskQuery().orderByTenantId().asc()).list();
        Assert.assertThat((Object)externalTasks.size(), (Matcher)CoreMatchers.is((Object)2));
        Assert.assertThat((Object)((ExternalTask)externalTasks.get(0)).getTenantId(), (Matcher)CoreMatchers.is((Object)TENANT_ONE));
        Assert.assertThat((Object)((ExternalTask)externalTasks.get(1)).getTenantId(), (Matcher)CoreMatchers.is((Object)TENANT_TWO));
    }

    @Test
    public void testQuerySortingDesc() {
        List externalTasks = ((ExternalTaskQuery)this.externalTaskService.createExternalTaskQuery().orderByTenantId().desc()).list();
        Assert.assertThat((Object)externalTasks.size(), (Matcher)CoreMatchers.is((Object)2));
        Assert.assertThat((Object)((ExternalTask)externalTasks.get(0)).getTenantId(), (Matcher)CoreMatchers.is((Object)TENANT_TWO));
        Assert.assertThat((Object)((ExternalTask)externalTasks.get(1)).getTenantId(), (Matcher)CoreMatchers.is((Object)TENANT_ONE));
    }

    @Test
    public void testQueryNoAuthenticatedTenants() {
        this.identityService.setAuthentication("user", null, null);
        ExternalTaskQuery query = this.externalTaskService.createExternalTaskQuery();
        Assert.assertThat((Object)query.count(), (Matcher)CoreMatchers.is((Object)0L));
    }

    @Test
    public void testQueryAuthenticatedTenant() {
        this.identityService.setAuthentication("user", null, Arrays.asList(TENANT_ONE));
        ExternalTaskQuery query = this.externalTaskService.createExternalTaskQuery();
        Assert.assertThat((Object)query.count(), (Matcher)CoreMatchers.is((Object)1L));
        Assert.assertThat((Object)query.tenantIdIn(new String[]{TENANT_ONE}).count(), (Matcher)CoreMatchers.is((Object)1L));
        Assert.assertThat((Object)query.tenantIdIn(new String[]{TENANT_TWO}).count(), (Matcher)CoreMatchers.is((Object)0L));
        Assert.assertThat((Object)query.tenantIdIn(new String[]{TENANT_ONE, TENANT_TWO}).count(), (Matcher)CoreMatchers.is((Object)1L));
    }

    @Test
    public void testQueryAuthenticatedTenants() {
        this.identityService.setAuthentication("user", null, Arrays.asList(TENANT_ONE, TENANT_TWO));
        ExternalTaskQuery query = this.externalTaskService.createExternalTaskQuery();
        Assert.assertThat((Object)query.count(), (Matcher)CoreMatchers.is((Object)2L));
        Assert.assertThat((Object)query.tenantIdIn(new String[]{TENANT_ONE}).count(), (Matcher)CoreMatchers.is((Object)1L));
        Assert.assertThat((Object)query.tenantIdIn(new String[]{TENANT_TWO}).count(), (Matcher)CoreMatchers.is((Object)1L));
    }

    @Test
    public void testQueryDisabledTenantCheck() {
        this.processEngineConfiguration.setTenantCheckEnabled(false);
        this.identityService.setAuthentication("user", null, null);
        ExternalTaskQuery query = this.externalTaskService.createExternalTaskQuery();
        Assert.assertThat((Object)query.count(), (Matcher)CoreMatchers.is((Object)2L));
    }

    protected void startProcessInstance(String tenant) {
        String processDefinitionId = ((ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().tenantIdIn(new String[]{tenant}).singleResult()).getId();
        this.runtimeService.startProcessInstanceById(processDefinitionId);
    }
}

