/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.runtime;

import java.util.Arrays;
import java.util.List;
import org.camunda.bpm.engine.BadUserRequestException;
import org.camunda.bpm.engine.HistoryService;
import org.camunda.bpm.engine.RuntimeService;
import org.camunda.bpm.engine.exception.NotFoundException;
import org.camunda.bpm.engine.impl.context.Context;
import org.camunda.bpm.engine.impl.incident.IncidentContext;
import org.camunda.bpm.engine.impl.incident.IncidentHandler;
import org.camunda.bpm.engine.impl.persistence.entity.IncidentEntity;
import org.camunda.bpm.engine.runtime.Incident;
import org.camunda.bpm.engine.runtime.Job;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.test.ProcessEngineRule;
import org.camunda.bpm.engine.test.api.runtime.migration.models.ProcessModels;
import org.camunda.bpm.engine.test.util.ProcessEngineBootstrapRule;
import org.camunda.bpm.engine.test.util.ProcessEngineTestRule;
import org.camunda.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;

public class CreateAndResolveIncidentTest {
    @ClassRule
    public static ProcessEngineBootstrapRule processEngineBootstrapRule = new ProcessEngineBootstrapRule(configuration -> configuration.setCustomIncidentHandlers(Arrays.asList(new CustomIncidentHandler())));
    protected ProcessEngineRule engineRule = new ProvidedProcessEngineRule(processEngineBootstrapRule);
    protected ProcessEngineTestRule testRule = new ProcessEngineTestRule(this.engineRule);
    @Rule
    public ExpectedException thrown = ExpectedException.none();
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.engineRule).around((TestRule)this.testRule);
    protected RuntimeService runtimeService;
    protected HistoryService historyService;

    @Before
    public void init() {
        this.runtimeService = this.engineRule.getRuntimeService();
        this.historyService = this.engineRule.getHistoryService();
    }

    @Test
    public void createIncident() {
        this.testRule.deploy(ProcessModels.TWO_TASKS_PROCESS);
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("Process");
        Incident incident = this.runtimeService.createIncident("foo", processInstance.getId(), "aa", "bar");
        Incident incident2 = (Incident)this.runtimeService.createIncidentQuery().executionId(processInstance.getId()).singleResult();
        Assert.assertEquals((Object)incident2.getId(), (Object)incident.getId());
        Assert.assertEquals((Object)"foo", (Object)incident2.getIncidentType());
        Assert.assertEquals((Object)"aa", (Object)incident2.getConfiguration());
        Assert.assertEquals((Object)"bar", (Object)incident2.getIncidentMessage());
        Assert.assertEquals((Object)processInstance.getId(), (Object)incident2.getExecutionId());
    }

    @Test
    public void createIncidentWithNullExecution() {
        try {
            this.runtimeService.createIncident("foo", null, "userTask1", "bar");
            Assert.fail((String)"exception expected");
        }
        catch (BadUserRequestException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)"Execution id cannot be null"));
        }
    }

    @Test
    public void createIncidentWithNullIncidentType() {
        try {
            this.runtimeService.createIncident(null, "processInstanceId", "foo", "bar");
            Assert.fail((String)"Exception expected");
        }
        catch (BadUserRequestException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)"incidentType is null"));
        }
    }

    @Test
    public void createIncidentWithNonExistingExecution() {
        try {
            this.runtimeService.createIncident("foo", "aaa", "bbb", "bar");
            Assert.fail((String)"exception expected");
        }
        catch (BadUserRequestException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)"Cannot find an execution with executionId 'aaa'"));
        }
    }

    @Test
    public void resolveIncident() {
        this.testRule.deploy(ProcessModels.TWO_TASKS_PROCESS);
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("Process");
        Incident incident = this.runtimeService.createIncident("foo", processInstance.getId(), "userTask1", "bar");
        this.runtimeService.resolveIncident(incident.getId());
        Incident incident2 = (Incident)this.runtimeService.createIncidentQuery().executionId(processInstance.getId()).singleResult();
        Assert.assertNull((Object)incident2);
    }

    @Test
    public void resolveUnexistingIncident() {
        try {
            this.runtimeService.resolveIncident("foo");
            Assert.fail((String)"Exception expected");
        }
        catch (NotFoundException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)"Cannot find an incident with id 'foo'"));
        }
    }

    @Test
    public void resolveNullIncident() {
        try {
            this.runtimeService.resolveIncident(null);
            Assert.fail((String)"Exception expected");
        }
        catch (BadUserRequestException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)"incidentId is null"));
        }
    }

    @Test
    public void resolveIncidentOfTypeFailedJob() {
        this.testRule.deploy("org/camunda/bpm/engine/test/api/mgmt/IncidentTest.testShouldCreateOneIncident.bpmn");
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("failingProcess");
        List jobs = this.engineRule.getManagementService().createJobQuery().withRetriesLeft().list();
        for (Job job : jobs) {
            this.engineRule.getManagementService().setJobRetries(job.getId(), 1);
            try {
                this.engineRule.getManagementService().executeJob(job.getId());
            }
            catch (Exception exception) {}
        }
        Incident incident = (Incident)this.runtimeService.createIncidentQuery().processInstanceId(processInstance.getId()).singleResult();
        try {
            this.runtimeService.resolveIncident(incident.getId());
            Assert.fail((String)"Exception expected");
        }
        catch (BadUserRequestException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)"Cannot resolve an incident of type failedJob"));
        }
    }

    @Test
    public void createIncidentWithIncidentHandler() {
        this.testRule.deploy(ProcessModels.TWO_TASKS_PROCESS);
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("Process");
        Incident incident = this.runtimeService.createIncident("custom", processInstance.getId(), "configuration");
        Assert.assertNotNull((Object)incident);
        Incident incident2 = (Incident)this.runtimeService.createIncidentQuery().singleResult();
        Assert.assertNotNull((Object)incident2);
        Assert.assertEquals((Object)incident, (Object)incident2);
        Assert.assertEquals((Object)"custom", (Object)incident.getIncidentType());
        Assert.assertEquals((Object)"configuration", (Object)incident.getConfiguration());
    }

    @Test
    public void resolveIncidentWithIncidentHandler() {
        this.testRule.deploy(ProcessModels.TWO_TASKS_PROCESS);
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("Process");
        this.runtimeService.createIncident("custom", processInstance.getId(), "configuration");
        Incident incident = (Incident)this.runtimeService.createIncidentQuery().singleResult();
        this.runtimeService.resolveIncident(incident.getId());
        incident = (Incident)this.runtimeService.createIncidentQuery().singleResult();
        Assert.assertNull((Object)incident);
    }

    public static class CustomIncidentHandler
    implements IncidentHandler {
        String incidentType = "custom";

        public String getIncidentHandlerType() {
            return this.incidentType;
        }

        public Incident handleIncident(IncidentContext context, String message) {
            return IncidentEntity.createAndInsertIncident((String)this.incidentType, (IncidentContext)context, (String)message);
        }

        public void resolveIncident(IncidentContext context) {
            this.deleteIncident(context);
        }

        public void deleteIncident(IncidentContext context) {
            List incidents = Context.getCommandContext().getIncidentManager().findIncidentByConfigurationAndIncidentType(context.getConfiguration(), this.incidentType);
            ((IncidentEntity)incidents.get(0)).delete();
        }
    }
}

