/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.bpmn.event.signal;

import java.util.HashMap;
import java.util.List;
import org.camunda.bpm.engine.RuntimeService;
import org.camunda.bpm.engine.TaskService;
import org.camunda.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.runtime.VariableInstance;
import org.camunda.bpm.engine.task.Task;
import org.camunda.bpm.engine.test.Deployment;
import org.camunda.bpm.engine.test.util.ProcessEngineBootstrapRule;
import org.camunda.bpm.engine.test.util.ProcessEngineTestRule;
import org.camunda.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;

public class SignalEventPayloadTest {
    @ClassRule
    public static ProcessEngineBootstrapRule bootstrapRule = new ProcessEngineBootstrapRule(configuration -> configuration.setJavaSerializationFormatEnabled(true));
    protected ProvidedProcessEngineRule engineRule = new ProvidedProcessEngineRule(bootstrapRule);
    protected ProcessEngineTestRule testRule = new ProcessEngineTestRule(this.engineRule);
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.engineRule).around((TestRule)this.testRule);
    @Rule
    public ExpectedException thrown = ExpectedException.none();
    protected RuntimeService runtimeService;
    protected TaskService taskService;
    protected ProcessEngineConfigurationImpl processEngineConfiguration;

    @Before
    public void init() {
        this.runtimeService = this.engineRule.getRuntimeService();
        this.taskService = this.engineRule.getTaskService();
        this.processEngineConfiguration = this.engineRule.getProcessEngineConfiguration();
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/event/signal/SignalEventPayloadTests.throwSignalWithPayload.bpmn20.xml", "org/camunda/bpm/engine/test/bpmn/event/signal/SignalEventPayloadTests.catchSignalWithPayloadStart.bpmn20.xml"})
    public void testSignalPayloadStart() {
        HashMap<String, String> variables = new HashMap<String, String>();
        variables.put("payloadVar1", "payloadVal1");
        variables.put("payloadVar2", "payloadVal2");
        this.runtimeService.startProcessInstanceByKey("throwPayloadSignal", variables);
        Task catchingPiUserTask = (Task)this.taskService.createTaskQuery().singleResult();
        List catchingPiVariables = this.runtimeService.createVariableInstanceQuery().processInstanceIdIn(new String[]{catchingPiUserTask.getProcessInstanceId()}).list();
        Assert.assertEquals((long)2L, (long)catchingPiVariables.size());
        for (VariableInstance variable : catchingPiVariables) {
            if (variable.getName().equals("payloadVar1Target")) {
                Assert.assertEquals((Object)"payloadVal1", (Object)variable.getValue());
                continue;
            }
            Assert.assertEquals((Object)"payloadVal2", (Object)variable.getValue());
        }
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/event/signal/SignalEventPayloadTests.throwSignalWithPayload.bpmn20.xml", "org/camunda/bpm/engine/test/bpmn/event/signal/SignalEventPayloadTests.catchSignalWithPayloadIntermediate.bpmn20.xml"})
    public void testSignalPayloadIntermediate() {
        HashMap<String, String> variables = new HashMap<String, String>();
        variables.put("payloadVar1", "payloadVal1");
        variables.put("payloadVar2", "payloadVal2");
        ProcessInstance catchingPI = this.runtimeService.startProcessInstanceByKey("catchIntermediatePayloadSignal");
        this.runtimeService.startProcessInstanceByKey("throwPayloadSignal", variables);
        List catchingPiVariables = this.runtimeService.createVariableInstanceQuery().processInstanceIdIn(new String[]{catchingPI.getId()}).list();
        Assert.assertEquals((long)2L, (long)catchingPiVariables.size());
        for (VariableInstance variable : catchingPiVariables) {
            if (variable.getName().equals("payloadVar1Target")) {
                Assert.assertEquals((Object)"payloadVal1", (Object)variable.getValue());
                continue;
            }
            Assert.assertEquals((Object)"payloadVal2", (Object)variable.getValue());
        }
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/event/signal/SignalEventPayloadTests.throwSignalWithExpressionPayload.bpmn20.xml", "org/camunda/bpm/engine/test/bpmn/event/signal/SignalEventPayloadTests.catchSignalWithPayloadIntermediate.bpmn20.xml"})
    public void testSignalSourceExpressionPayload() {
        HashMap<String, String> variables = new HashMap<String, String>();
        variables.put("payloadVar", "Val");
        ProcessInstance catchingPI = this.runtimeService.startProcessInstanceByKey("catchIntermediatePayloadSignal");
        this.runtimeService.startProcessInstanceByKey("throwExpressionPayloadSignal", variables);
        List catchingPiVariables = this.runtimeService.createVariableInstanceQuery().processInstanceIdIn(new String[]{catchingPI.getId()}).list();
        Assert.assertEquals((long)1L, (long)catchingPiVariables.size());
        Assert.assertEquals((Object)"srcExpressionResVal", (Object)((VariableInstance)catchingPiVariables.get(0)).getName());
        Assert.assertEquals((Object)"sourceVal", (Object)((VariableInstance)catchingPiVariables.get(0)).getValue());
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/event/signal/SignalEventPayloadTests.throwSignalWithAllVariablesPayload.bpmn20.xml", "org/camunda/bpm/engine/test/bpmn/event/signal/SignalEventPayloadTests.catchSignalWithPayloadIntermediate.bpmn20.xml"})
    public void testSignalAllSourceVariablesPayload() {
        HashMap<String, String> variables = new HashMap<String, String>();
        variables.put("payloadVar1", "payloadVal1");
        variables.put("payloadVar2", "payloadVal2");
        ProcessInstance catchingPI = this.runtimeService.startProcessInstanceByKey("catchIntermediatePayloadSignal");
        this.runtimeService.startProcessInstanceByKey("throwPayloadSignal", variables);
        List catchingPiVariables = this.runtimeService.createVariableInstanceQuery().processInstanceIdIn(new String[]{catchingPI.getId()}).list();
        Assert.assertEquals((long)2L, (long)catchingPiVariables.size());
        for (VariableInstance variable : catchingPiVariables) {
            if (variable.getName().equals("payloadVar1")) {
                Assert.assertEquals((Object)"payloadVal1", (Object)variable.getValue());
                continue;
            }
            Assert.assertEquals((Object)"payloadVal2", (Object)variable.getValue());
        }
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/event/signal/SignalEventPayloadTests.throwEndSignalEventWithAllLocalVariablesPayload.bpmn20.xml", "org/camunda/bpm/engine/test/bpmn/event/signal/SignalEventPayloadTests.catchSignalWithPayloadIntermediate.bpmn20.xml"})
    public void testSignalAllLocalSourceVariablesPayload() {
        HashMap<String, String> variables = new HashMap<String, String>();
        variables.put("payloadVar1", "payloadVal1");
        String localVar1 = "localVar1";
        String localVal1 = "localVal1";
        String localVar2 = "localVar2";
        String localVal2 = "localVal2";
        ProcessInstance catchingPI = this.runtimeService.startProcessInstanceByKey("catchIntermediatePayloadSignal");
        this.runtimeService.startProcessInstanceByKey("throwPayloadSignal", variables);
        List catchingPiVariables = this.runtimeService.createVariableInstanceQuery().processInstanceIdIn(new String[]{catchingPI.getId()}).list();
        Assert.assertEquals((long)2L, (long)catchingPiVariables.size());
        for (VariableInstance variable : catchingPiVariables) {
            if (variable.getName().equals(localVar1)) {
                Assert.assertEquals((Object)localVal1, (Object)variable.getValue());
                continue;
            }
            Assert.assertEquals((Object)localVal2, (Object)variable.getValue());
        }
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/event/signal/SignalEventPayloadTests.throwSignalWithBusinessKeyPayload.bpmn20.xml", "org/camunda/bpm/engine/test/bpmn/event/signal/SignalEventPayloadTests.catchSignalWithPayloadStart.bpmn20.xml"})
    public void testSignalBusinessKeyPayload() {
        String businessKey = "aBusinessKey";
        this.runtimeService.startProcessInstanceByKey("throwBusinessKeyPayloadSignal", businessKey);
        ProcessInstance catchingPI = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().singleResult();
        Assert.assertEquals((Object)businessKey, (Object)catchingPI.getBusinessKey());
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/event/signal/SignalEventPayloadTests.throwSignalWithAllOptions.bpmn20.xml", "org/camunda/bpm/engine/test/bpmn/event/signal/SignalEventPayloadTests.catchSignalWithPayloadStart.bpmn20.xml"})
    public void testSignalPayloadWithAllOptions() {
        HashMap<String, String> variables = new HashMap<String, String>();
        String globalVar1 = "payloadVar1";
        String globalVal1 = "payloadVar1";
        String globalVar2 = "payloadVar2";
        String globalVal2 = "payloadVal2";
        variables.put(globalVar1, globalVal1);
        variables.put(globalVar2, globalVal2);
        String localVar1 = "localVar1";
        String localVal1 = "localVal1";
        String localVar2 = "localVar2";
        String localVal2 = "localVal2";
        String businessKey = "aBusinessKey";
        this.runtimeService.startProcessInstanceByKey("throwCompletePayloadSignal", businessKey, variables);
        Task catchingPiUserTask = (Task)this.taskService.createTaskQuery().singleResult();
        ProcessInstance catchingPI = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().processInstanceId(catchingPiUserTask.getProcessInstanceId()).singleResult();
        Assert.assertEquals((Object)businessKey, (Object)catchingPI.getBusinessKey());
        List targetVariables = this.runtimeService.createVariableInstanceQuery().processInstanceIdIn(new String[]{catchingPiUserTask.getProcessInstanceId()}).list();
        Assert.assertEquals((long)4L, (long)targetVariables.size());
        for (VariableInstance variable : targetVariables) {
            if (variable.getName().equals(globalVar1 + "Target")) {
                Assert.assertEquals((Object)globalVal1, (Object)variable.getValue());
                continue;
            }
            if (variable.getName().equals(globalVar2 + "Target")) {
                Assert.assertEquals((Object)(globalVal2 + "Source"), (Object)variable.getValue());
                continue;
            }
            if (variable.getName().equals(localVar1)) {
                Assert.assertEquals((Object)localVal1, (Object)variable.getValue());
                continue;
            }
            if (!variable.getName().equals(localVar2)) continue;
            Assert.assertEquals((Object)localVal2, (Object)variable.getValue());
        }
    }
}

