/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.bpmn.gateway;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.camunda.bpm.engine.ParseException;
import org.camunda.bpm.engine.Problem;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.ResourceReport;
import org.camunda.bpm.engine.impl.util.CollectionUtil;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.task.Task;
import org.camunda.bpm.engine.test.Deployment;
import org.camunda.bpm.engine.test.bpmn.gateway.ExclusiveGatewayTestOrder;
import org.camunda.bpm.engine.test.util.PluggableProcessEngineTest;
import org.camunda.bpm.engine.variable.Variables;
import org.junit.Assert;
import org.junit.Test;

public class ExclusiveGatewayTest
extends PluggableProcessEngineTest {
    @Deployment
    @Test
    public void testDivergingExclusiveGateway() {
        for (int i = 1; i <= 3; ++i) {
            ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("exclusiveGwDiverging", CollectionUtil.singletonMap((String)"input", (Object)i));
            Assert.assertEquals((Object)("Task " + i), (Object)((Task)this.taskService.createTaskQuery().singleResult()).getName());
            this.runtimeService.deleteProcessInstance(pi.getId(), "testing deletion");
        }
    }

    @Deployment
    @Test
    public void testMergingExclusiveGateway() {
        this.runtimeService.startProcessInstanceByKey("exclusiveGwMerging");
        Assert.assertEquals((long)3L, (long)this.taskService.createTaskQuery().count());
    }

    @Deployment
    @Test
    public void testMultipleValidConditions() {
        this.runtimeService.startProcessInstanceByKey("exclusiveGwMultipleValidConditions", CollectionUtil.singletonMap((String)"input", (Object)5));
        Assert.assertEquals((Object)"Task 2", (Object)((Task)this.taskService.createTaskQuery().singleResult()).getName());
    }

    @Deployment
    @Test
    public void testNoSequenceFlowSelected() {
        try {
            this.runtimeService.startProcessInstanceByKey("exclusiveGwNoSeqFlowSelected", CollectionUtil.singletonMap((String)"input", (Object)4));
            Assert.fail();
        }
        catch (ProcessEngineException e) {
            this.testRule.assertTextPresent("ENGINE-02004 No outgoing sequence flow for the element with id 'exclusiveGw' could be selected for continuing the process.", e.getMessage());
        }
    }

    @Deployment
    @Test
    public void testWhitespaceInExpression() {
        this.runtimeService.startProcessInstanceByKey("whiteSpaceInExpression", CollectionUtil.singletonMap((String)"input", (Object)1));
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/gateway/ExclusiveGatewayTest.testDivergingExclusiveGateway.bpmn20.xml"})
    @Test
    public void testUnknownVariableInExpression() {
        try {
            this.runtimeService.startProcessInstanceByKey("exclusiveGwDiverging", CollectionUtil.singletonMap((String)"iinput", (Object)1));
            Assert.fail();
        }
        catch (ProcessEngineException e) {
            this.testRule.assertTextPresent("Unknown property used in expression", e.getMessage());
        }
    }

    @Deployment
    @Test
    public void testDecideBasedOnBeanProperty() {
        this.runtimeService.startProcessInstanceByKey("decisionBasedOnBeanProperty", CollectionUtil.singletonMap((String)"order", (Object)new ExclusiveGatewayTestOrder(150)));
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        Assert.assertNotNull((Object)task);
        Assert.assertEquals((Object)"Standard service", (Object)task.getName());
    }

    @Deployment
    @Test
    public void testDecideBasedOnListOrArrayOfBeans() {
        ArrayList<ExclusiveGatewayTestOrder> orders = new ArrayList<ExclusiveGatewayTestOrder>();
        orders.add(new ExclusiveGatewayTestOrder(50));
        orders.add(new ExclusiveGatewayTestOrder(300));
        orders.add(new ExclusiveGatewayTestOrder(175));
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("decisionBasedOnListOrArrayOfBeans", CollectionUtil.singletonMap((String)"orders", orders));
        Task task = (Task)this.taskService.createTaskQuery().processInstanceId(pi.getId()).singleResult();
        Assert.assertNotNull((Object)task);
        Assert.assertEquals((Object)"Gold Member service", (Object)task.getName());
        ExclusiveGatewayTestOrder[] orderArray = orders.toArray(new ExclusiveGatewayTestOrder[orders.size()]);
        orderArray[1].setPrice(10);
        pi = this.runtimeService.startProcessInstanceByKey("decisionBasedOnListOrArrayOfBeans", CollectionUtil.singletonMap((String)"orders", (Object)orderArray));
        task = (Task)this.taskService.createTaskQuery().processInstanceId(pi.getId()).singleResult();
        Assert.assertNotNull((Object)task);
        Assert.assertEquals((Object)"Basic service", (Object)task.getName());
    }

    @Deployment
    @Test
    public void testDecideBasedOnBeanMethod() {
        this.runtimeService.startProcessInstanceByKey("decisionBasedOnBeanMethod", CollectionUtil.singletonMap((String)"order", (Object)new ExclusiveGatewayTestOrder(300)));
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        Assert.assertNotNull((Object)task);
        Assert.assertEquals((Object)"Gold Member service", (Object)task.getName());
    }

    @Deployment
    @Test
    public void testInvalidMethodExpression() {
        try {
            this.runtimeService.startProcessInstanceByKey("invalidMethodExpression", CollectionUtil.singletonMap((String)"order", (Object)new ExclusiveGatewayTestOrder(50)));
            Assert.fail();
        }
        catch (ProcessEngineException e) {
            this.testRule.assertTextPresent("Unknown method used in expression", e.getMessage());
        }
    }

    @Deployment
    @Test
    public void testDefaultSequenceFlow() {
        String procId = this.runtimeService.startProcessInstanceByKey("exclusiveGwDefaultSequenceFlow", CollectionUtil.singletonMap((String)"input", (Object)1)).getId();
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        Assert.assertEquals((Object)"Input is one", (Object)task.getName());
        this.runtimeService.deleteProcessInstance(procId, null);
        procId = this.runtimeService.startProcessInstanceByKey("exclusiveGwDefaultSequenceFlow", CollectionUtil.singletonMap((String)"input", (Object)5)).getId();
        task = (Task)this.taskService.createTaskQuery().singleResult();
        Assert.assertEquals((Object)"Default input", (Object)task.getName());
    }

    @Deployment
    @Test
    public void testNoIdOnSequenceFlow() {
        this.runtimeService.startProcessInstanceByKey("noIdOnSequenceFlow", CollectionUtil.singletonMap((String)"input", (Object)3));
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        Assert.assertEquals((Object)"Input is more than one", (Object)task.getName());
    }

    @Test
    public void testFlowWithoutConditionNoDefaultFlow() {
        String flowWithoutConditionNoDefaultFlow = "<?xml version='1.0' encoding='UTF-8'?><definitions id='definitions' xmlns='http://www.omg.org/spec/BPMN/20100524/MODEL' xmlns:xsi='http://www.w3.org/2001/XMLSchema-instance' xmlns:activiti='http://activiti.org/bpmn' targetNamespace='Examples'>  <process id='exclusiveGwDefaultSequenceFlow' isExecutable='true'>     <startEvent id='theStart' />     <sequenceFlow id='flow1' sourceRef='theStart' targetRef='exclusiveGw' />     <exclusiveGateway id='exclusiveGw' name='Exclusive Gateway' />     <sequenceFlow id='flow2' sourceRef='exclusiveGw' targetRef='theTask1'>       <conditionExpression xsi:type='tFormalExpression'>${input == 1}</conditionExpression>     </sequenceFlow>     <sequenceFlow id='flow3' sourceRef='exclusiveGw' targetRef='theTask2'/>     <sequenceFlow id='flow4' sourceRef='exclusiveGw' targetRef='theTask2'/>     <userTask id='theTask1' name='Input is one' />     <userTask id='theTask2' name='Default input' />   </process></definitions>";
        try {
            this.repositoryService.createDeployment().addString("myprocess.bpmn20.xml", flowWithoutConditionNoDefaultFlow).deploy();
            Assert.fail((String)"Could deploy a process definition with a sequence flow out of a XOR Gateway without condition with is not the default flow.");
        }
        catch (ParseException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("Exclusive Gateway 'exclusiveGw' has outgoing sequence flow 'flow3' without condition which is not the default flow."));
            Problem error = (Problem)((ResourceReport)e.getResorceReports().get(0)).getErrors().get(0);
            Assertions.assertThat((String)error.getMainElementId()).isEqualTo((Object)"exclusiveGw");
            Assertions.assertThat((List)error.getElementIds()).containsExactlyInAnyOrder((Object[])new String[]{"exclusiveGw", "flow3"});
        }
    }

    @Test
    public void testDefaultFlowWithCondition() {
        String defaultFlowWithCondition = "<?xml version='1.0' encoding='UTF-8'?><definitions id='definitions' xmlns='http://www.omg.org/spec/BPMN/20100524/MODEL' xmlns:xsi='http://www.w3.org/2001/XMLSchema-instance' xmlns:activiti='http://activiti.org/bpmn' targetNamespace='Examples'>  <process id='exclusiveGwDefaultSequenceFlow' isExecutable='true'>     <startEvent id='theStart' />     <sequenceFlow id='flow1' sourceRef='theStart' targetRef='exclusiveGw' />     <exclusiveGateway id='exclusiveGw' name='Exclusive Gateway' default='flow3' />     <sequenceFlow id='flow2' sourceRef='exclusiveGw' targetRef='theTask1'>       <conditionExpression xsi:type='tFormalExpression'>${input == 1}</conditionExpression>     </sequenceFlow>     <sequenceFlow id='flow3' sourceRef='exclusiveGw' targetRef='theTask2'>       <conditionExpression xsi:type='tFormalExpression'>${input == 3}</conditionExpression>     </sequenceFlow>     <userTask id='theTask1' name='Input is one' />     <userTask id='theTask2' name='Default input' />   </process></definitions>";
        try {
            this.repositoryService.createDeployment().addString("myprocess.bpmn20.xml", defaultFlowWithCondition).deploy();
            Assert.fail((String)"Could deploy a process definition with a sequence flow out of a XOR Gateway without condition with is not the default flow.");
        }
        catch (ParseException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("Exclusive Gateway 'exclusiveGw' has outgoing sequence flow 'flow3' which is the default flow but has a condition too."));
            Problem error = (Problem)((ResourceReport)e.getResorceReports().get(0)).getErrors().get(0);
            Assertions.assertThat((String)error.getMainElementId()).isEqualTo((Object)"exclusiveGw");
            Assertions.assertThat((List)error.getElementIds()).containsExactlyInAnyOrder((Object[])new String[]{"exclusiveGw", "flow3"});
        }
    }

    @Test
    public void testNoOutgoingFlow() {
        String noOutgoingFlow = "<?xml version='1.0' encoding='UTF-8'?><definitions id='definitions' xmlns='http://www.omg.org/spec/BPMN/20100524/MODEL' xmlns:xsi='http://www.w3.org/2001/XMLSchema-instance' xmlns:activiti='http://activiti.org/bpmn' targetNamespace='Examples'>  <process id='exclusiveGwDefaultSequenceFlow' isExecutable='true'>     <startEvent id='theStart' />     <sequenceFlow id='flow1' sourceRef='theStart' targetRef='exclusiveGw' />     <exclusiveGateway id='exclusiveGw' name='Exclusive Gateway' />   </process></definitions>";
        try {
            this.repositoryService.createDeployment().addString("myprocess.bpmn20.xml", noOutgoingFlow).deploy();
            Assert.fail((String)"Could deploy a process definition with a sequence flow out of a XOR Gateway without condition with is not the default flow.");
        }
        catch (ParseException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("Exclusive Gateway 'exclusiveGw' has no outgoing sequence flows."));
            Assertions.assertThat((String)((Problem)((ResourceReport)e.getResorceReports().get(0)).getErrors().get(0)).getMainElementId()).isEqualTo((Object)"exclusiveGw");
        }
    }

    @Deployment
    @Test
    public void testLoopWithManyIterations() {
        int numOfIterations = 1000;
        this.runtimeService.startProcessInstanceByKey("testProcess", (Map)Variables.createVariables().putValue("numOfIterations", (Object)numOfIterations));
    }

    @Deployment
    @Test
    public void testDecisionFunctionality() {
        HashMap<String, Integer> variables = new HashMap<String, Integer>();
        variables.put("input", 1);
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("exclusiveGateway", variables);
        Task task = (Task)this.taskService.createTaskQuery().processInstanceId(pi.getId()).singleResult();
        Assert.assertEquals((Object)"Send e-mail for more information", (Object)task.getName());
        variables.put("input", 2);
        pi = this.runtimeService.startProcessInstanceByKey("exclusiveGateway", variables);
        task = (Task)this.taskService.createTaskQuery().processInstanceId(pi.getId()).singleResult();
        Assert.assertEquals((Object)"Check account balance", (Object)task.getName());
        variables.put("input", 3);
        pi = this.runtimeService.startProcessInstanceByKey("exclusiveGateway", variables);
        task = (Task)this.taskService.createTaskQuery().processInstanceId(pi.getId()).singleResult();
        Assert.assertEquals((Object)"Call customer", (Object)task.getName());
        variables.put("input", 4);
        try {
            this.runtimeService.startProcessInstanceByKey("exclusiveGateway", variables);
            Assert.fail();
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }
}

