/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.concurrency;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.List;
import org.camunda.bpm.engine.impl.cmd.DeployCmd;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.repository.DeploymentBuilderImpl;
import org.camunda.bpm.engine.impl.test.RequiredDatabase;
import org.camunda.bpm.engine.repository.Deployment;
import org.camunda.bpm.engine.repository.DeploymentBuilder;
import org.camunda.bpm.engine.repository.DeploymentQuery;
import org.camunda.bpm.engine.repository.ProcessDefinition;
import org.camunda.bpm.engine.repository.ProcessDefinitionQuery;
import org.camunda.bpm.engine.test.concurrency.ConcurrencyTestCase;
import org.camunda.bpm.engine.test.concurrency.ConcurrencyTestHelper;
import org.camunda.bpm.model.bpmn.Bpmn;
import org.camunda.bpm.model.bpmn.BpmnModelInstance;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;

@RequiredDatabase(excludes={"h2"})
public class ConcurrentDeploymentTest
extends ConcurrencyTestCase {
    private static String processResource;

    @Test
    public void testDuplicateFiltering() throws InterruptedException {
        this.deployOnTwoConcurrentThreads(this.createDeploymentBuilder().enableDuplicateFiltering(false), this.createDeploymentBuilder().enableDuplicateFiltering(false));
        DeploymentQuery deploymentQuery = this.repositoryService.createDeploymentQuery();
        Assert.assertThat((Object)deploymentQuery.count(), (Matcher)CoreMatchers.is((Object)1L));
    }

    @Test
    public void testVersioning() throws InterruptedException {
        this.deployOnTwoConcurrentThreads(this.createDeploymentBuilder(), this.createDeploymentBuilder());
        List processDefinitions = ((ProcessDefinitionQuery)this.repositoryService.createProcessDefinitionQuery().orderByProcessDefinitionVersion().asc()).list();
        Assert.assertThat((Object)processDefinitions.size(), (Matcher)CoreMatchers.is((Object)2));
        Assert.assertThat((Object)((ProcessDefinition)processDefinitions.get(0)).getVersion(), (Matcher)CoreMatchers.is((Object)1));
        Assert.assertThat((Object)((ProcessDefinition)processDefinitions.get(1)).getVersion(), (Matcher)CoreMatchers.is((Object)2));
    }

    protected DeploymentBuilder createDeploymentBuilder() {
        return new DeploymentBuilderImpl(null).name("some-deployment-name").addString("foo.bpmn", processResource);
    }

    protected void deployOnTwoConcurrentThreads(DeploymentBuilder deploymentOne, DeploymentBuilder deploymentTwo) throws InterruptedException {
        Assert.assertThat((String)"you can not use the same deployment builder for both deployments", (Object)deploymentOne, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Object)deploymentTwo)));
        ConcurrencyTestHelper.ThreadControl thread1 = this.executeControllableCommand(new ControllableDeployCommand(deploymentOne));
        thread1.waitForSync();
        ConcurrencyTestHelper.ThreadControl thread2 = this.executeControllableCommand(new ControllableDeployCommand(deploymentTwo));
        thread2.waitForSync();
        thread1.makeContinue();
        thread1.waitForSync();
        thread2.makeContinue();
        Thread.sleep(2000L);
        thread1.waitUntilDone();
        thread2.waitForSync();
        thread2.waitUntilDone();
    }

    @After
    public void tearDown() throws Exception {
        for (Deployment deployment : this.repositoryService.createDeploymentQuery().list()) {
            this.repositoryService.deleteDeployment(deployment.getId(), true);
        }
    }

    static {
        BpmnModelInstance modelInstance = Bpmn.createExecutableProcess().startEvent().done();
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        Bpmn.writeModelToStream((OutputStream)outputStream, (BpmnModelInstance)modelInstance);
        processResource = new String(outputStream.toByteArray());
    }

    protected static class ControllableDeployCommand
    extends ConcurrencyTestHelper.ControllableCommand<Void> {
        private final DeploymentBuilder deploymentBuilder;

        public ControllableDeployCommand(DeploymentBuilder deploymentBuilder) {
            this.deploymentBuilder = deploymentBuilder;
        }

        public Void execute(CommandContext commandContext) {
            this.monitor.sync();
            new DeployCmd((DeploymentBuilderImpl)this.deploymentBuilder).execute(commandContext);
            this.monitor.sync();
            return null;
        }
    }
}

