/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.concurrency;

import java.util.Date;
import java.util.List;
import org.camunda.bpm.engine.history.HistoricProcessInstance;
import org.camunda.bpm.engine.impl.context.Context;
import org.camunda.bpm.engine.impl.db.DbEntity;
import org.camunda.bpm.engine.impl.db.entitymanager.DbEntityManager;
import org.camunda.bpm.engine.impl.db.entitymanager.DbEntityManagerFactory;
import org.camunda.bpm.engine.impl.history.event.HistoricProcessInstanceEventEntity;
import org.camunda.bpm.engine.impl.interceptor.Command;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.test.RequiredHistoryLevel;
import org.camunda.bpm.engine.test.concurrency.ConcurrencyTestCase;
import org.camunda.bpm.engine.test.concurrency.ConcurrencyTestHelper;
import org.junit.After;
import org.junit.Test;

@RequiredHistoryLevel(value="activity")
public class DbDeadlockTest
extends ConcurrencyTestCase {
    private ConcurrencyTestHelper.ThreadControl thread1;
    private ConcurrencyTestHelper.ThreadControl thread2;

    @Test
    public void testTransactionIsolation() {
        this.thread1 = this.executeControllableCommand(new TestCommand("p1"));
        this.thread1.waitForSync();
        this.thread2 = this.executeControllableCommand(new TestCommand("p2"));
        this.thread2.waitForSync();
        this.thread2.makeContinue();
        this.thread1.makeContinue();
        this.thread2.waitForSync();
        this.thread1.waitForSync();
    }

    @After
    public void tearDown() throws Exception {
        this.thread2.waitUntilDone();
        this.thread1.waitUntilDone();
        this.processEngineConfiguration.getCommandExecutorTxRequired().execute((Command)new Command<Void>(){

            public Void execute(CommandContext commandContext) {
                List list = commandContext.getDbEntityManager().createHistoricProcessInstanceQuery().list();
                for (HistoricProcessInstance historicProcessInstance : list) {
                    commandContext.getDbEntityManager().delete(HistoricProcessInstanceEventEntity.class, "deleteHistoricProcessInstance", (Object)historicProcessInstance.getId());
                }
                return null;
            }
        });
    }

    static class TestCommand
    extends ConcurrencyTestHelper.ControllableCommand<Void> {
        protected String id;

        public TestCommand(String id) {
            this.id = id;
        }

        public Void execute(CommandContext commandContext) {
            DbEntityManagerFactory dbEntityManagerFactory = new DbEntityManagerFactory(Context.getProcessEngineConfiguration().getIdGenerator());
            DbEntityManager newEntityManager = dbEntityManagerFactory.openSession();
            HistoricProcessInstanceEventEntity hpi = new HistoricProcessInstanceEventEntity();
            hpi.setId(this.id);
            hpi.setProcessInstanceId(this.id);
            hpi.setProcessDefinitionId("someProcDefId");
            hpi.setStartTime(new Date());
            hpi.setState("ACTIVE");
            newEntityManager.insert((DbEntity)hpi);
            newEntityManager.flush();
            this.monitor.sync();
            DbEntityManager cmdEntityManager = commandContext.getDbEntityManager();
            cmdEntityManager.createHistoricProcessInstanceQuery().list();
            this.monitor.sync();
            return null;
        }
    }
}

