/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.concurrency;

import java.util.concurrent.atomic.AtomicReference;
import org.assertj.core.api.Assertions;
import org.camunda.bpm.engine.impl.db.DbEntity;
import org.camunda.bpm.engine.impl.interceptor.Command;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.persistence.entity.JobEntity;
import org.camunda.bpm.engine.impl.persistence.entity.MessageEntity;
import org.camunda.bpm.engine.test.concurrency.ConcurrencyTestCase;
import org.camunda.bpm.engine.test.concurrency.ConcurrencyTestHelper;
import org.junit.After;
import org.junit.Test;

public class ThrowOleWhenDeletingExceptionStacktraceTest
extends ConcurrencyTestCase {
    protected AtomicReference<JobEntity> job = new AtomicReference();

    @After
    public void tearDown() throws Exception {
        if (this.job.get() != null) {
            this.processEngineConfiguration.getCommandExecutorTxRequired().execute(commandContext -> {
                JobEntity jobEntity = this.job.get();
                jobEntity.setRevision(2);
                commandContext.getJobManager().deleteJob(jobEntity);
                commandContext.getByteArrayManager().deleteByteArrayById(jobEntity.getExceptionByteArrayId());
                commandContext.getHistoricJobLogManager().deleteHistoricJobLogByJobId(jobEntity.getId());
                return null;
            });
        }
    }

    @Test
    public void testThrowOleWhenDeletingExceptionStacktraceTest() {
        this.processEngineConfiguration.getCommandExecutorTxRequired().execute((Command)new Command<Void>(){

            public Void execute(CommandContext commandContext) {
                MessageEntity jobEntity = new MessageEntity();
                jobEntity.setExceptionStacktrace("foo");
                commandContext.getJobManager().insert((DbEntity)jobEntity);
                ThrowOleWhenDeletingExceptionStacktraceTest.this.job.set((JobEntity)jobEntity);
                return null;
            }
        });
        ConcurrencyTestHelper.ThreadControl threadOne = this.executeControllableCommand(new ThreadOne());
        ConcurrencyTestHelper.ThreadControl threadTwo = this.executeControllableCommand(new ThreadTwo());
        threadTwo.reportInterrupts();
        threadOne.waitForSync();
        threadTwo.waitForSync();
        threadTwo.makeContinueAndWaitForSync();
        threadOne.makeContinue();
        threadOne.join();
        threadTwo.makeContinue();
        threadTwo.join();
        Assertions.assertThat((String)threadTwo.getException().getMessage()).contains(new CharSequence[]{"Entity was updated by another transaction concurrently."});
    }

    public class ThreadTwo
    extends ConcurrencyTestHelper.ControllableCommand<Void> {
        public Void execute(CommandContext commandContext) {
            this.monitor.sync();
            JobEntity jobEntity = commandContext.getJobManager().findJobById(ThrowOleWhenDeletingExceptionStacktraceTest.this.job.get().getId());
            this.monitor.sync();
            commandContext.getJobManager().deleteJob(jobEntity);
            String byteArrayId = jobEntity.getExceptionByteArrayId();
            commandContext.getByteArrayManager().deleteByteArrayById(byteArrayId);
            return null;
        }
    }

    public class ThreadOne
    extends ConcurrencyTestHelper.ControllableCommand<Void> {
        public Void execute(CommandContext commandContext) {
            this.monitor.sync();
            JobEntity jobEntity = commandContext.getJobManager().findJobById(ThrowOleWhenDeletingExceptionStacktraceTest.this.job.get().getId());
            jobEntity.setLockOwner("foo");
            return null;
        }
    }
}

