/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.concurrency.partitioning;

import java.util.Map;
import org.camunda.bpm.engine.history.HistoricVariableInstance;
import org.camunda.bpm.engine.impl.db.DbEntity;
import org.camunda.bpm.engine.impl.interceptor.Command;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.persistence.entity.HistoricVariableInstanceEntity;
import org.camunda.bpm.engine.runtime.VariableInstance;
import org.camunda.bpm.engine.test.concurrency.ConcurrencyTestHelper;
import org.camunda.bpm.engine.test.concurrency.partitioning.AbstractPartitioningTest;
import org.camunda.bpm.engine.variable.Variables;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Test;

public class CompetingHistoricVariableInstancePartitioningTest
extends AbstractPartitioningTest {
    protected final String VARIABLE_NAME = "aVariableName";
    protected final String VARIABLE_VALUE = "aVariableValue";
    protected final String ANOTHER_VARIABLE_VALUE = "anotherVariableValue";

    @Test
    public void testConcurrentFetchAndDelete() {
        String processInstanceId = this.deployAndStartProcess(this.PROCESS_WITH_USERTASK, (Map<String, Object>)Variables.createVariables().putValue("aVariableName", (Object)"aVariableValue")).getId();
        ConcurrencyTestHelper.ThreadControl asyncThread = this.executeControllableCommand(new AsyncThread(processInstanceId));
        asyncThread.waitForSync();
        this.commandExecutor.execute((Command)new Command<Void>(){

            public Void execute(CommandContext commandContext) {
                HistoricVariableInstanceEntity historicVariableInstanceEntity = (HistoricVariableInstanceEntity)CompetingHistoricVariableInstancePartitioningTest.this.historyService.createHistoricVariableInstanceQuery().singleResult();
                commandContext.getDbEntityManager().delete((DbEntity)historicVariableInstanceEntity);
                return null;
            }
        });
        MatcherAssert.assertThat((Object)this.historyService.createHistoricVariableInstanceQuery().singleResult(), (Matcher)CoreMatchers.nullValue());
        asyncThread.makeContinue();
        asyncThread.waitUntilDone();
        MatcherAssert.assertThat((Object)((VariableInstance)this.runtimeService.createVariableInstanceQuery().singleResult()).getName(), (Matcher)CoreMatchers.is((Object)"aVariableName"));
        MatcherAssert.assertThat((Object)((String)((VariableInstance)this.runtimeService.createVariableInstanceQuery().singleResult()).getValue()), (Matcher)CoreMatchers.is((Object)"anotherVariableValue"));
    }

    public class AsyncThread
    extends ConcurrencyTestHelper.ControllableCommand<Void> {
        String processInstanceId;

        AsyncThread(String processInstanceId) {
            this.processInstanceId = processInstanceId;
        }

        public Void execute(CommandContext commandContext) {
            ((HistoricVariableInstance)CompetingHistoricVariableInstancePartitioningTest.this.historyService.createHistoricVariableInstanceQuery().singleResult()).getId();
            this.monitor.sync();
            commandContext.getProcessEngineConfiguration().getRuntimeService().setVariable(this.processInstanceId, "aVariableName", (Object)"anotherVariableValue");
            return null;
        }
    }
}

