/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl;

import java.util.UUID;
import org.camunda.bpm.engine.ProcessEngineBootstrapCommand;
import org.camunda.bpm.engine.impl.ProcessEngineLogger;
import org.camunda.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.camunda.bpm.engine.impl.context.Context;
import org.camunda.bpm.engine.impl.db.DbEntity;
import org.camunda.bpm.engine.impl.db.EnginePersistenceLogger;
import org.camunda.bpm.engine.impl.db.entitymanager.OptimisticLockingListener;
import org.camunda.bpm.engine.impl.db.entitymanager.operation.DbOperation;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.persistence.entity.EverLivingJobEntity;
import org.camunda.bpm.engine.impl.persistence.entity.PropertyEntity;

public class BootstrapEngineCommand
implements ProcessEngineBootstrapCommand {
    private static final EnginePersistenceLogger LOG = ProcessEngineLogger.PERSISTENCE_LOGGER;
    protected static final String TELEMETRY_PROPERTY_NAME = "camunda.telemetry.enabled";
    protected static final String INSTALLATION_PROPERTY_NAME = "camunda.installation.id";

    @Override
    public Void execute(CommandContext commandContext) {
        this.initializeInstallationId(commandContext);
        this.checkDeploymentLockExists(commandContext);
        if (this.isHistoryCleanupEnabled(commandContext)) {
            this.checkHistoryCleanupLockExists(commandContext);
            this.createHistoryCleanupJob(commandContext);
        }
        this.initializeTelemetryProperty(commandContext);
        this.updateTelemetryData(commandContext);
        this.startTelemetryReporter(commandContext);
        return null;
    }

    protected void createHistoryCleanupJob(CommandContext commandContext) {
        if (Context.getProcessEngineConfiguration().getManagementService().getTableMetaData("ACT_RU_JOB") != null) {
            commandContext.getDbEntityManager().registerOptimisticLockingListener(new OptimisticLockingListener(){

                @Override
                public Class<? extends DbEntity> getEntityType() {
                    return EverLivingJobEntity.class;
                }

                @Override
                public void failedOperation(DbOperation operation) {
                }
            });
            Context.getProcessEngineConfiguration().getHistoryService().cleanUpHistoryAsync();
        }
    }

    public void checkDeploymentLockExists(CommandContext commandContext) {
        PropertyEntity deploymentLockProperty = commandContext.getPropertyManager().findPropertyById("deployment.lock");
        if (deploymentLockProperty == null) {
            LOG.noDeploymentLockPropertyFound();
        }
    }

    public void checkHistoryCleanupLockExists(CommandContext commandContext) {
        PropertyEntity historyCleanupLockProperty = commandContext.getPropertyManager().findPropertyById("history.cleanup.job.lock");
        if (historyCleanupLockProperty == null) {
            LOG.noHistoryCleanupLockPropertyFound();
        }
    }

    protected boolean isHistoryCleanupEnabled(CommandContext commandContext) {
        return commandContext.getProcessEngineConfiguration().isHistoryCleanupEnabled();
    }

    public void initializeTelemetryProperty(CommandContext commandContext) {
        try {
            this.checkTelemetryLockExists(commandContext);
            commandContext.getPropertyManager().acquireExclusiveLockForTelemetry();
            PropertyEntity databaseTelemetryProperty = this.databaseTelemetryConfiguration(commandContext);
            if (databaseTelemetryProperty == null) {
                LOG.noTelemetryPropertyFound();
                this.createTelemetryProperty(commandContext);
            }
        }
        catch (Exception e) {
            LOG.errorConfiguringTelemetryProperty(e);
        }
    }

    protected void checkTelemetryLockExists(CommandContext commandContext) {
        PropertyEntity telemetryLockProperty = commandContext.getPropertyManager().findPropertyById("telemetry.lock");
        if (telemetryLockProperty == null) {
            LOG.noTelemetryLockPropertyFound();
        }
    }

    protected PropertyEntity databaseTelemetryConfiguration(CommandContext commandContext) {
        try {
            return commandContext.getPropertyManager().findPropertyById(TELEMETRY_PROPERTY_NAME);
        }
        catch (Exception e) {
            LOG.errorFetchingTelemetryPropertyInDatabase(e);
            return null;
        }
    }

    protected void createTelemetryProperty(CommandContext commandContext) {
        boolean telemetryEnabled = Context.getProcessEngineConfiguration().isInitializeTelemetry();
        PropertyEntity property = new PropertyEntity(TELEMETRY_PROPERTY_NAME, Boolean.toString(telemetryEnabled));
        commandContext.getPropertyManager().insert(property);
        LOG.creatingTelemetryPropertyInDatabase(telemetryEnabled);
    }

    public void initializeInstallationId(CommandContext commandContext) {
        this.checkInstallationIdLockExists(commandContext);
        String databaseInstallationId = this.databaseInstallationId(commandContext);
        if (databaseInstallationId == null || databaseInstallationId.isEmpty()) {
            commandContext.getPropertyManager().acquireExclusiveLockForInstallationId();
            databaseInstallationId = this.databaseInstallationId(commandContext);
            if (databaseInstallationId == null || databaseInstallationId.isEmpty()) {
                LOG.noInstallationIdPropertyFound();
                this.createInstallationProperty(commandContext);
            }
        } else {
            LOG.installationIdPropertyFound(databaseInstallationId);
            commandContext.getProcessEngineConfiguration().setInstallationId(databaseInstallationId);
        }
    }

    protected void createInstallationProperty(CommandContext commandContext) {
        String installationId = UUID.randomUUID().toString();
        PropertyEntity property = new PropertyEntity(INSTALLATION_PROPERTY_NAME, installationId);
        commandContext.getPropertyManager().insert(property);
        LOG.creatingInstallationPropertyInDatabase(property.getValue());
        commandContext.getProcessEngineConfiguration().setInstallationId(installationId);
    }

    protected String databaseInstallationId(CommandContext commandContext) {
        try {
            PropertyEntity installationIdProperty = commandContext.getPropertyManager().findPropertyById(INSTALLATION_PROPERTY_NAME);
            return installationIdProperty != null ? installationIdProperty.getValue() : null;
        }
        catch (Exception e) {
            LOG.couldNotSelectInstallationId(e.getMessage());
            return null;
        }
    }

    protected void checkInstallationIdLockExists(CommandContext commandContext) {
        PropertyEntity installationIdProperty = commandContext.getPropertyManager().findPropertyById("installationId.lock");
        if (installationIdProperty == null) {
            LOG.noInstallationIdLockPropertyFound();
        }
    }

    protected void updateTelemetryData(CommandContext commandContext) {
        ProcessEngineConfigurationImpl processEngineConfiguration = commandContext.getProcessEngineConfiguration();
        String installationId = processEngineConfiguration.getInstallationId();
        processEngineConfiguration.getTelemetryData().setInstallation(installationId);
    }

    protected void startTelemetryReporter(CommandContext commandContext) {
        ProcessEngineConfigurationImpl processEngineConfiguration = commandContext.getProcessEngineConfiguration();
        if (processEngineConfiguration.getManagementService().isTelemetryEnabled() && processEngineConfiguration.getTelemetryReporter() != null && processEngineConfiguration.getTelemetryReporter().getHttpConnector() != null) {
            processEngineConfiguration.getTelemetryReporter().start();
        }
    }
}

