/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.cmd;

import org.camunda.bpm.engine.impl.ProcessEngineLogger;
import org.camunda.bpm.engine.impl.interceptor.Command;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.persistence.entity.AuthorizationManager;
import org.camunda.bpm.engine.impl.persistence.entity.PropertyEntity;
import org.camunda.bpm.engine.impl.telemetry.TelemetryLogger;
import org.camunda.bpm.engine.impl.telemetry.reporter.TelemetryReporter;

public class TelemetryConfigureCmd
implements Command<Void> {
    protected static final TelemetryLogger LOG = ProcessEngineLogger.TELEMETRY_LOGGER;
    protected static final String TELEMETRY_PROPERTY = "camunda.telemetry.enabled";
    protected boolean telemetryEnabled;

    public TelemetryConfigureCmd(boolean telemetryEnabled) {
        this.telemetryEnabled = telemetryEnabled;
    }

    @Override
    public Void execute(CommandContext commandContext) {
        AuthorizationManager authorizationManager = commandContext.getAuthorizationManager();
        authorizationManager.checkCamundaAdmin();
        PropertyEntity telemetryProperty = commandContext.getPropertyManager().findPropertyById(TELEMETRY_PROPERTY);
        if (telemetryProperty != null) {
            telemetryProperty.setValue(Boolean.toString(this.telemetryEnabled));
        } else {
            LOG.databaseTelemetryPropertyMissingInfo(this.telemetryEnabled);
            telemetryProperty = new PropertyEntity(TELEMETRY_PROPERTY, Boolean.toString(this.telemetryEnabled));
            commandContext.getPropertyManager().insert(telemetryProperty);
        }
        TelemetryReporter telemetryReporter = commandContext.getProcessEngineConfiguration().getTelemetryReporter();
        if (this.telemetryEnabled) {
            telemetryReporter.start();
        } else {
            telemetryReporter.stop();
        }
        return null;
    }
}

