/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.telemetry;

import org.camunda.bpm.engine.impl.ProcessEngineLogger;

public class TelemetryLogger
extends ProcessEngineLogger {
    public void startTelemetrySendingTask() {
        this.logDebug("001", "Start telemetry sending task.", new Object[0]);
    }

    public void exceptionWhileSendingTelemetryData(Exception e) {
        this.logDebug("002", "'{}' exception occurred while sending telemetry data with message: {}", new Object[]{e.getClass().getCanonicalName(), e.getMessage()});
    }

    public void unexpectedResponseWhileSendingTelemetryData(int responseCode) {
        this.logDebug("003", "Unexpected response while sending telemetry data. Status code: {}", new Object[]{responseCode});
    }

    public void unexpectedResponseWhileSendingTelemetryData() {
        this.logDebug("004", "Unexpected 'null' response while sending telemetry data.", new Object[0]);
    }

    public void telemetryDataSent(String data) {
        this.logDebug("005", "Telemetry data sent: {}", new Object[]{data});
    }

    public void databaseTelemetryPropertyMissingInfo(boolean telemetryEnabled) {
        this.logInfo("006", "`camunda.telemetry.enabled` property is missing in the database, creating the property with value: {}", new Object[]{Boolean.toString(telemetryEnabled)});
    }

    public void databaseTelemetryPropertyMissingInfo() {
        this.logInfo("007", "`camunda.telemetry.enabled` property is missing in the database", new Object[0]);
    }

    public void telemetryDisabled() {
        this.logDebug("008", "Sending telemetry is disabled.", new Object[0]);
    }

    public void schedulingTaskFails(String message) {
        this.logDebug("009", "An exception occured during scheduling telemetry task: {}", new Object[]{message});
    }

    public void unableToConfigureHttpConnectorWarning() {
        this.logWarn("010", "The http connector used to send telemetry is `null`, telemetry data will not be sent.", new Object[0]);
    }

    public void unexpectedExceptionDuringHttpConnectorConfiguration(Exception e) {
        this.logDebug("011", "'{}' exception occurred while configuring http connector with message: {}", new Object[]{e.getClass().getCanonicalName(), e.getMessage()});
    }
}

