/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.telemetry.reporter;

import java.util.Map;
import java.util.TimerTask;
import org.camunda.bpm.engine.impl.ProcessEngineLogger;
import org.camunda.bpm.engine.impl.interceptor.CommandExecutor;
import org.camunda.bpm.engine.impl.telemetry.TelemetryLogger;
import org.camunda.bpm.engine.impl.telemetry.dto.Data;
import org.camunda.bpm.engine.impl.util.ConnectUtil;
import org.camunda.bpm.engine.impl.util.JsonUtil;
import org.camunda.connect.spi.CloseableConnectorResponse;
import org.camunda.connect.spi.Connector;
import org.camunda.connect.spi.ConnectorRequest;

public class TelemetrySendingTask
extends TimerTask {
    protected static final TelemetryLogger LOG = ProcessEngineLogger.TELEMETRY_LOGGER;
    protected CommandExecutor commandExecutor;
    protected String telemetryEndpoint;
    protected Data data;
    protected Connector<? extends ConnectorRequest<?>> httpConnector;

    public TelemetrySendingTask(CommandExecutor commandExecutor, String telemetryEndpoint, Data data, Connector<? extends ConnectorRequest<?>> httpConnector) {
        this.commandExecutor = commandExecutor;
        this.telemetryEndpoint = telemetryEndpoint;
        this.data = data;
        this.httpConnector = httpConnector;
    }

    @Override
    public void run() {
        LOG.startTelemetrySendingTask();
        try {
            this.sendData();
        }
        catch (Exception e) {
            LOG.exceptionWhileSendingTelemetryData(e);
        }
    }

    protected void sendData() {
        this.commandExecutor.execute(commandContext -> {
            block6: {
                if (commandContext.getProcessEngineConfiguration().getManagementService().isTelemetryEnabled()) {
                    try {
                        String telemetryData = JsonUtil.asString(this.data);
                        Map<String, Object> requestParams = ConnectUtil.assembleRequestParameters("POST", this.telemetryEndpoint, "application/json", telemetryData);
                        ConnectorRequest request = this.httpConnector.createRequest();
                        request.setRequestParameters(requestParams);
                        CloseableConnectorResponse response = (CloseableConnectorResponse)request.execute();
                        if (response == null) {
                            LOG.unexpectedResponseWhileSendingTelemetryData();
                            break block6;
                        }
                        int responseCode = (Integer)response.getResponseParameter("statusCode");
                        if (responseCode != 202) {
                            LOG.unexpectedResponseWhileSendingTelemetryData(responseCode);
                            break block6;
                        }
                        LOG.telemetryDataSent(telemetryData);
                    }
                    catch (Exception e) {
                        LOG.exceptionWhileSendingTelemetryData(e);
                    }
                } else {
                    LOG.telemetryDisabled();
                }
            }
            return null;
        });
    }
}

