/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.mgmt.telemetry;

import org.assertj.core.api.Assertions;
import org.camunda.bpm.engine.impl.ProcessEngineImpl;
import org.camunda.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.camunda.bpm.engine.impl.cfg.StandaloneInMemProcessEngineConfiguration;
import org.camunda.commons.testing.ProcessEngineLoggingRule;
import org.camunda.commons.testing.WatchLogger;
import org.junit.After;
import org.junit.Rule;
import org.junit.Test;

public class TelemetryConfigurationTest {
    protected static final String TELEMETRY_ENDPOINT = "http://localhost:8082/pings";
    @Rule
    public ProcessEngineLoggingRule loggingRule = new ProcessEngineLoggingRule();
    protected ProcessEngineConfigurationImpl inMemoryConfiguration;

    @After
    public void reset() {
        if (this.inMemoryConfiguration != null) {
            this.inMemoryConfiguration.getManagementService().toggleTelemetry(false);
            ProcessEngineImpl processEngineImpl = this.inMemoryConfiguration.getProcessEngine();
            processEngineImpl.close();
            Object var1_1 = null;
        }
    }

    @Test
    public void shouldStartEngineTelemetryDisabled() {
        this.inMemoryConfiguration = new StandaloneInMemProcessEngineConfiguration();
        this.inMemoryConfiguration.setJdbcUrl("jdbc:h2:mem:camunda" + this.getClass().getSimpleName()).setInitializeTelemetry(Boolean.valueOf(false));
        this.inMemoryConfiguration.buildProcessEngine();
        Assertions.assertThat((Boolean)this.inMemoryConfiguration.isInitializeTelemetry()).isFalse();
        Assertions.assertThat((Boolean)this.inMemoryConfiguration.getManagementService().isTelemetryEnabled()).isFalse();
    }

    @Test
    public void shouldStartEngineWithTelemetryEnabled() {
        this.inMemoryConfiguration = new StandaloneInMemProcessEngineConfiguration();
        this.inMemoryConfiguration.setJdbcUrl("jdbc:h2:mem:camunda" + this.getClass().getSimpleName()).setTelemetryEndpoint(TELEMETRY_ENDPOINT).setInitializeTelemetry(Boolean.valueOf(true));
        this.inMemoryConfiguration.buildProcessEngine();
        Assertions.assertThat((Boolean)this.inMemoryConfiguration.isInitializeTelemetry()).isTrue();
        Assertions.assertThat((Boolean)this.inMemoryConfiguration.getManagementService().isTelemetryEnabled()).isTrue();
    }

    @Test
    public void shouldStartEngineWithChangedTelemetryEndpoint() {
        this.inMemoryConfiguration = new StandaloneInMemProcessEngineConfiguration();
        this.inMemoryConfiguration.setJdbcUrl("jdbc:h2:mem:camunda" + this.getClass().getSimpleName()).setTelemetryEndpoint(TELEMETRY_ENDPOINT);
        this.inMemoryConfiguration.buildProcessEngine();
        Assertions.assertThat((String)this.inMemoryConfiguration.getTelemetryEndpoint()).isEqualTo((Object)TELEMETRY_ENDPOINT);
    }

    @Test
    @WatchLogger(loggerNames={"org.camunda.bpm.engine.persistence"}, level="DEBUG")
    public void shouldLogDefaultTelemetryValue() {
        Object telemetryInitializedValue = null;
        this.inMemoryConfiguration = new StandaloneInMemProcessEngineConfiguration();
        this.inMemoryConfiguration.setJdbcUrl("jdbc:h2:mem:camunda" + this.getClass().getSimpleName());
        this.inMemoryConfiguration.buildProcessEngine();
        Assertions.assertThat((int)this.loggingRule.getFilteredLog("Creating the telemetry property in database with the value: " + telemetryInitializedValue).size()).isOne();
    }

    @Test
    @WatchLogger(loggerNames={"org.camunda.bpm.engine.persistence"}, level="DEBUG")
    public void shouldLogTelemetryPersistenceLog() {
        boolean telemetryInitialized = true;
        this.inMemoryConfiguration = new StandaloneInMemProcessEngineConfiguration();
        this.inMemoryConfiguration.setInitializeTelemetry(Boolean.valueOf(telemetryInitialized)).setJdbcUrl("jdbc:h2:mem:camunda" + this.getClass().getSimpleName());
        this.inMemoryConfiguration.buildProcessEngine();
        Assertions.assertThat((int)this.loggingRule.getFilteredLog("No telemetry property found in the database").size()).isOne();
        Assertions.assertThat((int)this.loggingRule.getFilteredLog("Creating the telemetry property in database with the value: " + telemetryInitialized).size()).isOne();
    }
}

