/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.mgmt.telemetry;

import java.util.Map;
import org.assertj.core.api.Assertions;
import org.camunda.bpm.engine.ProcessEngine;
import org.camunda.bpm.engine.ProcessEngines;
import org.camunda.bpm.engine.RuntimeService;
import org.camunda.bpm.engine.TaskService;
import org.camunda.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.camunda.bpm.engine.impl.cfg.StandaloneInMemProcessEngineConfiguration;
import org.camunda.bpm.engine.impl.telemetry.CommandCounter;
import org.camunda.bpm.engine.impl.telemetry.TelemetryRegistry;
import org.camunda.bpm.engine.task.Task;
import org.camunda.bpm.engine.test.Deployment;
import org.camunda.bpm.engine.test.ProcessEngineRule;
import org.camunda.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.junit.After;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;

public class TelemetryRegistryCounterTest {
    public ProcessEngineRule engineRule = new ProvidedProcessEngineRule();
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.engineRule);
    protected ProcessEngineConfigurationImpl configuration;
    protected RuntimeService runtimeService;
    protected TaskService taskService;
    protected ProcessEngine processEngineInMem;

    @Before
    public void init() {
        this.configuration = this.engineRule.getProcessEngineConfiguration();
        this.runtimeService = this.configuration.getRuntimeService();
        this.taskService = this.configuration.getTaskService();
    }

    @After
    public void tearDown() {
        this.configuration.setTelemetryRegistry(new TelemetryRegistry());
        if (this.processEngineInMem != null) {
            ProcessEngines.unregister((ProcessEngine)this.processEngineInMem);
            this.processEngineInMem.close();
        }
    }

    @Test
    public void shouldCountCommandsFromEngineStart() {
        this.processEngineInMem = new StandaloneInMemProcessEngineConfiguration().setJdbcUrl("jdbc:h2:mem:camunda" + this.getClass().getSimpleName()).buildProcessEngine();
        TelemetryRegistry telemetryRegistry = this.processEngineInMem.getProcessEngineConfiguration().getTelemetryRegistry();
        Map entries = telemetryRegistry.getCommands();
        Assertions.assertThat((int)entries.size()).isEqualTo(6);
        Assertions.assertThat(entries.keySet()).containsExactlyInAnyOrder((Object[])new String[]{"SchemaOperationsProcessEngineBuild", "HistoryLevelSetupCommand", "GetTableMetaDataCmd", "HistoryCleanupCmd", "IsTelemetryEnabledCmd", "BootstrapEngineCommand"});
        for (String commandName : entries.keySet()) {
            Assertions.assertThat((long)((CommandCounter)entries.get(commandName)).get()).isEqualTo(1L);
        }
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void shouldCountAfterCleaning() {
        this.clearCommandCounts();
        Map entries = this.configuration.getTelemetryRegistry().getCommands();
        String processInstanceId = this.runtimeService.startProcessInstanceByKey("oneTaskProcess").getId();
        this.runtimeService.setVariable(processInstanceId, "foo", (Object)"bar");
        Task task = (Task)this.taskService.createTaskQuery().processInstanceId(processInstanceId).singleResult();
        this.taskService.complete(task.getId());
        Assertions.assertThat((int)entries.size()).isEqualTo(4);
        Object[] expectedExcutedCommands = new String[]{"StartProcessInstanceCmd", "SetExecutionVariablesCmd", "TaskQueryImpl", "CompleteTaskCmd"};
        Assertions.assertThat(entries.keySet()).contains(expectedExcutedCommands);
        for (Object commandName : expectedExcutedCommands) {
            Assertions.assertThat((long)((CommandCounter)entries.get(commandName)).get()).isEqualTo(1L);
        }
    }

    protected void clearCommandCounts() {
        TelemetryRegistry telemetryRegistry = this.configuration.getTelemetryRegistry();
        Map entries = telemetryRegistry.getCommands();
        entries.clear();
    }
}

