/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.mgmt.telemetry;

import camundajar.impl.com.google.gson.Gson;
import com.github.tomakehurst.wiremock.client.MappingBuilder;
import com.github.tomakehurst.wiremock.client.RequestPatternBuilder;
import com.github.tomakehurst.wiremock.client.UrlMatchingStrategy;
import com.github.tomakehurst.wiremock.client.WireMock;
import com.github.tomakehurst.wiremock.junit.WireMockRule;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.camunda.bpm.dmn.engine.impl.DefaultDmnEngineConfiguration;
import org.camunda.bpm.engine.ManagementService;
import org.camunda.bpm.engine.ProcessEngine;
import org.camunda.bpm.engine.ProcessEngines;
import org.camunda.bpm.engine.RuntimeService;
import org.camunda.bpm.engine.TaskService;
import org.camunda.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.camunda.bpm.engine.impl.cfg.StandaloneInMemProcessEngineConfiguration;
import org.camunda.bpm.engine.impl.history.HistoryLevel;
import org.camunda.bpm.engine.impl.metrics.Meter;
import org.camunda.bpm.engine.impl.telemetry.TelemetryRegistry;
import org.camunda.bpm.engine.impl.telemetry.dto.ApplicationServer;
import org.camunda.bpm.engine.impl.telemetry.dto.Command;
import org.camunda.bpm.engine.impl.telemetry.dto.Data;
import org.camunda.bpm.engine.impl.telemetry.dto.Database;
import org.camunda.bpm.engine.impl.telemetry.dto.Internals;
import org.camunda.bpm.engine.impl.telemetry.dto.Metric;
import org.camunda.bpm.engine.impl.telemetry.dto.Product;
import org.camunda.bpm.engine.impl.telemetry.reporter.TelemetryReporter;
import org.camunda.bpm.engine.impl.util.ClockUtil;
import org.camunda.bpm.engine.task.Task;
import org.camunda.bpm.engine.test.Deployment;
import org.camunda.bpm.engine.test.ProcessEngineRule;
import org.camunda.bpm.engine.test.RequiredHistoryLevel;
import org.camunda.bpm.engine.test.util.ProcessEngineBootstrapRule;
import org.camunda.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.camunda.bpm.engine.test.util.ResetDmnConfigUtil;
import org.camunda.commons.testing.ProcessEngineLoggingRule;
import org.camunda.commons.testing.WatchLogger;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;

public class TelemetryReporterTest {
    protected static final String TELEMETRY_ENDPOINT = "http://localhost:8081/pings";
    private static final String TELEMETRY_ENDPOINT_PATH = "/pings";
    @ClassRule
    public static ProcessEngineBootstrapRule bootstrapRule = new ProcessEngineBootstrapRule(configuration -> configuration.setTelemetryEndpoint(TELEMETRY_ENDPOINT));
    protected ProcessEngineRule engineRule = new ProvidedProcessEngineRule(bootstrapRule);
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.engineRule);
    @Rule
    public ProcessEngineLoggingRule loggingRule = new ProcessEngineLoggingRule();
    @ClassRule
    public static WireMockRule wireMockRule = new WireMockRule(8081);
    protected ProcessEngine standaloneProcessEngine;
    protected ProcessEngineConfigurationImpl configuration;
    protected ManagementService managementService;
    protected RuntimeService runtimeService;
    protected TaskService taskService;

    @Before
    public void init() {
        this.configuration = this.engineRule.getProcessEngineConfiguration();
        this.managementService = this.configuration.getManagementService();
        this.runtimeService = this.configuration.getRuntimeService();
        this.taskService = this.configuration.getTaskService();
        DefaultDmnEngineConfiguration dmnEngineConfiguration = this.configuration.getDmnEngineConfiguration();
        ResetDmnConfigUtil.reset(dmnEngineConfiguration).enableFeelLegacyBehavior(true).init();
        this.clearMetrics();
        this.configuration.setTelemetryRegistry(new TelemetryRegistry());
    }

    @After
    public void tearDown() {
        ClockUtil.resetClock();
        this.managementService.toggleTelemetry(false);
        this.clearMetrics();
        if (this.standaloneProcessEngine != null) {
            this.standaloneProcessEngine.close();
            ProcessEngines.unregister((ProcessEngine)this.standaloneProcessEngine);
        }
        DefaultDmnEngineConfiguration dmnEngineConfiguration = this.configuration.getDmnEngineConfiguration();
        ResetDmnConfigUtil.reset(dmnEngineConfiguration).enableFeelLegacyBehavior(false).init();
    }

    protected void clearMetrics() {
        Collection meters = this.configuration.getMetricsRegistry().getMeters().values();
        for (Meter meter : meters) {
            meter.getAndClear();
        }
        this.managementService.deleteMetrics(null);
    }

    @Test
    public void shouldSendTelemetry() {
        this.managementService.toggleTelemetry(true);
        Data data = this.createDataToSend();
        String requestBody = new Gson().toJson((Object)data);
        WireMock.stubFor((MappingBuilder)WireMock.post((UrlMatchingStrategy)WireMock.urlEqualTo((String)TELEMETRY_ENDPOINT_PATH)).willReturn(WireMock.aResponse().withBody(requestBody).withStatus(202)));
        TelemetryReporter telemetryReporter = new TelemetryReporter(this.configuration.getCommandExecutorTxRequired(), TELEMETRY_ENDPOINT, data, this.configuration.getTelemetryHttpConnector());
        telemetryReporter.reportNow();
        WireMock.verify((RequestPatternBuilder)WireMock.postRequestedFor((UrlMatchingStrategy)WireMock.urlEqualTo((String)TELEMETRY_ENDPOINT_PATH)).withRequestBody(WireMock.equalToJson((String)requestBody)).withHeader("Content-Type", WireMock.equalTo((String)"application/json")));
    }

    @Test
    public void shouldReportDataWhenTelemetryInitialized() {
        Data data = this.createDataToSend();
        StandaloneInMemProcessEngineConfiguration processEngineConfiguration = new StandaloneInMemProcessEngineConfiguration();
        processEngineConfiguration.setTelemetryEndpoint(TELEMETRY_ENDPOINT).setInitializeTelemetry(Boolean.valueOf(true)).setTelemetryData(data).setJdbcUrl("jdbc:h2:mem:camunda" + this.getClass().getSimpleName());
        WireMock.stubFor((MappingBuilder)WireMock.post((UrlMatchingStrategy)WireMock.urlEqualTo((String)TELEMETRY_ENDPOINT_PATH)).willReturn(WireMock.aResponse().withStatus(202)));
        this.standaloneProcessEngine = processEngineConfiguration.buildProcessEngine();
        processEngineConfiguration.getTelemetryReporter().reportNow();
        String requestBody = new Gson().toJson((Object)data);
        WireMock.verify((RequestPatternBuilder)WireMock.postRequestedFor((UrlMatchingStrategy)WireMock.urlEqualTo((String)TELEMETRY_ENDPOINT_PATH)).withRequestBody(WireMock.equalToJson((String)requestBody)).withHeader("Content-Type", WireMock.equalTo((String)"application/json")));
    }

    @Test
    public void shouldSendTelemetryWithApplicationServerInfo() {
        this.managementService.toggleTelemetry(true);
        String applicationServerVersion = "Tomcat 10";
        this.configuration.getTelemetryRegistry().setApplicationServer(applicationServerVersion);
        Data expectedData = this.adjustDataWithProductVersionAndAppServerInfo(this.configuration.getTelemetryData(), applicationServerVersion);
        String requestBody = new Gson().toJson((Object)expectedData);
        WireMock.stubFor((MappingBuilder)WireMock.post((UrlMatchingStrategy)WireMock.urlEqualTo((String)TELEMETRY_ENDPOINT_PATH)).willReturn(WireMock.aResponse().withBody(requestBody).withStatus(202)));
        this.configuration.getTelemetryReporter().reportNow();
        WireMock.verify((RequestPatternBuilder)WireMock.postRequestedFor((UrlMatchingStrategy)WireMock.urlEqualTo((String)TELEMETRY_ENDPOINT_PATH)).withRequestBody(WireMock.equalToJson((String)requestBody)).withHeader("Content-Type", WireMock.equalTo((String)"application/json")));
    }

    @Test
    public void shouldSendTelemetryWithCommandCounts() {
        this.managementService.toggleTelemetry(true);
        this.managementService.getHistoryLevel();
        this.managementService.getLicenseKey();
        Data expectedData = this.adjustDataWithCommandCounts(this.configuration.getTelemetryData());
        String requestBody = new Gson().toJson((Object)expectedData);
        WireMock.stubFor((MappingBuilder)WireMock.post((UrlMatchingStrategy)WireMock.urlEqualTo((String)TELEMETRY_ENDPOINT_PATH)).willReturn(WireMock.aResponse().withBody(requestBody).withStatus(202)));
        this.configuration.getTelemetryReporter().reportNow();
        WireMock.verify((RequestPatternBuilder)WireMock.postRequestedFor((UrlMatchingStrategy)WireMock.urlEqualTo((String)TELEMETRY_ENDPOINT_PATH)).withRequestBody(WireMock.equalToJson((String)requestBody)).withHeader("Content-Type", WireMock.equalTo((String)"application/json")));
        if (this.configuration.getHistoryLevel().getId() >= HistoryLevel.HISTORY_LEVEL_ACTIVITY.getId()) {
            Assertions.assertThat((int)this.configuration.getTelemetryRegistry().getCommands().size()).isEqualTo(3);
        } else if (this.configuration.getHistoryLevel().getId() >= HistoryLevel.HISTORY_LEVEL_NONE.getId()) {
            Assertions.assertThat((int)this.configuration.getTelemetryRegistry().getCommands().size()).isEqualTo(2);
        } else {
            Assert.fail((String)"Unexpected history level.");
        }
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void shouldSetStartReportTimeWhenTelemetryEnabled() {
        Date currentTime = ClockUtil.getCurrentTime();
        this.managementService.toggleTelemetry(true);
        Assertions.assertThat((Date)this.configuration.getTelemetryRegistry().getStartReportTime()).isInSameSecondWindowAs(currentTime);
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void shouldSendTelemetryWithRooProcessInstanceMetrics() {
        this.managementService.toggleTelemetry(true);
        ClockUtil.setCurrentTime((Date)this.addHour(ClockUtil.getCurrentTime()));
        for (int i = 0; i < 3; ++i) {
            this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        }
        this.configuration.getDbMetricsReporter().reportNow();
        ClockUtil.setCurrentTime((Date)this.addHour(ClockUtil.getCurrentTime()));
        Data expectedData = this.adjustDataWithMetricCounts(this.configuration.getTelemetryData(), 3L, 0L, 6L, 0L);
        String requestBody = new Gson().toJson((Object)expectedData);
        WireMock.stubFor((MappingBuilder)WireMock.post((UrlMatchingStrategy)WireMock.urlEqualTo((String)TELEMETRY_ENDPOINT_PATH)).willReturn(WireMock.aResponse().withBody(requestBody).withStatus(202)));
        this.configuration.getTelemetryReporter().reportNow();
        WireMock.verify((RequestPatternBuilder)WireMock.postRequestedFor((UrlMatchingStrategy)WireMock.urlEqualTo((String)TELEMETRY_ENDPOINT_PATH)).withRequestBody(WireMock.equalToJson((String)requestBody)).withHeader("Content-Type", WireMock.equalTo((String)"application/json")));
        Map metrics = this.configuration.getTelemetryData().getProduct().getInternals().getMetrics();
        Assertions.assertThat((long)((Metric)metrics.get("root-process-instances")).getCount()).isEqualTo(3L);
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void shouldSendTelemetryOnceWithRooProcessInstanceMetrics() {
        int i;
        this.managementService.toggleTelemetry(false);
        for (i = 0; i < 3; ++i) {
            this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        }
        this.configuration.getDbMetricsReporter().reportNow();
        ClockUtil.setCurrentTime((Date)this.addHour(ClockUtil.getCurrentTime()));
        this.managementService.toggleTelemetry(true);
        ClockUtil.setCurrentTime((Date)this.addHour(ClockUtil.getCurrentTime()));
        for (i = 0; i < 3; ++i) {
            this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        }
        this.configuration.getDbMetricsReporter().reportNow();
        ClockUtil.setCurrentTime((Date)this.addHour(ClockUtil.getCurrentTime()));
        Data expectedData = this.adjustDataWithMetricCounts(this.configuration.getTelemetryData(), 3L, 0L, 6L, 0L);
        String requestBody = new Gson().toJson((Object)expectedData);
        WireMock.stubFor((MappingBuilder)WireMock.post((UrlMatchingStrategy)WireMock.urlEqualTo((String)TELEMETRY_ENDPOINT_PATH)).willReturn(WireMock.aResponse().withBody(requestBody).withStatus(202)));
        this.configuration.getTelemetryReporter().reportNow();
        WireMock.verify((RequestPatternBuilder)WireMock.postRequestedFor((UrlMatchingStrategy)WireMock.urlEqualTo((String)TELEMETRY_ENDPOINT_PATH)).withRequestBody(WireMock.equalToJson((String)requestBody)).withHeader("Content-Type", WireMock.equalTo((String)"application/json")));
        Map metrics = this.configuration.getTelemetryData().getProduct().getInternals().getMetrics();
        Assertions.assertThat((long)((Metric)metrics.get("root-process-instances")).getCount()).isEqualTo(3L);
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/dmn/businessruletask/DmnBusinessRuleTaskTest.testDecisionRef.bpmn20.xml", "org/camunda/bpm/engine/test/dmn/businessruletask/DmnBusinessRuleTaskTest.testDecisionOkay.dmn11.xml"})
    public void shouldSendTelemetryWithExecutedDecisionInstanceMetrics() {
        this.managementService.toggleTelemetry(true);
        for (int i = 0; i < 2; ++i) {
            this.runtimeService.startProcessInstanceByKey("testProcess");
        }
        ClockUtil.setCurrentTime((Date)this.addHour(ClockUtil.getCurrentTime()));
        Data expectedData = this.adjustDataWithMetricCounts(this.configuration.getTelemetryData(), 2L, 2L, 4L, 0L);
        String requestBody = new Gson().toJson((Object)expectedData);
        WireMock.stubFor((MappingBuilder)WireMock.post((UrlMatchingStrategy)WireMock.urlEqualTo((String)TELEMETRY_ENDPOINT_PATH)).willReturn(WireMock.aResponse().withBody(requestBody).withStatus(202)));
        this.configuration.getTelemetryReporter().reportNow();
        WireMock.verify((RequestPatternBuilder)WireMock.postRequestedFor((UrlMatchingStrategy)WireMock.urlEqualTo((String)TELEMETRY_ENDPOINT_PATH)).withRequestBody(WireMock.equalToJson((String)requestBody)).withHeader("Content-Type", WireMock.equalTo((String)"application/json")));
        Map metrics = this.configuration.getTelemetryData().getProduct().getInternals().getMetrics();
        Assertions.assertThat((long)((Metric)metrics.get("executed-decision-instances")).getCount()).isEqualTo(2L);
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void shouldSendTelemetryWithFlowNodeInstanceMetrics() {
        this.managementService.toggleTelemetry(true);
        for (int i = 0; i < 4; ++i) {
            this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
            String taskId = ((Task)this.taskService.createTaskQuery().singleResult()).getId();
            this.taskService.complete(taskId);
        }
        ClockUtil.setCurrentTime((Date)this.addHour(ClockUtil.getCurrentTime()));
        Data expectedData = this.adjustDataWithMetricCounts(this.configuration.getTelemetryData(), 4L, 0L, 12L, 0L);
        String requestBody = new Gson().toJson((Object)expectedData);
        WireMock.stubFor((MappingBuilder)WireMock.post((UrlMatchingStrategy)WireMock.urlEqualTo((String)TELEMETRY_ENDPOINT_PATH)).willReturn(WireMock.aResponse().withBody(requestBody).withStatus(202)));
        this.configuration.getTelemetryReporter().reportNow();
        WireMock.verify((RequestPatternBuilder)WireMock.postRequestedFor((UrlMatchingStrategy)WireMock.urlEqualTo((String)TELEMETRY_ENDPOINT_PATH)).withRequestBody(WireMock.equalToJson((String)requestBody)).withHeader("Content-Type", WireMock.equalTo((String)"application/json")));
        Map metrics = this.configuration.getTelemetryData().getProduct().getInternals().getMetrics();
        Assertions.assertThat((long)((Metric)metrics.get("flow-node-instances")).getCount()).isEqualTo(12L);
    }

    @Test
    @RequiredHistoryLevel(value="activity")
    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void shouldSendTelemetryWithTaskWorkersMetrics() {
        this.managementService.toggleTelemetry(true);
        ClockUtil.setCurrentTime((Date)this.addHour(ClockUtil.getCurrentTime()));
        for (int i = 0; i < 3; ++i) {
            String processInstanceId = this.runtimeService.startProcessInstanceByKey("oneTaskProcess").getId();
            String taskId = ((Task)this.taskService.createTaskQuery().processInstanceId(processInstanceId).singleResult()).getId();
            this.taskService.setAssignee(taskId, "user" + i);
        }
        ClockUtil.setCurrentTime((Date)this.addHour(ClockUtil.getCurrentTime()));
        Data expectedData = this.adjustDataWithMetricCounts(this.configuration.getTelemetryData(), 3L, 0L, 6L, 3L);
        String requestBody = new Gson().toJson((Object)expectedData);
        WireMock.stubFor((MappingBuilder)WireMock.post((UrlMatchingStrategy)WireMock.urlEqualTo((String)TELEMETRY_ENDPOINT_PATH)).willReturn(WireMock.aResponse().withBody(requestBody).withStatus(202)));
        this.configuration.getTelemetryReporter().reportNow();
        WireMock.verify((RequestPatternBuilder)WireMock.postRequestedFor((UrlMatchingStrategy)WireMock.urlEqualTo((String)TELEMETRY_ENDPOINT_PATH)).withRequestBody(WireMock.equalToJson((String)requestBody)).withHeader("Content-Type", WireMock.equalTo((String)"application/json")));
        Map metrics = this.configuration.getTelemetryData().getProduct().getInternals().getMetrics();
        Assertions.assertThat((long)((Metric)metrics.get("unique-task-workers")).getCount()).isEqualTo(3L);
    }

    @Test
    @WatchLogger(loggerNames={"org.camunda.bpm.engine.telemetry"}, level="DEBUG")
    public void shouldLogTelemetrySent() {
        this.managementService.toggleTelemetry(true);
        WireMock.stubFor((MappingBuilder)WireMock.post((UrlMatchingStrategy)WireMock.urlEqualTo((String)TELEMETRY_ENDPOINT_PATH)).willReturn(WireMock.aResponse().withStatus(202)));
        this.configuration.getTelemetryReporter().reportNow();
        Assertions.assertThat((int)this.loggingRule.getFilteredLog("Start telemetry sending task").size()).isOne();
        Assertions.assertThat((int)this.loggingRule.getFilteredLog("Telemetry data sent").size()).isOne();
    }

    @Test
    @WatchLogger(loggerNames={"org.camunda.bpm.engine.telemetry"}, level="DEBUG")
    public void shouldLogUnexpectedResponse() {
        this.managementService.toggleTelemetry(true);
        WireMock.stubFor((MappingBuilder)WireMock.post((UrlMatchingStrategy)WireMock.urlEqualTo((String)TELEMETRY_ENDPOINT_PATH)).willReturn(WireMock.aResponse().withStatus(406)));
        this.configuration.getTelemetryReporter().reportNow();
        Assertions.assertThat((int)this.loggingRule.getFilteredLog("Unexpected response while sending telemetry data. Status code: 406").size()).isOne();
    }

    @Test
    @WatchLogger(loggerNames={"org.camunda.bpm.engine.telemetry"}, level="DEBUG")
    public void shouldLogTelemetryDisabled() {
        this.managementService.toggleTelemetry(false);
        this.configuration.getTelemetryReporter().reportNow();
        Assertions.assertThat((int)this.loggingRule.getFilteredLog("Sending telemetry is disabled").size()).isPositive();
    }

    @Test
    @WatchLogger(loggerNames={"org.camunda.bpm.engine.telemetry"}, level="DEBUG")
    public void shouldLogErrorOnDebugWhenHttpConnectorNotInitialized() {
        this.managementService.toggleTelemetry(true);
        Data data = this.createDataToSend();
        String requestBody = new Gson().toJson((Object)data);
        WireMock.stubFor((MappingBuilder)WireMock.post((UrlMatchingStrategy)WireMock.urlEqualTo((String)TELEMETRY_ENDPOINT_PATH)).willReturn(WireMock.aResponse().withBody(requestBody).withStatus(202)));
        TelemetryReporter telemetryReporter = new TelemetryReporter(this.configuration.getCommandExecutorTxRequired(), TELEMETRY_ENDPOINT, data, null);
        telemetryReporter.reportNow();
        Assertions.assertThat((int)this.loggingRule.getFilteredLog("'java.lang.NullPointerException' exception occurred while sending telemetry data").size()).isOne();
    }

    protected Data createDataToSend() {
        Database database = new Database("mySpecialDb", "v.1.2.3");
        Internals internals = new Internals(database, new ApplicationServer("Apache Tomcat/10.0.1"));
        Map<String, Command> commands = this.getDefaultCommandCounts();
        internals.setCommands(commands);
        Map<String, Metric> metrics = this.getDefaultMetrics();
        internals.setMetrics(metrics);
        Product product = new Product("Runtime", "7.14.0", "special", internals);
        Data data = new Data("f5b19e2e-b49a-11ea-b3de-0242ac130004", product);
        return data;
    }

    protected Data adjustDataWithProductVersionAndAppServerInfo(Data telemetryData, String applicationServerVersion) {
        Data result = new Data(telemetryData.getInstallation(), telemetryData.getProduct());
        Product product = result.getProduct();
        product.setVersion("7.14.0");
        result.setProduct(product);
        Internals internals = result.getProduct().getInternals();
        internals.setApplicationServer(new ApplicationServer(applicationServerVersion));
        Map<String, Command> commands = this.getDefaultCommandCounts();
        internals.setCommands(commands);
        Map<String, Metric> metrics = this.getDefaultMetrics();
        result.getProduct().getInternals().setMetrics(metrics);
        return result;
    }

    protected Data adjustDataWithCommandCounts(Data telemetryData) {
        Data result = this.adjustDataWithProductVersionAndAppServerInfo(telemetryData, "Wildfly 10");
        Map commands = result.getProduct().getInternals().getCommands();
        commands.put("GetHistoryLevelCmd", new Command(1L));
        commands.put("GetLicenseKeyCmd", new Command(1L));
        result.getProduct().getInternals().setCommands(commands);
        return result;
    }

    protected Map<String, Command> getDefaultCommandCounts() {
        HashMap<String, Command> commands = new HashMap<String, Command>();
        commands.put("TelemetryConfigureCmd", new Command(1L));
        commands.put("IsTelemetryEnabledCmd", new Command(1L));
        return commands;
    }

    protected Map<String, Metric> getDefaultMetrics() {
        return this.assembleMetrics(0L, 0L, 0L, 0L);
    }

    protected Data adjustDataWithMetricCounts(Data telemetryData, long processCount, long decisionCount, long flowNodeCount, long workerCount) {
        Data result = this.adjustDataWithProductVersionAndAppServerInfo(telemetryData, "JBoss EAP 7.2.0.GA");
        Internals internals = result.getProduct().getInternals();
        Map<String, Metric> metrics = this.assembleMetrics(processCount, decisionCount, flowNodeCount, workerCount);
        internals.setMetrics(metrics);
        this.configuration.getTelemetryRegistry().getCommands().clear();
        HashMap<String, Command> commands = new HashMap<String, Command>();
        commands.put("IsTelemetryEnabledCmd", new Command(1L));
        internals.setCommands(commands);
        return result;
    }

    protected Map<String, Metric> assembleMetrics(long processCount, long decisionCount, long flowNodeCount, long workerCount) {
        HashMap<String, Metric> metrics = new HashMap<String, Metric>();
        metrics.put("root-process-instances", new Metric(processCount));
        metrics.put("executed-decision-instances", new Metric(decisionCount));
        metrics.put("flow-node-instances", new Metric(flowNodeCount));
        metrics.put("unique-task-workers", new Metric(workerCount));
        return metrics;
    }

    protected Date addHour(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(11, 1);
        Date newDate = calendar.getTime();
        return newDate;
    }
}

