/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.multitenancy.cmmn;

import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.repository.CaseDefinition;
import org.camunda.bpm.engine.runtime.CaseExecution;
import org.camunda.bpm.engine.runtime.CaseInstanceQuery;
import org.camunda.bpm.engine.test.util.PluggableProcessEngineTest;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;

public class MultiTenancyCaseTaskTest
extends PluggableProcessEngineTest {
    protected static final String TENANT_ONE = "tenant1";
    protected static final String TENANT_TWO = "tenant2";
    protected static final String CMMN_LATEST = "org/camunda/bpm/engine/test/api/multitenancy/CaseWithCaseTask.cmmn";
    protected static final String CMMN_LATEST_WITH_MANUAL_ACTIVATION = "org/camunda/bpm/engine/test/api/multitenancy/CaseWithCaseTaskWithManualActivation.cmmn";
    protected static final String CMMN_DEPLOYMENT = "org/camunda/bpm/engine/test/api/multitenancy/CaseWithCaseTaskDeploymentBinding.cmmn";
    protected static final String CMMN_VERSION = "org/camunda/bpm/engine/test/api/multitenancy/CaseWithCaseTaskVersionBinding.cmmn";
    protected static final String CMMN_VERSION_2 = "org/camunda/bpm/engine/test/api/multitenancy/CaseWithCaseTaskVersionBinding_v2.cmmn";
    protected static final String CMMN_TENANT_CONST = "org/camunda/bpm/engine/test/api/multitenancy/CaseWithCaseTaskTenantIdConst.cmmn";
    protected static final String CMMN_TENANT_EXPR = "org/camunda/bpm/engine/test/api/multitenancy/CaseWithCaseTaskTenantIdExpr.cmmn";
    protected static final String CMMN_CASE = "org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn";
    protected static final String CASE_TASK_ID = "PI_CaseTask_1";

    @Test
    public void testStartCaseInstanceWithDeploymentBinding() {
        this.testRule.deployForTenant(TENANT_ONE, CMMN_DEPLOYMENT, CMMN_CASE);
        this.testRule.deployForTenant(TENANT_TWO, CMMN_DEPLOYMENT, CMMN_CASE);
        this.createCaseInstance("caseTaskCaseDeployment", TENANT_ONE);
        this.createCaseInstance("caseTaskCaseDeployment", TENANT_TWO);
        CaseInstanceQuery query = this.caseService.createCaseInstanceQuery().caseDefinitionKey("oneTaskCase");
        Assert.assertThat((Object)query.tenantIdIn(new String[]{TENANT_ONE}).count(), (Matcher)CoreMatchers.is((Object)1L));
        Assert.assertThat((Object)query.tenantIdIn(new String[]{TENANT_TWO}).count(), (Matcher)CoreMatchers.is((Object)1L));
    }

    @Test
    public void testStartCaseInstanceWithLatestBindingSameVersion() {
        this.testRule.deployForTenant(TENANT_ONE, CMMN_LATEST_WITH_MANUAL_ACTIVATION, CMMN_CASE);
        this.testRule.deployForTenant(TENANT_TWO, CMMN_LATEST_WITH_MANUAL_ACTIVATION, CMMN_CASE);
        this.createCaseInstance("caseTaskCase", TENANT_ONE);
        this.createCaseInstance("caseTaskCase", TENANT_TWO);
        CaseInstanceQuery query = this.caseService.createCaseInstanceQuery().caseDefinitionKey("oneTaskCase");
        Assert.assertThat((Object)query.tenantIdIn(new String[]{TENANT_ONE}).count(), (Matcher)CoreMatchers.is((Object)1L));
        Assert.assertThat((Object)query.tenantIdIn(new String[]{TENANT_TWO}).count(), (Matcher)CoreMatchers.is((Object)1L));
    }

    @Test
    public void testStartCaseInstanceWithLatestBindingDifferentVersion() {
        this.testRule.deployForTenant(TENANT_ONE, CMMN_LATEST_WITH_MANUAL_ACTIVATION, CMMN_CASE);
        this.testRule.deployForTenant(TENANT_TWO, CMMN_LATEST_WITH_MANUAL_ACTIVATION, CMMN_CASE);
        this.testRule.deployForTenant(TENANT_TWO, CMMN_CASE);
        this.createCaseInstance("caseTaskCase", TENANT_ONE);
        this.createCaseInstance("caseTaskCase", TENANT_TWO);
        CaseInstanceQuery query = this.caseService.createCaseInstanceQuery().caseDefinitionKey("oneTaskCase");
        Assert.assertThat((Object)query.tenantIdIn(new String[]{TENANT_ONE}).count(), (Matcher)CoreMatchers.is((Object)1L));
        CaseDefinition latestCaseDefinitionTenantTwo = (CaseDefinition)this.repositoryService.createCaseDefinitionQuery().caseDefinitionKey("oneTaskCase").tenantIdIn(new String[]{TENANT_TWO}).latestVersion().singleResult();
        query = this.caseService.createCaseInstanceQuery().caseDefinitionId(latestCaseDefinitionTenantTwo.getId());
        Assert.assertThat((Object)query.count(), (Matcher)CoreMatchers.is((Object)1L));
    }

    @Test
    public void testStartCaseInstanceWithVersionBinding() {
        this.testRule.deployForTenant(TENANT_ONE, CMMN_VERSION, CMMN_CASE);
        this.testRule.deployForTenant(TENANT_TWO, CMMN_VERSION, CMMN_CASE);
        this.createCaseInstance("caseTaskCaseVersion", TENANT_ONE);
        this.createCaseInstance("caseTaskCaseVersion", TENANT_TWO);
        CaseInstanceQuery query = this.caseService.createCaseInstanceQuery().caseDefinitionKey("oneTaskCase");
        Assert.assertThat((Object)query.tenantIdIn(new String[]{TENANT_ONE}).count(), (Matcher)CoreMatchers.is((Object)1L));
        Assert.assertThat((Object)query.tenantIdIn(new String[]{TENANT_TWO}).count(), (Matcher)CoreMatchers.is((Object)1L));
    }

    @Test
    public void testFailStartCaseInstanceFromOtherTenantWithDeploymentBinding() {
        this.testRule.deployForTenant(TENANT_ONE, CMMN_DEPLOYMENT);
        this.testRule.deployForTenant(TENANT_TWO, CMMN_CASE);
        try {
            this.createCaseInstance("caseTaskCaseDeployment", TENANT_ONE);
            Assert.fail((String)"expected exception");
        }
        catch (ProcessEngineException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)"no case definition deployed with key = 'oneTaskCase'"));
        }
    }

    @Test
    public void testFailStartCaseInstanceFromOtherTenantWithLatestBinding() {
        this.testRule.deployForTenant(TENANT_ONE, CMMN_LATEST);
        this.testRule.deployForTenant(TENANT_TWO, CMMN_CASE);
        try {
            this.createCaseInstance("caseTaskCase", TENANT_ONE);
            Assert.fail((String)"expected exception");
        }
        catch (ProcessEngineException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)"no case definition deployed with key 'oneTaskCase'"));
        }
    }

    @Test
    public void testFailStartCaseInstanceFromOtherTenantWithVersionBinding() {
        this.testRule.deployForTenant(TENANT_ONE, CMMN_VERSION_2, CMMN_CASE);
        this.testRule.deployForTenant(TENANT_TWO, CMMN_CASE);
        this.testRule.deployForTenant(TENANT_TWO, CMMN_CASE);
        try {
            this.createCaseInstance("caseTaskCaseVersion", TENANT_ONE);
            Assert.fail((String)"expected exception");
        }
        catch (ProcessEngineException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)"no case definition deployed with key = 'oneTaskCase'"));
        }
    }

    @Test
    public void testCaseRefTenantIdConstant() {
        this.testRule.deploy(CMMN_TENANT_CONST);
        this.testRule.deployForTenant(TENANT_ONE, CMMN_CASE);
        this.caseService.withCaseDefinitionByKey("caseTaskCase").create();
        CaseInstanceQuery query = this.caseService.createCaseInstanceQuery().caseDefinitionKey("oneTaskCase");
        Assert.assertThat((Object)query.tenantIdIn(new String[]{TENANT_ONE}).count(), (Matcher)CoreMatchers.is((Object)1L));
    }

    @Test
    public void testCaseRefTenantIdExpression() {
        this.testRule.deploy(CMMN_TENANT_EXPR);
        this.testRule.deployForTenant(TENANT_ONE, CMMN_CASE);
        this.caseService.withCaseDefinitionByKey("caseTaskCase").create();
        CaseInstanceQuery query = this.caseService.createCaseInstanceQuery().caseDefinitionKey("oneTaskCase");
        Assert.assertThat((Object)query.tenantIdIn(new String[]{TENANT_ONE}).count(), (Matcher)CoreMatchers.is((Object)1L));
    }

    protected void createCaseInstance(String caseDefinitionKey, String tenantId) {
        this.caseService.withCaseDefinitionByKey(caseDefinitionKey).caseDefinitionTenantId(tenantId).create();
        CaseExecution caseExecution = (CaseExecution)this.caseService.createCaseExecutionQuery().activityId(CASE_TASK_ID).tenantIdIn(new String[]{tenantId}).singleResult();
        this.caseService.withCaseExecution(caseExecution.getId()).manualStart();
    }
}

