/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.multitenancy.query;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.camunda.bpm.engine.exception.NullValueException;
import org.camunda.bpm.engine.repository.DecisionDefinition;
import org.camunda.bpm.engine.repository.DecisionDefinitionQuery;
import org.camunda.bpm.engine.test.util.PluggableProcessEngineTest;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class MultiTenancyDecisionDefinitionQueryTest
extends PluggableProcessEngineTest {
    protected static final String DECISION_DEFINITION_KEY = "decision";
    protected static final String DMN = "org/camunda/bpm/engine/test/api/multitenancy/simpleDecisionTable.dmn";
    protected static final String TENANT_ONE = "tenant1";
    protected static final String TENANT_TWO = "tenant2";

    @Before
    public void setUp() {
        this.testRule.deploy(DMN);
        this.testRule.deployForTenant(TENANT_ONE, DMN);
        this.testRule.deployForTenant(TENANT_TWO, DMN);
    }

    @Test
    public void testQueryNoTenantIdSet() {
        DecisionDefinitionQuery query = this.repositoryService.createDecisionDefinitionQuery();
        Assert.assertThat((Object)query.count(), (Matcher)CoreMatchers.is((Object)3L));
    }

    @Test
    public void testQueryByTenantId() {
        DecisionDefinitionQuery query = this.repositoryService.createDecisionDefinitionQuery().tenantIdIn(new String[]{TENANT_ONE});
        Assert.assertThat((Object)query.count(), (Matcher)CoreMatchers.is((Object)1L));
        query = this.repositoryService.createDecisionDefinitionQuery().tenantIdIn(new String[]{TENANT_TWO});
        Assert.assertThat((Object)query.count(), (Matcher)CoreMatchers.is((Object)1L));
    }

    @Test
    public void testQueryByTenantIds() {
        DecisionDefinitionQuery query = this.repositoryService.createDecisionDefinitionQuery().tenantIdIn(new String[]{TENANT_ONE, TENANT_TWO});
        Assert.assertThat((Object)query.count(), (Matcher)CoreMatchers.is((Object)2L));
    }

    @Test
    public void testQueryByDefinitionsWithoutTenantId() {
        DecisionDefinitionQuery query = this.repositoryService.createDecisionDefinitionQuery().withoutTenantId();
        Assert.assertThat((Object)query.count(), (Matcher)CoreMatchers.is((Object)1L));
    }

    @Test
    public void testQueryByTenantIdsIncludeDefinitionsWithoutTenantId() {
        DecisionDefinitionQuery query = this.repositoryService.createDecisionDefinitionQuery().tenantIdIn(new String[]{TENANT_ONE}).includeDecisionDefinitionsWithoutTenantId();
        Assert.assertThat((Object)query.count(), (Matcher)CoreMatchers.is((Object)2L));
        query = this.repositoryService.createDecisionDefinitionQuery().tenantIdIn(new String[]{TENANT_TWO}).includeDecisionDefinitionsWithoutTenantId();
        Assert.assertThat((Object)query.count(), (Matcher)CoreMatchers.is((Object)2L));
        query = this.repositoryService.createDecisionDefinitionQuery().tenantIdIn(new String[]{TENANT_ONE, TENANT_TWO}).includeDecisionDefinitionsWithoutTenantId();
        Assert.assertThat((Object)query.count(), (Matcher)CoreMatchers.is((Object)3L));
    }

    @Test
    public void testQueryByKey() {
        DecisionDefinitionQuery query = this.repositoryService.createDecisionDefinitionQuery().decisionDefinitionKey(DECISION_DEFINITION_KEY);
        Assert.assertThat((Object)query.count(), (Matcher)CoreMatchers.is((Object)3L));
        query = this.repositoryService.createDecisionDefinitionQuery().decisionDefinitionKey(DECISION_DEFINITION_KEY).withoutTenantId();
        Assert.assertThat((Object)query.count(), (Matcher)CoreMatchers.is((Object)1L));
        query = this.repositoryService.createDecisionDefinitionQuery().decisionDefinitionKey(DECISION_DEFINITION_KEY).tenantIdIn(new String[]{TENANT_ONE});
        Assert.assertThat((Object)query.count(), (Matcher)CoreMatchers.is((Object)1L));
    }

    @Test
    public void testQueryByLatestNoTenantIdSet() {
        this.testRule.deployForTenant(TENANT_ONE, DMN);
        DecisionDefinitionQuery query = this.repositoryService.createDecisionDefinitionQuery().decisionDefinitionKey(DECISION_DEFINITION_KEY).latestVersion();
        Assert.assertThat((Object)query.count(), (Matcher)CoreMatchers.is((Object)3L));
        Map<String, DecisionDefinition> decisionDefinitionsForTenant = this.getDecisionDefinitionsForTenant(query.list());
        Assert.assertThat((Object)decisionDefinitionsForTenant.get(TENANT_ONE).getVersion(), (Matcher)CoreMatchers.is((Object)2));
        Assert.assertThat((Object)decisionDefinitionsForTenant.get(TENANT_TWO).getVersion(), (Matcher)CoreMatchers.is((Object)1));
        Assert.assertThat((Object)decisionDefinitionsForTenant.get(null).getVersion(), (Matcher)CoreMatchers.is((Object)1));
    }

    @Test
    public void testQueryByLatestWithTenantId() {
        this.testRule.deployForTenant(TENANT_ONE, DMN);
        DecisionDefinitionQuery query = this.repositoryService.createDecisionDefinitionQuery().decisionDefinitionKey(DECISION_DEFINITION_KEY).latestVersion().tenantIdIn(new String[]{TENANT_ONE});
        Assert.assertThat((Object)query.count(), (Matcher)CoreMatchers.is((Object)1L));
        DecisionDefinition decisionDefinition = (DecisionDefinition)query.singleResult();
        Assert.assertThat((Object)decisionDefinition.getTenantId(), (Matcher)CoreMatchers.is((Object)TENANT_ONE));
        Assert.assertThat((Object)decisionDefinition.getVersion(), (Matcher)CoreMatchers.is((Object)2));
        query = this.repositoryService.createDecisionDefinitionQuery().decisionDefinitionKey(DECISION_DEFINITION_KEY).latestVersion().tenantIdIn(new String[]{TENANT_TWO});
        Assert.assertThat((Object)query.count(), (Matcher)CoreMatchers.is((Object)1L));
        decisionDefinition = (DecisionDefinition)query.singleResult();
        Assert.assertThat((Object)decisionDefinition.getTenantId(), (Matcher)CoreMatchers.is((Object)TENANT_TWO));
        Assert.assertThat((Object)decisionDefinition.getVersion(), (Matcher)CoreMatchers.is((Object)1));
    }

    @Test
    public void testQueryByLatestWithTenantIds() {
        this.testRule.deployForTenant(TENANT_ONE, DMN);
        DecisionDefinitionQuery query = (DecisionDefinitionQuery)this.repositoryService.createDecisionDefinitionQuery().decisionDefinitionKey(DECISION_DEFINITION_KEY).latestVersion().tenantIdIn(new String[]{TENANT_ONE, TENANT_TWO}).orderByTenantId().asc();
        Assert.assertThat((Object)query.count(), (Matcher)CoreMatchers.is((Object)2L));
        Map<String, DecisionDefinition> decisionDefinitionsForTenant = this.getDecisionDefinitionsForTenant(query.list());
        Assert.assertThat((Object)decisionDefinitionsForTenant.get(TENANT_ONE).getVersion(), (Matcher)CoreMatchers.is((Object)2));
        Assert.assertThat((Object)decisionDefinitionsForTenant.get(TENANT_TWO).getVersion(), (Matcher)CoreMatchers.is((Object)1));
    }

    @Test
    public void testQueryByLatestWithoutTenantId() {
        this.testRule.deploy(DMN);
        DecisionDefinitionQuery query = this.repositoryService.createDecisionDefinitionQuery().decisionDefinitionKey(DECISION_DEFINITION_KEY).latestVersion().withoutTenantId();
        Assert.assertThat((Object)query.count(), (Matcher)CoreMatchers.is((Object)1L));
        DecisionDefinition decisionDefinition = (DecisionDefinition)query.singleResult();
        Assert.assertThat((Object)decisionDefinition.getTenantId(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        Assert.assertThat((Object)decisionDefinition.getVersion(), (Matcher)CoreMatchers.is((Object)2));
    }

    @Test
    public void testQueryByLatestWithTenantIdsIncludeDefinitionsWithoutTenantId() {
        this.testRule.deploy(DMN);
        this.testRule.deployForTenant(TENANT_ONE, DMN);
        this.testRule.deployForTenant(TENANT_ONE, DMN);
        DecisionDefinitionQuery query = this.repositoryService.createDecisionDefinitionQuery().decisionDefinitionKey(DECISION_DEFINITION_KEY).latestVersion().tenantIdIn(new String[]{TENANT_ONE, TENANT_TWO}).includeDecisionDefinitionsWithoutTenantId();
        Assert.assertThat((Object)query.count(), (Matcher)CoreMatchers.is((Object)3L));
        Map<String, DecisionDefinition> decisionDefinitionsForTenant = this.getDecisionDefinitionsForTenant(query.list());
        Assert.assertThat((Object)decisionDefinitionsForTenant.get(TENANT_ONE).getVersion(), (Matcher)CoreMatchers.is((Object)3));
        Assert.assertThat((Object)decisionDefinitionsForTenant.get(TENANT_TWO).getVersion(), (Matcher)CoreMatchers.is((Object)1));
        Assert.assertThat((Object)decisionDefinitionsForTenant.get(null).getVersion(), (Matcher)CoreMatchers.is((Object)2));
    }

    @Test
    public void testQueryByNonExistingTenantId() {
        DecisionDefinitionQuery query = this.repositoryService.createDecisionDefinitionQuery().tenantIdIn(new String[]{"nonExisting"});
        Assert.assertThat((Object)query.count(), (Matcher)CoreMatchers.is((Object)0L));
    }

    @Test
    public void testFailQueryByTenantIdNull() {
        try {
            this.repositoryService.createDecisionDefinitionQuery().tenantIdIn(new String[]{null});
            Assert.fail((String)"expected exception");
        }
        catch (NullValueException nullValueException) {
            // empty catch block
        }
    }

    @Test
    public void testQuerySortingAsc() {
        List decisionDefinitions = ((DecisionDefinitionQuery)this.repositoryService.createDecisionDefinitionQuery().tenantIdIn(new String[]{TENANT_ONE, TENANT_TWO}).orderByTenantId().asc()).list();
        Assert.assertThat((Object)decisionDefinitions.size(), (Matcher)CoreMatchers.is((Object)2));
        Assert.assertThat((Object)((DecisionDefinition)decisionDefinitions.get(0)).getTenantId(), (Matcher)CoreMatchers.is((Object)TENANT_ONE));
        Assert.assertThat((Object)((DecisionDefinition)decisionDefinitions.get(1)).getTenantId(), (Matcher)CoreMatchers.is((Object)TENANT_TWO));
    }

    @Test
    public void testQuerySortingDesc() {
        List decisionDefinitions = ((DecisionDefinitionQuery)this.repositoryService.createDecisionDefinitionQuery().tenantIdIn(new String[]{TENANT_ONE, TENANT_TWO}).orderByTenantId().desc()).list();
        Assert.assertThat((Object)decisionDefinitions.size(), (Matcher)CoreMatchers.is((Object)2));
        Assert.assertThat((Object)((DecisionDefinition)decisionDefinitions.get(0)).getTenantId(), (Matcher)CoreMatchers.is((Object)TENANT_TWO));
        Assert.assertThat((Object)((DecisionDefinition)decisionDefinitions.get(1)).getTenantId(), (Matcher)CoreMatchers.is((Object)TENANT_ONE));
    }

    @Test
    public void testQueryNoAuthenticatedTenants() {
        this.identityService.setAuthentication("user", null, null);
        DecisionDefinitionQuery query = this.repositoryService.createDecisionDefinitionQuery();
        Assert.assertThat((Object)query.count(), (Matcher)CoreMatchers.is((Object)1L));
    }

    @Test
    public void testQueryAuthenticatedTenant() {
        this.identityService.setAuthentication("user", null, Arrays.asList(TENANT_ONE));
        DecisionDefinitionQuery query = this.repositoryService.createDecisionDefinitionQuery();
        Assert.assertThat((Object)query.count(), (Matcher)CoreMatchers.is((Object)2L));
        Assert.assertThat((Object)query.tenantIdIn(new String[]{TENANT_ONE}).count(), (Matcher)CoreMatchers.is((Object)1L));
        Assert.assertThat((Object)query.tenantIdIn(new String[]{TENANT_TWO}).count(), (Matcher)CoreMatchers.is((Object)0L));
        Assert.assertThat((Object)query.tenantIdIn(new String[]{TENANT_ONE, TENANT_TWO}).includeDecisionDefinitionsWithoutTenantId().count(), (Matcher)CoreMatchers.is((Object)2L));
    }

    @Test
    public void testQueryAuthenticatedTenants() {
        this.identityService.setAuthentication("user", null, Arrays.asList(TENANT_ONE, TENANT_TWO));
        DecisionDefinitionQuery query = this.repositoryService.createDecisionDefinitionQuery();
        Assert.assertThat((Object)query.count(), (Matcher)CoreMatchers.is((Object)3L));
        Assert.assertThat((Object)query.tenantIdIn(new String[]{TENANT_ONE}).count(), (Matcher)CoreMatchers.is((Object)1L));
        Assert.assertThat((Object)query.tenantIdIn(new String[]{TENANT_TWO}).count(), (Matcher)CoreMatchers.is((Object)1L));
        Assert.assertThat((Object)query.withoutTenantId().count(), (Matcher)CoreMatchers.is((Object)1L));
    }

    @Test
    public void testQueryDisabledTenantCheck() {
        this.processEngineConfiguration.setTenantCheckEnabled(false);
        this.identityService.setAuthentication("user", null, null);
        DecisionDefinitionQuery query = this.repositoryService.createDecisionDefinitionQuery();
        Assert.assertThat((Object)query.count(), (Matcher)CoreMatchers.is((Object)3L));
    }

    protected Map<String, DecisionDefinition> getDecisionDefinitionsForTenant(List<DecisionDefinition> decisionDefinitions) {
        HashMap<String, DecisionDefinition> definitionsForTenant = new HashMap<String, DecisionDefinition>();
        for (DecisionDefinition definition : decisionDefinitions) {
            definitionsForTenant.put(definition.getTenantId(), definition);
        }
        return definitionsForTenant;
    }
}

