/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.multitenancy.tenantcheck;

import java.util.Arrays;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.test.ProcessEngineRule;
import org.camunda.bpm.engine.test.util.ProcessEngineTestRule;
import org.camunda.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.camunda.bpm.model.bpmn.Bpmn;
import org.camunda.bpm.model.bpmn.BpmnModelInstance;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;

public class MultiTenancyProcessInstanceCmdsTenantCheckTest {
    protected static final String TENANT_ONE = "tenant1";
    protected static final String PROCESS_DEFINITION_KEY = "oneTaskProcess";
    protected ProcessEngineRule engineRule = new ProvidedProcessEngineRule();
    protected ProcessEngineTestRule testRule = new ProcessEngineTestRule(this.engineRule);
    protected String processInstanceId;
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.engineRule).around((TestRule)this.testRule);
    @Rule
    public ExpectedException thrown = ExpectedException.none();
    protected static final BpmnModelInstance ONE_TASK_PROCESS = Bpmn.createExecutableProcess((String)"oneTaskProcess").startEvent().userTask("task").endEvent().done();

    @Before
    public void init() {
        this.testRule.deployForTenant(TENANT_ONE, ONE_TASK_PROCESS);
        this.processInstanceId = this.engineRule.getRuntimeService().startProcessInstanceByKey(PROCESS_DEFINITION_KEY).getId();
    }

    @Test
    public void deleteProcessInstanceWithAuthenticatedTenant() {
        this.engineRule.getIdentityService().setAuthentication("aUserId", null, Arrays.asList(TENANT_ONE));
        this.engineRule.getRuntimeService().deleteProcessInstance(this.processInstanceId, null);
        Assert.assertEquals((long)0L, (long)this.engineRule.getRuntimeService().createProcessInstanceQuery().processInstanceId(this.processInstanceId).list().size());
    }

    @Test
    public void deleteProcessInstanceWithNoAuthenticatedTenant() {
        this.engineRule.getIdentityService().setAuthentication("aUserId", null);
        this.thrown.expect(ProcessEngineException.class);
        this.thrown.expectMessage("Cannot delete the process instance '" + this.processInstanceId + "' because it belongs to no authenticated tenant.");
        this.engineRule.getRuntimeService().deleteProcessInstance(this.processInstanceId, null);
    }

    @Test
    public void deleteProcessInstanceWithDisabledTenantCheck() {
        this.engineRule.getIdentityService().setAuthentication("aUserId", null);
        this.engineRule.getProcessEngineConfiguration().setTenantCheckEnabled(false);
        this.engineRule.getRuntimeService().deleteProcessInstance(this.processInstanceId, null);
        Assert.assertEquals((long)0L, (long)this.engineRule.getRuntimeService().createProcessInstanceQuery().processInstanceId(this.processInstanceId).list().size());
    }

    @Test
    public void modifyProcessInstanceWithAuthenticatedTenant() {
        Assert.assertNotNull((Object)this.engineRule.getRuntimeService().getActivityInstance(this.processInstanceId));
        this.engineRule.getIdentityService().setAuthentication("aUserId", null, Arrays.asList(TENANT_ONE));
        this.engineRule.getRuntimeService().createProcessInstanceModification(this.processInstanceId).cancelAllForActivity("task").execute();
        Assert.assertNull((Object)this.engineRule.getRuntimeService().getActivityInstance(this.processInstanceId));
    }

    @Test
    public void modifyProcessInstanceWithNoAuthenticatedTenant() {
        this.engineRule.getIdentityService().setAuthentication("aUserId", null);
        this.thrown.expect(ProcessEngineException.class);
        this.thrown.expectMessage("Cannot update the process instance '" + this.processInstanceId + "' because it belongs to no authenticated tenant.");
        this.engineRule.getRuntimeService().createProcessInstanceModification(this.processInstanceId).cancelAllForActivity("task").execute();
    }

    @Test
    public void modifyProcessInstanceWithDisabledTenantCheck() {
        Assert.assertNotNull((Object)this.engineRule.getRuntimeService().getActivityInstance(this.processInstanceId));
        this.engineRule.getIdentityService().setAuthentication("aUserId", null, Arrays.asList(TENANT_ONE));
        this.engineRule.getProcessEngineConfiguration().setTenantCheckEnabled(false);
        this.engineRule.getRuntimeService().createProcessInstanceModification(this.processInstanceId).cancelAllForActivity("task").execute();
        Assert.assertNull((Object)this.engineRule.getRuntimeService().getActivityInstance(this.processInstanceId));
    }
}

