/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.runtime;

import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.camunda.bpm.engine.BadUserRequestException;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.SuspendedEntityInteractionException;
import org.camunda.bpm.engine.externaltask.ExternalTask;
import org.camunda.bpm.engine.impl.history.HistoryLevel;
import org.camunda.bpm.engine.impl.util.ClockUtil;
import org.camunda.bpm.engine.repository.ProcessDefinition;
import org.camunda.bpm.engine.runtime.EventSubscription;
import org.camunda.bpm.engine.runtime.Execution;
import org.camunda.bpm.engine.runtime.Job;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.runtime.ProcessInstanceModificationInstantiationBuilder;
import org.camunda.bpm.engine.runtime.ProcessInstanceQuery;
import org.camunda.bpm.engine.task.Task;
import org.camunda.bpm.engine.test.Deployment;
import org.camunda.bpm.engine.test.util.PluggableProcessEngineTest;
import org.junit.Assert;
import org.junit.Test;

public class ProcessInstanceSuspensionTest
extends PluggableProcessEngineTest {
    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/oneTaskProcess.bpmn20.xml"})
    @Test
    public void testProcessInstanceActiveByDefault() {
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().singleResult();
        this.runtimeService.startProcessInstanceByKey(processDefinition.getKey());
        ProcessInstance processInstance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().singleResult();
        Assert.assertFalse((boolean)processInstance.isSuspended());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/oneTaskProcess.bpmn20.xml"})
    @Test
    public void testSuspendActivateProcessInstance() {
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().singleResult();
        this.runtimeService.startProcessInstanceByKey(processDefinition.getKey());
        ProcessInstance processInstance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().singleResult();
        Assert.assertFalse((boolean)processInstance.isSuspended());
        this.runtimeService.suspendProcessInstanceById(processInstance.getId());
        processInstance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().singleResult();
        Assert.assertTrue((boolean)processInstance.isSuspended());
        this.runtimeService.activateProcessInstanceById(processInstance.getId());
        processInstance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().singleResult();
        Assert.assertFalse((boolean)processInstance.isSuspended());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/oneTaskProcess.bpmn20.xml"})
    @Test
    public void testSuspendActivateProcessInstanceByProcessDefinitionId() {
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().singleResult();
        this.runtimeService.startProcessInstanceByKey(processDefinition.getKey());
        ProcessInstance processInstance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().singleResult();
        Assert.assertFalse((boolean)processInstance.isSuspended());
        this.runtimeService.suspendProcessInstanceByProcessDefinitionId(processDefinition.getId());
        processInstance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().singleResult();
        Assert.assertTrue((boolean)processInstance.isSuspended());
        this.runtimeService.activateProcessInstanceByProcessDefinitionId(processDefinition.getId());
        processInstance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().singleResult();
        Assert.assertFalse((boolean)processInstance.isSuspended());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/oneTaskProcess.bpmn20.xml"})
    @Test
    public void testSuspendActivateProcessInstanceByProcessDefinitionKey() {
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().singleResult();
        this.runtimeService.startProcessInstanceByKey(processDefinition.getKey());
        ProcessInstance processInstance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().singleResult();
        Assert.assertFalse((boolean)processInstance.isSuspended());
        this.runtimeService.suspendProcessInstanceByProcessDefinitionKey(processDefinition.getKey());
        processInstance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().singleResult();
        Assert.assertTrue((boolean)processInstance.isSuspended());
        this.runtimeService.activateProcessInstanceByProcessDefinitionKey(processDefinition.getKey());
        processInstance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().singleResult();
        Assert.assertFalse((boolean)processInstance.isSuspended());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/oneTaskProcess.bpmn20.xml"})
    @Test
    public void testActivateAlreadyActiveProcessInstance() {
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().singleResult();
        this.runtimeService.startProcessInstanceByKey(processDefinition.getKey());
        ProcessInstance processInstance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().singleResult();
        Assert.assertFalse((boolean)processInstance.isSuspended());
        try {
            this.runtimeService.activateProcessInstanceById(processInstance.getId());
            processInstance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().singleResult();
            Assert.assertFalse((boolean)processInstance.isSuspended());
        }
        catch (ProcessEngineException e) {
            Assert.fail((String)"Should not fail");
        }
        try {
            this.runtimeService.activateProcessInstanceByProcessDefinitionId(processDefinition.getId());
            processInstance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().singleResult();
            Assert.assertFalse((boolean)processInstance.isSuspended());
        }
        catch (ProcessEngineException e) {
            Assert.fail((String)"Should not fail");
        }
        try {
            this.runtimeService.activateProcessInstanceByProcessDefinitionKey(processDefinition.getKey());
            processInstance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().singleResult();
            Assert.assertFalse((boolean)processInstance.isSuspended());
        }
        catch (ProcessEngineException e) {
            Assert.fail((String)"Should not fail");
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/oneTaskProcess.bpmn20.xml"})
    @Test
    public void testSuspendAlreadySuspendedProcessInstance() {
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().singleResult();
        this.runtimeService.startProcessInstanceByKey(processDefinition.getKey());
        ProcessInstance processInstance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().singleResult();
        Assert.assertFalse((boolean)processInstance.isSuspended());
        this.runtimeService.suspendProcessInstanceById(processInstance.getId());
        try {
            this.runtimeService.suspendProcessInstanceById(processInstance.getId());
            processInstance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().singleResult();
            Assert.assertTrue((boolean)processInstance.isSuspended());
        }
        catch (ProcessEngineException e) {
            Assert.fail((String)"Should not fail");
        }
        try {
            this.runtimeService.suspendProcessInstanceByProcessDefinitionId(processDefinition.getId());
            processInstance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().singleResult();
            Assert.assertTrue((boolean)processInstance.isSuspended());
        }
        catch (ProcessEngineException e) {
            Assert.fail((String)"Should not fail");
        }
        try {
            this.runtimeService.suspendProcessInstanceByProcessDefinitionKey(processDefinition.getKey());
            processInstance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().singleResult();
            Assert.assertTrue((boolean)processInstance.isSuspended());
        }
        catch (ProcessEngineException e) {
            Assert.fail((String)"Should not fail");
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/superProcessWithMultipleNestedSubProcess.bpmn20.xml", "org/camunda/bpm/engine/test/api/runtime/nestedSubProcess.bpmn20.xml", "org/camunda/bpm/engine/test/api/runtime/subProcess.bpmn20.xml"})
    @Test
    public void testQueryForActiveAndSuspendedProcessInstances() {
        this.runtimeService.startProcessInstanceByKey("nestedSubProcessQueryTest");
        Assert.assertEquals((long)5L, (long)this.runtimeService.createProcessInstanceQuery().count());
        Assert.assertEquals((long)5L, (long)this.runtimeService.createProcessInstanceQuery().active().count());
        Assert.assertEquals((long)0L, (long)this.runtimeService.createProcessInstanceQuery().suspended().count());
        ProcessInstance piToSuspend = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().processDefinitionKey("nestedSubProcessQueryTest").singleResult();
        this.runtimeService.suspendProcessInstanceById(piToSuspend.getId());
        Assert.assertEquals((long)5L, (long)this.runtimeService.createProcessInstanceQuery().count());
        Assert.assertEquals((long)4L, (long)this.runtimeService.createProcessInstanceQuery().active().count());
        Assert.assertEquals((long)1L, (long)this.runtimeService.createProcessInstanceQuery().suspended().count());
        Assert.assertEquals((Object)piToSuspend.getId(), (Object)((ProcessInstance)this.runtimeService.createProcessInstanceQuery().suspended().singleResult()).getId());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/superProcessWithMultipleNestedSubProcess.bpmn20.xml", "org/camunda/bpm/engine/test/api/runtime/nestedSubProcess.bpmn20.xml", "org/camunda/bpm/engine/test/api/runtime/subProcess.bpmn20.xml"})
    @Test
    public void testQueryForActiveAndSuspendedProcessInstancesByProcessDefinitionId() {
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().processDefinitionKey("nestedSubProcessQueryTest").singleResult();
        this.runtimeService.startProcessInstanceByKey("nestedSubProcessQueryTest");
        Assert.assertEquals((long)5L, (long)this.runtimeService.createProcessInstanceQuery().count());
        Assert.assertEquals((long)5L, (long)this.runtimeService.createProcessInstanceQuery().active().count());
        Assert.assertEquals((long)0L, (long)this.runtimeService.createProcessInstanceQuery().suspended().count());
        ProcessInstance piToSuspend = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().processDefinitionKey("nestedSubProcessQueryTest").singleResult();
        this.runtimeService.suspendProcessInstanceByProcessDefinitionId(processDefinition.getId());
        Assert.assertEquals((long)5L, (long)this.runtimeService.createProcessInstanceQuery().count());
        Assert.assertEquals((long)4L, (long)this.runtimeService.createProcessInstanceQuery().active().count());
        Assert.assertEquals((long)1L, (long)this.runtimeService.createProcessInstanceQuery().suspended().count());
        Assert.assertEquals((Object)piToSuspend.getId(), (Object)((ProcessInstance)this.runtimeService.createProcessInstanceQuery().suspended().singleResult()).getId());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/superProcessWithMultipleNestedSubProcess.bpmn20.xml", "org/camunda/bpm/engine/test/api/runtime/nestedSubProcess.bpmn20.xml", "org/camunda/bpm/engine/test/api/runtime/subProcess.bpmn20.xml"})
    @Test
    public void testQueryForActiveAndSuspendedProcessInstancesByProcessDefinitionKey() {
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().processDefinitionKey("nestedSubProcessQueryTest").singleResult();
        this.runtimeService.startProcessInstanceByKey("nestedSubProcessQueryTest");
        Assert.assertEquals((long)5L, (long)this.runtimeService.createProcessInstanceQuery().count());
        Assert.assertEquals((long)5L, (long)this.runtimeService.createProcessInstanceQuery().active().count());
        Assert.assertEquals((long)0L, (long)this.runtimeService.createProcessInstanceQuery().suspended().count());
        ProcessInstance piToSuspend = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().processDefinitionKey("nestedSubProcessQueryTest").singleResult();
        this.runtimeService.suspendProcessInstanceByProcessDefinitionKey(processDefinition.getKey());
        Assert.assertEquals((long)5L, (long)this.runtimeService.createProcessInstanceQuery().count());
        Assert.assertEquals((long)4L, (long)this.runtimeService.createProcessInstanceQuery().active().count());
        Assert.assertEquals((long)1L, (long)this.runtimeService.createProcessInstanceQuery().suspended().count());
        Assert.assertEquals((Object)piToSuspend.getId(), (Object)((ProcessInstance)this.runtimeService.createProcessInstanceQuery().suspended().singleResult()).getId());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/oneTaskProcess.bpmn20.xml"})
    @Test
    public void testTaskSuspendedAfterProcessInstanceSuspension() {
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().singleResult();
        this.runtimeService.startProcessInstanceByKey(processDefinition.getKey());
        ProcessInstance processInstance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().singleResult();
        this.runtimeService.suspendProcessInstanceById(processInstance.getId());
        List tasks = this.taskService.createTaskQuery().processInstanceId(processInstance.getId()).list();
        for (Task task : tasks) {
            Assert.assertTrue((boolean)task.isSuspended());
        }
        this.runtimeService.activateProcessInstanceById(processInstance.getId());
        tasks = this.taskService.createTaskQuery().processInstanceId(processInstance.getId()).list();
        for (Task task : tasks) {
            Assert.assertFalse((boolean)task.isSuspended());
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/oneTaskProcess.bpmn20.xml"})
    @Test
    public void testPreserveCreateTimeOnUpdatedTask() {
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().singleResult();
        this.runtimeService.startProcessInstanceByKey(processDefinition.getKey());
        ProcessInstance processInstance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().singleResult();
        Task taskBeforeSuspension = (Task)this.taskService.createTaskQuery().processInstanceId(processInstance.getId()).singleResult();
        Date createTime = taskBeforeSuspension.getCreateTime();
        this.runtimeService.suspendProcessInstanceById(processInstance.getId());
        Task task = (Task)this.taskService.createTaskQuery().processInstanceId(processInstance.getId()).singleResult();
        Assert.assertTrue((boolean)task.isSuspended());
        Assert.assertEquals((Object)createTime, (Object)task.getCreateTime());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/oneTaskProcess.bpmn20.xml"})
    @Test
    public void testTaskSuspendedAfterProcessInstanceSuspensionByProcessDefinitionId() {
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().singleResult();
        this.runtimeService.startProcessInstanceByKey(processDefinition.getKey());
        ProcessInstance processInstance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().singleResult();
        this.runtimeService.suspendProcessInstanceByProcessDefinitionId(processDefinition.getId());
        List tasks = this.taskService.createTaskQuery().processInstanceId(processInstance.getId()).list();
        for (Task task : tasks) {
            Assert.assertTrue((boolean)task.isSuspended());
        }
        this.runtimeService.activateProcessInstanceByProcessDefinitionId(processDefinition.getId());
        tasks = this.taskService.createTaskQuery().processInstanceId(processInstance.getId()).list();
        for (Task task : tasks) {
            Assert.assertFalse((boolean)task.isSuspended());
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/oneTaskProcess.bpmn20.xml"})
    @Test
    public void testTaskSuspendedAfterProcessInstanceSuspensionByProcessDefinitionKey() {
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().singleResult();
        this.runtimeService.startProcessInstanceByKey(processDefinition.getKey());
        ProcessInstance processInstance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().singleResult();
        this.runtimeService.suspendProcessInstanceByProcessDefinitionKey(processDefinition.getKey());
        List tasks = this.taskService.createTaskQuery().processInstanceId(processInstance.getId()).list();
        for (Task task : tasks) {
            Assert.assertTrue((boolean)task.isSuspended());
        }
        this.runtimeService.activateProcessInstanceByProcessDefinitionKey(processDefinition.getKey());
        tasks = this.taskService.createTaskQuery().processInstanceId(processInstance.getId()).list();
        for (Task task : tasks) {
            Assert.assertFalse((boolean)task.isSuspended());
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    @Test
    public void testTaskQueryAfterProcessInstanceSuspend() {
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().singleResult();
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceById(processDefinition.getId());
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        Assert.assertNotNull((Object)task);
        task = (Task)this.taskService.createTaskQuery().active().singleResult();
        Assert.assertNotNull((Object)task);
        this.runtimeService.suspendProcessInstanceById(processInstance.getId());
        Assert.assertEquals((long)1L, (long)this.taskService.createTaskQuery().count());
        Assert.assertEquals((long)1L, (long)this.taskService.createTaskQuery().suspended().count());
        Assert.assertEquals((long)0L, (long)this.taskService.createTaskQuery().active().count());
        this.runtimeService.activateProcessInstanceById(processInstance.getId());
        Assert.assertEquals((long)1L, (long)this.taskService.createTaskQuery().count());
        Assert.assertEquals((long)0L, (long)this.taskService.createTaskQuery().suspended().count());
        Assert.assertEquals((long)1L, (long)this.taskService.createTaskQuery().active().count());
        task = (Task)this.taskService.createTaskQuery().singleResult();
        this.taskService.complete(task.getId());
        Assert.assertEquals((long)0L, (long)this.runtimeService.createProcessInstanceQuery().count());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    @Test
    public void testTaskQueryAfterProcessInstanceSuspendByProcessDefinitionId() {
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().singleResult();
        this.runtimeService.startProcessInstanceById(processDefinition.getId());
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        Assert.assertNotNull((Object)task);
        task = (Task)this.taskService.createTaskQuery().active().singleResult();
        Assert.assertNotNull((Object)task);
        this.runtimeService.suspendProcessInstanceByProcessDefinitionId(processDefinition.getId());
        Assert.assertEquals((long)1L, (long)this.taskService.createTaskQuery().count());
        Assert.assertEquals((long)1L, (long)this.taskService.createTaskQuery().suspended().count());
        Assert.assertEquals((long)0L, (long)this.taskService.createTaskQuery().active().count());
        this.runtimeService.activateProcessInstanceByProcessDefinitionId(processDefinition.getId());
        Assert.assertEquals((long)1L, (long)this.taskService.createTaskQuery().count());
        Assert.assertEquals((long)0L, (long)this.taskService.createTaskQuery().suspended().count());
        Assert.assertEquals((long)1L, (long)this.taskService.createTaskQuery().active().count());
        task = (Task)this.taskService.createTaskQuery().singleResult();
        this.taskService.complete(task.getId());
        Assert.assertEquals((long)0L, (long)this.runtimeService.createProcessInstanceQuery().count());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    @Test
    public void testTaskQueryAfterProcessInstanceSuspendByProcessDefinitionKey() {
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().singleResult();
        this.runtimeService.startProcessInstanceById(processDefinition.getId());
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        Assert.assertNotNull((Object)task);
        task = (Task)this.taskService.createTaskQuery().active().singleResult();
        Assert.assertNotNull((Object)task);
        this.runtimeService.suspendProcessInstanceByProcessDefinitionKey(processDefinition.getKey());
        Assert.assertEquals((long)1L, (long)this.taskService.createTaskQuery().count());
        Assert.assertEquals((long)1L, (long)this.taskService.createTaskQuery().suspended().count());
        Assert.assertEquals((long)0L, (long)this.taskService.createTaskQuery().active().count());
        this.runtimeService.activateProcessInstanceByProcessDefinitionKey(processDefinition.getKey());
        Assert.assertEquals((long)1L, (long)this.taskService.createTaskQuery().count());
        Assert.assertEquals((long)0L, (long)this.taskService.createTaskQuery().suspended().count());
        Assert.assertEquals((long)1L, (long)this.taskService.createTaskQuery().active().count());
        task = (Task)this.taskService.createTaskQuery().singleResult();
        this.taskService.complete(task.getId());
        Assert.assertEquals((long)0L, (long)this.runtimeService.createProcessInstanceQuery().count());
    }

    @Deployment
    @Test
    public void testChildExecutionsSuspendedAfterProcessInstanceSuspend() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("testChildExecutionsSuspended");
        this.runtimeService.suspendProcessInstanceById(processInstance.getId());
        List executions = this.runtimeService.createExecutionQuery().processInstanceId(processInstance.getId()).list();
        for (Execution execution : executions) {
            Assert.assertTrue((boolean)execution.isSuspended());
        }
        this.runtimeService.activateProcessInstanceById(processInstance.getId());
        executions = this.runtimeService.createExecutionQuery().processInstanceId(processInstance.getId()).list();
        for (Execution execution : executions) {
            Assert.assertFalse((boolean)execution.isSuspended());
        }
        while (this.taskService.createTaskQuery().count() > 0L) {
            for (Task task : this.taskService.createTaskQuery().list()) {
                this.taskService.complete(task.getId());
            }
        }
        Assert.assertEquals((long)0L, (long)this.runtimeService.createProcessInstanceQuery().count());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/ProcessInstanceSuspensionTest.testChildExecutionsSuspendedAfterProcessInstanceSuspend.bpmn20.xml"})
    @Test
    public void testChildExecutionsSuspendedAfterProcessInstanceSuspendByProcessDefinitionId() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("testChildExecutionsSuspended");
        this.runtimeService.suspendProcessInstanceByProcessDefinitionId(processInstance.getProcessDefinitionId());
        List executions = this.runtimeService.createExecutionQuery().processInstanceId(processInstance.getId()).list();
        for (Execution execution : executions) {
            Assert.assertTrue((boolean)execution.isSuspended());
        }
        this.runtimeService.activateProcessInstanceByProcessDefinitionId(processInstance.getProcessDefinitionId());
        executions = this.runtimeService.createExecutionQuery().processInstanceId(processInstance.getId()).list();
        for (Execution execution : executions) {
            Assert.assertFalse((boolean)execution.isSuspended());
        }
        while (this.taskService.createTaskQuery().count() > 0L) {
            for (Task task : this.taskService.createTaskQuery().list()) {
                this.taskService.complete(task.getId());
            }
        }
        Assert.assertEquals((long)0L, (long)this.runtimeService.createProcessInstanceQuery().count());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/ProcessInstanceSuspensionTest.testChildExecutionsSuspendedAfterProcessInstanceSuspend.bpmn20.xml"})
    @Test
    public void testChildExecutionsSuspendedAfterProcessInstanceSuspendByProcessDefinitionKey() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("testChildExecutionsSuspended");
        this.runtimeService.suspendProcessInstanceByProcessDefinitionKey("testChildExecutionsSuspended");
        List executions = this.runtimeService.createExecutionQuery().processInstanceId(processInstance.getId()).list();
        for (Execution execution : executions) {
            Assert.assertTrue((boolean)execution.isSuspended());
        }
        this.runtimeService.activateProcessInstanceByProcessDefinitionKey("testChildExecutionsSuspended");
        executions = this.runtimeService.createExecutionQuery().processInstanceId(processInstance.getId()).list();
        for (Execution execution : executions) {
            Assert.assertFalse((boolean)execution.isSuspended());
        }
        while (this.taskService.createTaskQuery().count() > 0L) {
            for (Task task : this.taskService.createTaskQuery().list()) {
                this.taskService.complete(task.getId());
            }
        }
        Assert.assertEquals((long)0L, (long)this.runtimeService.createProcessInstanceQuery().count());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    @Test
    public void testChangeVariablesAfterProcessInstanceSuspend() {
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().singleResult();
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceById(processDefinition.getId());
        this.runtimeService.suspendProcessInstanceById(processInstance.getId());
        try {
            this.runtimeService.removeVariable(processInstance.getId(), "someVariable");
        }
        catch (ProcessEngineException e) {
            Assert.fail((String)"This should be possible");
        }
        try {
            this.runtimeService.removeVariableLocal(processInstance.getId(), "someVariable");
        }
        catch (ProcessEngineException e) {
            Assert.fail((String)"This should be possible");
        }
        try {
            this.runtimeService.removeVariables(processInstance.getId(), Arrays.asList("one", "two", "three"));
        }
        catch (ProcessEngineException e) {
            Assert.fail((String)"This should be possible");
        }
        try {
            this.runtimeService.removeVariablesLocal(processInstance.getId(), Arrays.asList("one", "two", "three"));
        }
        catch (ProcessEngineException e) {
            Assert.fail((String)"This should be possible");
        }
        try {
            this.runtimeService.setVariable(processInstance.getId(), "someVariable", (Object)"someValue");
        }
        catch (ProcessEngineException e) {
            Assert.fail((String)"This should be possible");
        }
        try {
            this.runtimeService.setVariableLocal(processInstance.getId(), "someVariable", (Object)"someValue");
        }
        catch (ProcessEngineException e) {
            Assert.fail((String)"This should be possible");
        }
        try {
            this.runtimeService.setVariables(processInstance.getId(), new HashMap());
        }
        catch (ProcessEngineException e) {
            Assert.fail((String)"This should be possible");
        }
        try {
            this.runtimeService.setVariablesLocal(processInstance.getId(), new HashMap());
        }
        catch (ProcessEngineException e) {
            Assert.fail((String)"This should be possible");
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    @Test
    public void testChangeVariablesAfterProcessInstanceSuspendByProcessDefinitionId() {
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().singleResult();
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceById(processDefinition.getId());
        this.runtimeService.suspendProcessInstanceByProcessDefinitionId(processInstance.getProcessDefinitionId());
        try {
            this.runtimeService.removeVariable(processInstance.getId(), "someVariable");
        }
        catch (ProcessEngineException e) {
            Assert.fail((String)"This should be possible");
        }
        try {
            this.runtimeService.removeVariableLocal(processInstance.getId(), "someVariable");
        }
        catch (ProcessEngineException e) {
            Assert.fail((String)"This should be possible");
        }
        try {
            this.runtimeService.removeVariables(processInstance.getId(), Arrays.asList("one", "two", "three"));
        }
        catch (ProcessEngineException e) {
            Assert.fail((String)"This should be possible");
        }
        try {
            this.runtimeService.removeVariablesLocal(processInstance.getId(), Arrays.asList("one", "two", "three"));
        }
        catch (ProcessEngineException e) {
            Assert.fail((String)"This should be possible");
        }
        try {
            this.runtimeService.setVariable(processInstance.getId(), "someVariable", (Object)"someValue");
        }
        catch (ProcessEngineException e) {
            Assert.fail((String)"This should be possible");
        }
        try {
            this.runtimeService.setVariableLocal(processInstance.getId(), "someVariable", (Object)"someValue");
        }
        catch (ProcessEngineException e) {
            Assert.fail((String)"This should be possible");
        }
        try {
            this.runtimeService.setVariables(processInstance.getId(), new HashMap());
        }
        catch (ProcessEngineException e) {
            Assert.fail((String)"This should be possible");
        }
        try {
            this.runtimeService.setVariablesLocal(processInstance.getId(), new HashMap());
        }
        catch (ProcessEngineException e) {
            Assert.fail((String)"This should be possible");
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    @Test
    public void testChangeVariablesAfterProcessInstanceSuspendByProcessDefinitionKey() {
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().singleResult();
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceById(processDefinition.getId());
        this.runtimeService.suspendProcessInstanceByProcessDefinitionKey(processDefinition.getKey());
        try {
            this.runtimeService.removeVariable(processInstance.getId(), "someVariable");
        }
        catch (ProcessEngineException e) {
            Assert.fail((String)"This should be possible");
        }
        try {
            this.runtimeService.removeVariableLocal(processInstance.getId(), "someVariable");
        }
        catch (ProcessEngineException e) {
            Assert.fail((String)"This should be possible");
        }
        try {
            this.runtimeService.removeVariables(processInstance.getId(), Arrays.asList("one", "two", "three"));
        }
        catch (ProcessEngineException e) {
            Assert.fail((String)"This should be possible");
        }
        try {
            this.runtimeService.removeVariablesLocal(processInstance.getId(), Arrays.asList("one", "two", "three"));
        }
        catch (ProcessEngineException e) {
            Assert.fail((String)"This should be possible");
        }
        try {
            this.runtimeService.setVariable(processInstance.getId(), "someVariable", (Object)"someValue");
        }
        catch (ProcessEngineException e) {
            Assert.fail((String)"This should be possible");
        }
        try {
            this.runtimeService.setVariableLocal(processInstance.getId(), "someVariable", (Object)"someValue");
        }
        catch (ProcessEngineException e) {
            Assert.fail((String)"This should be possible");
        }
        try {
            this.runtimeService.setVariables(processInstance.getId(), new HashMap());
        }
        catch (ProcessEngineException e) {
            Assert.fail((String)"This should be possible");
        }
        try {
            this.runtimeService.setVariablesLocal(processInstance.getId(), new HashMap());
        }
        catch (ProcessEngineException e) {
            Assert.fail((String)"This should be possible");
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    @Test
    public void testSubmitTaskFormFailAfterProcessInstanceSuspend() {
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().singleResult();
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceById(processDefinition.getId());
        this.runtimeService.suspendProcessInstanceById(processInstance.getId());
        try {
            this.formService.submitTaskFormData(((Task)this.taskService.createTaskQuery().processInstanceId(processInstance.getId()).singleResult()).getId(), new HashMap());
            Assert.fail();
        }
        catch (SuspendedEntityInteractionException suspendedEntityInteractionException) {
            // empty catch block
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    @Test
    public void testSubmitTaskFormFailAfterProcessInstanceSuspendByProcessDefinitionId() {
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().singleResult();
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceById(processDefinition.getId());
        this.runtimeService.suspendProcessInstanceByProcessDefinitionId(processDefinition.getId());
        try {
            this.formService.submitTaskFormData(((Task)this.taskService.createTaskQuery().processInstanceId(processInstance.getId()).singleResult()).getId(), new HashMap());
            Assert.fail();
        }
        catch (SuspendedEntityInteractionException suspendedEntityInteractionException) {
            // empty catch block
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    @Test
    public void testSubmitTaskFormFailAfterProcessInstanceSuspendByProcessDefinitionKey() {
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().singleResult();
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceById(processDefinition.getId());
        this.runtimeService.suspendProcessInstanceByProcessDefinitionKey(processDefinition.getKey());
        try {
            this.formService.submitTaskFormData(((Task)this.taskService.createTaskQuery().processInstanceId(processInstance.getId()).singleResult()).getId(), new HashMap());
            Assert.fail();
        }
        catch (SuspendedEntityInteractionException suspendedEntityInteractionException) {
            // empty catch block
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    @Test
    public void testProcessInstanceSignalFailAfterSuspend() {
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().singleResult();
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceById(processDefinition.getId());
        this.runtimeService.suspendProcessInstanceById(processInstance.getId());
        try {
            this.runtimeService.signal(processInstance.getId());
            Assert.fail();
        }
        catch (SuspendedEntityInteractionException e) {
            this.testRule.assertTextPresent("is suspended", e.getMessage());
            Assert.assertTrue((boolean)(e instanceof BadUserRequestException));
        }
        try {
            this.runtimeService.signal(processInstance.getId(), new HashMap());
            Assert.fail();
        }
        catch (SuspendedEntityInteractionException e) {
            this.testRule.assertTextPresent("is suspended", e.getMessage());
            Assert.assertTrue((boolean)(e instanceof BadUserRequestException));
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    @Test
    public void testProcessInstanceSignalFailAfterSuspendByProcessDefinitionId() {
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().singleResult();
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceById(processDefinition.getId());
        this.runtimeService.suspendProcessInstanceByProcessDefinitionId(processDefinition.getId());
        try {
            this.runtimeService.signal(processInstance.getId());
            Assert.fail();
        }
        catch (SuspendedEntityInteractionException e) {
            this.testRule.assertTextPresent("is suspended", e.getMessage());
            Assert.assertTrue((boolean)(e instanceof BadUserRequestException));
        }
        try {
            this.runtimeService.signal(processInstance.getId(), new HashMap());
            Assert.fail();
        }
        catch (SuspendedEntityInteractionException e) {
            this.testRule.assertTextPresent("is suspended", e.getMessage());
            Assert.assertTrue((boolean)(e instanceof BadUserRequestException));
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    @Test
    public void testProcessInstanceSignalFailAfterSuspendByProcessDefinitionKey() {
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().singleResult();
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceById(processDefinition.getId());
        this.runtimeService.suspendProcessInstanceByProcessDefinitionKey(processDefinition.getKey());
        try {
            this.runtimeService.signal(processInstance.getId());
            Assert.fail();
        }
        catch (SuspendedEntityInteractionException e) {
            this.testRule.assertTextPresent("is suspended", e.getMessage());
            Assert.assertTrue((boolean)(e instanceof BadUserRequestException));
        }
        try {
            this.runtimeService.signal(processInstance.getId(), new HashMap());
            Assert.fail();
        }
        catch (SuspendedEntityInteractionException e) {
            this.testRule.assertTextPresent("is suspended", e.getMessage());
            Assert.assertTrue((boolean)(e instanceof BadUserRequestException));
        }
    }

    @Deployment
    @Test
    public void testMessageEventReceiveFailAfterSuspend() {
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().singleResult();
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceById(processDefinition.getId());
        this.runtimeService.suspendProcessInstanceById(processInstance.getId());
        EventSubscription subscription = (EventSubscription)this.runtimeService.createEventSubscriptionQuery().singleResult();
        try {
            this.runtimeService.messageEventReceived("someMessage", subscription.getExecutionId());
            Assert.fail();
        }
        catch (SuspendedEntityInteractionException e) {
            this.testRule.assertTextPresent("is suspended", e.getMessage());
        }
        try {
            this.runtimeService.messageEventReceived("someMessage", subscription.getExecutionId(), new HashMap());
            Assert.fail();
        }
        catch (SuspendedEntityInteractionException e) {
            this.testRule.assertTextPresent("is suspended", e.getMessage());
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/ProcessInstanceSuspensionTest.testMessageEventReceiveFailAfterSuspend.bpmn20.xml"})
    @Test
    public void testMessageEventReceiveFailAfterSuspendByProcessDefinitionId() {
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().singleResult();
        this.runtimeService.startProcessInstanceById(processDefinition.getId());
        this.runtimeService.suspendProcessInstanceByProcessDefinitionId(processDefinition.getId());
        EventSubscription subscription = (EventSubscription)this.runtimeService.createEventSubscriptionQuery().singleResult();
        try {
            this.runtimeService.messageEventReceived("someMessage", subscription.getExecutionId());
            Assert.fail();
        }
        catch (SuspendedEntityInteractionException e) {
            this.testRule.assertTextPresent("is suspended", e.getMessage());
        }
        try {
            this.runtimeService.messageEventReceived("someMessage", subscription.getExecutionId(), new HashMap());
            Assert.fail();
        }
        catch (SuspendedEntityInteractionException e) {
            this.testRule.assertTextPresent("is suspended", e.getMessage());
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/ProcessInstanceSuspensionTest.testMessageEventReceiveFailAfterSuspend.bpmn20.xml"})
    @Test
    public void testMessageEventReceiveFailAfterSuspendByProcessDefinitionKey() {
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().singleResult();
        this.runtimeService.startProcessInstanceById(processDefinition.getId());
        this.runtimeService.suspendProcessInstanceByProcessDefinitionKey(processDefinition.getKey());
        EventSubscription subscription = (EventSubscription)this.runtimeService.createEventSubscriptionQuery().singleResult();
        try {
            this.runtimeService.messageEventReceived("someMessage", subscription.getExecutionId());
            Assert.fail();
        }
        catch (SuspendedEntityInteractionException e) {
            this.testRule.assertTextPresent("is suspended", e.getMessage());
        }
        try {
            this.runtimeService.messageEventReceived("someMessage", subscription.getExecutionId(), new HashMap());
            Assert.fail();
        }
        catch (SuspendedEntityInteractionException e) {
            this.testRule.assertTextPresent("is suspended", e.getMessage());
        }
    }

    @Deployment
    @Test
    public void testSignalEventReceivedAfterProcessInstanceSuspended() {
        String signal = "Some Signal";
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("signalSuspendedProcessInstance");
        this.runtimeService.signalEventReceived("Some Signal");
        Assert.assertEquals((long)0L, (long)this.runtimeService.createProcessInstanceQuery().count());
        processInstance = this.runtimeService.startProcessInstanceByKey("signalSuspendedProcessInstance");
        this.runtimeService.suspendProcessInstanceById(processInstance.getId());
        this.runtimeService.signalEventReceived("Some Signal");
        Assert.assertEquals((long)1L, (long)this.runtimeService.createProcessInstanceQuery().count());
        this.runtimeService.signalEventReceived("Some Signal", new HashMap());
        Assert.assertEquals((long)1L, (long)this.runtimeService.createProcessInstanceQuery().count());
        EventSubscription subscription = (EventSubscription)this.runtimeService.createEventSubscriptionQuery().singleResult();
        try {
            this.runtimeService.signalEventReceived("Some Signal", subscription.getExecutionId());
            Assert.fail();
        }
        catch (SuspendedEntityInteractionException e) {
            this.testRule.assertTextPresent("is suspended", e.getMessage());
        }
        try {
            this.runtimeService.signalEventReceived("Some Signal", subscription.getExecutionId(), new HashMap());
            Assert.fail();
        }
        catch (SuspendedEntityInteractionException e) {
            this.testRule.assertTextPresent("is suspended", e.getMessage());
        }
        this.runtimeService.activateProcessInstanceById(processInstance.getId());
        this.runtimeService.signalEventReceived("Some Signal");
        Assert.assertEquals((long)0L, (long)this.runtimeService.createProcessInstanceQuery().count());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/ProcessInstanceSuspensionTest.testSignalEventReceivedAfterProcessInstanceSuspended.bpmn20.xml"})
    @Test
    public void testSignalEventReceivedAfterProcessInstanceSuspendedByProcessDefinitionId() {
        String signal = "Some Signal";
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("signalSuspendedProcessInstance");
        this.runtimeService.signalEventReceived("Some Signal");
        Assert.assertEquals((long)0L, (long)this.runtimeService.createProcessInstanceQuery().count());
        processInstance = this.runtimeService.startProcessInstanceByKey("signalSuspendedProcessInstance");
        this.runtimeService.suspendProcessInstanceByProcessDefinitionId(processInstance.getProcessDefinitionId());
        this.runtimeService.signalEventReceived("Some Signal");
        Assert.assertEquals((long)1L, (long)this.runtimeService.createProcessInstanceQuery().count());
        this.runtimeService.signalEventReceived("Some Signal", new HashMap());
        Assert.assertEquals((long)1L, (long)this.runtimeService.createProcessInstanceQuery().count());
        EventSubscription subscription = (EventSubscription)this.runtimeService.createEventSubscriptionQuery().singleResult();
        try {
            this.runtimeService.signalEventReceived("Some Signal", subscription.getExecutionId());
            Assert.fail();
        }
        catch (SuspendedEntityInteractionException e) {
            this.testRule.assertTextPresent("is suspended", e.getMessage());
        }
        try {
            this.runtimeService.signalEventReceived("Some Signal", subscription.getExecutionId(), new HashMap());
            Assert.fail();
        }
        catch (SuspendedEntityInteractionException e) {
            this.testRule.assertTextPresent("is suspended", e.getMessage());
        }
        this.runtimeService.activateProcessInstanceById(processInstance.getId());
        this.runtimeService.signalEventReceived("Some Signal");
        Assert.assertEquals((long)0L, (long)this.runtimeService.createProcessInstanceQuery().count());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/ProcessInstanceSuspensionTest.testSignalEventReceivedAfterProcessInstanceSuspended.bpmn20.xml"})
    @Test
    public void testSignalEventReceivedAfterProcessInstanceSuspendedByProcessDefinitionKey() {
        String signal = "Some Signal";
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("signalSuspendedProcessInstance");
        this.runtimeService.signalEventReceived("Some Signal");
        Assert.assertEquals((long)0L, (long)this.runtimeService.createProcessInstanceQuery().count());
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().processDefinitionKey("signalSuspendedProcessInstance").singleResult();
        processInstance = this.runtimeService.startProcessInstanceByKey("signalSuspendedProcessInstance");
        this.runtimeService.suspendProcessInstanceByProcessDefinitionKey(processDefinition.getKey());
        this.runtimeService.signalEventReceived("Some Signal");
        Assert.assertEquals((long)1L, (long)this.runtimeService.createProcessInstanceQuery().count());
        this.runtimeService.signalEventReceived("Some Signal", new HashMap());
        Assert.assertEquals((long)1L, (long)this.runtimeService.createProcessInstanceQuery().count());
        EventSubscription subscription = (EventSubscription)this.runtimeService.createEventSubscriptionQuery().singleResult();
        try {
            this.runtimeService.signalEventReceived("Some Signal", subscription.getExecutionId());
            Assert.fail();
        }
        catch (SuspendedEntityInteractionException e) {
            this.testRule.assertTextPresent("is suspended", e.getMessage());
        }
        try {
            this.runtimeService.signalEventReceived("Some Signal", subscription.getExecutionId(), new HashMap());
            Assert.fail();
        }
        catch (SuspendedEntityInteractionException e) {
            this.testRule.assertTextPresent("is suspended", e.getMessage());
        }
        this.runtimeService.activateProcessInstanceById(processInstance.getId());
        this.runtimeService.signalEventReceived("Some Signal");
        Assert.assertEquals((long)0L, (long)this.runtimeService.createProcessInstanceQuery().count());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    @Test
    public void testTaskLifecycleOperationsFailAfterProcessInstanceSuspend() {
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().singleResult();
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceById(processDefinition.getId());
        Task task = (Task)this.taskService.createTaskQuery().processInstanceId(processInstance.getId()).singleResult();
        Assert.assertNotNull((Object)task);
        this.runtimeService.suspendProcessInstanceById(processInstance.getId());
        try {
            this.taskService.complete(task.getId());
            Assert.fail((String)"It is not allowed to complete a task of a suspended process instance");
        }
        catch (SuspendedEntityInteractionException suspendedEntityInteractionException) {
            // empty catch block
        }
        try {
            this.taskService.claim(task.getId(), "jos");
            Assert.fail((String)"It is not allowed to claim a task of a suspended process instance");
        }
        catch (SuspendedEntityInteractionException suspendedEntityInteractionException) {
            // empty catch block
        }
        try {
            this.taskService.addCandidateGroup(task.getId(), "blahGroup");
            Assert.fail((String)"It is not allowed to add a candidate group on a task of a suspended process instance");
        }
        catch (SuspendedEntityInteractionException suspendedEntityInteractionException) {
            // empty catch block
        }
        try {
            this.taskService.addCandidateUser(task.getId(), "blahUser");
            Assert.fail((String)"It is not allowed to add a candidate user on a task of a suspended process instance");
        }
        catch (SuspendedEntityInteractionException suspendedEntityInteractionException) {
            // empty catch block
        }
        try {
            this.taskService.addGroupIdentityLink(task.getId(), "blahGroup", "candidate");
            Assert.fail((String)"It is not allowed to add a candidate user on a task of a suspended process instance");
        }
        catch (SuspendedEntityInteractionException suspendedEntityInteractionException) {
            // empty catch block
        }
        try {
            this.taskService.addUserIdentityLink(task.getId(), "blahUser", "owner");
            Assert.fail((String)"It is not allowed to add an identityLink on a task of a suspended process instance");
        }
        catch (SuspendedEntityInteractionException suspendedEntityInteractionException) {
            // empty catch block
        }
        try {
            this.taskService.setAssignee(task.getId(), "mispiggy");
            Assert.fail((String)"It is not allowed to set an assignee on a task of a suspended process instance");
        }
        catch (SuspendedEntityInteractionException suspendedEntityInteractionException) {
            // empty catch block
        }
        try {
            this.taskService.setOwner(task.getId(), "kermit");
            Assert.fail((String)"It is not allowed to set an owner on a task of a suspended process instance");
        }
        catch (SuspendedEntityInteractionException suspendedEntityInteractionException) {
            // empty catch block
        }
        try {
            this.taskService.deleteCandidateGroup(task.getId(), "blahGroup");
            Assert.fail((String)"It is not allowed to remove a candidate group on a task of a suspended process instance");
        }
        catch (SuspendedEntityInteractionException suspendedEntityInteractionException) {
            // empty catch block
        }
        try {
            this.taskService.deleteCandidateUser(task.getId(), "blahUser");
            Assert.fail((String)"It is not allowed to remove a candidate user on a task of a suspended process instance");
        }
        catch (SuspendedEntityInteractionException suspendedEntityInteractionException) {
            // empty catch block
        }
        try {
            this.taskService.deleteGroupIdentityLink(task.getId(), "blahGroup", "candidate");
            Assert.fail((String)"It is not allowed to remove a candidate user on a task of a suspended process instance");
        }
        catch (SuspendedEntityInteractionException suspendedEntityInteractionException) {
            // empty catch block
        }
        try {
            this.taskService.deleteUserIdentityLink(task.getId(), "blahUser", "owner");
            Assert.fail((String)"It is not allowed to remove an identityLink on a task of a suspended process instance");
        }
        catch (SuspendedEntityInteractionException suspendedEntityInteractionException) {
            // empty catch block
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    @Test
    public void testTaskLifecycleOperationsFailAfterProcessInstanceSuspendByProcessDefinitionId() {
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().singleResult();
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceById(processDefinition.getId());
        Task task = (Task)this.taskService.createTaskQuery().processInstanceId(processInstance.getId()).singleResult();
        Assert.assertNotNull((Object)task);
        this.runtimeService.suspendProcessInstanceByProcessDefinitionId(processDefinition.getId());
        try {
            this.taskService.complete(task.getId());
            Assert.fail((String)"It is not allowed to complete a task of a suspended process instance");
        }
        catch (SuspendedEntityInteractionException suspendedEntityInteractionException) {
            // empty catch block
        }
        try {
            this.taskService.claim(task.getId(), "jos");
            Assert.fail((String)"It is not allowed to claim a task of a suspended process instance");
        }
        catch (SuspendedEntityInteractionException suspendedEntityInteractionException) {
            // empty catch block
        }
        try {
            this.taskService.addCandidateGroup(task.getId(), "blahGroup");
            Assert.fail((String)"It is not allowed to add a candidate group on a task of a suspended process instance");
        }
        catch (SuspendedEntityInteractionException suspendedEntityInteractionException) {
            // empty catch block
        }
        try {
            this.taskService.addCandidateUser(task.getId(), "blahUser");
            Assert.fail((String)"It is not allowed to add a candidate user on a task of a suspended process instance");
        }
        catch (SuspendedEntityInteractionException suspendedEntityInteractionException) {
            // empty catch block
        }
        try {
            this.taskService.addGroupIdentityLink(task.getId(), "blahGroup", "candidate");
            Assert.fail((String)"It is not allowed to add a candidate user on a task of a suspended process instance");
        }
        catch (SuspendedEntityInteractionException suspendedEntityInteractionException) {
            // empty catch block
        }
        try {
            this.taskService.addUserIdentityLink(task.getId(), "blahUser", "owner");
            Assert.fail((String)"It is not allowed to add an identityLink on a task of a suspended process instance");
        }
        catch (SuspendedEntityInteractionException suspendedEntityInteractionException) {
            // empty catch block
        }
        try {
            this.taskService.setAssignee(task.getId(), "mispiggy");
            Assert.fail((String)"It is not allowed to set an assignee on a task of a suspended process instance");
        }
        catch (SuspendedEntityInteractionException suspendedEntityInteractionException) {
            // empty catch block
        }
        try {
            this.taskService.setOwner(task.getId(), "kermit");
            Assert.fail((String)"It is not allowed to set an owner on a task of a suspended process instance");
        }
        catch (SuspendedEntityInteractionException suspendedEntityInteractionException) {
            // empty catch block
        }
        try {
            this.taskService.deleteCandidateGroup(task.getId(), "blahGroup");
            Assert.fail((String)"It is not allowed to remove a candidate group on a task of a suspended process instance");
        }
        catch (SuspendedEntityInteractionException suspendedEntityInteractionException) {
            // empty catch block
        }
        try {
            this.taskService.deleteCandidateUser(task.getId(), "blahUser");
            Assert.fail((String)"It is not allowed to remove a candidate user on a task of a suspended process instance");
        }
        catch (SuspendedEntityInteractionException suspendedEntityInteractionException) {
            // empty catch block
        }
        try {
            this.taskService.deleteGroupIdentityLink(task.getId(), "blahGroup", "candidate");
            Assert.fail((String)"It is not allowed to remove a candidate user on a task of a suspended process instance");
        }
        catch (SuspendedEntityInteractionException suspendedEntityInteractionException) {
            // empty catch block
        }
        try {
            this.taskService.deleteUserIdentityLink(task.getId(), "blahUser", "owner");
            Assert.fail((String)"It is not allowed to remove an identityLink on a task of a suspended process instance");
        }
        catch (SuspendedEntityInteractionException suspendedEntityInteractionException) {
            // empty catch block
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    @Test
    public void testTaskLifecycleOperationsFailAfterProcessInstanceSuspendByProcessDefinitionKey() {
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().singleResult();
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceById(processDefinition.getId());
        Task task = (Task)this.taskService.createTaskQuery().processInstanceId(processInstance.getId()).singleResult();
        Assert.assertNotNull((Object)task);
        this.runtimeService.suspendProcessInstanceByProcessDefinitionKey(processDefinition.getKey());
        try {
            this.taskService.complete(task.getId());
            Assert.fail((String)"It is not allowed to complete a task of a suspended process instance");
        }
        catch (SuspendedEntityInteractionException suspendedEntityInteractionException) {
            // empty catch block
        }
        try {
            this.taskService.claim(task.getId(), "jos");
            Assert.fail((String)"It is not allowed to claim a task of a suspended process instance");
        }
        catch (SuspendedEntityInteractionException suspendedEntityInteractionException) {
            // empty catch block
        }
        try {
            this.taskService.addCandidateGroup(task.getId(), "blahGroup");
            Assert.fail((String)"It is not allowed to add a candidate group on a task of a suspended process instance");
        }
        catch (SuspendedEntityInteractionException suspendedEntityInteractionException) {
            // empty catch block
        }
        try {
            this.taskService.addCandidateUser(task.getId(), "blahUser");
            Assert.fail((String)"It is not allowed to add a candidate user on a task of a suspended process instance");
        }
        catch (SuspendedEntityInteractionException suspendedEntityInteractionException) {
            // empty catch block
        }
        try {
            this.taskService.addGroupIdentityLink(task.getId(), "blahGroup", "candidate");
            Assert.fail((String)"It is not allowed to add a candidate user on a task of a suspended process instance");
        }
        catch (SuspendedEntityInteractionException suspendedEntityInteractionException) {
            // empty catch block
        }
        try {
            this.taskService.addUserIdentityLink(task.getId(), "blahUser", "owner");
            Assert.fail((String)"It is not allowed to add an identityLink on a task of a suspended process instance");
        }
        catch (SuspendedEntityInteractionException suspendedEntityInteractionException) {
            // empty catch block
        }
        try {
            this.taskService.setAssignee(task.getId(), "mispiggy");
            Assert.fail((String)"It is not allowed to set an assignee on a task of a suspended process instance");
        }
        catch (SuspendedEntityInteractionException suspendedEntityInteractionException) {
            // empty catch block
        }
        try {
            this.taskService.setOwner(task.getId(), "kermit");
            Assert.fail((String)"It is not allowed to set an owner on a task of a suspended process instance");
        }
        catch (SuspendedEntityInteractionException suspendedEntityInteractionException) {
            // empty catch block
        }
        try {
            this.taskService.deleteCandidateGroup(task.getId(), "blahGroup");
            Assert.fail((String)"It is not allowed to remove a candidate group on a task of a suspended process instance");
        }
        catch (SuspendedEntityInteractionException suspendedEntityInteractionException) {
            // empty catch block
        }
        try {
            this.taskService.deleteCandidateUser(task.getId(), "blahUser");
            Assert.fail((String)"It is not allowed to remove a candidate user on a task of a suspended process instance");
        }
        catch (SuspendedEntityInteractionException suspendedEntityInteractionException) {
            // empty catch block
        }
        try {
            this.taskService.deleteGroupIdentityLink(task.getId(), "blahGroup", "candidate");
            Assert.fail((String)"It is not allowed to remove a candidate user on a task of a suspended process instance");
        }
        catch (SuspendedEntityInteractionException suspendedEntityInteractionException) {
            // empty catch block
        }
        try {
            this.taskService.deleteUserIdentityLink(task.getId(), "blahUser", "owner");
            Assert.fail((String)"It is not allowed to remove an identityLink on a task of a suspended process instance");
        }
        catch (SuspendedEntityInteractionException suspendedEntityInteractionException) {
            // empty catch block
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    @Test
    public void testSubTaskCreationFailAfterProcessInstanceSuspend() {
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().singleResult();
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceById(processDefinition.getId());
        Task task = (Task)this.taskService.createTaskQuery().processInstanceId(processInstance.getId()).singleResult();
        this.runtimeService.suspendProcessInstanceById(processInstance.getId());
        Task subTask = this.taskService.newTask("someTaskId");
        subTask.setParentTaskId(task.getId());
        try {
            this.taskService.saveTask(subTask);
            Assert.fail((String)"Creating sub tasks for suspended task should not be possible");
        }
        catch (SuspendedEntityInteractionException suspendedEntityInteractionException) {
            // empty catch block
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    @Test
    public void testSubTaskCreationFailAfterProcessInstanceSuspendByProcessDefinitionId() {
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().singleResult();
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceById(processDefinition.getId());
        Task task = (Task)this.taskService.createTaskQuery().processInstanceId(processInstance.getId()).singleResult();
        this.runtimeService.suspendProcessInstanceByProcessDefinitionId(processDefinition.getId());
        Task subTask = this.taskService.newTask("someTaskId");
        subTask.setParentTaskId(task.getId());
        try {
            this.taskService.saveTask(subTask);
            Assert.fail((String)"Creating sub tasks for suspended task should not be possible");
        }
        catch (SuspendedEntityInteractionException suspendedEntityInteractionException) {
            // empty catch block
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    @Test
    public void testSubTaskCreationFailAfterProcessInstanceSuspendByProcessDefinitionKey() {
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().singleResult();
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceById(processDefinition.getId());
        Task task = (Task)this.taskService.createTaskQuery().processInstanceId(processInstance.getId()).singleResult();
        this.runtimeService.suspendProcessInstanceByProcessDefinitionKey(processDefinition.getKey());
        Task subTask = this.taskService.newTask("someTaskId");
        subTask.setParentTaskId(task.getId());
        try {
            this.taskService.saveTask(subTask);
            Assert.fail((String)"Creating sub tasks for suspended task should not be possible");
        }
        catch (SuspendedEntityInteractionException suspendedEntityInteractionException) {
            // empty catch block
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    @Test
    public void testTaskNonLifecycleOperationsSucceedAfterProcessInstanceSuspend() {
        HashMap<String, String> variables;
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().singleResult();
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceById(processDefinition.getId());
        Task task = (Task)this.taskService.createTaskQuery().processInstanceId(processInstance.getId()).singleResult();
        this.runtimeService.suspendProcessInstanceById(processInstance.getId());
        Assert.assertNotNull((Object)task);
        try {
            this.taskService.setVariable(task.getId(), "someVar", (Object)"someValue");
        }
        catch (SuspendedEntityInteractionException e) {
            Assert.fail((String)"should be allowed");
        }
        try {
            this.taskService.setVariableLocal(task.getId(), "someVar", (Object)"someValue");
        }
        catch (SuspendedEntityInteractionException e) {
            Assert.fail((String)"should be allowed");
        }
        try {
            variables = new HashMap<String, String>();
            variables.put("varOne", "one");
            variables.put("varTwo", "two");
            this.taskService.setVariables(task.getId(), variables);
        }
        catch (SuspendedEntityInteractionException e) {
            Assert.fail((String)"should be allowed");
        }
        try {
            variables = new HashMap();
            variables.put("varOne", "one");
            variables.put("varTwo", "two");
            this.taskService.setVariablesLocal(task.getId(), variables);
        }
        catch (SuspendedEntityInteractionException e) {
            Assert.fail((String)"should be allowed");
        }
        try {
            this.taskService.removeVariable(task.getId(), "someVar");
        }
        catch (SuspendedEntityInteractionException e) {
            Assert.fail((String)"should be allowed");
        }
        try {
            this.taskService.removeVariableLocal(task.getId(), "someVar");
        }
        catch (SuspendedEntityInteractionException e) {
            Assert.fail((String)"should be allowed");
        }
        try {
            this.taskService.removeVariables(task.getId(), Arrays.asList("one", "two"));
        }
        catch (SuspendedEntityInteractionException e) {
            Assert.fail((String)"should be allowed");
        }
        try {
            this.taskService.removeVariablesLocal(task.getId(), Arrays.asList("one", "two"));
        }
        catch (SuspendedEntityInteractionException e) {
            Assert.fail((String)"should be allowed");
        }
        if (this.processEngineConfiguration.getHistoryLevel().getId() > HistoryLevel.HISTORY_LEVEL_ACTIVITY.getId()) {
            try {
                this.taskService.createComment(task.getId(), processInstance.getId(), "test comment");
            }
            catch (SuspendedEntityInteractionException e) {
                Assert.fail((String)"should be allowed");
            }
            try {
                this.taskService.createAttachment("text", task.getId(), processInstance.getId(), "tesTastName", "testDescription", "http://test.com");
            }
            catch (SuspendedEntityInteractionException e) {
                Assert.fail((String)"should be allowed");
            }
        }
        try {
            this.taskService.setPriority(task.getId(), 99);
        }
        catch (SuspendedEntityInteractionException e) {
            Assert.fail((String)"should be allowed");
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    @Test
    public void testTaskNonLifecycleOperationsSucceedAfterProcessInstanceSuspendByProcessDefinitionId() {
        HashMap<String, String> variables;
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().singleResult();
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceById(processDefinition.getId());
        Task task = (Task)this.taskService.createTaskQuery().processInstanceId(processInstance.getId()).singleResult();
        this.runtimeService.suspendProcessInstanceByProcessDefinitionId(processInstance.getProcessDefinitionId());
        Assert.assertNotNull((Object)task);
        try {
            this.taskService.setVariable(task.getId(), "someVar", (Object)"someValue");
        }
        catch (SuspendedEntityInteractionException e) {
            Assert.fail((String)"should be allowed");
        }
        try {
            this.taskService.setVariableLocal(task.getId(), "someVar", (Object)"someValue");
        }
        catch (SuspendedEntityInteractionException e) {
            Assert.fail((String)"should be allowed");
        }
        try {
            variables = new HashMap<String, String>();
            variables.put("varOne", "one");
            variables.put("varTwo", "two");
            this.taskService.setVariables(task.getId(), variables);
        }
        catch (SuspendedEntityInteractionException e) {
            Assert.fail((String)"should be allowed");
        }
        try {
            variables = new HashMap();
            variables.put("varOne", "one");
            variables.put("varTwo", "two");
            this.taskService.setVariablesLocal(task.getId(), variables);
        }
        catch (SuspendedEntityInteractionException e) {
            Assert.fail((String)"should be allowed");
        }
        try {
            this.taskService.removeVariable(task.getId(), "someVar");
        }
        catch (SuspendedEntityInteractionException e) {
            Assert.fail((String)"should be allowed");
        }
        try {
            this.taskService.removeVariableLocal(task.getId(), "someVar");
        }
        catch (SuspendedEntityInteractionException e) {
            Assert.fail((String)"should be allowed");
        }
        try {
            this.taskService.removeVariables(task.getId(), Arrays.asList("one", "two"));
        }
        catch (SuspendedEntityInteractionException e) {
            Assert.fail((String)"should be allowed");
        }
        try {
            this.taskService.removeVariablesLocal(task.getId(), Arrays.asList("one", "two"));
        }
        catch (SuspendedEntityInteractionException e) {
            Assert.fail((String)"should be allowed");
        }
        if (this.processEngineConfiguration.getHistoryLevel().getId() > HistoryLevel.HISTORY_LEVEL_ACTIVITY.getId()) {
            try {
                this.taskService.createComment(task.getId(), processInstance.getId(), "test comment");
            }
            catch (SuspendedEntityInteractionException e) {
                Assert.fail((String)"should be allowed");
            }
            try {
                this.taskService.createAttachment("text", task.getId(), processInstance.getId(), "tesTastName", "testDescription", "http://test.com");
            }
            catch (SuspendedEntityInteractionException e) {
                Assert.fail((String)"should be allowed");
            }
        }
        try {
            this.taskService.setPriority(task.getId(), 99);
        }
        catch (SuspendedEntityInteractionException e) {
            Assert.fail((String)"should be allowed");
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    @Test
    public void testTaskNonLifecycleOperationsSucceedAfterProcessInstanceSuspendByProcessDefinitionKey() {
        HashMap<String, String> variables;
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().singleResult();
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceById(processDefinition.getId());
        Task task = (Task)this.taskService.createTaskQuery().processInstanceId(processInstance.getId()).singleResult();
        this.runtimeService.suspendProcessInstanceByProcessDefinitionKey(processDefinition.getKey());
        Assert.assertNotNull((Object)task);
        try {
            this.taskService.setVariable(task.getId(), "someVar", (Object)"someValue");
        }
        catch (SuspendedEntityInteractionException e) {
            Assert.fail((String)"should be allowed");
        }
        try {
            this.taskService.setVariableLocal(task.getId(), "someVar", (Object)"someValue");
        }
        catch (SuspendedEntityInteractionException e) {
            Assert.fail((String)"should be allowed");
        }
        try {
            variables = new HashMap<String, String>();
            variables.put("varOne", "one");
            variables.put("varTwo", "two");
            this.taskService.setVariables(task.getId(), variables);
        }
        catch (SuspendedEntityInteractionException e) {
            Assert.fail((String)"should be allowed");
        }
        try {
            variables = new HashMap();
            variables.put("varOne", "one");
            variables.put("varTwo", "two");
            this.taskService.setVariablesLocal(task.getId(), variables);
        }
        catch (SuspendedEntityInteractionException e) {
            Assert.fail((String)"should be allowed");
        }
        try {
            this.taskService.removeVariable(task.getId(), "someVar");
        }
        catch (SuspendedEntityInteractionException e) {
            Assert.fail((String)"should be allowed");
        }
        try {
            this.taskService.removeVariableLocal(task.getId(), "someVar");
        }
        catch (SuspendedEntityInteractionException e) {
            Assert.fail((String)"should be allowed");
        }
        try {
            this.taskService.removeVariables(task.getId(), Arrays.asList("one", "two"));
        }
        catch (SuspendedEntityInteractionException e) {
            Assert.fail((String)"should be allowed");
        }
        try {
            this.taskService.removeVariablesLocal(task.getId(), Arrays.asList("one", "two"));
        }
        catch (SuspendedEntityInteractionException e) {
            Assert.fail((String)"should be allowed");
        }
        if (this.processEngineConfiguration.getHistoryLevel().getId() > HistoryLevel.HISTORY_LEVEL_ACTIVITY.getId()) {
            try {
                this.taskService.createComment(task.getId(), processInstance.getId(), "test comment");
            }
            catch (SuspendedEntityInteractionException e) {
                Assert.fail((String)"should be allowed");
            }
            try {
                this.taskService.createAttachment("text", task.getId(), processInstance.getId(), "tesTastName", "testDescription", "http://test.com");
            }
            catch (SuspendedEntityInteractionException e) {
                Assert.fail((String)"should be allowed");
            }
        }
        try {
            this.taskService.setPriority(task.getId(), 99);
        }
        catch (SuspendedEntityInteractionException e) {
            Assert.fail((String)"should be allowed");
        }
    }

    @Deployment
    @Test
    public void testJobNotExecutedAfterProcessInstanceSuspend() {
        Date now = new Date();
        ClockUtil.setCurrentTime((Date)now);
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().singleResult();
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceById(processDefinition.getId());
        Assert.assertEquals((long)1L, (long)this.managementService.createJobQuery().count());
        this.runtimeService.suspendProcessInstanceById(processInstance.getId());
        Assert.assertEquals((long)1L, (long)this.managementService.createJobQuery().count());
        ClockUtil.setCurrentTime((Date)new Date(now.getTime() + 3600000L));
        Assert.assertEquals((long)0L, (long)this.managementService.createJobQuery().executable().count());
        this.runtimeService.activateProcessInstanceById(processInstance.getId());
        Assert.assertEquals((long)1L, (long)this.managementService.createJobQuery().executable().count());
        this.managementService.executeJob(((Job)this.managementService.createJobQuery().singleResult()).getId());
        Assert.assertEquals((long)0L, (long)this.managementService.createJobQuery().count());
        Assert.assertEquals((long)0L, (long)this.runtimeService.createProcessInstanceQuery().count());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/ProcessInstanceSuspensionTest.testJobNotExecutedAfterProcessInstanceSuspend.bpmn20.xml"})
    @Test
    public void testJobNotExecutedAfterProcessInstanceSuspendByProcessDefinitionId() {
        Date now = new Date();
        ClockUtil.setCurrentTime((Date)now);
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().singleResult();
        this.runtimeService.startProcessInstanceById(processDefinition.getId());
        Assert.assertEquals((long)1L, (long)this.managementService.createJobQuery().count());
        this.runtimeService.suspendProcessInstanceByProcessDefinitionId(processDefinition.getId());
        Assert.assertEquals((long)1L, (long)this.managementService.createJobQuery().count());
        ClockUtil.setCurrentTime((Date)new Date(now.getTime() + 3600000L));
        Assert.assertEquals((long)0L, (long)this.managementService.createJobQuery().executable().count());
        this.runtimeService.activateProcessInstanceByProcessDefinitionId(processDefinition.getId());
        Assert.assertEquals((long)1L, (long)this.managementService.createJobQuery().executable().count());
        this.managementService.executeJob(((Job)this.managementService.createJobQuery().singleResult()).getId());
        Assert.assertEquals((long)0L, (long)this.managementService.createJobQuery().count());
        Assert.assertEquals((long)0L, (long)this.runtimeService.createProcessInstanceQuery().count());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/ProcessInstanceSuspensionTest.testJobNotExecutedAfterProcessInstanceSuspend.bpmn20.xml"})
    @Test
    public void testJobNotExecutedAfterProcessInstanceSuspendByProcessDefinitionKey() {
        Date now = new Date();
        ClockUtil.setCurrentTime((Date)now);
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().singleResult();
        this.runtimeService.startProcessInstanceById(processDefinition.getId());
        Assert.assertEquals((long)1L, (long)this.managementService.createJobQuery().count());
        this.runtimeService.suspendProcessInstanceByProcessDefinitionKey(processDefinition.getKey());
        Assert.assertEquals((long)1L, (long)this.managementService.createJobQuery().count());
        ClockUtil.setCurrentTime((Date)new Date(now.getTime() + 3600000L));
        Assert.assertEquals((long)0L, (long)this.managementService.createJobQuery().executable().count());
        this.runtimeService.activateProcessInstanceByProcessDefinitionKey(processDefinition.getKey());
        Assert.assertEquals((long)1L, (long)this.managementService.createJobQuery().executable().count());
        this.managementService.executeJob(((Job)this.managementService.createJobQuery().singleResult()).getId());
        Assert.assertEquals((long)0L, (long)this.managementService.createJobQuery().count());
        Assert.assertEquals((long)0L, (long)this.runtimeService.createProcessInstanceQuery().count());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/ProcessInstanceSuspensionTest.callSimpleProcess.bpmn20.xml", "org/camunda/bpm/engine/test/api/runtime/subProcess.bpmn20.xml"})
    @Test
    public void testCallActivityReturnAfterProcessInstanceSuspend() {
        ProcessInstance instance = this.runtimeService.startProcessInstanceByKey("callSimpleProcess");
        this.runtimeService.suspendProcessInstanceById(instance.getId());
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        try {
            this.taskService.complete(task.getId());
            Assert.fail((String)"this should not be successful, as the execution of a suspended instance is resumed");
        }
        catch (SuspendedEntityInteractionException suspendedEntityInteractionException) {
            // empty catch block
        }
        this.runtimeService.activateProcessInstanceById(instance.getId());
        this.taskService.complete(task.getId());
        Assert.assertEquals((long)1L, (long)this.runtimeService.createProcessInstanceQuery().count());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/ProcessInstanceSuspensionTest.callSimpleProcess.bpmn20.xml", "org/camunda/bpm/engine/test/api/runtime/subProcess.bpmn20.xml"})
    @Test
    public void testCallActivityReturnAfterProcessInstanceSuspendByProcessDefinitionId() {
        ProcessInstance instance = this.runtimeService.startProcessInstanceByKey("callSimpleProcess");
        this.runtimeService.suspendProcessInstanceByProcessDefinitionId(instance.getProcessDefinitionId());
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        try {
            this.taskService.complete(task.getId());
            Assert.fail((String)"this should not be successful, as the execution of a suspended instance is resumed");
        }
        catch (SuspendedEntityInteractionException suspendedEntityInteractionException) {
            // empty catch block
        }
        this.runtimeService.activateProcessInstanceByProcessDefinitionId(instance.getProcessDefinitionId());
        this.taskService.complete(task.getId());
        Assert.assertEquals((long)1L, (long)this.runtimeService.createProcessInstanceQuery().count());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/ProcessInstanceSuspensionTest.callSimpleProcess.bpmn20.xml", "org/camunda/bpm/engine/test/api/runtime/subProcess.bpmn20.xml"})
    @Test
    public void testCallActivityReturnAfterProcessInstanceSuspendByProcessDefinitionKey() {
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().processDefinitionKey("callSimpleProcess").singleResult();
        this.runtimeService.startProcessInstanceByKey("callSimpleProcess");
        this.runtimeService.suspendProcessInstanceByProcessDefinitionKey(processDefinition.getKey());
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        try {
            this.taskService.complete(task.getId());
            Assert.fail((String)"this should not be successful, as the execution of a suspended instance is resumed");
        }
        catch (SuspendedEntityInteractionException suspendedEntityInteractionException) {
            // empty catch block
        }
        this.runtimeService.activateProcessInstanceByProcessDefinitionKey(processDefinition.getKey());
        this.taskService.complete(task.getId());
        Assert.assertEquals((long)1L, (long)this.runtimeService.createProcessInstanceQuery().count());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/ProcessInstanceSuspensionTest.callMISimpleProcess.bpmn20.xml", "org/camunda/bpm/engine/test/api/runtime/subProcess.bpmn20.xml"})
    @Test
    public void testMICallActivityReturnAfterProcessInstanceSuspend() {
        ProcessInstance instance = this.runtimeService.startProcessInstanceByKey("callMISimpleProcess");
        this.runtimeService.suspendProcessInstanceById(instance.getId());
        List tasks = this.taskService.createTaskQuery().list();
        Task task1 = (Task)tasks.get(0);
        Task task2 = (Task)tasks.get(1);
        try {
            this.taskService.complete(task1.getId());
            Assert.fail((String)"this should not be successful, as the execution of a suspended instance is resumed");
        }
        catch (SuspendedEntityInteractionException suspendedEntityInteractionException) {
            // empty catch block
        }
        try {
            this.taskService.complete(task2.getId());
            Assert.fail((String)"this should not be successful, as the execution of a suspended instance is resumed");
        }
        catch (SuspendedEntityInteractionException suspendedEntityInteractionException) {
            // empty catch block
        }
        this.runtimeService.activateProcessInstanceById(instance.getId());
        this.taskService.complete(task1.getId());
        this.taskService.complete(task2.getId());
        Assert.assertEquals((long)0L, (long)this.runtimeService.createProcessInstanceQuery().count());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/ProcessInstanceSuspensionTest.callMISimpleProcess.bpmn20.xml", "org/camunda/bpm/engine/test/api/runtime/subProcess.bpmn20.xml"})
    @Test
    public void testMICallActivityReturnAfterProcessInstanceSuspendByProcessDefinitionId() {
        ProcessInstance instance = this.runtimeService.startProcessInstanceByKey("callMISimpleProcess");
        this.runtimeService.suspendProcessInstanceByProcessDefinitionId(instance.getProcessDefinitionId());
        List tasks = this.taskService.createTaskQuery().list();
        Task task1 = (Task)tasks.get(0);
        Task task2 = (Task)tasks.get(1);
        try {
            this.taskService.complete(task1.getId());
            Assert.fail((String)"this should not be successful, as the execution of a suspended instance is resumed");
        }
        catch (SuspendedEntityInteractionException suspendedEntityInteractionException) {
            // empty catch block
        }
        try {
            this.taskService.complete(task2.getId());
            Assert.fail((String)"this should not be successful, as the execution of a suspended instance is resumed");
        }
        catch (SuspendedEntityInteractionException suspendedEntityInteractionException) {
            // empty catch block
        }
        this.runtimeService.activateProcessInstanceByProcessDefinitionId(instance.getProcessDefinitionId());
        this.taskService.complete(task1.getId());
        this.taskService.complete(task2.getId());
        Assert.assertEquals((long)0L, (long)this.runtimeService.createProcessInstanceQuery().count());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/ProcessInstanceSuspensionTest.callMISimpleProcess.bpmn20.xml", "org/camunda/bpm/engine/test/api/runtime/subProcess.bpmn20.xml"})
    @Test
    public void testMICallActivityReturnAfterProcessInstanceSuspendByProcessDefinitionKey() {
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().processDefinitionKey("callMISimpleProcess").singleResult();
        this.runtimeService.startProcessInstanceByKey("callMISimpleProcess");
        this.runtimeService.suspendProcessInstanceByProcessDefinitionKey(processDefinition.getKey());
        List tasks = this.taskService.createTaskQuery().list();
        Task task1 = (Task)tasks.get(0);
        Task task2 = (Task)tasks.get(1);
        try {
            this.taskService.complete(task1.getId());
            Assert.fail((String)"this should not be successful, as the execution of a suspended instance is resumed");
        }
        catch (SuspendedEntityInteractionException suspendedEntityInteractionException) {
            // empty catch block
        }
        try {
            this.taskService.complete(task2.getId());
            Assert.fail((String)"this should not be successful, as the execution of a suspended instance is resumed");
        }
        catch (SuspendedEntityInteractionException suspendedEntityInteractionException) {
            // empty catch block
        }
        this.runtimeService.activateProcessInstanceByProcessDefinitionKey(processDefinition.getKey());
        this.taskService.complete(task1.getId());
        this.taskService.complete(task2.getId());
        Assert.assertEquals((long)0L, (long)this.runtimeService.createProcessInstanceQuery().count());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/oneTaskProcess.bpmn20.xml"})
    @Test
    public void testStartBeforeActivityForSuspendProcessInstance() {
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().singleResult();
        this.runtimeService.startProcessInstanceById(processDefinition.getId());
        ProcessInstance processInstance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().singleResult();
        this.runtimeService.suspendProcessInstanceById(processInstance.getId());
        try {
            ((ProcessInstanceModificationInstantiationBuilder)this.runtimeService.createProcessInstanceModification(processInstance.getId()).startBeforeActivity("theTask")).execute();
            Assert.fail((String)"Exception is expected but not thrown");
        }
        catch (SuspendedEntityInteractionException e) {
            this.testRule.assertTextPresentIgnoreCase("is suspended", e.getMessage());
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/oneTaskProcess.bpmn20.xml"})
    @Test
    public void testStartAfterActivityForSuspendProcessInstance() {
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().singleResult();
        this.runtimeService.startProcessInstanceById(processDefinition.getId());
        ProcessInstance processInstance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().singleResult();
        this.runtimeService.suspendProcessInstanceById(processInstance.getId());
        try {
            ((ProcessInstanceModificationInstantiationBuilder)this.runtimeService.createProcessInstanceModification(processInstance.getId()).startAfterActivity("theTask")).execute();
            Assert.fail((String)"Exception is expected but not thrown");
        }
        catch (SuspendedEntityInteractionException e) {
            this.testRule.assertTextPresentIgnoreCase("is suspended", e.getMessage());
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/externaltask/oneExternalTaskProcess.bpmn20.xml", "org/camunda/bpm/engine/test/api/externaltask/twoExternalTaskProcess.bpmn20.xml"})
    @Test
    public void testSuspensionByIdCascadesToExternalTasks() {
        ProcessInstance processInstance1 = this.runtimeService.startProcessInstanceByKey("oneExternalTaskProcess");
        ProcessInstance processInstance2 = this.runtimeService.startProcessInstanceByKey("twoExternalTaskProcess");
        ExternalTask task1 = (ExternalTask)this.externalTaskService.createExternalTaskQuery().processInstanceId(processInstance1.getId()).singleResult();
        Assert.assertFalse((boolean)task1.isSuspended());
        this.runtimeService.suspendProcessInstanceById(processInstance1.getId());
        task1 = (ExternalTask)this.externalTaskService.createExternalTaskQuery().processInstanceId(processInstance1.getId()).singleResult();
        Assert.assertTrue((boolean)task1.isSuspended());
        ExternalTask task2 = (ExternalTask)this.externalTaskService.createExternalTaskQuery().processInstanceId(processInstance2.getId()).singleResult();
        Assert.assertFalse((boolean)task2.isSuspended());
        this.runtimeService.activateProcessInstanceById(processInstance1.getId());
        task1 = (ExternalTask)this.externalTaskService.createExternalTaskQuery().processInstanceId(processInstance1.getId()).singleResult();
        Assert.assertFalse((boolean)task1.isSuspended());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/externaltask/oneExternalTaskProcess.bpmn20.xml", "org/camunda/bpm/engine/test/api/externaltask/twoExternalTaskProcess.bpmn20.xml"})
    @Test
    public void testSuspensionByProcessDefinitionIdCascadesToExternalTasks() {
        ProcessInstance processInstance1 = this.runtimeService.startProcessInstanceByKey("oneExternalTaskProcess");
        ProcessInstance processInstance2 = this.runtimeService.startProcessInstanceByKey("twoExternalTaskProcess");
        ExternalTask task1 = (ExternalTask)this.externalTaskService.createExternalTaskQuery().processInstanceId(processInstance1.getId()).singleResult();
        Assert.assertFalse((boolean)task1.isSuspended());
        this.runtimeService.suspendProcessInstanceByProcessDefinitionId(processInstance1.getProcessDefinitionId());
        task1 = (ExternalTask)this.externalTaskService.createExternalTaskQuery().processInstanceId(processInstance1.getId()).singleResult();
        Assert.assertTrue((boolean)task1.isSuspended());
        ExternalTask task2 = (ExternalTask)this.externalTaskService.createExternalTaskQuery().processInstanceId(processInstance2.getId()).singleResult();
        Assert.assertFalse((boolean)task2.isSuspended());
        this.runtimeService.activateProcessInstanceByProcessDefinitionId(processInstance1.getProcessDefinitionId());
        task1 = (ExternalTask)this.externalTaskService.createExternalTaskQuery().processInstanceId(processInstance1.getId()).singleResult();
        Assert.assertFalse((boolean)task1.isSuspended());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/externaltask/oneExternalTaskProcess.bpmn20.xml", "org/camunda/bpm/engine/test/api/externaltask/twoExternalTaskProcess.bpmn20.xml"})
    @Test
    public void testSuspensionByProcessDefinitionKeyCascadesToExternalTasks() {
        ProcessInstance processInstance1 = this.runtimeService.startProcessInstanceByKey("oneExternalTaskProcess");
        ProcessInstance processInstance2 = this.runtimeService.startProcessInstanceByKey("twoExternalTaskProcess");
        ExternalTask task1 = (ExternalTask)this.externalTaskService.createExternalTaskQuery().processInstanceId(processInstance1.getId()).singleResult();
        Assert.assertFalse((boolean)task1.isSuspended());
        this.runtimeService.suspendProcessInstanceByProcessDefinitionKey("oneExternalTaskProcess");
        task1 = (ExternalTask)this.externalTaskService.createExternalTaskQuery().processInstanceId(processInstance1.getId()).singleResult();
        Assert.assertTrue((boolean)task1.isSuspended());
        ExternalTask task2 = (ExternalTask)this.externalTaskService.createExternalTaskQuery().processInstanceId(processInstance2.getId()).singleResult();
        Assert.assertFalse((boolean)task2.isSuspended());
        this.runtimeService.activateProcessInstanceByProcessDefinitionKey("oneExternalTaskProcess");
        task1 = (ExternalTask)this.externalTaskService.createExternalTaskQuery().processInstanceId(processInstance1.getId()).singleResult();
        Assert.assertFalse((boolean)task1.isSuspended());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/oneTaskProcess.bpmn20.xml"})
    @Test
    public void testSuspendAndActivateProcessInstanceByIdUsingBuilder() {
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        ProcessInstance processInstance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().singleResult();
        Assert.assertFalse((boolean)processInstance.isSuspended());
        this.runtimeService.updateProcessInstanceSuspensionState().byProcessInstanceId(processInstance.getId()).suspend();
        ProcessInstanceQuery query = this.runtimeService.createProcessInstanceQuery();
        Assert.assertEquals((long)0L, (long)query.active().count());
        Assert.assertEquals((long)1L, (long)query.suspended().count());
        this.runtimeService.updateProcessInstanceSuspensionState().byProcessInstanceId(processInstance.getId()).activate();
        Assert.assertEquals((long)1L, (long)query.active().count());
        Assert.assertEquals((long)0L, (long)query.suspended().count());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/oneTaskProcess.bpmn20.xml"})
    @Test
    public void testSuspendAndActivateProcessInstanceByProcessDefinitionIdUsingBuilder() {
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().singleResult();
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        ProcessInstanceQuery query = this.runtimeService.createProcessInstanceQuery();
        Assert.assertEquals((long)1L, (long)query.active().count());
        Assert.assertEquals((long)0L, (long)query.suspended().count());
        this.runtimeService.updateProcessInstanceSuspensionState().byProcessDefinitionId(processDefinition.getId()).suspend();
        Assert.assertEquals((long)0L, (long)query.active().count());
        Assert.assertEquals((long)1L, (long)query.suspended().count());
        this.runtimeService.updateProcessInstanceSuspensionState().byProcessDefinitionId(processDefinition.getId()).activate();
        Assert.assertEquals((long)1L, (long)query.active().count());
        Assert.assertEquals((long)0L, (long)query.suspended().count());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/oneTaskProcess.bpmn20.xml"})
    @Test
    public void testSuspendAndActivateProcessInstanceByProcessDefinitionKeyUsingBuilder() {
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        ProcessInstanceQuery query = this.runtimeService.createProcessInstanceQuery();
        Assert.assertEquals((long)1L, (long)query.active().count());
        Assert.assertEquals((long)0L, (long)query.suspended().count());
        this.runtimeService.updateProcessInstanceSuspensionState().byProcessDefinitionKey("oneTaskProcess").suspend();
        Assert.assertEquals((long)0L, (long)query.active().count());
        Assert.assertEquals((long)1L, (long)query.suspended().count());
        this.runtimeService.updateProcessInstanceSuspensionState().byProcessDefinitionKey("oneTaskProcess").activate();
        Assert.assertEquals((long)1L, (long)query.active().count());
        Assert.assertEquals((long)0L, (long)query.suspended().count());
    }

    @Deployment
    @Test
    public void testJobSuspensionStateUpdate() {
        ProcessInstance instance = this.runtimeService.startProcessInstanceByKey("process");
        String id = instance.getProcessInstanceId();
        this.runtimeService.suspendProcessInstanceById(id);
        Job job = (Job)this.managementService.createJobQuery().processInstanceId(id).singleResult();
        Assert.assertTrue((boolean)job.isSuspended());
    }
}

