/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.task;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Set;
import org.camunda.bpm.engine.RuntimeService;
import org.camunda.bpm.engine.TaskService;
import org.camunda.bpm.engine.delegate.DelegateTask;
import org.camunda.bpm.engine.delegate.TaskListener;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.task.Task;
import org.camunda.bpm.engine.test.Deployment;
import org.camunda.bpm.engine.test.ProcessEngineRule;
import org.camunda.bpm.engine.test.util.ProcessEngineTestRule;
import org.camunda.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.camunda.bpm.model.bpmn.Bpmn;
import org.camunda.bpm.model.bpmn.BpmnModelInstance;
import org.camunda.bpm.model.bpmn.builder.UserTaskBuilder;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;

public class DelegateTaskTest {
    public ProcessEngineRule engineRule = new ProvidedProcessEngineRule();
    public ProcessEngineTestRule testRule = new ProcessEngineTestRule(this.engineRule);
    private static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
    private static final String FOLLOW_UP_DATE_STRING = "2019-01-01T01:00:00";
    private static Date FOLLOW_UP_DATE;
    private RuntimeService runtimeService;
    private TaskService taskService;
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.engineRule).around((TestRule)this.testRule);

    @Before
    public void init() {
        this.runtimeService = this.engineRule.getRuntimeService();
        this.taskService = this.engineRule.getTaskService();
    }

    @Test
    @Deployment
    public void testGetCandidates() {
        this.runtimeService.startProcessInstanceByKey("DelegateTaskTest.testGetCandidates");
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        Assert.assertNotNull((Object)task);
        Set candidateUsers = (Set)this.taskService.getVariable(task.getId(), "candidateUsers");
        Assert.assertEquals((long)2L, (long)candidateUsers.size());
        Assert.assertTrue((boolean)candidateUsers.contains("kermit"));
        Assert.assertTrue((boolean)candidateUsers.contains("gonzo"));
        Set candidateGroups = (Set)this.taskService.getVariable(task.getId(), "candidateGroups");
        Assert.assertEquals((long)2L, (long)candidateGroups.size());
        Assert.assertTrue((boolean)candidateGroups.contains("management"));
        Assert.assertTrue((boolean)candidateGroups.contains("accountancy"));
    }

    @Test
    public void testGetFollowUpDate() {
        BpmnModelInstance modelInstance = ((UserTaskBuilder)((UserTaskBuilder)Bpmn.createExecutableProcess((String)"process").startEvent().userTask().camundaFollowUpDate(FOLLOW_UP_DATE_STRING)).camundaTaskListenerClass("create", GetFollowUpDateListener.class)).endEvent().done();
        this.testRule.deploy(modelInstance);
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("process");
        String processInstanceId = processInstance.getId();
        Date followUpDate = (Date)this.runtimeService.getVariable(processInstanceId, "followUp");
        Assert.assertThat((Object)followUpDate, (Matcher)CoreMatchers.notNullValue());
        Assert.assertThat((Object)followUpDate, (Matcher)CoreMatchers.is((Object)FOLLOW_UP_DATE));
    }

    @Test
    public void testSetFollowUpDate() {
        BpmnModelInstance modelInstance = ((UserTaskBuilder)Bpmn.createExecutableProcess((String)"process").startEvent().userTask().camundaTaskListenerClass("create", SetFollowUpDateListener.class)).endEvent().done();
        this.testRule.deploy(modelInstance);
        this.runtimeService.startProcessInstanceByKey("process");
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        Date followUpDate = task.getFollowUpDate();
        Assert.assertThat((Object)followUpDate, (Matcher)CoreMatchers.notNullValue());
        Assert.assertThat((Object)followUpDate, (Matcher)CoreMatchers.is((Object)FOLLOW_UP_DATE));
    }

    static {
        try {
            FOLLOW_UP_DATE = DATE_FORMAT.parse(FOLLOW_UP_DATE_STRING);
        }
        catch (ParseException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public static class SetFollowUpDateListener
    implements TaskListener {
        public void notify(DelegateTask delegateTask) {
            delegateTask.setFollowUpDate(FOLLOW_UP_DATE);
        }
    }

    public static class GetFollowUpDateListener
    implements TaskListener {
        public void notify(DelegateTask delegateTask) {
            Date followUpDate = delegateTask.getFollowUpDate();
            Assert.assertThat((Object)followUpDate, (Matcher)CoreMatchers.notNullValue());
            delegateTask.setVariable("followUp", (Object)followUpDate);
        }
    }
}

