/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.bpmn.iomapping;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.assertj.core.api.Assertions;
import org.camunda.bpm.engine.ParseException;
import org.camunda.bpm.engine.Problem;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.ResourceReport;
import org.camunda.bpm.engine.delegate.BpmnError;
import org.camunda.bpm.engine.runtime.ActivityInstance;
import org.camunda.bpm.engine.runtime.Execution;
import org.camunda.bpm.engine.runtime.Job;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.runtime.VariableInstance;
import org.camunda.bpm.engine.task.Task;
import org.camunda.bpm.engine.test.Deployment;
import org.camunda.bpm.engine.test.bpmn.iomapping.OnePlusOneBean;
import org.camunda.bpm.engine.test.util.PluggableProcessEngineTest;
import org.camunda.bpm.model.bpmn.Bpmn;
import org.camunda.bpm.model.bpmn.BpmnModelInstance;
import org.camunda.bpm.model.bpmn.builder.ReceiveTaskBuilder;
import org.camunda.bpm.model.bpmn.builder.ServiceTaskBuilder;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;

public class InputOutputTest
extends PluggableProcessEngineTest {
    @Deployment
    @Test
    public void testInputNullValue() {
        this.runtimeService.startProcessInstanceByKey("testProcess");
        Execution execution = (Execution)this.runtimeService.createExecutionQuery().activityId("wait").singleResult();
        VariableInstance variable = (VariableInstance)this.runtimeService.createVariableInstanceQuery().variableName("var1").singleResult();
        Assert.assertNotNull((Object)variable);
        Assert.assertEquals((Object)"null", (Object)variable.getTypeName());
        Assert.assertEquals((Object)execution.getId(), (Object)variable.getExecutionId());
    }

    @Deployment
    @Test
    public void testInputStringConstantValue() {
        this.runtimeService.startProcessInstanceByKey("testProcess");
        Execution execution = (Execution)this.runtimeService.createExecutionQuery().activityId("wait").singleResult();
        VariableInstance variable = (VariableInstance)this.runtimeService.createVariableInstanceQuery().variableName("var1").singleResult();
        Assert.assertNotNull((Object)variable);
        Assert.assertEquals((Object)"stringValue", (Object)variable.getValue());
        Assert.assertEquals((Object)execution.getId(), (Object)variable.getExecutionId());
    }

    @Deployment
    @Test
    public void testInputElValue() {
        this.runtimeService.startProcessInstanceByKey("testProcess");
        Execution execution = (Execution)this.runtimeService.createExecutionQuery().activityId("wait").singleResult();
        VariableInstance variable = (VariableInstance)this.runtimeService.createVariableInstanceQuery().variableName("var1").singleResult();
        Assert.assertNotNull((Object)variable);
        Assert.assertEquals((Object)2L, (Object)variable.getValue());
        Assert.assertEquals((Object)execution.getId(), (Object)variable.getExecutionId());
    }

    @Deployment
    @Test
    public void testInputScriptValue() {
        this.runtimeService.startProcessInstanceByKey("testProcess");
        Execution execution = (Execution)this.runtimeService.createExecutionQuery().activityId("wait").singleResult();
        VariableInstance variable = (VariableInstance)this.runtimeService.createVariableInstanceQuery().variableName("var1").singleResult();
        Assert.assertNotNull((Object)variable);
        Assert.assertEquals((Object)2, (Object)variable.getValue());
        Assert.assertEquals((Object)execution.getId(), (Object)variable.getExecutionId());
    }

    @Deployment
    @Test
    public void testInputScriptValueAsVariable() {
        HashMap<String, String> variables = new HashMap<String, String>();
        variables.put("scriptSource", "return 1 + 1");
        this.runtimeService.startProcessInstanceByKey("testProcess", variables);
        Execution execution = (Execution)this.runtimeService.createExecutionQuery().activityId("wait").singleResult();
        VariableInstance variable = (VariableInstance)this.runtimeService.createVariableInstanceQuery().variableName("var1").singleResult();
        Assert.assertNotNull((Object)variable);
        Assert.assertEquals((Object)2, (Object)variable.getValue());
        Assert.assertEquals((Object)execution.getId(), (Object)variable.getExecutionId());
    }

    @Deployment
    @Test
    public void testInputScriptValueAsBean() {
        HashMap<String, OnePlusOneBean> variables = new HashMap<String, OnePlusOneBean>();
        variables.put("onePlusOneBean", new OnePlusOneBean());
        this.runtimeService.startProcessInstanceByKey("testProcess", variables);
        Execution execution = (Execution)this.runtimeService.createExecutionQuery().activityId("wait").singleResult();
        VariableInstance variable = (VariableInstance)this.runtimeService.createVariableInstanceQuery().variableName("var1").singleResult();
        Assert.assertNotNull((Object)variable);
        Assert.assertEquals((Object)2, (Object)variable.getValue());
        Assert.assertEquals((Object)execution.getId(), (Object)variable.getExecutionId());
    }

    @Deployment
    @Test
    public void testInputExternalScriptValue() {
        this.runtimeService.startProcessInstanceByKey("testProcess");
        Execution execution = (Execution)this.runtimeService.createExecutionQuery().activityId("wait").singleResult();
        VariableInstance variable = (VariableInstance)this.runtimeService.createVariableInstanceQuery().variableName("var1").singleResult();
        Assert.assertNotNull((Object)variable);
        Assert.assertEquals((Object)2, (Object)variable.getValue());
        Assert.assertEquals((Object)execution.getId(), (Object)variable.getExecutionId());
    }

    @Deployment
    @Test
    public void testInputExternalScriptValueAsVariable() {
        HashMap<String, String> variables = new HashMap<String, String>();
        variables.put("scriptPath", "org/camunda/bpm/engine/test/bpmn/iomapping/oneplusone.groovy");
        this.runtimeService.startProcessInstanceByKey("testProcess", variables);
        Execution execution = (Execution)this.runtimeService.createExecutionQuery().activityId("wait").singleResult();
        VariableInstance variable = (VariableInstance)this.runtimeService.createVariableInstanceQuery().variableName("var1").singleResult();
        Assert.assertNotNull((Object)variable);
        Assert.assertEquals((Object)2, (Object)variable.getValue());
        Assert.assertEquals((Object)execution.getId(), (Object)variable.getExecutionId());
    }

    @Deployment
    @Test
    public void testInputExternalScriptValueAsBean() {
        HashMap<String, OnePlusOneBean> variables = new HashMap<String, OnePlusOneBean>();
        variables.put("onePlusOneBean", new OnePlusOneBean());
        this.runtimeService.startProcessInstanceByKey("testProcess", variables);
        Execution execution = (Execution)this.runtimeService.createExecutionQuery().activityId("wait").singleResult();
        VariableInstance variable = (VariableInstance)this.runtimeService.createVariableInstanceQuery().variableName("var1").singleResult();
        Assert.assertNotNull((Object)variable);
        Assert.assertEquals((Object)2, (Object)variable.getValue());
        Assert.assertEquals((Object)execution.getId(), (Object)variable.getExecutionId());
    }

    @Deployment
    @Test
    public void testInputExternalClasspathScriptValue() {
        this.runtimeService.startProcessInstanceByKey("testProcess");
        Execution execution = (Execution)this.runtimeService.createExecutionQuery().activityId("wait").singleResult();
        VariableInstance variable = (VariableInstance)this.runtimeService.createVariableInstanceQuery().variableName("var1").singleResult();
        Assert.assertNotNull((Object)variable);
        Assert.assertEquals((Object)2, (Object)variable.getValue());
        Assert.assertEquals((Object)execution.getId(), (Object)variable.getExecutionId());
    }

    @Deployment
    @Test
    public void testInputExternalClasspathScriptValueAsVariable() {
        HashMap<String, String> variables = new HashMap<String, String>();
        variables.put("scriptPath", "classpath://org/camunda/bpm/engine/test/bpmn/iomapping/oneplusone.groovy");
        this.runtimeService.startProcessInstanceByKey("testProcess", variables);
        Execution execution = (Execution)this.runtimeService.createExecutionQuery().activityId("wait").singleResult();
        VariableInstance variable = (VariableInstance)this.runtimeService.createVariableInstanceQuery().variableName("var1").singleResult();
        Assert.assertNotNull((Object)variable);
        Assert.assertEquals((Object)2, (Object)variable.getValue());
        Assert.assertEquals((Object)execution.getId(), (Object)variable.getExecutionId());
    }

    @Deployment
    @Test
    public void testInputExternalClasspathScriptValueAsBean() {
        HashMap<String, OnePlusOneBean> variables = new HashMap<String, OnePlusOneBean>();
        variables.put("onePlusOneBean", new OnePlusOneBean());
        this.runtimeService.startProcessInstanceByKey("testProcess", variables);
        Execution execution = (Execution)this.runtimeService.createExecutionQuery().activityId("wait").singleResult();
        VariableInstance variable = (VariableInstance)this.runtimeService.createVariableInstanceQuery().variableName("var1").singleResult();
        Assert.assertNotNull((Object)variable);
        Assert.assertEquals((Object)2, (Object)variable.getValue());
        Assert.assertEquals((Object)execution.getId(), (Object)variable.getExecutionId());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/iomapping/InputOutputTest.testInputExternalDeploymentScriptValue.bpmn", "org/camunda/bpm/engine/test/bpmn/iomapping/oneplusone.groovy"})
    @Test
    public void testInputExternalDeploymentScriptValue() {
        this.runtimeService.startProcessInstanceByKey("testProcess");
        Execution execution = (Execution)this.runtimeService.createExecutionQuery().activityId("wait").singleResult();
        VariableInstance variable = (VariableInstance)this.runtimeService.createVariableInstanceQuery().variableName("var1").singleResult();
        Assert.assertNotNull((Object)variable);
        Assert.assertEquals((Object)2, (Object)variable.getValue());
        Assert.assertEquals((Object)execution.getId(), (Object)variable.getExecutionId());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/iomapping/InputOutputTest.testInputExternalDeploymentScriptValueAsVariable.bpmn", "org/camunda/bpm/engine/test/bpmn/iomapping/oneplusone.groovy"})
    @Test
    public void testInputExternalDeploymentScriptValueAsVariable() {
        HashMap<String, String> variables = new HashMap<String, String>();
        variables.put("scriptPath", "deployment://org/camunda/bpm/engine/test/bpmn/iomapping/oneplusone.groovy");
        this.runtimeService.startProcessInstanceByKey("testProcess", variables);
        Execution execution = (Execution)this.runtimeService.createExecutionQuery().activityId("wait").singleResult();
        VariableInstance variable = (VariableInstance)this.runtimeService.createVariableInstanceQuery().variableName("var1").singleResult();
        Assert.assertNotNull((Object)variable);
        Assert.assertEquals((Object)2, (Object)variable.getValue());
        Assert.assertEquals((Object)execution.getId(), (Object)variable.getExecutionId());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/iomapping/InputOutputTest.testInputExternalDeploymentScriptValueAsBean.bpmn", "org/camunda/bpm/engine/test/bpmn/iomapping/oneplusone.groovy"})
    @Test
    public void testInputExternalDeploymentScriptValueAsBean() {
        HashMap<String, OnePlusOneBean> variables = new HashMap<String, OnePlusOneBean>();
        variables.put("onePlusOneBean", new OnePlusOneBean());
        this.runtimeService.startProcessInstanceByKey("testProcess", variables);
        Execution execution = (Execution)this.runtimeService.createExecutionQuery().activityId("wait").singleResult();
        VariableInstance variable = (VariableInstance)this.runtimeService.createVariableInstanceQuery().variableName("var1").singleResult();
        Assert.assertNotNull((Object)variable);
        Assert.assertEquals((Object)2, (Object)variable.getValue());
        Assert.assertEquals((Object)execution.getId(), (Object)variable.getExecutionId());
    }

    @Deployment
    @Test
    public void testInputListElValues() {
        this.runtimeService.startProcessInstanceByKey("testProcess");
        VariableInstance variable = (VariableInstance)this.runtimeService.createVariableInstanceQuery().variableName("var1").singleResult();
        Assert.assertNotNull((Object)variable);
        List value = (List)variable.getValue();
        Assert.assertEquals((Object)2L, value.get(0));
        Assert.assertEquals((Object)3L, value.get(1));
        Assert.assertEquals((Object)4L, value.get(2));
    }

    @Deployment
    @Test
    public void testInputListMixedValues() {
        this.runtimeService.startProcessInstanceByKey("testProcess");
        VariableInstance variable = (VariableInstance)this.runtimeService.createVariableInstanceQuery().variableName("var1").singleResult();
        Assert.assertNotNull((Object)variable);
        List value = (List)variable.getValue();
        Assert.assertEquals((Object)"constantStringValue", value.get(0));
        Assert.assertEquals((Object)"elValue", value.get(1));
        Assert.assertEquals((Object)"scriptValue", value.get(2));
    }

    @Deployment
    @Test
    public void testInputMapElValues() {
        this.runtimeService.startProcessInstanceByKey("testProcess");
        VariableInstance variable = (VariableInstance)this.runtimeService.createVariableInstanceQuery().variableName("var1").singleResult();
        Assert.assertNotNull((Object)variable);
        TreeMap value = (TreeMap)variable.getValue();
        Assert.assertEquals((Object)2L, value.get("a"));
        Assert.assertEquals((Object)3L, value.get("b"));
        Assert.assertEquals((Object)4L, value.get("c"));
    }

    @Deployment
    @Test
    public void testInputMultipleElValue() {
        this.runtimeService.startProcessInstanceByKey("testProcess");
        Execution execution = (Execution)this.runtimeService.createExecutionQuery().activityId("wait").singleResult();
        VariableInstance var1 = (VariableInstance)this.runtimeService.createVariableInstanceQuery().variableName("var1").singleResult();
        Assert.assertNotNull((Object)var1);
        Assert.assertEquals((Object)2L, (Object)var1.getValue());
        Assert.assertEquals((Object)execution.getId(), (Object)var1.getExecutionId());
        VariableInstance var2 = (VariableInstance)this.runtimeService.createVariableInstanceQuery().variableName("var2").singleResult();
        Assert.assertNotNull((Object)var2);
        Assert.assertEquals((Object)3L, (Object)var2.getValue());
        Assert.assertEquals((Object)execution.getId(), (Object)var2.getExecutionId());
    }

    @Deployment
    @Test
    public void testInputMultipleMixedValue() {
        this.runtimeService.startProcessInstanceByKey("testProcess");
        Execution execution = (Execution)this.runtimeService.createExecutionQuery().activityId("wait").singleResult();
        VariableInstance var1 = (VariableInstance)this.runtimeService.createVariableInstanceQuery().variableName("var1").singleResult();
        Assert.assertNotNull((Object)var1);
        Assert.assertEquals((Object)2L, (Object)var1.getValue());
        Assert.assertEquals((Object)execution.getId(), (Object)var1.getExecutionId());
        VariableInstance var2 = (VariableInstance)this.runtimeService.createVariableInstanceQuery().variableName("var2").singleResult();
        Assert.assertNotNull((Object)var2);
        Assert.assertEquals((Object)"stringConstantValue", (Object)var2.getValue());
        Assert.assertEquals((Object)execution.getId(), (Object)var2.getExecutionId());
    }

    @Deployment
    @Test
    public void testInputNested() {
        HashMap<String, String> variables = new HashMap<String, String>();
        variables.put("exprKey", "b");
        this.runtimeService.startProcessInstanceByKey("testProcess", variables);
        Execution execution = (Execution)this.runtimeService.createExecutionQuery().activityId("wait").singleResult();
        VariableInstance var1 = (VariableInstance)this.runtimeService.createVariableInstanceQuery().variableName("var1").singleResult();
        TreeMap value = (TreeMap)var1.getValue();
        List nestedList = (List)value.get("a");
        Assert.assertEquals((Object)"stringInListNestedInMap", nestedList.get(0));
        Assert.assertEquals((Object)"b", nestedList.get(1));
        Assert.assertEquals((Object)"stringValueWithExprKey", value.get("b"));
        VariableInstance var2 = (VariableInstance)this.runtimeService.createVariableInstanceQuery().variableName("var2").singleResult();
        Assert.assertNotNull((Object)var2);
        Assert.assertEquals((Object)"stringConstantValue", (Object)var2.getValue());
        Assert.assertEquals((Object)execution.getId(), (Object)var2.getExecutionId());
    }

    @Deployment
    @Test
    public void testInputNestedListValues() {
        HashMap<String, String> variables = new HashMap<String, String>();
        variables.put("exprKey", "vegie");
        this.runtimeService.startProcessInstanceByKey("testProcess", variables);
        VariableInstance variable = (VariableInstance)this.runtimeService.createVariableInstanceQuery().variableName("var1").singleResult();
        Assert.assertNotNull((Object)variable);
        List value = (List)variable.getValue();
        Assert.assertEquals((Object)"constantStringValue", value.get(0));
        Assert.assertEquals((Object)"elValue", value.get(1));
        Assert.assertEquals((Object)"scriptValue", value.get(2));
        List nestedList = (List)value.get(3);
        List nestedNestedList = (List)nestedList.get(0);
        Assert.assertEquals((Object)"a", nestedNestedList.get(0));
        Assert.assertEquals((Object)"b", nestedNestedList.get(1));
        Assert.assertEquals((Object)"c", nestedNestedList.get(2));
        Assert.assertEquals((Object)"d", nestedList.get(1));
        TreeMap nestedMap = (TreeMap)value.get(4);
        Assert.assertEquals((Object)"bar", nestedMap.get("foo"));
        Assert.assertEquals((Object)"world", nestedMap.get("hello"));
        Assert.assertEquals((Object)"potato", nestedMap.get("vegie"));
    }

    @Deployment
    @Test
    public void testInputMapElKey() {
        HashMap<String, String> variables = new HashMap<String, String>();
        variables.put("varExpr1", "a");
        variables.put("varExpr2", "b");
        this.runtimeService.startProcessInstanceByKey("testProcess", variables);
        VariableInstance variable = (VariableInstance)this.runtimeService.createVariableInstanceQuery().variableName("var1").singleResult();
        Assert.assertNotNull((Object)variable);
        TreeMap value = (TreeMap)variable.getValue();
        Assert.assertEquals((Object)"potato", value.get("a"));
        Assert.assertEquals((Object)"tomato", value.get("b"));
    }

    @Deployment
    @Test
    public void testInputMapElMixedKey() {
        HashMap<String, String> variables = new HashMap<String, String>();
        variables.put("varExpr1", "a");
        variables.put("varExpr2", "b");
        variables.put("varExprMapValue", "avocado");
        this.runtimeService.startProcessInstanceByKey("testProcess", variables);
        VariableInstance variable = (VariableInstance)this.runtimeService.createVariableInstanceQuery().variableName("var1").singleResult();
        Assert.assertNotNull((Object)variable);
        TreeMap value = (TreeMap)variable.getValue();
        Assert.assertEquals((Object)"potato", value.get("a"));
        Assert.assertEquals((Object)"tomato", value.get("b"));
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/iomapping/InputOutputTest.testInputMapElKey.bpmn"})
    @Test
    public void testInputMapElUndefinedKey() {
        try {
            this.runtimeService.startProcessInstanceByKey("testProcess");
            Assert.fail((String)"Exception expected");
        }
        catch (ProcessEngineException e) {
            this.testRule.assertTextPresent("Unknown property used in expression: ${varExpr1}", e.getMessage());
        }
    }

    @Deployment
    @Test
    public void testOutputNullValue() {
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("testProcess");
        VariableInstance variable = (VariableInstance)this.runtimeService.createVariableInstanceQuery().variableName("var1").singleResult();
        Assert.assertNotNull((Object)variable);
        Assert.assertEquals((Object)"null", (Object)variable.getTypeName());
        Assert.assertEquals((Object)pi.getId(), (Object)variable.getExecutionId());
    }

    @Deployment
    @Test
    public void testOutputStringConstantValue() {
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("testProcess");
        VariableInstance variable = (VariableInstance)this.runtimeService.createVariableInstanceQuery().variableName("var1").singleResult();
        Assert.assertNotNull((Object)variable);
        Assert.assertEquals((Object)"stringValue", (Object)variable.getValue());
        Assert.assertEquals((Object)pi.getId(), (Object)variable.getExecutionId());
    }

    @Deployment
    @Test
    public void testOutputElValue() {
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("testProcess");
        VariableInstance variable = (VariableInstance)this.runtimeService.createVariableInstanceQuery().variableName("var1").singleResult();
        Assert.assertNotNull((Object)variable);
        Assert.assertEquals((Object)2L, (Object)variable.getValue());
        Assert.assertEquals((Object)pi.getId(), (Object)variable.getExecutionId());
    }

    @Deployment
    @Test
    public void testOutputScriptValue() {
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("testProcess");
        VariableInstance variable = (VariableInstance)this.runtimeService.createVariableInstanceQuery().variableName("var1").singleResult();
        Assert.assertNotNull((Object)variable);
        Assert.assertEquals((Object)2, (Object)variable.getValue());
        Assert.assertEquals((Object)pi.getId(), (Object)variable.getExecutionId());
    }

    @Deployment
    @Test
    public void testOutputScriptValueAsVariable() {
        HashMap<String, String> variables = new HashMap<String, String>();
        variables.put("scriptSource", "return 1 + 1");
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("testProcess", variables);
        VariableInstance variable = (VariableInstance)this.runtimeService.createVariableInstanceQuery().variableName("var1").singleResult();
        Assert.assertNotNull((Object)variable);
        Assert.assertEquals((Object)2, (Object)variable.getValue());
        Assert.assertEquals((Object)pi.getId(), (Object)variable.getExecutionId());
    }

    @Test
    public void testOutputParameterAvailableAfterParallelGateway() {
        BpmnModelInstance processDefinition = ((ServiceTaskBuilder)((ServiceTaskBuilder)((ServiceTaskBuilder)Bpmn.createExecutableProcess((String)"process").startEvent().serviceTask().camundaOutputParameter("variable", "A")).camundaExpression("${'this value does not matter'}")).parallelGateway("fork").endEvent().moveToNode("fork").serviceTask().camundaExpression("${variable}")).receiveTask().endEvent().done();
        this.testRule.deploy(processDefinition);
        this.runtimeService.startProcessInstanceByKey("process");
        VariableInstance variableInstance = (VariableInstance)this.runtimeService.createVariableInstanceQuery().variableName("variable").singleResult();
        Assert.assertNotNull((Object)variableInstance);
    }

    @Deployment
    @Test
    public void testOutputScriptValueAsBean() {
        HashMap<String, OnePlusOneBean> variables = new HashMap<String, OnePlusOneBean>();
        variables.put("onePlusOneBean", new OnePlusOneBean());
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("testProcess", variables);
        VariableInstance variable = (VariableInstance)this.runtimeService.createVariableInstanceQuery().variableName("var1").singleResult();
        Assert.assertNotNull((Object)variable);
        Assert.assertEquals((Object)2, (Object)variable.getValue());
        Assert.assertEquals((Object)pi.getId(), (Object)variable.getExecutionId());
    }

    @Deployment
    @Test
    public void testOutputExternalScriptValue() {
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("testProcess");
        VariableInstance variable = (VariableInstance)this.runtimeService.createVariableInstanceQuery().variableName("var1").singleResult();
        Assert.assertNotNull((Object)variable);
        Assert.assertEquals((Object)2, (Object)variable.getValue());
        Assert.assertEquals((Object)pi.getId(), (Object)variable.getExecutionId());
    }

    @Deployment
    @Test
    public void testOutputExternalScriptValueAsVariable() {
        HashMap<String, String> variables = new HashMap<String, String>();
        variables.put("scriptPath", "org/camunda/bpm/engine/test/bpmn/iomapping/oneplusone.groovy");
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("testProcess", variables);
        VariableInstance variable = (VariableInstance)this.runtimeService.createVariableInstanceQuery().variableName("var1").singleResult();
        Assert.assertNotNull((Object)variable);
        Assert.assertEquals((Object)2, (Object)variable.getValue());
        Assert.assertEquals((Object)pi.getId(), (Object)variable.getExecutionId());
    }

    @Deployment
    @Test
    public void testOutputExternalScriptValueAsBean() {
        HashMap<String, OnePlusOneBean> variables = new HashMap<String, OnePlusOneBean>();
        variables.put("onePlusOneBean", new OnePlusOneBean());
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("testProcess", variables);
        VariableInstance variable = (VariableInstance)this.runtimeService.createVariableInstanceQuery().variableName("var1").singleResult();
        Assert.assertNotNull((Object)variable);
        Assert.assertEquals((Object)2, (Object)variable.getValue());
        Assert.assertEquals((Object)pi.getId(), (Object)variable.getExecutionId());
    }

    @Deployment
    @Test
    public void testOutputExternalClasspathScriptValue() {
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("testProcess");
        VariableInstance variable = (VariableInstance)this.runtimeService.createVariableInstanceQuery().variableName("var1").singleResult();
        Assert.assertNotNull((Object)variable);
        Assert.assertEquals((Object)2, (Object)variable.getValue());
        Assert.assertEquals((Object)pi.getId(), (Object)variable.getExecutionId());
    }

    @Deployment
    @Test
    public void testOutputExternalClasspathScriptValueAsVariable() {
        HashMap<String, String> variables = new HashMap<String, String>();
        variables.put("scriptPath", "classpath://org/camunda/bpm/engine/test/bpmn/iomapping/oneplusone.groovy");
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("testProcess", variables);
        VariableInstance variable = (VariableInstance)this.runtimeService.createVariableInstanceQuery().variableName("var1").singleResult();
        Assert.assertNotNull((Object)variable);
        Assert.assertEquals((Object)2, (Object)variable.getValue());
        Assert.assertEquals((Object)pi.getId(), (Object)variable.getExecutionId());
    }

    @Deployment
    @Test
    public void testOutputExternalClasspathScriptValueAsBean() {
        HashMap<String, OnePlusOneBean> variables = new HashMap<String, OnePlusOneBean>();
        variables.put("onePlusOneBean", new OnePlusOneBean());
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("testProcess", variables);
        VariableInstance variable = (VariableInstance)this.runtimeService.createVariableInstanceQuery().variableName("var1").singleResult();
        Assert.assertNotNull((Object)variable);
        Assert.assertEquals((Object)2, (Object)variable.getValue());
        Assert.assertEquals((Object)pi.getId(), (Object)variable.getExecutionId());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/iomapping/InputOutputTest.testOutputExternalDeploymentScriptValue.bpmn", "org/camunda/bpm/engine/test/bpmn/iomapping/oneplusone.groovy"})
    @Test
    public void testOutputExternalDeploymentScriptValue() {
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("testProcess");
        VariableInstance variable = (VariableInstance)this.runtimeService.createVariableInstanceQuery().variableName("var1").singleResult();
        Assert.assertNotNull((Object)variable);
        Assert.assertEquals((Object)2, (Object)variable.getValue());
        Assert.assertEquals((Object)pi.getId(), (Object)variable.getExecutionId());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/iomapping/InputOutputTest.testOutputExternalDeploymentScriptValueAsVariable.bpmn", "org/camunda/bpm/engine/test/bpmn/iomapping/oneplusone.groovy"})
    @Test
    public void testOutputExternalDeploymentScriptValueAsVariable() {
        HashMap<String, String> variables = new HashMap<String, String>();
        variables.put("scriptPath", "deployment://org/camunda/bpm/engine/test/bpmn/iomapping/oneplusone.groovy");
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("testProcess", variables);
        VariableInstance variable = (VariableInstance)this.runtimeService.createVariableInstanceQuery().variableName("var1").singleResult();
        Assert.assertNotNull((Object)variable);
        Assert.assertEquals((Object)2, (Object)variable.getValue());
        Assert.assertEquals((Object)pi.getId(), (Object)variable.getExecutionId());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/iomapping/InputOutputTest.testOutputExternalDeploymentScriptValueAsBean.bpmn", "org/camunda/bpm/engine/test/bpmn/iomapping/oneplusone.groovy"})
    @Test
    public void testOutputExternalDeploymentScriptValueAsBean() {
        HashMap<String, OnePlusOneBean> variables = new HashMap<String, OnePlusOneBean>();
        variables.put("onePlusOneBean", new OnePlusOneBean());
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("testProcess", variables);
        VariableInstance variable = (VariableInstance)this.runtimeService.createVariableInstanceQuery().variableName("var1").singleResult();
        Assert.assertNotNull((Object)variable);
        Assert.assertEquals((Object)2, (Object)variable.getValue());
        Assert.assertEquals((Object)pi.getId(), (Object)variable.getExecutionId());
    }

    @Deployment
    @Test
    public void testOutputListElValues() {
        this.runtimeService.startProcessInstanceByKey("testProcess");
        VariableInstance variable = (VariableInstance)this.runtimeService.createVariableInstanceQuery().variableName("var1").singleResult();
        Assert.assertNotNull((Object)variable);
        List value = (List)variable.getValue();
        Assert.assertEquals((Object)2L, value.get(0));
        Assert.assertEquals((Object)3L, value.get(1));
        Assert.assertEquals((Object)4L, value.get(2));
    }

    @Deployment
    @Test
    public void testOutputListMixedValues() {
        this.runtimeService.startProcessInstanceByKey("testProcess");
        VariableInstance variable = (VariableInstance)this.runtimeService.createVariableInstanceQuery().variableName("var1").singleResult();
        Assert.assertNotNull((Object)variable);
        List value = (List)variable.getValue();
        Assert.assertEquals((Object)"constantStringValue", value.get(0));
        Assert.assertEquals((Object)"elValue", value.get(1));
        Assert.assertEquals((Object)"scriptValue", value.get(2));
    }

    @Deployment
    @Test
    public void testOutputMapElValues() {
        this.runtimeService.startProcessInstanceByKey("testProcess");
        VariableInstance variable = (VariableInstance)this.runtimeService.createVariableInstanceQuery().variableName("var1").singleResult();
        Assert.assertNotNull((Object)variable);
        TreeMap value = (TreeMap)variable.getValue();
        Assert.assertEquals((Object)2L, value.get("a"));
        Assert.assertEquals((Object)3L, value.get("b"));
        Assert.assertEquals((Object)4L, value.get("c"));
    }

    @Deployment
    @Test
    public void testOutputMultipleElValue() {
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("testProcess");
        VariableInstance var1 = (VariableInstance)this.runtimeService.createVariableInstanceQuery().variableName("var1").singleResult();
        Assert.assertNotNull((Object)var1);
        Assert.assertEquals((Object)2L, (Object)var1.getValue());
        Assert.assertEquals((Object)pi.getId(), (Object)var1.getExecutionId());
        VariableInstance var2 = (VariableInstance)this.runtimeService.createVariableInstanceQuery().variableName("var2").singleResult();
        Assert.assertNotNull((Object)var2);
        Assert.assertEquals((Object)3L, (Object)var2.getValue());
        Assert.assertEquals((Object)pi.getId(), (Object)var2.getExecutionId());
    }

    @Deployment
    @Test
    public void testOutputMultipleMixedValue() {
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("testProcess");
        VariableInstance var1 = (VariableInstance)this.runtimeService.createVariableInstanceQuery().variableName("var1").singleResult();
        Assert.assertNotNull((Object)var1);
        Assert.assertEquals((Object)2L, (Object)var1.getValue());
        Assert.assertEquals((Object)pi.getId(), (Object)var1.getExecutionId());
        VariableInstance var2 = (VariableInstance)this.runtimeService.createVariableInstanceQuery().variableName("var2").singleResult();
        Assert.assertNotNull((Object)var2);
        Assert.assertEquals((Object)"stringConstantValue", (Object)var2.getValue());
        Assert.assertEquals((Object)pi.getId(), (Object)var2.getExecutionId());
    }

    @Deployment
    @Test
    public void testOutputNested() {
        HashMap<String, String> variables = new HashMap<String, String>();
        variables.put("exprKey", "b");
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("testProcess", variables);
        VariableInstance var1 = (VariableInstance)this.runtimeService.createVariableInstanceQuery().variableName("var1").singleResult();
        TreeMap value = (TreeMap)var1.getValue();
        List nestedList = (List)value.get("a");
        Assert.assertEquals((Object)"stringInListNestedInMap", nestedList.get(0));
        Assert.assertEquals((Object)"b", nestedList.get(1));
        Assert.assertEquals((Object)pi.getId(), (Object)var1.getExecutionId());
        Assert.assertEquals((Object)"stringValueWithExprKey", value.get("b"));
        VariableInstance var2 = (VariableInstance)this.runtimeService.createVariableInstanceQuery().variableName("var2").singleResult();
        Assert.assertNotNull((Object)var2);
        Assert.assertEquals((Object)"stringConstantValue", (Object)var2.getValue());
        Assert.assertEquals((Object)pi.getId(), (Object)var2.getExecutionId());
    }

    @Deployment
    @Test
    public void testOutputListNestedValues() {
        HashMap<String, String> variables = new HashMap<String, String>();
        variables.put("exprKey", "vegie");
        this.runtimeService.startProcessInstanceByKey("testProcess", variables);
        VariableInstance variable = (VariableInstance)this.runtimeService.createVariableInstanceQuery().variableName("var1").singleResult();
        Assert.assertNotNull((Object)variable);
        List value = (List)variable.getValue();
        Assert.assertEquals((Object)"constantStringValue", value.get(0));
        Assert.assertEquals((Object)"elValue", value.get(1));
        Assert.assertEquals((Object)"scriptValue", value.get(2));
        List nestedList = (List)value.get(3);
        List nestedNestedList = (List)nestedList.get(0);
        Assert.assertEquals((Object)"a", nestedNestedList.get(0));
        Assert.assertEquals((Object)"b", nestedNestedList.get(1));
        Assert.assertEquals((Object)"c", nestedNestedList.get(2));
        Assert.assertEquals((Object)"d", nestedList.get(1));
        TreeMap nestedMap = (TreeMap)value.get(4);
        Assert.assertEquals((Object)"bar", nestedMap.get("foo"));
        Assert.assertEquals((Object)"world", nestedMap.get("hello"));
        Assert.assertEquals((Object)"potato", nestedMap.get("vegie"));
    }

    @Deployment
    @Test
    public void testOutputMapElKey() {
        HashMap<String, String> variables = new HashMap<String, String>();
        variables.put("varExpr1", "a");
        variables.put("varExpr2", "b");
        this.runtimeService.startProcessInstanceByKey("testProcess", variables);
        VariableInstance variable = (VariableInstance)this.runtimeService.createVariableInstanceQuery().variableName("var1").singleResult();
        Assert.assertNotNull((Object)variable);
        TreeMap value = (TreeMap)variable.getValue();
        Assert.assertEquals((Object)"potato", value.get("a"));
        Assert.assertEquals((Object)"tomato", value.get("b"));
    }

    @Deployment
    @Test
    public void testOutputMapElMixedKey() {
        HashMap<String, String> variables = new HashMap<String, String>();
        variables.put("varExpr1", "a");
        variables.put("varExpr2", "b");
        this.runtimeService.startProcessInstanceByKey("testProcess", variables);
        VariableInstance variable = (VariableInstance)this.runtimeService.createVariableInstanceQuery().variableName("var1").singleResult();
        Assert.assertNotNull((Object)variable);
        TreeMap value = (TreeMap)variable.getValue();
        Assert.assertEquals((Object)"potato", value.get("a"));
        Assert.assertEquals((Object)"tomato", value.get("b"));
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/iomapping/InputOutputTest.testOutputMapElKey.bpmn"})
    @Test
    public void testOutputMapElUndefinedKey() {
        try {
            this.runtimeService.startProcessInstanceByKey("testProcess");
            Assert.fail((String)"Exception expected");
        }
        catch (ProcessEngineException e) {
            this.testRule.assertTextPresent("Unknown property used in expression: ${varExpr1}", e.getMessage());
        }
    }

    @Test
    public void testInterruptingEventSubprocessIoSupport() {
        try {
            this.repositoryService.createDeployment().addClasspathResource("org/camunda/bpm/engine/test/bpmn/iomapping/InputOutputTest.testInterruptingEventSubprocessIoSupport.bpmn").deploy();
            Assert.fail((String)"exception expected");
        }
        catch (ParseException e) {
            this.testRule.assertTextPresent("camunda:inputOutput mapping unsupported for element type 'subProcess' with attribute 'triggeredByEvent = true'", e.getMessage());
            Assertions.assertThat((String)((Problem)((ResourceReport)e.getResorceReports().get(0)).getErrors().get(0)).getMainElementId()).isEqualTo((Object)"SubProcess_1");
        }
    }

    @Deployment
    @Test
    public void testSubprocessIoSupport() {
        HashMap<String, String> variables = new HashMap<String, String>();
        variables.put("processVar", "value");
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("testProcess", variables);
        Execution subprocessExecution = (Execution)this.runtimeService.createExecutionQuery().activityId("subprocessTask").singleResult();
        Map variablesLocal = this.runtimeService.getVariablesLocal(subprocessExecution.getId());
        Assert.assertEquals((long)1L, (long)variablesLocal.size());
        Assert.assertEquals((Object)"value", variablesLocal.get("innerVar"));
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        this.taskService.complete(task.getId());
        String outerVariable = (String)this.runtimeService.getVariableLocal(processInstance.getId(), "outerVar");
        Assert.assertNotNull((Object)outerVariable);
        Assert.assertEquals((Object)"value", (Object)outerVariable);
    }

    @Deployment
    @Test
    public void testSequentialMIActivityIoSupport() {
        HashMap<String, Number> variables = new HashMap<String, Number>();
        variables.put("counter", new AtomicInteger());
        variables.put("nrOfLoops", 2);
        ProcessInstance instance = this.runtimeService.startProcessInstanceByKey("miSequentialActivity", variables);
        Execution miExecution = (Execution)this.runtimeService.createExecutionQuery().activityId("miTask").singleResult();
        Assert.assertNotNull((Object)miExecution);
        Assert.assertFalse((boolean)instance.getId().equals(miExecution.getId()));
        Assert.assertEquals((Object)0, (Object)this.runtimeService.getVariable(miExecution.getId(), "loopCounter"));
        Assert.assertEquals((long)1L, (long)this.runtimeService.createVariableInstanceQuery().variableName("miCounterValue").count());
        Assert.assertEquals((Object)1, (Object)this.runtimeService.getVariableLocal(miExecution.getId(), "miCounterValue"));
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        this.taskService.complete(task.getId());
        miExecution = (Execution)this.runtimeService.createExecutionQuery().activityId("miTask").singleResult();
        Assert.assertNotNull((Object)miExecution);
        Assert.assertFalse((boolean)instance.getId().equals(miExecution.getId()));
        Assert.assertEquals((Object)1, (Object)this.runtimeService.getVariable(miExecution.getId(), "loopCounter"));
        Assert.assertEquals((long)1L, (long)this.runtimeService.createVariableInstanceQuery().variableName("miCounterValue").count());
        Assert.assertEquals((Object)2, (Object)this.runtimeService.getVariableLocal(miExecution.getId(), "miCounterValue"));
        task = (Task)this.taskService.createTaskQuery().singleResult();
        this.taskService.complete(task.getId());
        Assert.assertEquals((long)0L, (long)this.runtimeService.createVariableInstanceQuery().variableName("miCounterValue").count());
    }

    @Deployment
    @Test
    public void testSequentialMISubprocessIoSupport() {
        HashMap<String, Number> variables = new HashMap<String, Number>();
        variables.put("counter", new AtomicInteger());
        variables.put("nrOfLoops", 2);
        ProcessInstance instance = this.runtimeService.startProcessInstanceByKey("miSequentialSubprocess", variables);
        Execution miScopeExecution = (Execution)this.runtimeService.createExecutionQuery().activityId("task").singleResult();
        Assert.assertNotNull((Object)miScopeExecution);
        Assert.assertEquals((Object)0, (Object)this.runtimeService.getVariable(miScopeExecution.getId(), "loopCounter"));
        Assert.assertEquals((long)1L, (long)this.runtimeService.createVariableInstanceQuery().variableName("miCounterValue").count());
        Assert.assertEquals((Object)1, (Object)this.runtimeService.getVariableLocal(miScopeExecution.getId(), "miCounterValue"));
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        this.taskService.complete(task.getId());
        miScopeExecution = (Execution)this.runtimeService.createExecutionQuery().activityId("task").singleResult();
        Assert.assertNotNull((Object)miScopeExecution);
        Assert.assertFalse((boolean)instance.getId().equals(miScopeExecution.getId()));
        Assert.assertEquals((Object)1, (Object)this.runtimeService.getVariable(miScopeExecution.getId(), "loopCounter"));
        Assert.assertEquals((long)1L, (long)this.runtimeService.createVariableInstanceQuery().variableName("miCounterValue").count());
        Assert.assertEquals((Object)2, (Object)this.runtimeService.getVariableLocal(miScopeExecution.getId(), "miCounterValue"));
        task = (Task)this.taskService.createTaskQuery().singleResult();
        this.taskService.complete(task.getId());
        Assert.assertEquals((long)0L, (long)this.runtimeService.createVariableInstanceQuery().variableName("miCounterValue").count());
    }

    @Deployment
    @Test
    public void testParallelMIActivityIoSupport() {
        HashMap<String, Number> variables = new HashMap<String, Number>();
        variables.put("counter", new AtomicInteger());
        variables.put("nrOfLoops", 2);
        ProcessInstance instance = this.runtimeService.startProcessInstanceByKey("miParallelActivity", variables);
        HashSet<Integer> counters = new HashSet<Integer>();
        Execution miExecution1 = (Execution)this.runtimeService.createExecutionQuery().activityId("miTask").variableValueEquals("loopCounter", (Object)0).singleResult();
        Assert.assertNotNull((Object)miExecution1);
        Assert.assertFalse((boolean)instance.getId().equals(miExecution1.getId()));
        counters.add((Integer)this.runtimeService.getVariableLocal(miExecution1.getId(), "miCounterValue"));
        Execution miExecution2 = (Execution)this.runtimeService.createExecutionQuery().activityId("miTask").variableValueEquals("loopCounter", (Object)1).singleResult();
        Assert.assertNotNull((Object)miExecution2);
        Assert.assertFalse((boolean)instance.getId().equals(miExecution2.getId()));
        counters.add((Integer)this.runtimeService.getVariableLocal(miExecution2.getId(), "miCounterValue"));
        Assert.assertTrue((boolean)counters.contains(1));
        Assert.assertTrue((boolean)counters.contains(2));
        Assert.assertEquals((long)2L, (long)this.runtimeService.createVariableInstanceQuery().variableName("miCounterValue").count());
        for (Task task : this.taskService.createTaskQuery().list()) {
            this.taskService.complete(task.getId());
        }
        Assert.assertEquals((long)0L, (long)this.runtimeService.createVariableInstanceQuery().variableName("miCounterValue").count());
    }

    @Deployment
    @Test
    public void testParallelMISubprocessIoSupport() {
        HashMap<String, Number> variables = new HashMap<String, Number>();
        variables.put("counter", new AtomicInteger());
        variables.put("nrOfLoops", 2);
        ProcessInstance instance = this.runtimeService.startProcessInstanceByKey("miParallelSubprocess", variables);
        HashSet<Integer> counters = new HashSet<Integer>();
        Execution miScopeExecution1 = (Execution)this.runtimeService.createExecutionQuery().activityId("task").variableValueEquals("loopCounter", (Object)0).singleResult();
        Assert.assertNotNull((Object)miScopeExecution1);
        counters.add((Integer)this.runtimeService.getVariableLocal(miScopeExecution1.getId(), "miCounterValue"));
        Execution miScopeExecution2 = (Execution)this.runtimeService.createExecutionQuery().activityId("task").variableValueEquals("loopCounter", (Object)1).singleResult();
        Assert.assertNotNull((Object)miScopeExecution2);
        Assert.assertFalse((boolean)instance.getId().equals(miScopeExecution2.getId()));
        counters.add((Integer)this.runtimeService.getVariableLocal(miScopeExecution2.getId(), "miCounterValue"));
        Assert.assertTrue((boolean)counters.contains(1));
        Assert.assertTrue((boolean)counters.contains(2));
        Assert.assertEquals((long)2L, (long)this.runtimeService.createVariableInstanceQuery().variableName("miCounterValue").count());
        for (Task task : this.taskService.createTaskQuery().list()) {
            this.taskService.complete(task.getId());
        }
        Assert.assertEquals((long)0L, (long)this.runtimeService.createVariableInstanceQuery().variableName("miCounterValue").count());
    }

    @Test
    public void testMIOutputMappingDisallowed() {
        try {
            this.repositoryService.createDeployment().addClasspathResource("org/camunda/bpm/engine/test/bpmn/iomapping/InputOutputTest.testMIOutputMappingDisallowed.bpmn20.xml").deploy();
            Assert.fail((String)"Exception expected");
        }
        catch (ParseException e) {
            this.testRule.assertTextPresent("camunda:outputParameter not allowed for multi-instance constructs", e.getMessage());
            Assertions.assertThat((String)((Problem)((ResourceReport)e.getResorceReports().get(0)).getErrors().get(0)).getMainElementId()).isEqualTo((Object)"miTask");
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/iomapping/InputOutputTest.testThrowErrorInScriptInputOutputMapping.bpmn"})
    @Ignore
    @Test
    public void testBpmnErrorInScriptInputMapping() {
        HashMap<String, String> variables = new HashMap<String, String>();
        variables.put("throwInMapping", "in");
        variables.put("exception", (String)new BpmnError("error"));
        this.runtimeService.startProcessInstanceByKey("testProcess", variables);
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        Assert.assertThat((Object)task.getName(), (Matcher)CoreMatchers.is((Object)"User Task"));
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/iomapping/InputOutputTest.testThrowErrorInScriptInputOutputMapping.bpmn"})
    @Test
    public void testExceptionInScriptInputMapping() {
        String exceptionMessage = "myException";
        HashMap<String, Object> variables = new HashMap<String, Object>();
        variables.put("throwInMapping", "in");
        variables.put("exception", new RuntimeException(exceptionMessage));
        try {
            this.runtimeService.startProcessInstanceByKey("testProcess", variables);
        }
        catch (RuntimeException re) {
            Assert.assertThat((Object)re.getMessage(), (Matcher)CoreMatchers.containsString((String)exceptionMessage));
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/iomapping/InputOutputTest.testThrowErrorInScriptInputOutputMapping.bpmn"})
    @Ignore
    @Test
    public void testBpmnErrorInScriptOutputMapping() {
        HashMap<String, String> variables = new HashMap<String, String>();
        variables.put("throwInMapping", "out");
        variables.put("exception", (String)new BpmnError("error"));
        this.runtimeService.startProcessInstanceByKey("testProcess", variables);
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        Assert.assertThat((Object)task.getName(), (Matcher)CoreMatchers.is((Object)"User Task"));
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/iomapping/InputOutputTest.testThrowErrorInScriptInputOutputMapping.bpmn"})
    @Test
    public void testExceptionInScriptOutputMapping() {
        String exceptionMessage = "myException";
        HashMap<String, Object> variables = new HashMap<String, Object>();
        variables.put("throwInMapping", "out");
        variables.put("exception", new RuntimeException(exceptionMessage));
        try {
            this.runtimeService.startProcessInstanceByKey("testProcess", variables);
        }
        catch (RuntimeException re) {
            Assert.assertThat((Object)re.getMessage(), (Matcher)CoreMatchers.containsString((String)exceptionMessage));
        }
    }

    @Deployment
    @Ignore
    @Test
    public void testOutputMappingOnErrorBoundaryEvent() {
        this.runtimeService.startProcessInstanceByKey("testProcess");
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        Assert.assertNotNull((Object)task);
        Assert.assertEquals((Object)"taskOk", (Object)task.getTaskDefinitionKey());
        Assert.assertEquals((long)0L, (long)this.runtimeService.createVariableInstanceQuery().variableName("localNotMapped").count());
        Assert.assertEquals((long)0L, (long)this.runtimeService.createVariableInstanceQuery().variableName("localMapped").count());
        Assert.assertEquals((long)1L, (long)this.runtimeService.createVariableInstanceQuery().variableName("mapped").count());
        this.taskService.complete(task.getId());
        Assert.assertEquals((long)0L, (long)this.runtimeService.createProcessInstanceQuery().count());
        this.runtimeService.startProcessInstanceByKey("testProcess", Collections.singletonMap("throwError", true));
        task = (Task)this.taskService.createTaskQuery().singleResult();
        Assert.assertNotNull((Object)task);
        Assert.assertEquals((Object)"taskError", (Object)task.getTaskDefinitionKey());
        Assert.assertEquals((long)0L, (long)this.runtimeService.createVariableInstanceQuery().variableName("localNotMapped").count());
        Assert.assertEquals((long)0L, (long)this.runtimeService.createVariableInstanceQuery().variableName("localMapped").count());
        Assert.assertEquals((long)0L, (long)this.runtimeService.createVariableInstanceQuery().variableName("mapped").count());
        this.taskService.complete(task.getId());
        Assert.assertEquals((long)0L, (long)this.runtimeService.createProcessInstanceQuery().count());
    }

    @Deployment
    @Ignore
    @Test
    public void testOutputMappingOnMessageBoundaryEvent() {
        this.runtimeService.startProcessInstanceByKey("testProcess");
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        Assert.assertNotNull((Object)task);
        Assert.assertEquals((Object)"wait", (Object)task.getTaskDefinitionKey());
        this.taskService.complete(task.getId());
        task = (Task)this.taskService.createTaskQuery().singleResult();
        Assert.assertNotNull((Object)task);
        Assert.assertEquals((Object)"taskOk", (Object)task.getTaskDefinitionKey());
        Assert.assertEquals((long)1L, (long)this.runtimeService.createVariableInstanceQuery().variableName("mapped").count());
        this.taskService.complete(task.getId());
        Assert.assertEquals((long)0L, (long)this.runtimeService.createProcessInstanceQuery().count());
        this.runtimeService.startProcessInstanceByKey("testProcess", Collections.singletonMap("throwError", true));
        task = (Task)this.taskService.createTaskQuery().singleResult();
        Assert.assertNotNull((Object)task);
        Assert.assertEquals((Object)"wait", (Object)task.getTaskDefinitionKey());
        this.runtimeService.correlateMessage("message");
        task = (Task)this.taskService.createTaskQuery().singleResult();
        Assert.assertNotNull((Object)task);
        Assert.assertEquals((Object)"taskError", (Object)task.getTaskDefinitionKey());
        Assert.assertEquals((long)0L, (long)this.runtimeService.createVariableInstanceQuery().variableName("mapped").count());
        this.taskService.complete(task.getId());
        Assert.assertEquals((long)0L, (long)this.runtimeService.createProcessInstanceQuery().count());
    }

    @Deployment
    @Ignore
    @Test
    public void testOutputMappingOnTimerBoundaryEvent() {
        this.runtimeService.startProcessInstanceByKey("testProcess");
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        Assert.assertNotNull((Object)task);
        Assert.assertEquals((Object)"wait", (Object)task.getTaskDefinitionKey());
        this.taskService.complete(task.getId());
        task = (Task)this.taskService.createTaskQuery().singleResult();
        Assert.assertNotNull((Object)task);
        Assert.assertEquals((Object)"taskOk", (Object)task.getTaskDefinitionKey());
        Assert.assertEquals((long)1L, (long)this.runtimeService.createVariableInstanceQuery().variableName("mapped").count());
        this.taskService.complete(task.getId());
        Assert.assertEquals((long)0L, (long)this.runtimeService.createProcessInstanceQuery().count());
        this.runtimeService.startProcessInstanceByKey("testProcess", Collections.singletonMap("throwError", true));
        task = (Task)this.taskService.createTaskQuery().singleResult();
        Assert.assertNotNull((Object)task);
        Assert.assertEquals((Object)"wait", (Object)task.getTaskDefinitionKey());
        Job job = (Job)this.managementService.createJobQuery().singleResult();
        Assert.assertNotNull((Object)job);
        this.managementService.executeJob(job.getId());
        task = (Task)this.taskService.createTaskQuery().singleResult();
        Assert.assertNotNull((Object)task);
        Assert.assertEquals((Object)"taskError", (Object)task.getTaskDefinitionKey());
        Assert.assertEquals((long)0L, (long)this.runtimeService.createVariableInstanceQuery().variableName("mapped").count());
        this.taskService.complete(task.getId());
        Assert.assertEquals((long)0L, (long)this.runtimeService.createProcessInstanceQuery().count());
    }

    @Deployment
    @Test
    public void testScopeActivityInstanceId() {
        String processInstanceId = this.runtimeService.startProcessInstanceByKey("process").getId();
        ActivityInstance tree = this.runtimeService.getActivityInstance(processInstanceId);
        ActivityInstance theTaskInstance = tree.getActivityInstances("theTask")[0];
        VariableInstance variableInstance = (VariableInstance)this.runtimeService.createVariableInstanceQuery().singleResult();
        Assert.assertEquals((Object)theTaskInstance.getId(), (Object)variableInstance.getActivityInstanceId());
    }

    @Test
    public void testCompositeExpressionForInputValue() {
        BpmnModelInstance instance = ((ReceiveTaskBuilder)Bpmn.createExecutableProcess((String)"Process").startEvent().receiveTask().camundaInputParameter("var", "Hello World${'!'}")).endEvent("end").done();
        this.testRule.deploy(instance);
        this.runtimeService.startProcessInstanceByKey("Process");
        VariableInstance variableInstance = (VariableInstance)this.runtimeService.createVariableInstanceQuery().variableName("var").singleResult();
        Assert.assertEquals((Object)"Hello World!", (Object)variableInstance.getValue());
    }

    @Test
    public void testCompositeExpressionForOutputValue() {
        BpmnModelInstance instance = ((ServiceTaskBuilder)((ServiceTaskBuilder)((ServiceTaskBuilder)Bpmn.createExecutableProcess((String)"Process").startEvent().serviceTask().camundaExpression("${true}")).camundaInputParameter("var1", "World!")).camundaOutputParameter("var2", "Hello ${var1}")).userTask().endEvent("end").done();
        this.testRule.deploy(instance);
        this.runtimeService.startProcessInstanceByKey("Process");
        VariableInstance variableInstance = (VariableInstance)this.runtimeService.createVariableInstanceQuery().variableName("var2").singleResult();
        Assert.assertEquals((Object)"Hello World!", (Object)variableInstance.getValue());
    }

    @Deployment
    @Test
    public void testOutputPlainTask() {
        HashMap<String, String> variables = new HashMap<String, String>();
        variables.put("foo", "bar");
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("process", variables);
        VariableInstance variable = (VariableInstance)this.runtimeService.createVariableInstanceQuery().variableName("var").singleResult();
        Assert.assertNotNull((Object)variable);
        Assert.assertEquals((Object)"baroque", (Object)variable.getValue());
        Assert.assertEquals((Object)pi.getId(), (Object)variable.getExecutionId());
    }
}

