/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.bpmn.servicetask;

import java.util.HashMap;
import org.camunda.bpm.engine.ClassLoadingException;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.impl.util.CollectionUtil;
import org.camunda.bpm.engine.runtime.Execution;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.task.Task;
import org.camunda.bpm.engine.test.Deployment;
import org.camunda.bpm.engine.test.bpmn.servicetask.util.GenderBean;
import org.camunda.bpm.engine.test.util.PluggableProcessEngineTest;
import org.junit.Assert;
import org.junit.Test;

public class JavaServiceTaskTest
extends PluggableProcessEngineTest {
    @Deployment
    @Test
    public void testJavaServiceDelegation() {
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("javaServiceDelegation", CollectionUtil.singletonMap((String)"input", (Object)"Activiti BPM Engine"));
        Execution execution = (Execution)this.runtimeService.createExecutionQuery().processInstanceId(pi.getId()).activityId("waitState").singleResult();
        Assert.assertEquals((Object)"ACTIVITI BPM ENGINE", (Object)this.runtimeService.getVariable(execution.getId(), "input"));
    }

    @Deployment
    @Test
    public void testFieldInjection() {
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("fieldInjection");
        Execution execution = (Execution)this.runtimeService.createExecutionQuery().processInstanceId(pi.getId()).activityId("waitState").singleResult();
        Assert.assertEquals((Object)"HELLO WORLD", (Object)this.runtimeService.getVariable(execution.getId(), "var"));
        Assert.assertEquals((Object)"HELLO SETTER", (Object)this.runtimeService.getVariable(execution.getId(), "setterVar"));
    }

    @Deployment
    @Test
    public void testExpressionFieldInjection() {
        HashMap<String, Object> vars = new HashMap<String, Object>();
        vars.put("name", "kermit");
        vars.put("gender", "male");
        vars.put("genderBean", new GenderBean());
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("expressionFieldInjection", vars);
        Execution execution = (Execution)this.runtimeService.createExecutionQuery().processInstanceId(pi.getId()).activityId("waitState").singleResult();
        Assert.assertEquals((Object)"timrek .rM olleH", (Object)this.runtimeService.getVariable(execution.getId(), "var2"));
        Assert.assertEquals((Object)"elam :si redneg ruoY", (Object)this.runtimeService.getVariable(execution.getId(), "var1"));
    }

    @Deployment
    @Test
    public void testUnexistingClassDelegation() {
        try {
            this.runtimeService.startProcessInstanceByKey("unexistingClassDelegation");
            Assert.fail();
        }
        catch (ProcessEngineException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("Exception while instantiating class 'org.camunda.bpm.engine.test.BogusClass'"));
            Assert.assertNotNull((Object)e.getCause());
            Assert.assertTrue((boolean)(e.getCause() instanceof ClassLoadingException));
        }
    }

    @Test
    public void testIllegalUseOfResultVariableName() {
        try {
            this.repositoryService.createDeployment().addClasspathResource("org/camunda/bpm/engine/test/bpmn/servicetask/JavaServiceTaskTest.testIllegalUseOfResultVariableName.bpmn20.xml").deploy();
            Assert.fail();
        }
        catch (ProcessEngineException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("resultVariable"));
        }
    }

    @Deployment
    @Test
    public void testExceptionHandling() {
        HashMap<String, String> vars = new HashMap<String, String>();
        vars.put("var", "no-exception");
        this.runtimeService.startProcessInstanceByKey("exceptionHandling", vars);
        Assert.assertEquals((long)0L, (long)this.runtimeService.createProcessInstanceQuery().count());
        vars.put("var", "throw-exception");
        this.runtimeService.startProcessInstanceByKey("exceptionHandling", vars);
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        Assert.assertEquals((Object)"Fix Exception", (Object)task.getName());
    }

    @Deployment
    @Test
    public void testGetBusinessKeyFromDelegateExecution() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("businessKeyProcess", "1234567890");
        Assert.assertEquals((long)1L, (long)this.runtimeService.createProcessInstanceQuery().processDefinitionKey("businessKeyProcess").count());
        String key = (String)this.runtimeService.getVariable(processInstance.getId(), "businessKeySetOnExecution");
        Assert.assertNotNull((Object)key);
        Assert.assertEquals((Object)"1234567890", (Object)key);
        String key2 = (String)this.runtimeService.getVariable(processInstance.getId(), "businessKeyAsProcessBusinessKey");
        Assert.assertEquals((Object)key2, (Object)key);
    }
}

