/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.bpmn.tasklistener;

import java.util.HashMap;
import org.camunda.bpm.engine.task.Task;
import org.camunda.bpm.engine.test.Deployment;
import org.camunda.bpm.engine.test.util.PluggableProcessEngineTest;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class CustomTaskAssignmentTest
extends PluggableProcessEngineTest {
    @Before
    public void setUp() throws Exception {
        this.identityService.saveUser(this.identityService.newUser("kermit"));
        this.identityService.saveUser(this.identityService.newUser("fozzie"));
        this.identityService.saveUser(this.identityService.newUser("gonzo"));
        this.identityService.saveGroup(this.identityService.newGroup("management"));
        this.identityService.createMembership("kermit", "management");
    }

    @After
    public void tearDown() throws Exception {
        this.identityService.deleteUser("kermit");
        this.identityService.deleteUser("fozzie");
        this.identityService.deleteUser("gonzo");
        this.identityService.deleteGroup("management");
    }

    @Deployment
    @Test
    public void testCandidateGroupAssignment() {
        this.runtimeService.startProcessInstanceByKey("customTaskAssignment");
        Assert.assertEquals((long)1L, (long)this.taskService.createTaskQuery().taskCandidateGroup("management").count());
        Assert.assertEquals((long)1L, (long)this.taskService.createTaskQuery().taskCandidateUser("kermit").count());
        Assert.assertEquals((long)0L, (long)this.taskService.createTaskQuery().taskCandidateUser("fozzie").count());
    }

    @Deployment
    @Test
    public void testCandidateUserAssignment() {
        this.runtimeService.startProcessInstanceByKey("customTaskAssignment");
        Assert.assertEquals((long)1L, (long)this.taskService.createTaskQuery().taskCandidateUser("kermit").count());
        Assert.assertEquals((long)1L, (long)this.taskService.createTaskQuery().taskCandidateUser("fozzie").count());
        Assert.assertEquals((long)0L, (long)this.taskService.createTaskQuery().taskCandidateUser("gonzo").count());
    }

    @Deployment
    @Test
    public void testAssigneeAssignment() {
        this.runtimeService.startProcessInstanceByKey("setAssigneeInListener");
        Assert.assertNotNull((Object)this.taskService.createTaskQuery().taskAssignee("kermit").singleResult());
        Assert.assertEquals((long)0L, (long)this.taskService.createTaskQuery().taskAssignee("fozzie").count());
        Assert.assertEquals((long)0L, (long)this.taskService.createTaskQuery().taskAssignee("gonzo").count());
    }

    @Deployment
    @Test
    public void testOverwriteExistingAssignments() {
        this.runtimeService.startProcessInstanceByKey("overrideAssigneeInListener");
        Assert.assertNotNull((Object)this.taskService.createTaskQuery().taskAssignee("kermit").singleResult());
        Assert.assertEquals((long)0L, (long)this.taskService.createTaskQuery().taskAssignee("fozzie").count());
        Assert.assertEquals((long)0L, (long)this.taskService.createTaskQuery().taskAssignee("gonzo").count());
    }

    @Deployment
    @Test
    public void testOverwriteExistingAssignmentsFromVariable() {
        HashMap<String, String> assigneeMappingTable = new HashMap<String, String>();
        assigneeMappingTable.put("fozzie", "gonzo");
        HashMap<String, HashMap<String, String>> variables = new HashMap<String, HashMap<String, String>>();
        variables.put("assigneeMappingTable", assigneeMappingTable);
        this.runtimeService.startProcessInstanceByKey("customTaskAssignment", variables);
        Assert.assertNotNull((Object)this.taskService.createTaskQuery().taskAssignee("gonzo").singleResult());
        Assert.assertEquals((long)0L, (long)this.taskService.createTaskQuery().taskAssignee("fozzie").count());
        Assert.assertEquals((long)0L, (long)this.taskService.createTaskQuery().taskAssignee("kermit").count());
    }

    @Deployment
    @Test
    public void testReleaseTask() throws Exception {
        this.runtimeService.startProcessInstanceByKey("releaseTaskProcess");
        Task task = (Task)this.taskService.createTaskQuery().taskAssignee("fozzie").singleResult();
        Assert.assertNotNull((Object)task);
        String taskId = task.getId();
        this.taskService.setAssignee(taskId, null);
        task = (Task)this.taskService.createTaskQuery().taskAssignee("fozzie").singleResult();
        Assert.assertNull((Object)task);
        task = (Task)this.taskService.createTaskQuery().taskId(taskId).singleResult();
        Assert.assertNotNull((Object)task);
        Assert.assertNull((Object)task.getAssignee());
    }
}

