/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.concurrency;

import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.camunda.bpm.engine.ProcessEngine;
import org.camunda.bpm.engine.ProcessEngineBootstrapCommand;
import org.camunda.bpm.engine.ProcessEngineConfiguration;
import org.camunda.bpm.engine.ProcessEngines;
import org.camunda.bpm.engine.impl.BootstrapEngineCommand;
import org.camunda.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.camunda.bpm.engine.impl.context.Context;
import org.camunda.bpm.engine.impl.interceptor.Command;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.interceptor.CommandInvocationContext;
import org.camunda.bpm.engine.impl.persistence.entity.JobEntity;
import org.camunda.bpm.engine.impl.util.ClockUtil;
import org.camunda.bpm.engine.runtime.Job;
import org.camunda.bpm.engine.test.concurrency.ConcurrencyTestCase;
import org.camunda.bpm.engine.test.concurrency.ConcurrencyTestHelper;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ConcurrentProcessEngineJobExecutorHistoryCleanupJobTest
extends ConcurrencyTestCase {
    private static final String PROCESS_ENGINE_NAME = "historyCleanupJobEngine";

    @Before
    public void setUp() throws Exception {
        Calendar timeOfDay = Calendar.getInstance();
        timeOfDay.set(11, 17);
        ClockUtil.setCurrentTime((Date)timeOfDay.getTime());
        this.processEngineConfiguration.setHistoryCleanupStrategy("endTimeBased");
    }

    protected void closeDownProcessEngine() {
        final ProcessEngine otherProcessEngine = ProcessEngines.getProcessEngine((String)PROCESS_ENGINE_NAME);
        if (otherProcessEngine != null) {
            ((ProcessEngineConfigurationImpl)otherProcessEngine.getProcessEngineConfiguration()).getCommandExecutorTxRequired().execute((Command)new Command<Void>(){

                public Void execute(CommandContext commandContext) {
                    List jobs = otherProcessEngine.getManagementService().createJobQuery().list();
                    if (jobs.size() > 0) {
                        Assert.assertEquals((long)1L, (long)jobs.size());
                        String jobId = ((Job)jobs.get(0)).getId();
                        commandContext.getJobManager().deleteJob((JobEntity)jobs.get(0));
                        commandContext.getHistoricJobLogManager().deleteHistoricJobLogByJobId(jobId);
                    }
                    return null;
                }
            });
            otherProcessEngine.close();
            ProcessEngines.unregister((ProcessEngine)otherProcessEngine);
        }
    }

    @After
    public void tearDown() throws Exception {
        this.processEngineConfiguration.getCommandExecutorTxRequired().execute(commandContext -> {
            List jobs = this.processEngine.getManagementService().createJobQuery().list();
            if (jobs.size() > 0) {
                Assert.assertEquals((long)1L, (long)jobs.size());
                String jobId = ((Job)jobs.get(0)).getId();
                commandContext.getJobManager().deleteJob((JobEntity)jobs.get(0));
                commandContext.getHistoricJobLogManager().deleteHistoricJobLogByJobId(jobId);
            }
            return null;
        });
        ClockUtil.setCurrentTime((Date)new Date());
        this.closeDownProcessEngine();
    }

    @Test
    public void testConcurrentHistoryCleanupJobReconfigurationExecution() throws InterruptedException {
        this.processEngine.getHistoryService().cleanUpHistoryAsync(true);
        ConcurrencyTestHelper.ThreadControl thread1 = this.executeControllableCommand(new ControllableJobExecutionCommand());
        thread1.reportInterrupts();
        thread1.waitForSync();
        ControllableProcessEngineBootstrapCommand bootstrapCommand = new ControllableProcessEngineBootstrapCommand();
        ConcurrencyTestHelper.ThreadControl thread2 = this.executeControllableCommand(bootstrapCommand);
        thread2.reportInterrupts();
        thread2.waitForSync();
        thread1.makeContinue();
        thread1.waitForSync();
        thread2.makeContinue();
        Thread.sleep(2000L);
        thread1.waitUntilDone();
        thread2.waitForSync();
        thread2.waitUntilDone(true);
        Assert.assertNull((Object)thread1.getException());
        Assert.assertNull((Object)thread2.getException());
        Assert.assertNull((Object)bootstrapCommand.getContextSpy().getThrowable());
        Assert.assertNotNull(ProcessEngines.getProcessEngines().get(PROCESS_ENGINE_NAME));
    }

    protected static class ControllableBootstrapEngineCommand
    extends BootstrapEngineCommand
    implements Command<Void> {
        protected final ConcurrencyTestHelper.ThreadControl monitor;
        protected CommandInvocationContext spy;

        public ControllableBootstrapEngineCommand(ConcurrencyTestHelper.ThreadControl threadControl) {
            this.monitor = threadControl;
        }

        protected void createHistoryCleanupJob(CommandContext commandContext) {
            this.monitor.sync();
            super.createHistoryCleanupJob(commandContext);
            this.spy = Context.getCommandInvocationContext();
            this.monitor.sync();
        }

        public CommandInvocationContext getSpy() {
            return this.spy;
        }
    }

    protected static class ControllableJobExecutionCommand
    extends ConcurrencyTestHelper.ControllableCommand<Void> {
        protected ControllableJobExecutionCommand() {
        }

        public Void execute(CommandContext commandContext) {
            this.monitor.sync();
            List historyCleanupJobs = commandContext.getProcessEngineConfiguration().getHistoryService().findHistoryCleanupJobs();
            for (Job job : historyCleanupJobs) {
                commandContext.getProcessEngineConfiguration().getManagementService().executeJob(job.getId());
            }
            this.monitor.sync();
            return null;
        }
    }

    protected static class ControllableProcessEngineBootstrapCommand
    extends ConcurrencyTestHelper.ControllableCommand<Void> {
        protected ControllableBootstrapEngineCommand bootstrapCommand;

        protected ControllableProcessEngineBootstrapCommand() {
        }

        public Void execute(CommandContext commandContext) {
            this.bootstrapCommand = new ControllableBootstrapEngineCommand(this.monitor);
            ProcessEngineConfiguration processEngineConfiguration = ProcessEngineConfiguration.createProcessEngineConfigurationFromResource((String)"org/camunda/bpm/engine/test/concurrency/historycleanup.camunda.cfg.xml");
            processEngineConfiguration.setProcessEngineBootstrapCommand((ProcessEngineBootstrapCommand)this.bootstrapCommand);
            processEngineConfiguration.setProcessEngineName(ConcurrentProcessEngineJobExecutorHistoryCleanupJobTest.PROCESS_ENGINE_NAME);
            processEngineConfiguration.buildProcessEngine();
            return null;
        }

        public CommandInvocationContext getContextSpy() {
            return this.bootstrapCommand.getSpy();
        }
    }
}

