/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.concurrency;

import org.assertj.core.api.Assertions;
import org.assertj.core.api.Assumptions;
import org.camunda.bpm.engine.impl.BootstrapEngineCommand;
import org.camunda.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.test.RequiredDatabase;
import org.camunda.bpm.engine.impl.test.TestHelper;
import org.camunda.bpm.engine.test.concurrency.ConcurrencyTestCase;
import org.camunda.bpm.engine.test.concurrency.ConcurrencyTestHelper;
import org.camunda.bpm.engine.test.util.DatabaseHelper;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ConcurrentTelemetryConfigurationTest
extends ConcurrencyTestCase {
    @Before
    public void setUp() {
        TestHelper.deleteTelemetryProperty((ProcessEngineConfigurationImpl)this.processEngineConfiguration);
    }

    @Test
    @RequiredDatabase(excludes={"h2", "mariadb"})
    public void testEnableTelemetryWithoutConcurancyIssue() throws InterruptedException {
        Integer transactionIsolationLevel = DatabaseHelper.getTransactionIsolationLevel(this.processEngineConfiguration);
        Assumptions.assumeThat((transactionIsolationLevel != null && !transactionIsolationLevel.equals(2) ? 1 : 0) != 0);
        ConcurrencyTestHelper.ThreadControl thread1 = this.executeControllableCommand(new ControllableUpdateTelemetrySetupCommand(false));
        thread1.waitForSync();
        ConcurrencyTestHelper.ThreadControl thread2 = this.executeControllableCommand(new ControllableUpdateTelemetrySetupCommand(false));
        thread2.waitForSync();
        thread1.makeContinue();
        thread1.waitForSync();
        thread2.makeContinue();
        Thread.sleep(2000L);
        thread1.waitUntilDone();
        thread2.waitForSync();
        thread2.waitUntilDone();
        Assert.assertNull((Object)thread1.exception);
        Assert.assertNull((Object)thread2.exception);
        Assertions.assertThat((Boolean)this.managementService.isTelemetryEnabled()).isNull();
    }

    protected static class ControllableUpdateTelemetrySetupCommand
    extends ConcurrencyTestHelper.ControllableCommand<Void> {
        boolean telemetryEnabled;

        public ControllableUpdateTelemetrySetupCommand(boolean telemetryEnabled) {
            this.telemetryEnabled = telemetryEnabled;
        }

        public Void execute(CommandContext commandContext) {
            this.monitor.sync();
            new BootstrapEngineCommand().initializeTelemetryProperty(commandContext);
            this.monitor.sync();
            return null;
        }
    }
}

