/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.concurrency.partitioning;

import org.camunda.bpm.engine.impl.db.DbEntity;
import org.camunda.bpm.engine.impl.interceptor.Command;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.persistence.entity.AttachmentEntity;
import org.camunda.bpm.engine.task.Attachment;
import org.camunda.bpm.engine.test.concurrency.ConcurrencyTestHelper;
import org.camunda.bpm.engine.test.concurrency.partitioning.AbstractPartitioningTest;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Test;

public class CompetingHistoricAttachmentPartitioningTest
extends AbstractPartitioningTest {
    @Test
    public void testConcurrentFetchAndDelete() {
        String processInstanceId = this.deployAndStartProcess(this.PROCESS_WITH_USERTASK).getId();
        final Attachment attachment = this.taskService.createAttachment("anAttachmentType", null, processInstanceId, "anAttachmentName", null, "http://camunda.com");
        ConcurrencyTestHelper.ThreadControl asyncThread = this.executeControllableCommand(new AsyncThread(attachment.getId()));
        MatcherAssert.assertThat((Object)this.taskService.getAttachment(attachment.getId()), (Matcher)CoreMatchers.notNullValue());
        asyncThread.waitForSync();
        this.commandExecutor.execute((Command)new Command<Void>(){

            public Void execute(CommandContext commandContext) {
                commandContext.getAttachmentManager().delete((DbEntity)((AttachmentEntity)attachment));
                return null;
            }
        });
        asyncThread.makeContinue();
        asyncThread.waitUntilDone();
        MatcherAssert.assertThat((Object)this.taskService.getAttachment(attachment.getId()), (Matcher)CoreMatchers.nullValue());
    }

    public class AsyncThread
    extends ConcurrencyTestHelper.ControllableCommand<Void> {
        String attachmentId;

        AsyncThread(String attachmentId) {
            this.attachmentId = attachmentId;
        }

        public Void execute(CommandContext commandContext) {
            commandContext.getDbEntityManager().selectById(AttachmentEntity.class, this.attachmentId);
            this.monitor.sync();
            AttachmentEntity changedAttachmentEntity = new AttachmentEntity();
            changedAttachmentEntity.setId(this.attachmentId);
            CompetingHistoricAttachmentPartitioningTest.this.taskService.saveAttachment((Attachment)changedAttachmentEntity);
            return null;
        }
    }
}

