/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.history;

import java.util.List;
import org.camunda.bpm.engine.history.HistoricIdentityLinkLog;
import org.camunda.bpm.engine.history.HistoricIdentityLinkLogQuery;
import org.camunda.bpm.engine.repository.ProcessDefinition;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.test.Deployment;
import org.camunda.bpm.engine.test.RequiredHistoryLevel;
import org.camunda.bpm.engine.test.util.PluggableProcessEngineTest;
import org.junit.Assert;
import org.junit.Test;

@RequiredHistoryLevel(value="full")
public class HistoricIdentityLinkLogTestByXml
extends PluggableProcessEngineTest {
    private static String PROCESS_DEFINITION_KEY_CANDIDATE_USER = "oneTaskProcessForHistoricIdentityLinkWithCanidateUser";
    private static String PROCESS_DEFINITION_KEY_CANDIDATE_GROUP = "oneTaskProcessForHistoricIdentityLinkWithCanidateGroup";
    private static String PROCESS_DEFINITION_KEY_ASSIGNEE = "oneTaskProcessForHistoricIdentityLinkWithAssignee";
    private static String PROCESS_DEFINITION_KEY_CANDIDATE_STARTER_USER = "oneTaskProcessForHistoricIdentityLinkWithCanidateStarterUsers";
    private static String PROCESS_DEFINITION_KEY_CANDIDATE_STARTER_GROUP = "oneTaskProcessForHistoricIdentityLinkWithCanidateStarterGroups";
    private static final String XML_USER = "demo";
    private static final String XML_GROUP = "demoGroups";
    private static final String XML_ASSIGNEE = "assignee";
    protected static final String TENANT_ONE = "tenant1";
    protected static final String CANDIDATE_STARTER_USER = "org/camunda/bpm/engine/test/api/repository/ProcessDefinitionCandidateTest.testCandidateStarterUser.bpmn20.xml";
    protected static final String CANDIDATE_STARTER_USERS = "org/camunda/bpm/engine/test/api/repository/ProcessDefinitionCandidateTest.testCandidateStarterUsers.bpmn20.xml";
    protected static final String CANDIDATE_STARTER_GROUP = "org/camunda/bpm/engine/test/api/repository/ProcessDefinitionCandidateTest.testCandidateStarterGroup.bpmn20.xml";
    protected static final String CANDIDATE_STARTER_GROUPS = "org/camunda/bpm/engine/test/api/repository/ProcessDefinitionCandidateTest.testCandidateStarterGroups.bpmn20.xml";

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/OneTaskProcessWithCandidateUser.bpmn20.xml"})
    @Test
    public void testShouldAddTaskCandidateforAddIdentityLinkUsingXml() {
        List historicIdentityLinks = this.historyService.createHistoricIdentityLinkLogQuery().list();
        Assert.assertEquals((long)historicIdentityLinks.size(), (long)0L);
        this.startProcessInstance(PROCESS_DEFINITION_KEY_CANDIDATE_USER);
        historicIdentityLinks = this.historyService.createHistoricIdentityLinkLogQuery().list();
        Assert.assertEquals((long)historicIdentityLinks.size(), (long)1L);
        HistoricIdentityLinkLogQuery query = this.historyService.createHistoricIdentityLinkLogQuery();
        Assert.assertEquals((long)query.userId(XML_USER).count(), (long)1L);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/OneTaskProcessWithTaskAssignee.bpmn20.xml"})
    @Test
    public void testShouldAddTaskAssigneeforAddIdentityLinkUsingXml() {
        List historicIdentityLinks = this.historyService.createHistoricIdentityLinkLogQuery().list();
        Assert.assertEquals((long)historicIdentityLinks.size(), (long)0L);
        this.startProcessInstance(PROCESS_DEFINITION_KEY_ASSIGNEE);
        historicIdentityLinks = this.historyService.createHistoricIdentityLinkLogQuery().list();
        Assert.assertEquals((long)historicIdentityLinks.size(), (long)1L);
        HistoricIdentityLinkLogQuery query = this.historyService.createHistoricIdentityLinkLogQuery();
        Assert.assertEquals((long)query.userId(XML_ASSIGNEE).count(), (long)1L);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/OneTaskProcessWithCandidateGroups.bpmn20.xml"})
    @Test
    public void testShouldAddTaskCandidateGroupforAddIdentityLinkUsingXml() {
        List historicIdentityLinks = this.historyService.createHistoricIdentityLinkLogQuery().list();
        Assert.assertEquals((long)historicIdentityLinks.size(), (long)0L);
        this.startProcessInstance(PROCESS_DEFINITION_KEY_CANDIDATE_GROUP);
        historicIdentityLinks = this.historyService.createHistoricIdentityLinkLogQuery().list();
        Assert.assertEquals((long)historicIdentityLinks.size(), (long)1L);
        HistoricIdentityLinkLogQuery query = this.historyService.createHistoricIdentityLinkLogQuery();
        Assert.assertEquals((long)query.groupId(XML_GROUP).count(), (long)1L);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/OneTaskProcessWithCandidateStarterUsers.bpmn20.xml"})
    @Test
    public void testShouldAddProcessCandidateStarterUserforAddIdentityLinkUsingXml() {
        List historicIdentityLinks = this.historyService.createHistoricIdentityLinkLogQuery().list();
        Assert.assertEquals((long)historicIdentityLinks.size(), (long)1L);
        ProcessDefinition latestProcessDef = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().processDefinitionKey(PROCESS_DEFINITION_KEY_CANDIDATE_STARTER_USER).singleResult();
        Assert.assertNotNull((Object)latestProcessDef);
        List links = this.repositoryService.getIdentityLinksForProcessDefinition(latestProcessDef.getId());
        Assert.assertEquals((long)1L, (long)links.size());
        historicIdentityLinks = this.historyService.createHistoricIdentityLinkLogQuery().list();
        Assert.assertEquals((long)historicIdentityLinks.size(), (long)1L);
        HistoricIdentityLinkLogQuery query = this.historyService.createHistoricIdentityLinkLogQuery();
        Assert.assertEquals((long)query.userId(XML_USER).count(), (long)1L);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/OneTaskProcessWithCandidateStarterGroups.bpmn20.xml"})
    public void testShouldAddProcessCandidateStarterGroupforAddIdentityLinkUsingXml() {
        List historicIdentityLinks = this.historyService.createHistoricIdentityLinkLogQuery().list();
        Assert.assertEquals((long)historicIdentityLinks.size(), (long)1L);
        ProcessDefinition latestProcessDef = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().processDefinitionKey(PROCESS_DEFINITION_KEY_CANDIDATE_STARTER_GROUP).singleResult();
        Assert.assertNotNull((Object)latestProcessDef);
        List links = this.repositoryService.getIdentityLinksForProcessDefinition(latestProcessDef.getId());
        Assert.assertEquals((long)1L, (long)links.size());
        historicIdentityLinks = this.historyService.createHistoricIdentityLinkLogQuery().list();
        Assert.assertEquals((long)historicIdentityLinks.size(), (long)1L);
        HistoricIdentityLinkLogQuery query = this.historyService.createHistoricIdentityLinkLogQuery();
        Assert.assertEquals((long)query.groupId(XML_GROUP).count(), (long)1L);
    }

    @Test
    public void testPropagateTenantIdToCandidateStarterUser() {
        org.camunda.bpm.engine.repository.Deployment deployment = this.repositoryService.createDeployment().addClasspathResource(CANDIDATE_STARTER_USER).tenantId(TENANT_ONE).deploy();
        List historicLinks = this.historyService.createHistoricIdentityLinkLogQuery().list();
        Assert.assertEquals((long)historicLinks.size(), (long)1L);
        HistoricIdentityLinkLog historicLink = (HistoricIdentityLinkLog)historicLinks.get(0);
        Assert.assertNotNull((Object)historicLink.getTenantId());
        Assert.assertEquals((Object)TENANT_ONE, (Object)historicLink.getTenantId());
        this.repositoryService.deleteDeployment(deployment.getId(), true);
    }

    @Test
    public void testPropagateTenantIdToCandidateStarterUsers() {
        org.camunda.bpm.engine.repository.Deployment deployment = this.repositoryService.createDeployment().addClasspathResource(CANDIDATE_STARTER_USERS).tenantId(TENANT_ONE).deploy();
        List historicLinks = this.historyService.createHistoricIdentityLinkLogQuery().list();
        Assert.assertEquals((long)3L, (long)historicLinks.size());
        for (HistoricIdentityLinkLog historicLink : historicLinks) {
            Assert.assertNotNull((Object)historicLink.getTenantId());
            Assert.assertEquals((Object)TENANT_ONE, (Object)historicLink.getTenantId());
        }
        this.repositoryService.deleteDeployment(deployment.getId(), true);
    }

    @Test
    public void testPropagateTenantIdToCandidateStarterGroup() {
        org.camunda.bpm.engine.repository.Deployment deployment = this.repositoryService.createDeployment().addClasspathResource(CANDIDATE_STARTER_GROUP).tenantId(TENANT_ONE).deploy();
        List historicLinks = this.historyService.createHistoricIdentityLinkLogQuery().list();
        Assert.assertEquals((long)historicLinks.size(), (long)1L);
        HistoricIdentityLinkLog historicLink = (HistoricIdentityLinkLog)historicLinks.get(0);
        Assert.assertNotNull((Object)historicLink.getTenantId());
        Assert.assertEquals((Object)TENANT_ONE, (Object)historicLink.getTenantId());
        this.repositoryService.deleteDeployment(deployment.getId(), true);
    }

    @Test
    public void testPropagateTenantIdToCandidateStarterGroups() {
        org.camunda.bpm.engine.repository.Deployment deployment = this.repositoryService.createDeployment().addClasspathResource(CANDIDATE_STARTER_GROUPS).tenantId(TENANT_ONE).deploy();
        List historicLinks = this.historyService.createHistoricIdentityLinkLogQuery().list();
        Assert.assertEquals((long)3L, (long)historicLinks.size());
        for (HistoricIdentityLinkLog historicLink : historicLinks) {
            Assert.assertNotNull((Object)historicLink.getTenantId());
            Assert.assertEquals((Object)TENANT_ONE, (Object)historicLink.getTenantId());
        }
        this.repositoryService.deleteDeployment(deployment.getId(), true);
    }

    protected ProcessInstance startProcessInstance(String key) {
        return this.runtimeService.startProcessInstanceByKey(key);
    }
}

