/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.standalone.history;

import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.history.HistoricTaskInstance;
import org.camunda.bpm.engine.history.HistoricTaskInstanceQuery;
import org.camunda.bpm.engine.impl.util.ClockUtil;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.task.Task;
import org.camunda.bpm.engine.test.Deployment;
import org.camunda.bpm.engine.test.RequiredHistoryLevel;
import org.camunda.bpm.engine.test.util.PluggableProcessEngineTest;
import org.camunda.bpm.engine.variable.Variables;
import org.junit.Assert;
import org.junit.Test;

@RequiredHistoryLevel(value="audit")
public class HistoricTaskInstanceQueryTest
extends PluggableProcessEngineTest {
    protected static final String VARIABLE_NAME = "variableName";
    protected static final String VARIABLE_NAME_LC = "variableName".toLowerCase();
    protected static final String VARIABLE_VALUE = "variableValue";
    protected static final String VARIABLE_VALUE_LC = "variableValue".toLowerCase();
    protected static final String VARIABLE_VALUE_LC_LIKE = "%" + VARIABLE_VALUE_LC.substring(2, 10) + "%";
    protected static final String VARIABLE_VALUE_NE = "nonExistent";
    protected static Map<String, Object> VARIABLES = new HashMap<String, Object>();

    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    @Test
    public void testProcessVariableValueEqualsNumber() throws Exception {
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess", Collections.singletonMap("var", 123L));
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess", Collections.singletonMap("var", 12345L));
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess", Collections.singletonMap("var", (short)123));
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess", Collections.singletonMap("var", 123.0));
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess", Collections.singletonMap("var", 123));
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess", Collections.singletonMap("var", null));
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess", Collections.singletonMap("var", Variables.longValue(null)));
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess", Collections.singletonMap("var", "123"));
        Assert.assertEquals((long)4L, (long)this.historyService.createHistoricTaskInstanceQuery().processVariableValueEquals("var", (Object)Variables.numberValue((Number)123)).count());
        Assert.assertEquals((long)4L, (long)this.historyService.createHistoricTaskInstanceQuery().processVariableValueEquals("var", (Object)Variables.numberValue((Number)123L)).count());
        Assert.assertEquals((long)4L, (long)this.historyService.createHistoricTaskInstanceQuery().processVariableValueEquals("var", (Object)Variables.numberValue((Number)123.0)).count());
        Assert.assertEquals((long)4L, (long)this.historyService.createHistoricTaskInstanceQuery().processVariableValueEquals("var", (Object)Variables.numberValue((Number)123)).count());
        Assert.assertEquals((long)1L, (long)this.historyService.createHistoricTaskInstanceQuery().processVariableValueEquals("var", (Object)Variables.numberValue(null)).count());
        Assert.assertEquals((long)8L, (long)this.historyService.createHistoricTaskInstanceQuery().processVariableValueNotEquals("var", (Object)999L).count());
        Assert.assertEquals((long)8L, (long)this.historyService.createHistoricTaskInstanceQuery().processVariableValueNotEquals("var", (Object)999).count());
        Assert.assertEquals((long)8L, (long)this.historyService.createHistoricTaskInstanceQuery().processVariableValueNotEquals("var", (Object)999).count());
        Assert.assertEquals((long)8L, (long)this.historyService.createHistoricTaskInstanceQuery().processVariableValueNotEquals("var", (Object)"999").count());
        Assert.assertEquals((long)8L, (long)this.historyService.createHistoricTaskInstanceQuery().processVariableValueNotEquals("var", (Object)false).count());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    @Test
    public void testProcessVariableValueLike() throws Exception {
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess", Collections.singletonMap("requester", "vahid alizadeh"));
        Assert.assertEquals((long)1L, (long)this.historyService.createHistoricTaskInstanceQuery().processVariableValueLike("requester", (Object)"vahid%").count());
        Assert.assertEquals((long)1L, (long)this.historyService.createHistoricTaskInstanceQuery().processVariableValueLike("requester", (Object)"%alizadeh").count());
        Assert.assertEquals((long)1L, (long)this.historyService.createHistoricTaskInstanceQuery().processVariableValueLike("requester", (Object)"%ali%").count());
        Assert.assertEquals((long)0L, (long)this.historyService.createHistoricTaskInstanceQuery().processVariableValueLike("requester", (Object)"requester%").count());
        Assert.assertEquals((long)0L, (long)this.historyService.createHistoricTaskInstanceQuery().processVariableValueLike("requester", (Object)"%ali").count());
        Assert.assertEquals((long)0L, (long)this.historyService.createHistoricTaskInstanceQuery().processVariableValueLike("requester", (Object)"vahid").count());
        Assert.assertEquals((long)0L, (long)this.historyService.createHistoricTaskInstanceQuery().processVariableValueLike("nonExistingVar", (Object)"string%").count());
        try {
            this.historyService.createHistoricTaskInstanceQuery().processVariableValueLike("requester", null).count();
            Assert.fail((String)"expected exception");
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    @Test
    public void testProcessVariableValueGreaterThan() throws Exception {
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess", Collections.singletonMap("requestNumber", 123));
        Assert.assertEquals((long)1L, (long)this.historyService.createHistoricTaskInstanceQuery().processVariableValueGreaterThan("requestNumber", (Object)122).count());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    @Test
    public void testProcessVariableValueGreaterThanOrEqual() throws Exception {
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess", Collections.singletonMap("requestNumber", 123));
        Assert.assertEquals((long)1L, (long)this.historyService.createHistoricTaskInstanceQuery().processVariableValueGreaterThanOrEquals("requestNumber", (Object)122).count());
        Assert.assertEquals((long)1L, (long)this.historyService.createHistoricTaskInstanceQuery().processVariableValueGreaterThanOrEquals("requestNumber", (Object)123).count());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    @Test
    public void testProcessVariableValueLessThan() throws Exception {
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess", Collections.singletonMap("requestNumber", 123));
        Assert.assertEquals((long)1L, (long)this.historyService.createHistoricTaskInstanceQuery().processVariableValueLessThan("requestNumber", (Object)124).count());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    @Test
    public void testProcessVariableValueLessThanOrEqual() throws Exception {
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess", Collections.singletonMap("requestNumber", 123));
        Assert.assertEquals((long)1L, (long)this.historyService.createHistoricTaskInstanceQuery().processVariableValueLessThanOrEquals("requestNumber", (Object)123).count());
        Assert.assertEquals((long)1L, (long)this.historyService.createHistoricTaskInstanceQuery().processVariableValueLessThanOrEquals("requestNumber", (Object)124).count());
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void testProcessVariableNameEqualsIgnoreCase() {
        ProcessInstance instance = this.runtimeService.startProcessInstanceByKey("oneTaskProcess", VARIABLES);
        List eq = this.queryNameIgnoreCase().processVariableValueEquals(VARIABLE_NAME, (Object)VARIABLE_VALUE).list();
        List eqNameLC = this.queryNameIgnoreCase().processVariableValueEquals(VARIABLE_NAME_LC, (Object)VARIABLE_VALUE).list();
        List eqValueLC = this.queryNameIgnoreCase().processVariableValueEquals(VARIABLE_NAME, (Object)VARIABLE_VALUE_LC).list();
        List eqNameValueLC = this.queryNameIgnoreCase().processVariableValueEquals(VARIABLE_NAME_LC, (Object)VARIABLE_VALUE_LC).list();
        this.assertThatListContainsOnlyExpectedElement(eq, instance);
        this.assertThatListContainsOnlyExpectedElement(eqNameLC, instance);
        Assertions.assertThat((List)eqValueLC).isEmpty();
        Assertions.assertThat((List)eqNameValueLC).isEmpty();
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void testProcessVariableNameNotEqualsIgnoreCase() {
        ProcessInstance instance = this.runtimeService.startProcessInstanceByKey("oneTaskProcess", VARIABLES);
        List neq = this.queryNameIgnoreCase().processVariableValueNotEquals(VARIABLE_NAME, (Object)VARIABLE_VALUE).list();
        List neqNameLC = this.queryNameIgnoreCase().processVariableValueNotEquals(VARIABLE_NAME_LC, (Object)VARIABLE_VALUE).list();
        List neqValueNE = this.queryNameIgnoreCase().processVariableValueNotEquals(VARIABLE_NAME, (Object)VARIABLE_VALUE_NE).list();
        List neqNameLCValueNE = this.queryNameIgnoreCase().processVariableValueNotEquals(VARIABLE_NAME_LC, (Object)VARIABLE_VALUE_NE).list();
        Assertions.assertThat((List)neq).isEmpty();
        Assertions.assertThat((List)neqNameLC).isEmpty();
        this.assertThatListContainsOnlyExpectedElement(neqValueNE, instance);
        this.assertThatListContainsOnlyExpectedElement(neqNameLCValueNE, instance);
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void testProcessVariableValueEqualsIgnoreCase() {
        ProcessInstance instance = this.runtimeService.startProcessInstanceByKey("oneTaskProcess", VARIABLES);
        List eq = this.queryValueIgnoreCase().processVariableValueEquals(VARIABLE_NAME, (Object)VARIABLE_VALUE).list();
        List eqNameLC = this.queryValueIgnoreCase().processVariableValueEquals(VARIABLE_NAME_LC, (Object)VARIABLE_VALUE).list();
        List eqValueLC = this.queryValueIgnoreCase().processVariableValueEquals(VARIABLE_NAME, (Object)VARIABLE_VALUE_LC).list();
        List eqNameValueLC = this.queryValueIgnoreCase().processVariableValueEquals(VARIABLE_NAME_LC, (Object)VARIABLE_VALUE_LC).list();
        this.assertThatListContainsOnlyExpectedElement(eq, instance);
        Assertions.assertThat((List)eqNameLC).isEmpty();
        this.assertThatListContainsOnlyExpectedElement(eqValueLC, instance);
        Assertions.assertThat((List)eqNameValueLC).isEmpty();
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void testProcessVariableValueNotEqualsIgnoreCase() {
        ProcessInstance instance = this.runtimeService.startProcessInstanceByKey("oneTaskProcess", VARIABLES);
        List neq = this.queryValueIgnoreCase().processVariableValueNotEquals(VARIABLE_NAME, (Object)VARIABLE_VALUE).list();
        List neqNameLC = this.queryValueIgnoreCase().processVariableValueNotEquals(VARIABLE_NAME_LC, (Object)VARIABLE_VALUE).list();
        List neqValueNE = this.queryValueIgnoreCase().processVariableValueNotEquals(VARIABLE_NAME, (Object)VARIABLE_VALUE_NE).list();
        List neqNameLCValueNE = this.queryValueIgnoreCase().processVariableValueNotEquals(VARIABLE_NAME_LC, (Object)VARIABLE_VALUE_NE).list();
        Assertions.assertThat((List)neq).isEmpty();
        Assertions.assertThat((List)neqNameLC).isEmpty();
        this.assertThatListContainsOnlyExpectedElement(neqValueNE, instance);
        Assertions.assertThat((List)neqNameLCValueNE).isEmpty();
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void testProcessVariableValueLikeIgnoreCase() {
        ProcessInstance instance = this.runtimeService.startProcessInstanceByKey("oneTaskProcess", VARIABLES);
        List like = this.queryNameValueIgnoreCase().processVariableValueLike(VARIABLE_NAME, (Object)VARIABLE_VALUE).list();
        List likeValueLC = this.queryValueIgnoreCase().processVariableValueLike(VARIABLE_NAME, (Object)VARIABLE_VALUE_LC_LIKE).list();
        this.assertThatListContainsOnlyExpectedElement(like, instance);
        this.assertThatListContainsOnlyExpectedElement(likeValueLC, instance);
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void testProcessVariableNameAndValueEqualsIgnoreCase() {
        ProcessInstance instance = this.runtimeService.startProcessInstanceByKey("oneTaskProcess", VARIABLES);
        List eq = this.queryNameValueIgnoreCase().processVariableValueEquals(VARIABLE_NAME, (Object)VARIABLE_VALUE).list();
        List eqNameLC = this.queryNameValueIgnoreCase().processVariableValueEquals(VARIABLE_NAME_LC, (Object)VARIABLE_VALUE).list();
        List eqValueLC = this.queryNameValueIgnoreCase().processVariableValueEquals(VARIABLE_NAME, (Object)VARIABLE_VALUE_LC).list();
        List eqValueNE = this.queryNameValueIgnoreCase().processVariableValueEquals(VARIABLE_NAME, (Object)VARIABLE_VALUE_NE).list();
        List eqNameValueLC = this.queryNameValueIgnoreCase().processVariableValueEquals(VARIABLE_NAME_LC, (Object)VARIABLE_VALUE_LC).list();
        List eqNameLCValueNE = this.queryNameValueIgnoreCase().processVariableValueEquals(VARIABLE_NAME_LC, (Object)VARIABLE_VALUE_NE).list();
        this.assertThatListContainsOnlyExpectedElement(eq, instance);
        this.assertThatListContainsOnlyExpectedElement(eqNameLC, instance);
        this.assertThatListContainsOnlyExpectedElement(eqValueLC, instance);
        Assertions.assertThat((List)eqValueNE).isEmpty();
        this.assertThatListContainsOnlyExpectedElement(eqNameValueLC, instance);
        Assertions.assertThat((List)eqNameLCValueNE).isEmpty();
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void testProcessVariableNameAndValueNotEqualsIgnoreCase() {
        ProcessInstance instance = this.runtimeService.startProcessInstanceByKey("oneTaskProcess", VARIABLES);
        List neq = this.queryNameValueIgnoreCase().processVariableValueNotEquals(VARIABLE_NAME, (Object)VARIABLE_VALUE).list();
        List neqNameLC = this.queryNameValueIgnoreCase().processVariableValueNotEquals(VARIABLE_NAME_LC, (Object)VARIABLE_VALUE).list();
        List neqValueLC = this.queryNameValueIgnoreCase().processVariableValueNotEquals(VARIABLE_NAME, (Object)VARIABLE_VALUE_LC).list();
        List neqValueNE = this.queryNameValueIgnoreCase().processVariableValueNotEquals(VARIABLE_NAME, (Object)VARIABLE_VALUE_NE).list();
        List neqNameValueLC = this.queryNameValueIgnoreCase().processVariableValueNotEquals(VARIABLE_NAME_LC, (Object)VARIABLE_VALUE_LC).list();
        List neqNameLCValueNE = this.queryNameValueIgnoreCase().processVariableValueNotEquals(VARIABLE_NAME_LC, (Object)VARIABLE_VALUE_NE).list();
        Assertions.assertThat((List)neq).isEmpty();
        Assertions.assertThat((List)neqNameLC).isEmpty();
        Assertions.assertThat((List)neqValueLC).isEmpty();
        this.assertThatListContainsOnlyExpectedElement(neqValueNE, instance);
        Assertions.assertThat((List)neqNameValueLC).isEmpty();
        this.assertThatListContainsOnlyExpectedElement(neqNameLCValueNE, instance);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    @Test
    public void testTaskVariableValueEqualsNumber() throws Exception {
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        List tasks = this.taskService.createTaskQuery().processDefinitionKey("oneTaskProcess").list();
        Assert.assertEquals((long)8L, (long)tasks.size());
        this.taskService.setVariableLocal(((Task)tasks.get(0)).getId(), "var", (Object)123L);
        this.taskService.setVariableLocal(((Task)tasks.get(1)).getId(), "var", (Object)12345L);
        this.taskService.setVariableLocal(((Task)tasks.get(2)).getId(), "var", (Object)123);
        this.taskService.setVariableLocal(((Task)tasks.get(3)).getId(), "var", (Object)123.0);
        this.taskService.setVariableLocal(((Task)tasks.get(4)).getId(), "var", (Object)123);
        this.taskService.setVariableLocal(((Task)tasks.get(5)).getId(), "var", null);
        this.taskService.setVariableLocal(((Task)tasks.get(6)).getId(), "var", (Object)Variables.longValue(null));
        this.taskService.setVariableLocal(((Task)tasks.get(7)).getId(), "var", (Object)"123");
        Assert.assertEquals((long)4L, (long)this.historyService.createHistoricTaskInstanceQuery().taskVariableValueEquals("var", (Object)Variables.numberValue((Number)123)).count());
        Assert.assertEquals((long)4L, (long)this.historyService.createHistoricTaskInstanceQuery().taskVariableValueEquals("var", (Object)Variables.numberValue((Number)123L)).count());
        Assert.assertEquals((long)4L, (long)this.historyService.createHistoricTaskInstanceQuery().taskVariableValueEquals("var", (Object)Variables.numberValue((Number)123.0)).count());
        Assert.assertEquals((long)4L, (long)this.historyService.createHistoricTaskInstanceQuery().taskVariableValueEquals("var", (Object)Variables.numberValue((Number)123)).count());
        Assert.assertEquals((long)1L, (long)this.historyService.createHistoricTaskInstanceQuery().taskVariableValueEquals("var", (Object)Variables.numberValue(null)).count());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    @Test
    public void testTaskVariableValueEqualsNumberIgnoreCase() {
        ProcessInstance instance = this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        this.taskService.setVariablesLocal(task.getId(), VARIABLES);
        List eq = this.queryValueIgnoreCase().taskVariableValueEquals(VARIABLE_NAME, (Object)VARIABLE_VALUE).list();
        List eqNameLC = this.queryValueIgnoreCase().taskVariableValueEquals(VARIABLE_NAME_LC, (Object)VARIABLE_VALUE).list();
        List eqValueLC = this.queryValueIgnoreCase().taskVariableValueEquals(VARIABLE_NAME, (Object)VARIABLE_VALUE_LC).list();
        List eqNameValueLC = this.queryValueIgnoreCase().taskVariableValueEquals(VARIABLE_NAME_LC, (Object)VARIABLE_VALUE_LC).list();
        this.assertThatListContainsOnlyExpectedElement(eq, instance);
        Assertions.assertThat((List)eqNameLC).isEmpty();
        this.assertThatListContainsOnlyExpectedElement(eqValueLC, instance);
        Assertions.assertThat((List)eqNameValueLC).isEmpty();
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void testTaskVariableNameEqualsIgnoreCase() {
        ProcessInstance instance = this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        this.taskService.setVariablesLocal(task.getId(), VARIABLES);
        List eq = this.queryNameIgnoreCase().taskVariableValueEquals(VARIABLE_NAME, (Object)VARIABLE_VALUE).list();
        List eqNameLC = this.queryNameIgnoreCase().taskVariableValueEquals(VARIABLE_NAME_LC, (Object)VARIABLE_VALUE).list();
        List eqValueLC = this.queryNameIgnoreCase().taskVariableValueEquals(VARIABLE_NAME, (Object)VARIABLE_VALUE_LC).list();
        List eqNameValueLC = this.queryNameIgnoreCase().taskVariableValueEquals(VARIABLE_NAME_LC, (Object)VARIABLE_VALUE_LC).list();
        this.assertThatListContainsOnlyExpectedElement(eq, instance);
        this.assertThatListContainsOnlyExpectedElement(eqNameLC, instance);
        Assertions.assertThat((List)eqValueLC).isEmpty();
        Assertions.assertThat((List)eqNameValueLC).isEmpty();
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void testTaskVariableNameAndValueEqualsIgnoreCase() {
        ProcessInstance instance = this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        this.taskService.setVariablesLocal(task.getId(), VARIABLES);
        List eq = this.queryNameValueIgnoreCase().taskVariableValueEquals(VARIABLE_NAME, (Object)VARIABLE_VALUE).list();
        List eqNameLC = this.queryNameValueIgnoreCase().taskVariableValueEquals(VARIABLE_NAME_LC, (Object)VARIABLE_VALUE).list();
        List eqValueLC = this.queryNameValueIgnoreCase().taskVariableValueEquals(VARIABLE_NAME, (Object)VARIABLE_VALUE_LC).list();
        List eqValueNE = this.queryNameValueIgnoreCase().taskVariableValueEquals(VARIABLE_NAME, (Object)VARIABLE_VALUE_NE).list();
        List eqNameValueLC = this.queryNameValueIgnoreCase().taskVariableValueEquals(VARIABLE_NAME_LC, (Object)VARIABLE_VALUE_LC).list();
        List eqNameLCValueNE = this.queryNameValueIgnoreCase().taskVariableValueEquals(VARIABLE_NAME_LC, (Object)VARIABLE_VALUE_NE).list();
        this.assertThatListContainsOnlyExpectedElement(eq, instance);
        this.assertThatListContainsOnlyExpectedElement(eqNameLC, instance);
        this.assertThatListContainsOnlyExpectedElement(eqValueLC, instance);
        Assertions.assertThat((List)eqValueNE).isEmpty();
        this.assertThatListContainsOnlyExpectedElement(eqNameValueLC, instance);
        Assertions.assertThat((List)eqNameLCValueNE).isEmpty();
    }

    @Test
    @RequiredHistoryLevel(value="full")
    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/oneTaskProcess.bpmn20.xml"})
    public void testTaskInvolvedUser() {
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        String taskId = ((Task)this.taskService.createTaskQuery().singleResult()).getId();
        this.identityService.setAuthenticatedUserId("aAssignerId");
        this.taskService.addCandidateUser(taskId, "aUserId");
        this.taskService.addCandidateUser(taskId, "bUserId");
        this.taskService.deleteCandidateUser(taskId, "aUserId");
        this.taskService.deleteCandidateUser(taskId, "bUserId");
        Task taskAssignee = this.taskService.newTask("newTask");
        taskAssignee.setAssignee("aUserId");
        this.taskService.saveTask(taskAssignee);
        Assert.assertEquals((long)2L, (long)this.historyService.createHistoricTaskInstanceQuery().taskInvolvedUser("aUserId").count());
        Assert.assertEquals((long)1L, (long)this.historyService.createHistoricTaskInstanceQuery().taskInvolvedUser("bUserId").count());
        Assert.assertEquals((long)0L, (long)this.historyService.createHistoricTaskInstanceQuery().taskInvolvedUser("invalidUserId").count());
        this.taskService.deleteTask("newTask", true);
    }

    @Test
    @RequiredHistoryLevel(value="full")
    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/oneTaskProcess.bpmn20.xml"})
    public void testTaskInvolvedGroup() {
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        String taskId = ((Task)this.taskService.createTaskQuery().singleResult()).getId();
        this.identityService.setAuthenticatedUserId("aAssignerId");
        this.taskService.addCandidateGroup(taskId, "aGroupId");
        this.taskService.addCandidateGroup(taskId, "bGroupId");
        this.taskService.deleteCandidateGroup(taskId, "aGroupId");
        this.taskService.deleteCandidateGroup(taskId, "bGroupId");
        Assert.assertEquals((long)1L, (long)this.historyService.createHistoricTaskInstanceQuery().taskInvolvedGroup("aGroupId").count());
        Assert.assertEquals((long)1L, (long)this.historyService.createHistoricTaskInstanceQuery().taskInvolvedGroup("bGroupId").count());
        Assert.assertEquals((long)0L, (long)this.historyService.createHistoricTaskInstanceQuery().taskInvolvedGroup("invalidGroupId").count());
        this.taskService.deleteTask("newTask", true);
    }

    @Test
    @RequiredHistoryLevel(value="full")
    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/oneTaskProcess.bpmn20.xml"})
    public void testTaskHadCandidateUser() {
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        String taskId = ((Task)this.taskService.createTaskQuery().singleResult()).getId();
        this.identityService.setAuthenticatedUserId("aAssignerId");
        this.taskService.addCandidateUser(taskId, "aUserId");
        this.taskService.addCandidateUser(taskId, "bUserId");
        this.taskService.deleteCandidateUser(taskId, "bUserId");
        Task taskAssignee = this.taskService.newTask("newTask");
        taskAssignee.setAssignee("aUserId");
        this.taskService.saveTask(taskAssignee);
        Assert.assertEquals((long)1L, (long)this.historyService.createHistoricTaskInstanceQuery().taskHadCandidateUser("aUserId").count());
        Assert.assertEquals((long)1L, (long)this.historyService.createHistoricTaskInstanceQuery().taskHadCandidateUser("bUserId").count());
        Assert.assertEquals((long)0L, (long)this.historyService.createHistoricTaskInstanceQuery().taskHadCandidateUser("invalidUserId").count());
        this.taskService.deleteTask("newTask", true);
    }

    @Test
    @RequiredHistoryLevel(value="full")
    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/oneTaskProcess.bpmn20.xml"})
    public void testTaskHadCandidateGroup() {
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        String taskId = ((Task)this.taskService.createTaskQuery().singleResult()).getId();
        this.identityService.setAuthenticatedUserId("aAssignerId");
        this.taskService.addCandidateGroup(taskId, "bGroupId");
        this.taskService.deleteCandidateGroup(taskId, "bGroupId");
        Assert.assertEquals((long)1L, (long)this.historyService.createHistoricTaskInstanceQuery().taskHadCandidateGroup("bGroupId").count());
        Assert.assertEquals((long)0L, (long)this.historyService.createHistoricTaskInstanceQuery().taskHadCandidateGroup("invalidGroupId").count());
        this.taskService.deleteTask("newTask", true);
    }

    @Test
    @RequiredHistoryLevel(value="full")
    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/oneTaskProcess.bpmn20.xml"})
    public void testWithCandidateGroups() {
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        String taskId = ((Task)this.taskService.createTaskQuery().singleResult()).getId();
        this.identityService.setAuthenticatedUserId("aAssignerId");
        this.taskService.addCandidateGroup(taskId, "aGroupId");
        Assert.assertEquals((long)this.historyService.createHistoricTaskInstanceQuery().withCandidateGroups().count(), (long)1L);
        this.taskService.deleteTask("newTask", true);
    }

    @Test
    @RequiredHistoryLevel(value="full")
    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/oneTaskProcess.bpmn20.xml"})
    public void testWithoutCandidateGroups() {
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        String taskId = ((Task)this.taskService.createTaskQuery().singleResult()).getId();
        this.identityService.setAuthenticatedUserId("aAssignerId");
        this.taskService.addCandidateGroup(taskId, "aGroupId");
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        Assert.assertEquals((long)this.historyService.createHistoricTaskInstanceQuery().count(), (long)2L);
        Assert.assertEquals((long)this.historyService.createHistoricTaskInstanceQuery().withoutCandidateGroups().count(), (long)1L);
        this.taskService.deleteTask("newTask", true);
    }

    @Test
    @RequiredHistoryLevel(value="full")
    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/oneTaskProcess.bpmn20.xml"})
    public void testGroupTaskQuery() {
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        String taskId = ((Task)this.taskService.createTaskQuery().singleResult()).getId();
        this.identityService.setAuthenticatedUserId("aAssignerId");
        this.taskService.addCandidateUser(taskId, "aUserId");
        this.taskService.addCandidateGroup(taskId, "aGroupId");
        this.taskService.addCandidateGroup(taskId, "bGroupId");
        Task taskOne = this.taskService.newTask("taskOne");
        taskOne.setAssignee("aUserId");
        this.taskService.saveTask(taskOne);
        Task taskTwo = this.taskService.newTask("taskTwo");
        taskTwo.setAssignee("aUserId");
        this.taskService.saveTask(taskTwo);
        Task taskThree = this.taskService.newTask("taskThree");
        taskThree.setOwner("aUserId");
        this.taskService.saveTask(taskThree);
        this.taskService.deleteCandidateGroup(taskId, "aGroupId");
        this.taskService.deleteCandidateGroup(taskId, "bGroupId");
        this.historyService.createHistoricTaskInstanceQuery();
        HistoricTaskInstanceQuery query = this.historyService.createHistoricTaskInstanceQuery();
        Assert.assertEquals((long)4L, (long)query.taskInvolvedUser("aUserId").count());
        query = this.historyService.createHistoricTaskInstanceQuery();
        Assert.assertEquals((long)1L, (long)query.taskHadCandidateUser("aUserId").count());
        query = this.historyService.createHistoricTaskInstanceQuery();
        Assert.assertEquals((long)1L, (long)query.taskHadCandidateGroup("aGroupId").count());
        Assert.assertEquals((long)1L, (long)query.taskHadCandidateGroup("bGroupId").count());
        Assert.assertEquals((long)0L, (long)query.taskInvolvedUser("aUserId").count());
        query = this.historyService.createHistoricTaskInstanceQuery();
        Assert.assertEquals((long)4L, (long)query.taskInvolvedUser("aUserId").count());
        Assert.assertEquals((long)1L, (long)query.taskHadCandidateUser("aUserId").count());
        Assert.assertEquals((long)1L, (long)query.taskInvolvedUser("aUserId").count());
        this.taskService.deleteTask("taskOne", true);
        this.taskService.deleteTask("taskTwo", true);
        this.taskService.deleteTask("taskThree", true);
    }

    @Test
    @RequiredHistoryLevel(value="full")
    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/oneTaskProcess.bpmn20.xml"})
    public void testTaskWasAssigned() {
        Task taskOne = this.taskService.newTask("taskOne");
        Task taskTwo = this.taskService.newTask("taskTwo");
        Task taskThree = this.taskService.newTask("taskThree");
        taskOne.setAssignee("aUserId");
        this.taskService.saveTask(taskOne);
        taskTwo.setAssignee("anotherUserId");
        this.taskService.saveTask(taskTwo);
        this.taskService.saveTask(taskThree);
        List list = this.historyService.createHistoricTaskInstanceQuery().taskAssigned().list();
        Assert.assertEquals((long)list.size(), (long)2L);
        this.taskService.deleteTask("taskOne", true);
        this.taskService.deleteTask("taskTwo", true);
        this.taskService.deleteTask("taskThree", true);
    }

    @Test
    @RequiredHistoryLevel(value="full")
    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/oneTaskProcess.bpmn20.xml"})
    public void testTaskWasUnassigned() {
        Task taskOne = this.taskService.newTask("taskOne");
        Task taskTwo = this.taskService.newTask("taskTwo");
        Task taskThree = this.taskService.newTask("taskThree");
        taskOne.setAssignee("aUserId");
        this.taskService.saveTask(taskOne);
        taskTwo.setAssignee("anotherUserId");
        this.taskService.saveTask(taskTwo);
        this.taskService.saveTask(taskThree);
        List list = this.historyService.createHistoricTaskInstanceQuery().taskUnassigned().list();
        Assert.assertEquals((long)list.size(), (long)1L);
        this.taskService.deleteTask("taskOne", true);
        this.taskService.deleteTask("taskTwo", true);
        this.taskService.deleteTask("taskThree", true);
    }

    @Test
    @RequiredHistoryLevel(value="full")
    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/oneTaskProcess.bpmn20.xml"})
    public void testTaskReturnedBeforeEndTime() {
        Task taskOne = this.taskService.newTask("taskOne");
        taskOne.setAssignee("aUserId");
        this.taskService.saveTask(taskOne);
        Calendar hourAgo = Calendar.getInstance();
        hourAgo.add(11, -1);
        ClockUtil.setCurrentTime((Date)hourAgo.getTime());
        this.taskService.complete(taskOne.getId());
        List list = this.historyService.createHistoricTaskInstanceQuery().finishedBefore(hourAgo.getTime()).list();
        Assert.assertEquals((long)1L, (long)list.size());
        this.taskService.deleteTask("taskOne", true);
        ClockUtil.reset();
    }

    @Test
    @RequiredHistoryLevel(value="full")
    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/oneTaskProcess.bpmn20.xml"})
    public void testTaskNotReturnedAfterEndTime() {
        Task taskOne = this.taskService.newTask("taskOne");
        taskOne.setAssignee("aUserId");
        this.taskService.saveTask(taskOne);
        Calendar hourAgo = Calendar.getInstance();
        hourAgo.add(11, -1);
        ClockUtil.setCurrentTime((Date)hourAgo.getTime());
        this.taskService.complete(taskOne.getId());
        List list = this.historyService.createHistoricTaskInstanceQuery().finishedAfter(Calendar.getInstance().getTime()).list();
        Assert.assertEquals((long)0L, (long)list.size());
        this.taskService.deleteTask("taskOne", true);
        ClockUtil.reset();
    }

    private void assertThatListContainsOnlyExpectedElement(List<HistoricTaskInstance> instances, ProcessInstance instance) {
        Assertions.assertThat((int)instances.size()).isEqualTo(1);
        Assertions.assertThat((String)instances.get(0).getProcessInstanceId()).isEqualTo((Object)instance.getId());
    }

    private HistoricTaskInstanceQuery queryNameIgnoreCase() {
        return this.historyService.createHistoricTaskInstanceQuery().matchVariableNamesIgnoreCase();
    }

    private HistoricTaskInstanceQuery queryValueIgnoreCase() {
        return this.historyService.createHistoricTaskInstanceQuery().matchVariableValuesIgnoreCase();
    }

    private HistoricTaskInstanceQuery queryNameValueIgnoreCase() {
        return this.historyService.createHistoricTaskInstanceQuery().matchVariableNamesIgnoreCase().matchVariableValuesIgnoreCase();
    }

    static {
        VARIABLES.put(VARIABLE_NAME, VARIABLE_VALUE);
    }
}

