/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.container.impl.deployment;

import java.util.Map;
import org.camunda.bpm.application.AbstractProcessApplication;
import org.camunda.bpm.container.impl.ContainerIntegrationLogger;
import org.camunda.bpm.container.impl.jmx.services.JmxManagedProcessEngineController;
import org.camunda.bpm.container.impl.metadata.PropertyHelper;
import org.camunda.bpm.container.impl.metadata.spi.ProcessEnginePluginXml;
import org.camunda.bpm.container.impl.metadata.spi.ProcessEngineXml;
import org.camunda.bpm.container.impl.spi.DeploymentOperation;
import org.camunda.bpm.container.impl.spi.DeploymentOperationStep;
import org.camunda.bpm.container.impl.spi.PlatformServiceContainer;
import org.camunda.bpm.container.impl.spi.ServiceTypes;
import org.camunda.bpm.engine.impl.ProcessEngineLogger;
import org.camunda.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.camunda.bpm.engine.impl.cfg.ProcessEnginePlugin;
import org.camunda.bpm.engine.impl.cfg.StandaloneProcessEngineConfiguration;
import org.camunda.bpm.engine.impl.jobexecutor.JobExecutor;
import org.camunda.bpm.engine.impl.persistence.StrongUuidGenerator;
import org.camunda.bpm.engine.impl.util.EnsureUtil;
import org.camunda.bpm.engine.impl.util.ReflectUtil;

public class StartProcessEngineStep
extends DeploymentOperationStep {
    private static final ContainerIntegrationLogger LOG = ProcessEngineLogger.CONTAINER_INTEGRATION_LOGGER;
    protected final ProcessEngineXml processEngineXml;

    public StartProcessEngineStep(ProcessEngineXml processEngineXml) {
        this.processEngineXml = processEngineXml;
    }

    @Override
    public String getName() {
        return "Start process engine " + this.processEngineXml.getName();
    }

    @Override
    public void performOperationStep(DeploymentOperation operationContext) {
        ProcessEngineConfigurationImpl configuration;
        String configurationClassName;
        PlatformServiceContainer serviceContainer = operationContext.getServiceContainer();
        AbstractProcessApplication processApplication = (AbstractProcessApplication)operationContext.getAttachment("processApplication");
        ClassLoader classLoader = null;
        if (processApplication != null) {
            classLoader = processApplication.getProcessApplicationClassloader();
        }
        if ((configurationClassName = this.processEngineXml.getConfigurationClass()) == null || configurationClassName.isEmpty()) {
            configurationClassName = StandaloneProcessEngineConfiguration.class.getName();
        }
        Class<ProcessEngineConfigurationImpl> configurationClass = this.loadClass(configurationClassName, classLoader, ProcessEngineConfigurationImpl.class);
        ProcessEngineConfigurationImpl configurationImpl = configuration = this.createInstance(configurationClass);
        configurationImpl.setIdGenerator(new StrongUuidGenerator());
        String name = this.processEngineXml.getName();
        configuration.setProcessEngineName(name);
        String datasourceJndiName = this.processEngineXml.getDatasource();
        configuration.setDataSourceJndiName(datasourceJndiName);
        Map<String, String> properties = this.processEngineXml.getProperties();
        this.setJobExecutorActivate(configuration, properties);
        PropertyHelper.applyProperties(configuration, properties);
        this.configurePlugins(configuration, this.processEngineXml, classLoader);
        this.addAdditionalPlugins(configuration);
        if (this.processEngineXml.getJobAcquisitionName() != null && !this.processEngineXml.getJobAcquisitionName().isEmpty()) {
            JobExecutor jobExecutor = this.getJobExecutorService(serviceContainer);
            EnsureUtil.ensureNotNull("Cannot find referenced job executor with name '" + this.processEngineXml.getJobAcquisitionName() + "'", "jobExecutor", (Object)jobExecutor);
            configurationImpl.setJobExecutor(jobExecutor);
        }
        JmxManagedProcessEngineController managedProcessEngineService = this.createProcessEngineControllerInstance(configuration);
        serviceContainer.startService(ServiceTypes.PROCESS_ENGINE, configuration.getProcessEngineName(), managedProcessEngineService);
    }

    protected void setJobExecutorActivate(ProcessEngineConfigurationImpl configuration, Map<String, String> properties) {
        configuration.setJobExecutorActivate(true);
    }

    protected JmxManagedProcessEngineController createProcessEngineControllerInstance(ProcessEngineConfigurationImpl configuration) {
        return new JmxManagedProcessEngineController(configuration);
    }

    protected void configurePlugins(ProcessEngineConfigurationImpl configuration, ProcessEngineXml processEngineXml, ClassLoader classLoader) {
        for (ProcessEnginePluginXml pluginXml : processEngineXml.getPlugins()) {
            Class<ProcessEnginePlugin> pluginClass = this.loadClass(pluginXml.getPluginClass(), classLoader, ProcessEnginePlugin.class);
            ProcessEnginePlugin plugin = this.createInstance(pluginClass);
            Map<String, String> properties = pluginXml.getProperties();
            PropertyHelper.applyProperties(plugin, properties);
            configuration.getProcessEnginePlugins().add(plugin);
        }
    }

    protected JobExecutor getJobExecutorService(PlatformServiceContainer serviceContainer) {
        String jobAcquisitionName = this.processEngineXml.getJobAcquisitionName();
        JobExecutor jobExecutor = (JobExecutor)serviceContainer.getServiceValue(ServiceTypes.JOB_EXECUTOR, jobAcquisitionName);
        return jobExecutor;
    }

    protected <T> T createInstance(Class<? extends T> clazz) {
        return ReflectUtil.instantiate(clazz);
    }

    protected <T> Class<? extends T> loadClass(String className, ClassLoader customClassloader, Class<T> clazz) {
        try {
            if (customClassloader != null) {
                return customClassloader.loadClass(className);
            }
            return ReflectUtil.loadClass(className);
        }
        catch (ClassNotFoundException e) {
            throw LOG.camnnotLoadConfigurationClass(className, e);
        }
        catch (ClassCastException e) {
            throw LOG.configurationClassHasWrongType(className, clazz, e);
        }
    }

    public void addAdditionalPlugins(ProcessEngineConfigurationImpl configuration) {
    }
}

