/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.cmd.batch.variables;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.camunda.bpm.engine.BadUserRequestException;
import org.camunda.bpm.engine.authorization.BatchPermissions;
import org.camunda.bpm.engine.batch.Batch;
import org.camunda.bpm.engine.history.HistoricProcessInstanceQuery;
import org.camunda.bpm.engine.impl.HistoricProcessInstanceQueryImpl;
import org.camunda.bpm.engine.impl.ProcessInstanceQueryImpl;
import org.camunda.bpm.engine.impl.batch.BatchConfiguration;
import org.camunda.bpm.engine.impl.batch.BatchElementConfiguration;
import org.camunda.bpm.engine.impl.batch.DeploymentMappings;
import org.camunda.bpm.engine.impl.batch.builder.BatchBuilder;
import org.camunda.bpm.engine.impl.cmd.CommandLogger;
import org.camunda.bpm.engine.impl.core.variable.VariableUtil;
import org.camunda.bpm.engine.impl.interceptor.Command;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.persistence.entity.PropertyChange;
import org.camunda.bpm.engine.impl.persistence.entity.VariableInstanceEntity;
import org.camunda.bpm.engine.impl.util.CollectionUtil;
import org.camunda.bpm.engine.impl.util.EnsureUtil;
import org.camunda.bpm.engine.impl.util.ImmutablePair;
import org.camunda.bpm.engine.runtime.ProcessInstanceQuery;
import org.camunda.bpm.engine.variable.Variables;
import org.camunda.bpm.engine.variable.value.TypedValue;

public class SetVariablesToProcessInstancesBatchCmd
implements Command<Batch> {
    protected static final CommandLogger LOGGER = CommandLogger.CMD_LOGGER;
    protected List<String> processInstanceIds;
    protected ProcessInstanceQuery processInstanceQuery;
    protected HistoricProcessInstanceQuery historicProcessInstanceQuery;
    protected Map<String, ?> variables;

    public SetVariablesToProcessInstancesBatchCmd(List<String> processInstanceIds, ProcessInstanceQuery processInstanceQuery, HistoricProcessInstanceQuery historicProcessInstanceQuery, Map<String, ?> variables) {
        this.processInstanceIds = processInstanceIds;
        this.processInstanceQuery = processInstanceQuery;
        this.historicProcessInstanceQuery = historicProcessInstanceQuery;
        this.variables = variables;
    }

    @Override
    public Batch execute(CommandContext commandContext) {
        EnsureUtil.ensureNotNull("variables", this.variables);
        EnsureUtil.ensureNotEmpty(BadUserRequestException.class, "variables", this.variables);
        EnsureUtil.ensureAtLeastOneNotNull("No process instances found.", this.processInstanceIds, this.processInstanceQuery, this.historicProcessInstanceQuery);
        BatchElementConfiguration elementConfiguration = this.collectProcessInstanceIds(commandContext);
        List<String> ids = elementConfiguration.getIds();
        EnsureUtil.ensureNotEmpty(BadUserRequestException.class, "processInstanceIds", ids);
        BatchConfiguration configuration = this.getConfiguration(elementConfiguration);
        Batch batch = new BatchBuilder(commandContext).type("set-variables").config(configuration).permission(BatchPermissions.CREATE_BATCH_SET_VARIABLES).operationLogHandler(this::writeUserOperationLog).build();
        String batchId = batch.getId();
        VariableUtil.setVariables(this.variables, (name, value) -> this.setVariable(batchId, name, value));
        return batch;
    }

    protected void writeUserOperationLog(CommandContext commandContext, int instancesCount) {
        ArrayList<PropertyChange> propChanges = new ArrayList<PropertyChange>();
        int variablesCount = this.variables.size();
        propChanges.add(new PropertyChange("nrOfInstances", null, instancesCount));
        propChanges.add(new PropertyChange("nrOfVariables", null, variablesCount));
        propChanges.add(new PropertyChange("async", null, true));
        commandContext.getOperationLogManager().logProcessInstanceOperation("SetVariables", propChanges);
    }

    protected void setVariable(String batchId, String variableName, Object variableValue) {
        TypedValue variableTypedValue = Variables.untypedValue((Object)variableValue);
        boolean isTransient = variableTypedValue.isTransient();
        if (isTransient) {
            throw LOGGER.exceptionSettingTransientVariablesAsyncNotSupported(variableName);
        }
        VariableUtil.checkJavaSerialization(variableName, variableTypedValue);
        VariableInstanceEntity variableInstance = VariableInstanceEntity.createAndInsert(variableName, variableTypedValue);
        variableInstance.setVariableScopeId(batchId);
    }

    public BatchConfiguration getConfiguration(BatchElementConfiguration elementConfiguration) {
        DeploymentMappings mappings = elementConfiguration.getMappings();
        List<String> ids = elementConfiguration.getIds();
        return new BatchConfiguration(ids, mappings);
    }

    protected BatchElementConfiguration collectProcessInstanceIds(CommandContext commandContext) {
        HistoricProcessInstanceQueryImpl historicProcessInstanceQuery;
        ProcessInstanceQueryImpl processInstanceQuery;
        List mappings;
        BatchElementConfiguration elementConfiguration = new BatchElementConfiguration();
        if (!CollectionUtil.isEmpty(this.processInstanceIds)) {
            ProcessInstanceQueryImpl query = new ProcessInstanceQueryImpl();
            query.processInstanceIds(new HashSet<String>(this.processInstanceIds));
            mappings = commandContext.runWithoutAuthorization(query::listDeploymentIdMappings);
            elementConfiguration.addDeploymentMappings(mappings);
        }
        if ((processInstanceQuery = (ProcessInstanceQueryImpl)this.processInstanceQuery) != null) {
            mappings = processInstanceQuery.listDeploymentIdMappings();
            elementConfiguration.addDeploymentMappings(mappings);
        }
        if ((historicProcessInstanceQuery = (HistoricProcessInstanceQueryImpl)this.historicProcessInstanceQuery) != null) {
            historicProcessInstanceQuery.unfinished();
            List<ImmutablePair<String, String>> mappings2 = historicProcessInstanceQuery.listDeploymentIdMappings();
            elementConfiguration.addDeploymentMappings(mappings2);
        }
        return elementConfiguration;
    }
}

