/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.telemetry.reporter;

import java.util.Timer;
import java.util.TimerTask;
import org.camunda.bpm.engine.impl.ProcessEngineLogger;
import org.camunda.bpm.engine.impl.interceptor.CommandExecutor;
import org.camunda.bpm.engine.impl.telemetry.TelemetryLogger;
import org.camunda.bpm.engine.impl.telemetry.dto.Data;
import org.camunda.bpm.engine.impl.telemetry.reporter.TelemetrySendingTask;
import org.camunda.connect.spi.Connector;
import org.camunda.connect.spi.ConnectorRequest;

public class TelemetryReporter {
    protected static final TelemetryLogger LOG = ProcessEngineLogger.TELEMETRY_LOGGER;
    protected long reportingIntervalInSeconds = 86400L;
    protected TelemetrySendingTask telemetrySendingTask;
    protected Timer timer;
    protected CommandExecutor commandExecutor;
    protected String telemetryEndpoint;
    protected Data data;
    protected Connector<? extends ConnectorRequest<?>> httpConnector;
    protected boolean stopped;

    public TelemetryReporter(CommandExecutor commandExecutor, String telemetryEndpoint, Data data, Connector<? extends ConnectorRequest<?>> httpConnector) {
        this.commandExecutor = commandExecutor;
        this.telemetryEndpoint = telemetryEndpoint;
        this.data = data;
        this.httpConnector = httpConnector;
        this.initTelemetrySendingTask();
    }

    protected void initTelemetrySendingTask() {
        this.telemetrySendingTask = new TelemetrySendingTask(this.commandExecutor, this.telemetryEndpoint, this.data, this.httpConnector);
    }

    public synchronized void start() {
        if (this.stopped) {
            this.initTelemetrySendingTask();
        }
        if (this.timer == null) {
            this.timer = new Timer("Camunda BPM Runtime Telemetry Reporter", true);
            long reportingIntervalInMillis = this.reportingIntervalInSeconds * 1000L;
            try {
                this.timer.scheduleAtFixedRate((TimerTask)this.telemetrySendingTask, reportingIntervalInMillis, reportingIntervalInMillis);
            }
            catch (Exception e) {
                LOG.schedulingTaskFails(e.getMessage());
            }
        }
    }

    public synchronized void stop() {
        if (this.timer != null) {
            this.timer.cancel();
            this.timer = null;
            this.reportNow();
        }
        this.stopped = true;
    }

    public void reportNow() {
        if (this.telemetrySendingTask != null) {
            this.telemetrySendingTask.run();
        }
    }

    public long getReportingIntervalInSeconds() {
        return this.reportingIntervalInSeconds;
    }

    public TelemetrySendingTask getTelemetrySendingTask() {
        return this.telemetrySendingTask;
    }

    public void setTelemetrySendingTask(TelemetrySendingTask telemetrySendingTask) {
        this.telemetrySendingTask = telemetrySendingTask;
    }

    public String getTelemetryEndpoint() {
        return this.telemetryEndpoint;
    }

    public Connector<? extends ConnectorRequest<?>> getHttpConnector() {
        return this.httpConnector;
    }
}

