/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.telemetry.reporter;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TimerTask;
import org.camunda.bpm.engine.history.HistoricTaskInstance;
import org.camunda.bpm.engine.impl.ProcessEngineLogger;
import org.camunda.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.camunda.bpm.engine.impl.history.HistoryLevel;
import org.camunda.bpm.engine.impl.interceptor.CommandExecutor;
import org.camunda.bpm.engine.impl.telemetry.CommandCounter;
import org.camunda.bpm.engine.impl.telemetry.TelemetryLogger;
import org.camunda.bpm.engine.impl.telemetry.TelemetryRegistry;
import org.camunda.bpm.engine.impl.telemetry.dto.ApplicationServer;
import org.camunda.bpm.engine.impl.telemetry.dto.Command;
import org.camunda.bpm.engine.impl.telemetry.dto.Data;
import org.camunda.bpm.engine.impl.telemetry.dto.Internals;
import org.camunda.bpm.engine.impl.telemetry.dto.Metric;
import org.camunda.bpm.engine.impl.util.ClockUtil;
import org.camunda.bpm.engine.impl.util.ConnectUtil;
import org.camunda.bpm.engine.impl.util.JsonUtil;
import org.camunda.connect.spi.CloseableConnectorResponse;
import org.camunda.connect.spi.Connector;
import org.camunda.connect.spi.ConnectorRequest;

public class TelemetrySendingTask
extends TimerTask {
    protected static final TelemetryLogger LOG = ProcessEngineLogger.TELEMETRY_LOGGER;
    protected CommandExecutor commandExecutor;
    protected String telemetryEndpoint;
    protected Data data;
    protected Connector<? extends ConnectorRequest<?>> httpConnector;

    public TelemetrySendingTask(CommandExecutor commandExecutor, String telemetryEndpoint, Data data, Connector<? extends ConnectorRequest<?>> httpConnector) {
        this.commandExecutor = commandExecutor;
        this.telemetryEndpoint = telemetryEndpoint;
        this.data = data;
        this.httpConnector = httpConnector;
    }

    @Override
    public void run() {
        LOG.startTelemetrySendingTask();
        try {
            this.sendData();
        }
        catch (Exception e) {
            LOG.exceptionWhileSendingTelemetryData(e);
        }
    }

    protected void sendData() {
        this.commandExecutor.execute(commandContext -> {
            block6: {
                ProcessEngineConfigurationImpl processEngineConfiguration = commandContext.getProcessEngineConfiguration();
                if (processEngineConfiguration.getManagementService().isTelemetryEnabled().booleanValue()) {
                    try {
                        this.resolveData(processEngineConfiguration);
                        String telemetryData = JsonUtil.asString(this.data);
                        Map<String, Object> requestParams = ConnectUtil.assembleRequestParameters("POST", this.telemetryEndpoint, "application/json", telemetryData);
                        ConnectorRequest request = this.httpConnector.createRequest();
                        request.setRequestParameters(requestParams);
                        CloseableConnectorResponse response = (CloseableConnectorResponse)request.execute();
                        if (response == null) {
                            LOG.unexpectedResponseWhileSendingTelemetryData();
                            break block6;
                        }
                        int responseCode = (Integer)response.getResponseParameter("statusCode");
                        if (responseCode != 202) {
                            LOG.unexpectedResponseWhileSendingTelemetryData(responseCode);
                            break block6;
                        }
                        LOG.telemetryDataSent(telemetryData);
                        processEngineConfiguration.getTelemetryRegistry().setStartReportTime(ClockUtil.getCurrentTime());
                    }
                    catch (Exception e) {
                        LOG.exceptionWhileSendingTelemetryData(e);
                    }
                } else {
                    LOG.telemetryDisabled();
                }
            }
            return null;
        });
    }

    protected void resolveData(ProcessEngineConfigurationImpl processEngineConfiguration) {
        Internals internals = this.data.getProduct().getInternals();
        ApplicationServer applicationServer = processEngineConfiguration.getTelemetryRegistry().getApplicationServer();
        if (internals.getApplicationServer() == null && applicationServer != null) {
            internals.setApplicationServer(applicationServer);
        }
        Map<String, Command> commands = this.fetchAndResetCommandCounts(processEngineConfiguration);
        internals.setCommands(commands);
        Map<String, Metric> metrics = this.calculateMetrics(processEngineConfiguration);
        internals.setMetrics(metrics);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Map<String, Command> fetchAndResetCommandCounts(ProcessEngineConfigurationImpl processEngineConfiguration) {
        HashMap<String, CommandCounter> copiedCounts;
        Map<String, CommandCounter> originalCounts;
        HashMap<String, Command> commandsToReport = new HashMap<String, Command>();
        Map<String, CommandCounter> map = originalCounts = processEngineConfiguration.getTelemetryRegistry().getCommands();
        synchronized (map) {
            copiedCounts = new HashMap<String, CommandCounter>(originalCounts);
            originalCounts.clear();
        }
        copiedCounts.forEach((k, v) -> commandsToReport.put((String)k, new Command(v.get())));
        return commandsToReport;
    }

    protected Map<String, Metric> calculateMetrics(ProcessEngineConfigurationImpl processEngineConfiguration) {
        TelemetryRegistry telemetryRegistry = processEngineConfiguration.getTelemetryRegistry();
        Date startReportTime = telemetryRegistry.getStartReportTime();
        Date currentTime = ClockUtil.getCurrentTime();
        HashMap<String, Metric> metrics = new HashMap<String, Metric>();
        long sum = this.calculateMetricCount(processEngineConfiguration, startReportTime, currentTime, "root-process-instance-start");
        metrics.put("root-process-instances", new Metric(sum));
        sum = this.calculateMetricCount(processEngineConfiguration, startReportTime, currentTime, "executed-decision-instances");
        metrics.put("executed-decision-instances", new Metric(sum));
        sum = this.calculateMetricCount(processEngineConfiguration, startReportTime, currentTime, "activity-instance-start");
        metrics.put("flow-node-instances", new Metric(sum));
        sum = this.calculateUniqueUserCount(processEngineConfiguration, startReportTime, currentTime);
        metrics.put("unique-task-workers", new Metric(sum));
        return metrics;
    }

    protected long calculateMetricCount(ProcessEngineConfigurationImpl processEngineConfiguration, Date startReportTime, Date currentTime, String metricName) {
        return processEngineConfiguration.getManagementService().createMetricsQuery().name(metricName).startDate(startReportTime).endDate(currentTime).sum();
    }

    protected long calculateUniqueUserCount(ProcessEngineConfigurationImpl processEngineConfiguration, Date startReportTime, Date currentTime) {
        if (processEngineConfiguration.getHistoryLevel().equals(HistoryLevel.HISTORY_LEVEL_NONE)) {
            return 0L;
        }
        List historicTaskInstances = processEngineConfiguration.getHistoryService().createHistoricTaskInstanceQuery().startedAfter(startReportTime).startedBefore(currentTime).taskAssigned().list();
        return historicTaskInstances.stream().map(HistoricTaskInstance::getAssignee).distinct().count();
    }
}

