/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.identity;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.time.DateUtils;
import org.camunda.bpm.engine.AuthorizationException;
import org.camunda.bpm.engine.authorization.Authorization;
import org.camunda.bpm.engine.authorization.MissingAuthorization;
import org.camunda.bpm.engine.authorization.Permission;
import org.camunda.bpm.engine.authorization.Permissions;
import org.camunda.bpm.engine.authorization.Resource;
import org.camunda.bpm.engine.authorization.Resources;
import org.camunda.bpm.engine.identity.Group;
import org.camunda.bpm.engine.identity.Tenant;
import org.camunda.bpm.engine.identity.TenantQuery;
import org.camunda.bpm.engine.identity.User;
import org.camunda.bpm.engine.impl.persistence.entity.AuthorizationEntity;
import org.camunda.bpm.engine.impl.persistence.entity.GroupEntity;
import org.camunda.bpm.engine.impl.persistence.entity.TenantEntity;
import org.camunda.bpm.engine.impl.persistence.entity.UserEntity;
import org.camunda.bpm.engine.impl.util.ClockUtil;
import org.camunda.bpm.engine.test.api.authorization.util.AuthorizationTestUtil;
import org.camunda.bpm.engine.test.util.PluggableProcessEngineTest;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;

public class IdentityServiceAuthorizationsTest
extends PluggableProcessEngineTest {
    private static final String jonny2 = "jonny2";

    @After
    public void tearDown() throws Exception {
        this.processEngineConfiguration.setAuthorizationEnabled(false);
        this.cleanupAfterTest();
    }

    @Test
    public void testUserCreateAuthorizations() {
        Authorization basePerms = this.authorizationService.createNewAuthorization(0);
        basePerms.setResource((Resource)Resources.USER);
        basePerms.setResourceId("*");
        basePerms.addPermission((Permission)Permissions.ALL);
        basePerms.removePermission((Permission)Permissions.CREATE);
        this.authorizationService.saveAuthorization(basePerms);
        this.processEngineConfiguration.setAuthorizationEnabled(true);
        this.identityService.setAuthenticatedUserId(jonny2);
        try {
            this.identityService.newUser("jonny1");
            Assert.fail((String)"exception expected");
        }
        catch (AuthorizationException e) {
            Assert.assertEquals((long)1L, (long)e.getMissingAuthorizations().size());
            MissingAuthorization info = (MissingAuthorization)e.getMissingAuthorizations().get(0);
            Assert.assertEquals((Object)jonny2, (Object)e.getUserId());
            AuthorizationTestUtil.assertExceptionInfo(Permissions.CREATE.getName(), Resources.USER.resourceName(), null, info);
        }
        UserEntity newUser = new UserEntity("jonny1");
        try {
            this.identityService.saveUser((User)newUser);
            Assert.fail((String)"exception expected");
        }
        catch (AuthorizationException e) {
            Assert.assertEquals((long)1L, (long)e.getMissingAuthorizations().size());
            MissingAuthorization info = (MissingAuthorization)e.getMissingAuthorizations().get(0);
            Assert.assertEquals((Object)jonny2, (Object)e.getUserId());
            AuthorizationTestUtil.assertExceptionInfo(Permissions.CREATE.getName(), Resources.USER.resourceName(), null, info);
        }
    }

    @Test
    public void testUserDeleteAuthorizations() {
        User jonny1 = this.identityService.newUser("jonny1");
        this.identityService.saveUser(jonny1);
        Authorization basePerms = this.authorizationService.createNewAuthorization(0);
        basePerms.setResource((Resource)Resources.USER);
        basePerms.setResourceId("*");
        basePerms.addPermission((Permission)Permissions.ALL);
        basePerms.removePermission((Permission)Permissions.DELETE);
        this.authorizationService.saveAuthorization(basePerms);
        this.processEngineConfiguration.setAuthorizationEnabled(true);
        this.identityService.setAuthenticatedUserId(jonny2);
        try {
            this.identityService.deleteUser("jonny1");
            Assert.fail((String)"exception expected");
        }
        catch (AuthorizationException e) {
            Assert.assertEquals((long)1L, (long)e.getMissingAuthorizations().size());
            MissingAuthorization info = (MissingAuthorization)e.getMissingAuthorizations().get(0);
            Assert.assertEquals((Object)jonny2, (Object)e.getUserId());
            AuthorizationTestUtil.assertExceptionInfo(Permissions.DELETE.getName(), Resources.USER.resourceName(), "jonny1", info);
        }
    }

    @Test
    public void testTenantAuthorizationAfterDeleteUser() {
        User jonny = this.identityService.newUser(jonny2);
        this.identityService.saveUser(jonny);
        this.grantPermissions();
        this.processEngineConfiguration.setAuthorizationEnabled(true);
        this.identityService.setAuthenticatedUserId(jonny2);
        User jonny1 = this.identityService.newUser("jonny1");
        this.identityService.saveUser(jonny1);
        String jonny1Id = jonny1.getId();
        String tenant1 = "tenant1";
        Tenant tenant = this.identityService.newTenant(tenant1);
        this.identityService.saveTenant(tenant);
        this.identityService.createTenantUserMembership(tenant1, jonny1Id);
        TenantQuery query = this.identityService.createTenantQuery().userMember(jonny1Id);
        Assert.assertThat((Object)query.count(), (Matcher)CoreMatchers.is((Object)1L));
        this.identityService.deleteUser(jonny1Id);
        this.processEngineConfiguration.setAuthorizationEnabled(false);
        Assert.assertThat((Object)query.count(), (Matcher)CoreMatchers.is((Object)0L));
        Assert.assertThat((Object)this.authorizationService.createAuthorizationQuery().resourceType((Resource)Resources.TENANT).userIdIn(new String[]{jonny1Id}).count(), (Matcher)CoreMatchers.is((Object)0L));
    }

    @Test
    public void testUserUpdateAuthorizations() {
        User jonny1 = this.identityService.newUser("jonny1");
        this.identityService.saveUser(jonny1);
        Authorization basePerms = this.authorizationService.createNewAuthorization(0);
        basePerms.setResource((Resource)Resources.USER);
        basePerms.setResourceId("*");
        basePerms.addPermission((Permission)Permissions.ALL);
        basePerms.removePermission((Permission)Permissions.UPDATE);
        this.authorizationService.saveAuthorization(basePerms);
        this.processEngineConfiguration.setAuthorizationEnabled(true);
        this.identityService.setAuthenticatedUserId(jonny2);
        jonny1 = (User)this.identityService.createUserQuery().singleResult();
        jonny1.setFirstName("Jonny");
        try {
            this.identityService.saveUser(jonny1);
            Assert.fail((String)"exception expected");
        }
        catch (AuthorizationException e) {
            Assert.assertEquals((long)1L, (long)e.getMissingAuthorizations().size());
            MissingAuthorization info = (MissingAuthorization)e.getMissingAuthorizations().get(0);
            Assert.assertEquals((Object)jonny2, (Object)e.getUserId());
            AuthorizationTestUtil.assertExceptionInfo(Permissions.UPDATE.getName(), Resources.USER.resourceName(), "jonny1", info);
        }
        User jonny3 = this.identityService.newUser("jonny3");
        this.identityService.saveUser(jonny3);
    }

    @Test
    public void testUserUnlock() throws ParseException {
        String userId = "jonny";
        User jonny = this.identityService.newUser(userId);
        jonny.setPassword("xxx");
        this.identityService.saveUser(jonny);
        this.lockUser(userId, "invalid pwd");
        int maxNumOfAttempts = 10;
        UserEntity lockedUser = (UserEntity)this.identityService.createUserQuery().userId(jonny.getId()).singleResult();
        Assert.assertNotNull((Object)lockedUser);
        Assert.assertNotNull((Object)lockedUser.getLockExpirationTime());
        Assert.assertEquals((long)maxNumOfAttempts, (long)lockedUser.getAttempts());
        Authorization basePerms = this.authorizationService.createNewAuthorization(0);
        basePerms.setResource((Resource)Resources.USER);
        basePerms.setResourceId("*");
        basePerms.addPermission((Permission)Permissions.ALL);
        this.authorizationService.saveAuthorization(basePerms);
        this.processEngineConfiguration.setAuthorizationEnabled(true);
        this.identityService.setAuthentication("admin", Collections.singletonList("camunda-admin"), null);
        this.identityService.unlockUser(lockedUser.getId());
        lockedUser = (UserEntity)this.identityService.createUserQuery().userId(jonny.getId()).singleResult();
        Assert.assertNotNull((Object)lockedUser);
        Assert.assertNull((Object)lockedUser.getLockExpirationTime());
        Assert.assertEquals((long)0L, (long)lockedUser.getAttempts());
    }

    @Test
    public void testUserUnlockWithoutAuthorization() throws ParseException {
        String userId = "jonny";
        User jonny = this.identityService.newUser(userId);
        jonny.setPassword("xxx");
        this.identityService.saveUser(jonny);
        this.lockUser(userId, "invalid pwd");
        int maxNumOfAttempts = 10;
        UserEntity lockedUser = (UserEntity)this.identityService.createUserQuery().userId(jonny.getId()).singleResult();
        Assert.assertNotNull((Object)lockedUser);
        Assert.assertNotNull((Object)lockedUser.getLockExpirationTime());
        Assert.assertEquals((long)maxNumOfAttempts, (long)lockedUser.getAttempts());
        this.processEngineConfiguration.setAuthorizationEnabled(true);
        this.identityService.setAuthentication("admin", null, null);
        try {
            this.identityService.unlockUser(lockedUser.getId());
            Assert.fail((String)"expected exception");
        }
        catch (AuthorizationException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("ENGINE-03029 Required admin authenticated group or user."));
        }
        this.processEngineConfiguration.setAuthorizationEnabled(false);
        int maxNumOfLoginAttempts = 10;
        lockedUser = (UserEntity)this.identityService.createUserQuery().userId(jonny.getId()).singleResult();
        Assert.assertNotNull((Object)lockedUser);
        Assert.assertNotNull((Object)lockedUser.getLockExpirationTime());
        Assert.assertEquals((long)maxNumOfLoginAttempts, (long)lockedUser.getAttempts());
    }

    @Test
    public void testGroupCreateAuthorizations() {
        Authorization basePerms = this.authorizationService.createNewAuthorization(0);
        basePerms.setResource((Resource)Resources.GROUP);
        basePerms.setResourceId("*");
        basePerms.addPermission((Permission)Permissions.ALL);
        basePerms.removePermission((Permission)Permissions.CREATE);
        this.authorizationService.saveAuthorization(basePerms);
        this.processEngineConfiguration.setAuthorizationEnabled(true);
        this.identityService.setAuthenticatedUserId(jonny2);
        try {
            this.identityService.newGroup("group1");
            Assert.fail((String)"exception expected");
        }
        catch (AuthorizationException e) {
            Assert.assertEquals((long)1L, (long)e.getMissingAuthorizations().size());
            MissingAuthorization info = (MissingAuthorization)e.getMissingAuthorizations().get(0);
            Assert.assertEquals((Object)jonny2, (Object)e.getUserId());
            AuthorizationTestUtil.assertExceptionInfo(Permissions.CREATE.getName(), Resources.GROUP.resourceName(), null, info);
        }
        GroupEntity group = new GroupEntity("group1");
        try {
            this.identityService.saveGroup((Group)group);
            Assert.fail((String)"exception expected");
        }
        catch (AuthorizationException e) {
            Assert.assertEquals((long)1L, (long)e.getMissingAuthorizations().size());
            MissingAuthorization info = (MissingAuthorization)e.getMissingAuthorizations().get(0);
            Assert.assertEquals((Object)jonny2, (Object)e.getUserId());
            AuthorizationTestUtil.assertExceptionInfo(Permissions.CREATE.getName(), Resources.GROUP.resourceName(), null, info);
        }
    }

    @Test
    public void testGroupDeleteAuthorizations() {
        Group group1 = this.identityService.newGroup("group1");
        this.identityService.saveGroup(group1);
        Authorization basePerms = this.authorizationService.createNewAuthorization(0);
        basePerms.setResource((Resource)Resources.GROUP);
        basePerms.setResourceId("*");
        basePerms.addPermission((Permission)Permissions.ALL);
        basePerms.removePermission((Permission)Permissions.DELETE);
        this.authorizationService.saveAuthorization(basePerms);
        this.processEngineConfiguration.setAuthorizationEnabled(true);
        this.identityService.setAuthenticatedUserId(jonny2);
        try {
            this.identityService.deleteGroup("group1");
            Assert.fail((String)"exception expected");
        }
        catch (AuthorizationException e) {
            Assert.assertEquals((long)1L, (long)e.getMissingAuthorizations().size());
            MissingAuthorization info = (MissingAuthorization)e.getMissingAuthorizations().get(0);
            Assert.assertEquals((Object)jonny2, (Object)e.getUserId());
            AuthorizationTestUtil.assertExceptionInfo(Permissions.DELETE.getName(), Resources.GROUP.resourceName(), "group1", info);
        }
    }

    @Test
    public void testTenantAuthorizationAfterDeleteGroup() {
        User jonny = this.identityService.newUser(jonny2);
        this.identityService.saveUser(jonny);
        this.grantPermissions();
        this.processEngineConfiguration.setAuthorizationEnabled(true);
        this.identityService.setAuthenticatedUserId(jonny2);
        Group group1 = this.identityService.newGroup("group1");
        this.identityService.saveGroup(group1);
        String tenant1 = "tenant1";
        Tenant tenant = this.identityService.newTenant(tenant1);
        this.identityService.saveTenant(tenant);
        this.identityService.createTenantGroupMembership(tenant1, "group1");
        TenantQuery query = this.identityService.createTenantQuery().groupMember("group1");
        Assert.assertThat((Object)query.count(), (Matcher)CoreMatchers.is((Object)1L));
        this.identityService.deleteGroup("group1");
        this.processEngineConfiguration.setAuthorizationEnabled(false);
        Assert.assertThat((Object)query.count(), (Matcher)CoreMatchers.is((Object)0L));
        Assert.assertThat((Object)this.authorizationService.createAuthorizationQuery().resourceType((Resource)Resources.TENANT).groupIdIn(new String[]{"group1"}).count(), (Matcher)CoreMatchers.is((Object)0L));
    }

    @Test
    public void testGroupUpdateAuthorizations() {
        Group group1 = this.identityService.newGroup("group1");
        this.identityService.saveGroup(group1);
        Authorization basePerms = this.authorizationService.createNewAuthorization(0);
        basePerms.setResource((Resource)Resources.GROUP);
        basePerms.setResourceId("*");
        basePerms.addPermission((Permission)Permissions.ALL);
        basePerms.removePermission((Permission)Permissions.UPDATE);
        this.authorizationService.saveAuthorization(basePerms);
        this.processEngineConfiguration.setAuthorizationEnabled(true);
        this.identityService.setAuthenticatedUserId(jonny2);
        group1 = (Group)this.identityService.createGroupQuery().singleResult();
        group1.setName("Group 1");
        try {
            this.identityService.saveGroup(group1);
            Assert.fail((String)"exception expected");
        }
        catch (AuthorizationException e) {
            Assert.assertEquals((long)1L, (long)e.getMissingAuthorizations().size());
            MissingAuthorization info = (MissingAuthorization)e.getMissingAuthorizations().get(0);
            Assert.assertEquals((Object)jonny2, (Object)e.getUserId());
            AuthorizationTestUtil.assertExceptionInfo(Permissions.UPDATE.getName(), Resources.GROUP.resourceName(), "group1", info);
        }
        Group group2 = this.identityService.newGroup("group2");
        this.identityService.saveGroup(group2);
    }

    @Test
    public void testTenantCreateAuthorizations() {
        Authorization basePerms = this.authorizationService.createNewAuthorization(0);
        basePerms.setResource((Resource)Resources.TENANT);
        basePerms.setResourceId("*");
        basePerms.addPermission((Permission)Permissions.ALL);
        basePerms.removePermission((Permission)Permissions.CREATE);
        this.authorizationService.saveAuthorization(basePerms);
        this.processEngineConfiguration.setAuthorizationEnabled(true);
        this.identityService.setAuthenticatedUserId(jonny2);
        try {
            this.identityService.newTenant("tenant");
            Assert.fail((String)"exception expected");
        }
        catch (AuthorizationException e) {
            Assert.assertEquals((long)1L, (long)e.getMissingAuthorizations().size());
            MissingAuthorization info = (MissingAuthorization)e.getMissingAuthorizations().get(0);
            Assert.assertEquals((Object)jonny2, (Object)e.getUserId());
            AuthorizationTestUtil.assertExceptionInfo(Permissions.CREATE.getName(), Resources.TENANT.resourceName(), null, info);
        }
        TenantEntity tenant = new TenantEntity("tenant");
        try {
            this.identityService.saveTenant((Tenant)tenant);
            Assert.fail((String)"exception expected");
        }
        catch (AuthorizationException e) {
            Assert.assertEquals((long)1L, (long)e.getMissingAuthorizations().size());
            MissingAuthorization info = (MissingAuthorization)e.getMissingAuthorizations().get(0);
            Assert.assertEquals((Object)jonny2, (Object)e.getUserId());
            AuthorizationTestUtil.assertExceptionInfo(Permissions.CREATE.getName(), Resources.TENANT.resourceName(), null, info);
        }
    }

    @Test
    public void testTenantDeleteAuthorizations() {
        TenantEntity tenant = new TenantEntity("tenant");
        this.identityService.saveTenant((Tenant)tenant);
        Authorization basePerms = this.authorizationService.createNewAuthorization(0);
        basePerms.setResource((Resource)Resources.TENANT);
        basePerms.setResourceId("*");
        basePerms.addPermission((Permission)Permissions.ALL);
        basePerms.removePermission((Permission)Permissions.DELETE);
        this.authorizationService.saveAuthorization(basePerms);
        this.processEngineConfiguration.setAuthorizationEnabled(true);
        this.identityService.setAuthenticatedUserId(jonny2);
        try {
            this.identityService.deleteTenant("tenant");
            Assert.fail((String)"exception expected");
        }
        catch (AuthorizationException e) {
            Assert.assertEquals((long)1L, (long)e.getMissingAuthorizations().size());
            MissingAuthorization info = (MissingAuthorization)e.getMissingAuthorizations().get(0);
            Assert.assertEquals((Object)jonny2, (Object)e.getUserId());
            AuthorizationTestUtil.assertExceptionInfo(Permissions.DELETE.getName(), Resources.TENANT.resourceName(), "tenant", info);
        }
    }

    @Test
    public void testTenantUpdateAuthorizations() {
        TenantEntity tenant = new TenantEntity("tenant");
        this.identityService.saveTenant((Tenant)tenant);
        Authorization basePerms = this.authorizationService.createNewAuthorization(0);
        basePerms.setResource((Resource)Resources.TENANT);
        basePerms.setResourceId("*");
        basePerms.addPermission((Permission)Permissions.ALL);
        basePerms.removePermission((Permission)Permissions.UPDATE);
        this.authorizationService.saveAuthorization(basePerms);
        this.processEngineConfiguration.setAuthorizationEnabled(true);
        this.identityService.setAuthenticatedUserId(jonny2);
        tenant = (Tenant)this.identityService.createTenantQuery().singleResult();
        tenant.setName("newName");
        try {
            this.identityService.saveTenant((Tenant)tenant);
            Assert.fail((String)"exception expected");
        }
        catch (AuthorizationException e) {
            Assert.assertEquals((long)1L, (long)e.getMissingAuthorizations().size());
            MissingAuthorization info = (MissingAuthorization)e.getMissingAuthorizations().get(0);
            Assert.assertEquals((Object)jonny2, (Object)e.getUserId());
            AuthorizationTestUtil.assertExceptionInfo(Permissions.UPDATE.getName(), Resources.TENANT.resourceName(), "tenant", info);
        }
        Tenant newTenant = this.identityService.newTenant("newTenant");
        this.identityService.saveTenant(newTenant);
    }

    @Test
    public void testMembershipCreateAuthorizations() {
        User jonny1 = this.identityService.newUser("jonny1");
        this.identityService.saveUser(jonny1);
        Group group1 = this.identityService.newGroup("group1");
        this.identityService.saveGroup(group1);
        Authorization basePerms = this.authorizationService.createNewAuthorization(0);
        basePerms.setResource((Resource)Resources.GROUP_MEMBERSHIP);
        basePerms.setResourceId("*");
        basePerms.addPermission((Permission)Permissions.ALL);
        basePerms.removePermission((Permission)Permissions.CREATE);
        this.authorizationService.saveAuthorization(basePerms);
        this.processEngineConfiguration.setAuthorizationEnabled(true);
        this.identityService.setAuthenticatedUserId(jonny2);
        try {
            this.identityService.createMembership("jonny1", "group1");
            Assert.fail((String)"exception expected");
        }
        catch (AuthorizationException e) {
            Assert.assertEquals((long)1L, (long)e.getMissingAuthorizations().size());
            MissingAuthorization info = (MissingAuthorization)e.getMissingAuthorizations().get(0);
            Assert.assertEquals((Object)jonny2, (Object)e.getUserId());
            AuthorizationTestUtil.assertExceptionInfo(Permissions.CREATE.getName(), Resources.GROUP_MEMBERSHIP.resourceName(), "group1", info);
        }
    }

    @Test
    public void testMembershipDeleteAuthorizations() {
        User jonny1 = this.identityService.newUser("jonny1");
        this.identityService.saveUser(jonny1);
        Group group1 = this.identityService.newGroup("group1");
        this.identityService.saveGroup(group1);
        Authorization basePerms = this.authorizationService.createNewAuthorization(0);
        basePerms.setResource((Resource)Resources.GROUP_MEMBERSHIP);
        basePerms.setResourceId("*");
        basePerms.addPermission((Permission)Permissions.ALL);
        basePerms.removePermission((Permission)Permissions.DELETE);
        this.authorizationService.saveAuthorization(basePerms);
        this.processEngineConfiguration.setAuthorizationEnabled(true);
        this.identityService.setAuthenticatedUserId(jonny2);
        try {
            this.identityService.deleteMembership("jonny1", "group1");
            Assert.fail((String)"exception expected");
        }
        catch (AuthorizationException e) {
            Assert.assertEquals((long)1L, (long)e.getMissingAuthorizations().size());
            MissingAuthorization info = (MissingAuthorization)e.getMissingAuthorizations().get(0);
            Assert.assertEquals((Object)jonny2, (Object)e.getUserId());
            AuthorizationTestUtil.assertExceptionInfo(Permissions.DELETE.getName(), Resources.GROUP_MEMBERSHIP.resourceName(), "group1", info);
        }
    }

    @Test
    public void testTenantUserMembershipCreateAuthorizations() {
        User jonny1 = this.identityService.newUser("jonny1");
        this.identityService.saveUser(jonny1);
        Tenant tenant1 = this.identityService.newTenant("tenant1");
        this.identityService.saveTenant(tenant1);
        Authorization basePerms = this.authorizationService.createNewAuthorization(0);
        basePerms.setResource((Resource)Resources.TENANT_MEMBERSHIP);
        basePerms.setResourceId("*");
        basePerms.addPermission((Permission)Permissions.ALL);
        basePerms.removePermission((Permission)Permissions.CREATE);
        this.authorizationService.saveAuthorization(basePerms);
        this.processEngineConfiguration.setAuthorizationEnabled(true);
        this.identityService.setAuthenticatedUserId(jonny2);
        try {
            this.identityService.createTenantUserMembership("tenant1", "jonny1");
            Assert.fail((String)"exception expected");
        }
        catch (AuthorizationException e) {
            Assert.assertEquals((long)1L, (long)e.getMissingAuthorizations().size());
            MissingAuthorization info = (MissingAuthorization)e.getMissingAuthorizations().get(0);
            Assert.assertEquals((Object)jonny2, (Object)e.getUserId());
            AuthorizationTestUtil.assertExceptionInfo(Permissions.CREATE.getName(), Resources.TENANT_MEMBERSHIP.resourceName(), "tenant1", info);
        }
    }

    @Test
    public void testTenantGroupMembershipCreateAuthorizations() {
        Group group1 = this.identityService.newGroup("group1");
        this.identityService.saveGroup(group1);
        Tenant tenant1 = this.identityService.newTenant("tenant1");
        this.identityService.saveTenant(tenant1);
        Authorization basePerms = this.authorizationService.createNewAuthorization(0);
        basePerms.setResource((Resource)Resources.TENANT_MEMBERSHIP);
        basePerms.setResourceId("*");
        basePerms.addPermission((Permission)Permissions.ALL);
        basePerms.removePermission((Permission)Permissions.CREATE);
        this.authorizationService.saveAuthorization(basePerms);
        this.processEngineConfiguration.setAuthorizationEnabled(true);
        this.identityService.setAuthenticatedUserId(jonny2);
        try {
            this.identityService.createTenantGroupMembership("tenant1", "group1");
            Assert.fail((String)"exception expected");
        }
        catch (AuthorizationException e) {
            Assert.assertEquals((long)1L, (long)e.getMissingAuthorizations().size());
            MissingAuthorization info = (MissingAuthorization)e.getMissingAuthorizations().get(0);
            Assert.assertEquals((Object)jonny2, (Object)e.getUserId());
            AuthorizationTestUtil.assertExceptionInfo(Permissions.CREATE.getName(), Resources.TENANT_MEMBERSHIP.resourceName(), "tenant1", info);
        }
    }

    @Test
    public void testTenantUserMembershipDeleteAuthorizations() {
        User jonny1 = this.identityService.newUser("jonny1");
        this.identityService.saveUser(jonny1);
        Tenant tenant1 = this.identityService.newTenant("tenant1");
        this.identityService.saveTenant(tenant1);
        Authorization basePerms = this.authorizationService.createNewAuthorization(0);
        basePerms.setResource((Resource)Resources.TENANT_MEMBERSHIP);
        basePerms.setResourceId("*");
        basePerms.addPermission((Permission)Permissions.ALL);
        basePerms.removePermission((Permission)Permissions.DELETE);
        this.authorizationService.saveAuthorization(basePerms);
        this.processEngineConfiguration.setAuthorizationEnabled(true);
        this.identityService.setAuthenticatedUserId(jonny2);
        try {
            this.identityService.deleteTenantUserMembership("tenant1", "jonny1");
            Assert.fail((String)"exception expected");
        }
        catch (AuthorizationException e) {
            Assert.assertEquals((long)1L, (long)e.getMissingAuthorizations().size());
            MissingAuthorization info = (MissingAuthorization)e.getMissingAuthorizations().get(0);
            Assert.assertEquals((Object)jonny2, (Object)e.getUserId());
            AuthorizationTestUtil.assertExceptionInfo(Permissions.DELETE.getName(), Resources.TENANT_MEMBERSHIP.resourceName(), "tenant1", info);
        }
    }

    @Test
    public void testTenanGroupMembershipDeleteAuthorizations() {
        Group group1 = this.identityService.newGroup("group1");
        this.identityService.saveGroup(group1);
        Tenant tenant1 = this.identityService.newTenant("tenant1");
        this.identityService.saveTenant(tenant1);
        Authorization basePerms = this.authorizationService.createNewAuthorization(0);
        basePerms.setResource((Resource)Resources.TENANT_MEMBERSHIP);
        basePerms.setResourceId("*");
        basePerms.addPermission((Permission)Permissions.ALL);
        basePerms.removePermission((Permission)Permissions.DELETE);
        this.authorizationService.saveAuthorization(basePerms);
        this.processEngineConfiguration.setAuthorizationEnabled(true);
        this.identityService.setAuthenticatedUserId(jonny2);
        try {
            this.identityService.deleteTenantGroupMembership("tenant1", "group1");
            Assert.fail((String)"exception expected");
        }
        catch (AuthorizationException e) {
            Assert.assertEquals((long)1L, (long)e.getMissingAuthorizations().size());
            MissingAuthorization info = (MissingAuthorization)e.getMissingAuthorizations().get(0);
            Assert.assertEquals((Object)jonny2, (Object)e.getUserId());
            AuthorizationTestUtil.assertExceptionInfo(Permissions.DELETE.getName(), Resources.TENANT_MEMBERSHIP.resourceName(), "tenant1", info);
        }
    }

    @Test
    public void testUserQueryAuthorizations() {
        String authUserId = jonny2;
        this.identityService.setAuthenticatedUserId(authUserId);
        User jonny1 = this.identityService.newUser("jonny1");
        this.identityService.saveUser(jonny1);
        Authorization basePerms = this.authorizationService.createNewAuthorization(0);
        basePerms.setResource((Resource)Resources.USER);
        basePerms.setResourceId("*");
        this.authorizationService.saveAuthorization(basePerms);
        this.processEngineConfiguration.setAuthorizationEnabled(true);
        Assert.assertNull((Object)this.identityService.createUserQuery().singleResult());
        Assert.assertEquals((long)0L, (long)this.identityService.createUserQuery().count());
        this.processEngineConfiguration.setAuthorizationEnabled(false);
        Authorization ourPerms = this.authorizationService.createNewAuthorization(1);
        ourPerms.setUserId(authUserId);
        ourPerms.setResource((Resource)Resources.USER);
        ourPerms.setResourceId("*");
        ourPerms.addPermission((Permission)Permissions.READ);
        this.authorizationService.saveAuthorization(ourPerms);
        this.processEngineConfiguration.setAuthorizationEnabled(true);
        Assert.assertNotNull((Object)this.identityService.createUserQuery().singleResult());
        Assert.assertEquals((long)1L, (long)this.identityService.createUserQuery().count());
        this.processEngineConfiguration.setAuthorizationEnabled(false);
        basePerms = (Authorization)this.authorizationService.createAuthorizationQuery().resourceType((Resource)Resources.USER).userIdIn(new String[]{"*"}).singleResult();
        basePerms.addPermission((Permission)Permissions.READ);
        this.authorizationService.saveAuthorization(basePerms);
        this.processEngineConfiguration.setAuthorizationEnabled(true);
        Assert.assertNotNull((Object)this.identityService.createUserQuery().singleResult());
        Assert.assertEquals((long)1L, (long)this.identityService.createUserQuery().count());
        this.processEngineConfiguration.setAuthorizationEnabled(false);
        ourPerms = (Authorization)this.authorizationService.createAuthorizationQuery().resourceType((Resource)Resources.USER).userIdIn(new String[]{authUserId}).singleResult();
        ourPerms.removePermission((Permission)Permissions.READ);
        this.authorizationService.saveAuthorization(ourPerms);
        Authorization revoke = this.authorizationService.createNewAuthorization(2);
        revoke.setUserId(authUserId);
        revoke.setResource((Resource)Resources.USER);
        revoke.setResourceId("*");
        revoke.removePermission((Permission)Permissions.READ);
        this.authorizationService.saveAuthorization(revoke);
        this.processEngineConfiguration.setAuthorizationEnabled(true);
        Assert.assertNull((Object)this.identityService.createUserQuery().singleResult());
        Assert.assertEquals((long)0L, (long)this.identityService.createUserQuery().count());
        this.processEngineConfiguration.setAuthorizationEnabled(false);
        this.authorizationService.deleteAuthorization(ourPerms.getId());
        this.authorizationService.deleteAuthorization(revoke.getId());
        this.processEngineConfiguration.setAuthorizationEnabled(true);
        Assert.assertNotNull((Object)this.identityService.createUserQuery().singleResult());
        Assert.assertEquals((long)1L, (long)this.identityService.createUserQuery().count());
    }

    @Test
    public void testUserQueryAuthorizationsMultipleGroups() {
        String authUserId = jonny2;
        this.identityService.setAuthenticatedUserId(authUserId);
        User demo = this.identityService.newUser("demo");
        this.identityService.saveUser(demo);
        User mary = this.identityService.newUser("mary");
        this.identityService.saveUser(mary);
        User peter = this.identityService.newUser("peter");
        this.identityService.saveUser(peter);
        User john = this.identityService.newUser("john");
        this.identityService.saveUser(john);
        Group sales = this.identityService.newGroup("sales");
        this.identityService.saveGroup(sales);
        Group accounting = this.identityService.newGroup("accounting");
        this.identityService.saveGroup(accounting);
        Group management = this.identityService.newGroup("management");
        this.identityService.saveGroup(management);
        this.identityService.createMembership("demo", "sales");
        this.identityService.createMembership("demo", "accounting");
        this.identityService.createMembership("demo", "management");
        this.identityService.createMembership("john", "sales");
        this.identityService.createMembership("mary", "accounting");
        this.identityService.createMembership("peter", "management");
        Authorization demoAuth = this.authorizationService.createNewAuthorization(1);
        demoAuth.setUserId("demo");
        demoAuth.setResource((Resource)Resources.USER);
        demoAuth.setResourceId("demo");
        demoAuth.addPermission((Permission)Permissions.ALL);
        this.authorizationService.saveAuthorization(demoAuth);
        Authorization johnAuth = this.authorizationService.createNewAuthorization(1);
        johnAuth.setUserId("john");
        johnAuth.setResource((Resource)Resources.USER);
        johnAuth.setResourceId("john");
        johnAuth.addPermission((Permission)Permissions.ALL);
        this.authorizationService.saveAuthorization(johnAuth);
        Authorization maryAuth = this.authorizationService.createNewAuthorization(1);
        maryAuth.setUserId("mary");
        maryAuth.setResource((Resource)Resources.USER);
        maryAuth.setResourceId("mary");
        maryAuth.addPermission((Permission)Permissions.ALL);
        this.authorizationService.saveAuthorization(maryAuth);
        Authorization peterAuth = this.authorizationService.createNewAuthorization(1);
        peterAuth.setUserId("peter");
        peterAuth.setResource((Resource)Resources.USER);
        peterAuth.setResourceId("peter");
        peterAuth.addPermission((Permission)Permissions.ALL);
        this.authorizationService.saveAuthorization(peterAuth);
        Authorization accAuth = this.authorizationService.createNewAuthorization(1);
        accAuth.setGroupId("accounting");
        accAuth.setResource((Resource)Resources.GROUP);
        accAuth.setResourceId("accounting");
        accAuth.addPermission((Permission)Permissions.READ);
        this.authorizationService.saveAuthorization(accAuth);
        Authorization salesAuth = this.authorizationService.createNewAuthorization(1);
        salesAuth.setGroupId("sales");
        salesAuth.setResource((Resource)Resources.GROUP);
        salesAuth.setResourceId("sales");
        salesAuth.addPermission((Permission)Permissions.READ);
        this.authorizationService.saveAuthorization(salesAuth);
        Authorization manAuth = this.authorizationService.createNewAuthorization(1);
        manAuth.setGroupId("management");
        manAuth.setResource((Resource)Resources.GROUP);
        manAuth.setResourceId("management");
        manAuth.addPermission((Permission)Permissions.READ);
        this.authorizationService.saveAuthorization(manAuth);
        Authorization salesDemoAuth = this.authorizationService.createNewAuthorization(1);
        salesDemoAuth.setGroupId("sales");
        salesDemoAuth.setResource((Resource)Resources.USER);
        salesDemoAuth.setResourceId("demo");
        salesDemoAuth.addPermission((Permission)Permissions.READ);
        this.authorizationService.saveAuthorization(salesDemoAuth);
        Authorization salesJohnAuth = this.authorizationService.createNewAuthorization(1);
        salesJohnAuth.setGroupId("sales");
        salesJohnAuth.setResource((Resource)Resources.USER);
        salesJohnAuth.setResourceId("john");
        salesJohnAuth.addPermission((Permission)Permissions.READ);
        this.authorizationService.saveAuthorization(salesJohnAuth);
        Authorization manDemoAuth = this.authorizationService.createNewAuthorization(1);
        manDemoAuth.setGroupId("management");
        manDemoAuth.setResource((Resource)Resources.USER);
        manDemoAuth.setResourceId("demo");
        manDemoAuth.addPermission((Permission)Permissions.READ);
        this.authorizationService.saveAuthorization(manDemoAuth);
        Authorization manPeterAuth = this.authorizationService.createNewAuthorization(1);
        manPeterAuth.setGroupId("management");
        manPeterAuth.setResource((Resource)Resources.USER);
        manPeterAuth.setResourceId("peter");
        manPeterAuth.addPermission((Permission)Permissions.READ);
        this.authorizationService.saveAuthorization(manPeterAuth);
        Authorization accDemoAuth = this.authorizationService.createNewAuthorization(1);
        accDemoAuth.setGroupId("accounting");
        accDemoAuth.setResource((Resource)Resources.USER);
        accDemoAuth.setResourceId("demo");
        accDemoAuth.addPermission((Permission)Permissions.READ);
        this.authorizationService.saveAuthorization(accDemoAuth);
        Authorization accMaryAuth = this.authorizationService.createNewAuthorization(1);
        accMaryAuth.setGroupId("accounting");
        accMaryAuth.setResource((Resource)Resources.USER);
        accMaryAuth.setResourceId("mary");
        accMaryAuth.addPermission((Permission)Permissions.READ);
        this.authorizationService.saveAuthorization(accMaryAuth);
        ArrayList<String> groups = new ArrayList<String>();
        groups.add("management");
        groups.add("accounting");
        groups.add("sales");
        this.identityService.setAuthentication("demo", groups);
        this.processEngineConfiguration.setAuthorizationEnabled(true);
        List salesUser = this.identityService.createUserQuery().memberOfGroup("sales").list();
        Assert.assertEquals((long)2L, (long)salesUser.size());
        for (Object user : salesUser) {
            if (user.getId().equals("demo") || user.getId().equals("john")) continue;
            Assert.fail((String)("Unexpected user for group sales: " + user.getId()));
        }
        List accountingUser = this.identityService.createUserQuery().memberOfGroup("accounting").list();
        Assert.assertEquals((long)2L, (long)accountingUser.size());
        for (User user : accountingUser) {
            if (user.getId().equals("demo") || user.getId().equals("mary")) continue;
            Assert.fail((String)("Unexpected user for group accounting: " + user.getId()));
        }
        List managementUser = this.identityService.createUserQuery().memberOfGroup("management").list();
        Assert.assertEquals((long)2L, (long)managementUser.size());
        for (User user : managementUser) {
            if (user.getId().equals("demo") || user.getId().equals("peter")) continue;
            Assert.fail((String)("Unexpected user for group managment: " + user.getId()));
        }
    }

    @Test
    public void testGroupQueryAuthorizations() {
        String authUserId = jonny2;
        this.identityService.setAuthenticatedUserId(authUserId);
        User jonny1 = this.identityService.newUser("jonny1");
        this.identityService.saveUser(jonny1);
        Group group1 = this.identityService.newGroup("group1");
        this.identityService.saveGroup(group1);
        Authorization basePerms = this.authorizationService.createNewAuthorization(0);
        basePerms.setResource((Resource)Resources.GROUP);
        basePerms.setResourceId("*");
        this.authorizationService.saveAuthorization(basePerms);
        this.processEngineConfiguration.setAuthorizationEnabled(true);
        Assert.assertNull((Object)this.identityService.createGroupQuery().singleResult());
        Assert.assertEquals((long)0L, (long)this.identityService.createGroupQuery().count());
        this.processEngineConfiguration.setAuthorizationEnabled(false);
        Authorization ourPerms = this.authorizationService.createNewAuthorization(1);
        ourPerms.setUserId(authUserId);
        ourPerms.setResource((Resource)Resources.GROUP);
        ourPerms.setResourceId("*");
        ourPerms.addPermission((Permission)Permissions.READ);
        this.authorizationService.saveAuthorization(ourPerms);
        this.processEngineConfiguration.setAuthorizationEnabled(true);
        Assert.assertNotNull((Object)this.identityService.createGroupQuery().singleResult());
        Assert.assertEquals((long)1L, (long)this.identityService.createGroupQuery().count());
        this.processEngineConfiguration.setAuthorizationEnabled(false);
        basePerms = (Authorization)this.authorizationService.createAuthorizationQuery().resourceType((Resource)Resources.GROUP).userIdIn(new String[]{"*"}).singleResult();
        basePerms.addPermission((Permission)Permissions.READ);
        this.authorizationService.saveAuthorization(basePerms);
        this.processEngineConfiguration.setAuthorizationEnabled(true);
        Assert.assertNotNull((Object)this.identityService.createGroupQuery().singleResult());
        Assert.assertEquals((long)1L, (long)this.identityService.createGroupQuery().count());
        this.processEngineConfiguration.setAuthorizationEnabled(false);
        ourPerms = (Authorization)this.authorizationService.createAuthorizationQuery().resourceType((Resource)Resources.GROUP).userIdIn(new String[]{authUserId}).singleResult();
        ourPerms.removePermission((Permission)Permissions.READ);
        this.authorizationService.saveAuthorization(ourPerms);
        Authorization revoke = this.authorizationService.createNewAuthorization(2);
        revoke.setUserId(authUserId);
        revoke.setResource((Resource)Resources.GROUP);
        revoke.setResourceId("*");
        revoke.removePermission((Permission)Permissions.READ);
        this.authorizationService.saveAuthorization(revoke);
        this.processEngineConfiguration.setAuthorizationEnabled(true);
        Assert.assertNull((Object)this.identityService.createGroupQuery().singleResult());
        Assert.assertEquals((long)0L, (long)this.identityService.createGroupQuery().count());
        this.processEngineConfiguration.setAuthorizationEnabled(false);
        this.authorizationService.deleteAuthorization(ourPerms.getId());
        this.authorizationService.deleteAuthorization(revoke.getId());
        this.processEngineConfiguration.setAuthorizationEnabled(true);
        Assert.assertNotNull((Object)this.identityService.createGroupQuery().singleResult());
        Assert.assertEquals((long)1L, (long)this.identityService.createGroupQuery().count());
    }

    @Test
    public void testTenantQueryAuthorizations() {
        String authUserId = jonny2;
        this.identityService.setAuthenticatedUserId(authUserId);
        User jonny1 = this.identityService.newUser("jonny1");
        this.identityService.saveUser(jonny1);
        Tenant tenant = this.identityService.newTenant("tenant");
        this.identityService.saveTenant(tenant);
        Authorization basePerms = this.authorizationService.createNewAuthorization(0);
        basePerms.setResource((Resource)Resources.TENANT);
        basePerms.setResourceId("*");
        this.authorizationService.saveAuthorization(basePerms);
        this.processEngineConfiguration.setAuthorizationEnabled(true);
        Assert.assertEquals((long)0L, (long)this.identityService.createTenantQuery().count());
        this.processEngineConfiguration.setAuthorizationEnabled(false);
        Authorization ourPerms = this.authorizationService.createNewAuthorization(1);
        ourPerms.setUserId(authUserId);
        ourPerms.setResource((Resource)Resources.TENANT);
        ourPerms.setResourceId("*");
        ourPerms.addPermission((Permission)Permissions.READ);
        this.authorizationService.saveAuthorization(ourPerms);
        this.processEngineConfiguration.setAuthorizationEnabled(true);
        Assert.assertEquals((long)1L, (long)this.identityService.createTenantQuery().count());
        this.processEngineConfiguration.setAuthorizationEnabled(false);
        basePerms = (Authorization)this.authorizationService.createAuthorizationQuery().resourceType((Resource)Resources.TENANT).userIdIn(new String[]{"*"}).singleResult();
        basePerms.addPermission((Permission)Permissions.READ);
        this.authorizationService.saveAuthorization(basePerms);
        this.processEngineConfiguration.setAuthorizationEnabled(true);
        Assert.assertEquals((long)1L, (long)this.identityService.createTenantQuery().count());
        this.processEngineConfiguration.setAuthorizationEnabled(false);
        ourPerms = (Authorization)this.authorizationService.createAuthorizationQuery().resourceType((Resource)Resources.TENANT).userIdIn(new String[]{authUserId}).singleResult();
        ourPerms.removePermission((Permission)Permissions.READ);
        this.authorizationService.saveAuthorization(ourPerms);
        Authorization revoke = this.authorizationService.createNewAuthorization(2);
        revoke.setUserId(authUserId);
        revoke.setResource((Resource)Resources.TENANT);
        revoke.setResourceId("*");
        revoke.removePermission((Permission)Permissions.READ);
        this.authorizationService.saveAuthorization(revoke);
        this.processEngineConfiguration.setAuthorizationEnabled(true);
        Assert.assertEquals((long)0L, (long)this.identityService.createTenantQuery().count());
        this.processEngineConfiguration.setAuthorizationEnabled(false);
        this.authorizationService.deleteAuthorization(ourPerms.getId());
        this.authorizationService.deleteAuthorization(revoke.getId());
        this.processEngineConfiguration.setAuthorizationEnabled(true);
        Assert.assertEquals((long)1L, (long)this.identityService.createTenantQuery().count());
    }

    protected void lockUser(String userId, String invalidPassword) throws ParseException {
        Date now = ClockUtil.getCurrentTime();
        try {
            for (int i = 0; i <= 11; ++i) {
                Assert.assertFalse((boolean)this.identityService.checkPassword(userId, invalidPassword));
                now = DateUtils.addMinutes((Date)ClockUtil.getCurrentTime(), (int)1);
                ClockUtil.setCurrentTime((Date)now);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void grantPermissions() {
        AuthorizationEntity userAdminAuth = new AuthorizationEntity(0);
        userAdminAuth.setResource((Resource)Resources.USER);
        userAdminAuth.setResourceId("*");
        userAdminAuth.addPermission((Permission)Permissions.ALL);
        this.authorizationService.saveAuthorization((Authorization)userAdminAuth);
        userAdminAuth = new AuthorizationEntity(0);
        userAdminAuth.setResource((Resource)Resources.GROUP);
        userAdminAuth.setResourceId("*");
        userAdminAuth.addPermission((Permission)Permissions.ALL);
        this.authorizationService.saveAuthorization((Authorization)userAdminAuth);
        userAdminAuth = new AuthorizationEntity(0);
        userAdminAuth.setResource((Resource)Resources.TENANT);
        userAdminAuth.setResourceId("*");
        userAdminAuth.addPermission((Permission)Permissions.ALL);
        this.authorizationService.saveAuthorization((Authorization)userAdminAuth);
        userAdminAuth = new AuthorizationEntity(0);
        userAdminAuth.setResource((Resource)Resources.TENANT_MEMBERSHIP);
        userAdminAuth.setResourceId("*");
        userAdminAuth.addPermission((Permission)Permissions.ALL);
        this.authorizationService.saveAuthorization((Authorization)userAdminAuth);
    }

    protected void cleanupAfterTest() {
        for (Group group : this.identityService.createGroupQuery().list()) {
            this.identityService.deleteGroup(group.getId());
        }
        for (User user : this.identityService.createUserQuery().list()) {
            this.identityService.deleteUser(user.getId());
        }
        for (Tenant tenant : this.identityService.createTenantQuery().list()) {
            this.identityService.deleteTenant(tenant.getId());
        }
        for (Authorization authorization : this.authorizationService.createAuthorizationQuery().list()) {
            this.authorizationService.deleteAuthorization(authorization.getId());
        }
    }
}

