/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.mgmt.license;

import org.assertj.core.api.Assertions;
import org.camunda.bpm.engine.ManagementService;
import org.camunda.bpm.engine.ProcessEngine;
import org.camunda.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.camunda.bpm.engine.impl.telemetry.TelemetryRegistry;
import org.camunda.bpm.engine.impl.telemetry.dto.LicenseKeyData;
import org.camunda.bpm.engine.test.util.ProcessEngineTestRule;
import org.camunda.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.junit.After;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;

public class LicenseKeyTelemetryTest {
    public ProvidedProcessEngineRule engineRule = new ProvidedProcessEngineRule();
    public ProcessEngineTestRule testRule = new ProcessEngineTestRule(this.engineRule);
    public ExpectedException exceptionRule = ExpectedException.none();
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.testRule).around((TestRule)this.engineRule).around((TestRule)this.exceptionRule);
    ProcessEngine processEngine;
    ProcessEngineConfigurationImpl processEngineConfiguration;
    ManagementService managementService;
    TelemetryRegistry telemetryRegistry;

    @Before
    public void init() {
        this.processEngine = this.engineRule.getProcessEngine();
        this.processEngineConfiguration = (ProcessEngineConfigurationImpl)this.processEngine.getProcessEngineConfiguration();
        this.managementService = this.processEngine.getManagementService();
        this.telemetryRegistry = this.processEngineConfiguration.getTelemetryRegistry();
    }

    @After
    public void tearDown() {
        this.managementService.deleteLicenseKey();
        this.telemetryRegistry.clear();
    }

    @Test
    public void shouldSetLicenseKeyInTelemetryRegistry() {
        String licenseKey = "testLicenseKey";
        this.managementService.setLicenseKey(licenseKey);
        Assertions.assertThat((String)this.telemetryRegistry.getLicenseKey().getRaw()).isEqualTo((Object)licenseKey);
    }

    @Test
    public void shouldNotOverrideSameLicenseKeyInTelemetryRegistry() {
        String licenseKey = "testLicenseKey";
        LicenseKeyData licenseKeyData = new LicenseKeyData("customer", null, null, null, null, licenseKey);
        this.telemetryRegistry.setLicenseKey(licenseKeyData);
        this.managementService.setLicenseKey(licenseKey);
        Assertions.assertThat((Object)this.telemetryRegistry.getLicenseKey()).isEqualTo((Object)licenseKeyData);
    }

    @Test
    public void shouldNotOverrideSameMultipartLicenseKeyInTelemetryRegistry() {
        String licenseKey = "signature;testLicenseKey;more;data";
        LicenseKeyData licenseKeyData = new LicenseKeyData("customer", null, null, null, null, "testLicenseKey;more;data");
        this.telemetryRegistry.setLicenseKey(licenseKeyData);
        this.managementService.setLicenseKey(licenseKey);
        Assertions.assertThat((Object)this.telemetryRegistry.getLicenseKey()).isEqualTo((Object)licenseKeyData);
    }

    @Test
    public void shouldRemoveLicenseKeyFromTelemetryRegistry() {
        LicenseKeyData licenseKeyData = new LicenseKeyData("customer", null, null, null, null, "testLicenseKey");
        this.telemetryRegistry.setLicenseKey(licenseKeyData);
        this.managementService.deleteLicenseKey();
        Assertions.assertThat((Object)this.telemetryRegistry.getLicenseKey()).isNull();
    }
}

