/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.multitenancy;

import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.repository.CaseDefinition;
import org.camunda.bpm.engine.repository.ProcessDefinition;
import org.camunda.bpm.engine.runtime.CaseInstanceQuery;
import org.camunda.bpm.engine.runtime.ProcessInstanceQuery;
import org.camunda.bpm.engine.test.util.PluggableProcessEngineTest;
import org.camunda.bpm.model.bpmn.Bpmn;
import org.camunda.bpm.model.bpmn.BpmnModelInstance;
import org.camunda.bpm.model.bpmn.builder.CallActivityBuilder;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;

public class MultiTenancyCallActivityTest
extends PluggableProcessEngineTest {
    protected static final String TENANT_ONE = "tenant1";
    protected static final String TENANT_TWO = "tenant2";
    protected static final String CMMN = "org/camunda/bpm/engine/test/cmmn/deployment/CmmnDeploymentTest.testSimpleDeployment.cmmn";
    protected static final BpmnModelInstance SUB_PROCESS = Bpmn.createExecutableProcess((String)"subProcess").startEvent().userTask().endEvent().done();

    @Test
    public void testStartProcessInstanceWithDeploymentBinding() {
        BpmnModelInstance callingProcess = ((CallActivityBuilder)((CallActivityBuilder)Bpmn.createExecutableProcess((String)"callingProcess").startEvent().callActivity().calledElement("subProcess")).camundaCalledElementBinding("deployment")).endEvent().done();
        this.testRule.deployForTenant(TENANT_ONE, SUB_PROCESS, callingProcess);
        this.testRule.deployForTenant(TENANT_TWO, SUB_PROCESS, callingProcess);
        this.runtimeService.createProcessInstanceByKey("callingProcess").processDefinitionTenantId(TENANT_ONE).execute();
        this.runtimeService.createProcessInstanceByKey("callingProcess").processDefinitionTenantId(TENANT_TWO).execute();
        ProcessInstanceQuery query = this.runtimeService.createProcessInstanceQuery().processDefinitionKey("subProcess");
        Assert.assertThat((Object)query.tenantIdIn(new String[]{TENANT_ONE}).count(), (Matcher)CoreMatchers.is((Object)1L));
        Assert.assertThat((Object)query.tenantIdIn(new String[]{TENANT_TWO}).count(), (Matcher)CoreMatchers.is((Object)1L));
    }

    @Test
    public void testStartProcessInstanceWithLatestBindingSameVersion() {
        BpmnModelInstance callingProcess = ((CallActivityBuilder)((CallActivityBuilder)Bpmn.createExecutableProcess((String)"callingProcess").startEvent().callActivity().calledElement("subProcess")).camundaCalledElementBinding("latest")).endEvent().done();
        this.testRule.deployForTenant(TENANT_ONE, SUB_PROCESS, callingProcess);
        this.testRule.deployForTenant(TENANT_TWO, SUB_PROCESS, callingProcess);
        this.runtimeService.createProcessInstanceByKey("callingProcess").processDefinitionTenantId(TENANT_ONE).execute();
        this.runtimeService.createProcessInstanceByKey("callingProcess").processDefinitionTenantId(TENANT_TWO).execute();
        ProcessInstanceQuery query = this.runtimeService.createProcessInstanceQuery().processDefinitionKey("subProcess");
        Assert.assertThat((Object)query.tenantIdIn(new String[]{TENANT_ONE}).count(), (Matcher)CoreMatchers.is((Object)1L));
        Assert.assertThat((Object)query.tenantIdIn(new String[]{TENANT_TWO}).count(), (Matcher)CoreMatchers.is((Object)1L));
    }

    @Test
    public void testStartProcessInstanceWithLatestBindingDifferentVersion() {
        BpmnModelInstance callingProcess = ((CallActivityBuilder)((CallActivityBuilder)Bpmn.createExecutableProcess((String)"callingProcess").startEvent().callActivity().calledElement("subProcess")).camundaCalledElementBinding("latest")).endEvent().done();
        this.testRule.deployForTenant(TENANT_ONE, SUB_PROCESS, callingProcess);
        this.testRule.deployForTenant(TENANT_TWO, SUB_PROCESS, callingProcess);
        this.testRule.deployForTenant(TENANT_TWO, SUB_PROCESS);
        this.runtimeService.createProcessInstanceByKey("callingProcess").processDefinitionTenantId(TENANT_ONE).execute();
        this.runtimeService.createProcessInstanceByKey("callingProcess").processDefinitionTenantId(TENANT_TWO).execute();
        ProcessDefinition latestSubProcessTenantTwo = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().tenantIdIn(new String[]{TENANT_TWO}).processDefinitionKey("subProcess").latestVersion().singleResult();
        ProcessInstanceQuery query = this.runtimeService.createProcessInstanceQuery().processDefinitionKey("subProcess");
        Assert.assertThat((Object)query.tenantIdIn(new String[]{TENANT_ONE}).count(), (Matcher)CoreMatchers.is((Object)1L));
        Assert.assertThat((Object)query.tenantIdIn(new String[]{TENANT_TWO}).processDefinitionId(latestSubProcessTenantTwo.getId()).count(), (Matcher)CoreMatchers.is((Object)1L));
    }

    @Test
    public void testStartProcessInstanceWithVersionBinding() {
        BpmnModelInstance callingProcess = ((CallActivityBuilder)((CallActivityBuilder)((CallActivityBuilder)Bpmn.createExecutableProcess((String)"callingProcess").startEvent().callActivity().calledElement("subProcess")).camundaCalledElementBinding("version")).camundaCalledElementVersion("1")).endEvent().done();
        this.testRule.deployForTenant(TENANT_ONE, SUB_PROCESS, callingProcess);
        this.testRule.deployForTenant(TENANT_TWO, SUB_PROCESS, callingProcess);
        this.runtimeService.createProcessInstanceByKey("callingProcess").processDefinitionTenantId(TENANT_ONE).execute();
        this.runtimeService.createProcessInstanceByKey("callingProcess").processDefinitionTenantId(TENANT_TWO).execute();
        ProcessInstanceQuery query = this.runtimeService.createProcessInstanceQuery().processDefinitionKey("subProcess");
        Assert.assertThat((Object)query.tenantIdIn(new String[]{TENANT_ONE}).count(), (Matcher)CoreMatchers.is((Object)1L));
        Assert.assertThat((Object)query.tenantIdIn(new String[]{TENANT_TWO}).count(), (Matcher)CoreMatchers.is((Object)1L));
    }

    @Test
    public void testStartProcessInstanceWithVersionTagBinding() {
        BpmnModelInstance callingProcess = this.createCallingProcess("callingProcess", "ver_tag_1");
        this.testRule.deployForTenant(TENANT_ONE, callingProcess);
        this.testRule.deployForTenant(TENANT_ONE, "org/camunda/bpm/engine/test/bpmn/callactivity/subProcessWithVersionTag.bpmn20.xml");
        this.testRule.deployForTenant(TENANT_TWO, callingProcess);
        this.testRule.deployForTenant(TENANT_TWO, "org/camunda/bpm/engine/test/bpmn/callactivity/subProcessWithVersionTag2.bpmn20.xml");
        this.runtimeService.createProcessInstanceByKey("callingProcess").processDefinitionTenantId(TENANT_ONE).execute();
        this.runtimeService.createProcessInstanceByKey("callingProcess").processDefinitionTenantId(TENANT_TWO).execute();
        ProcessInstanceQuery query = this.runtimeService.createProcessInstanceQuery().processDefinitionKey("subProcess");
        Assert.assertThat((Object)query.activityIdIn(new String[]{"Task_1"}).tenantIdIn(new String[]{TENANT_ONE}).count(), (Matcher)CoreMatchers.is((Object)1L));
        Assert.assertThat((Object)query.activityIdIn(new String[]{"Task_2"}).tenantIdIn(new String[]{TENANT_TWO}).count(), (Matcher)CoreMatchers.is((Object)1L));
    }

    @Test
    public void testFailStartProcessInstanceFromOtherTenantWithDeploymentBinding() {
        BpmnModelInstance callingProcess = ((CallActivityBuilder)((CallActivityBuilder)Bpmn.createExecutableProcess((String)"callingProcess").startEvent().callActivity().calledElement("subProcess")).camundaCalledElementBinding("deployment")).endEvent().done();
        this.testRule.deployForTenant(TENANT_ONE, callingProcess);
        this.testRule.deployForTenant(TENANT_TWO, SUB_PROCESS);
        try {
            this.runtimeService.createProcessInstanceByKey("callingProcess").processDefinitionTenantId(TENANT_ONE).execute();
            Assert.fail((String)"expected exception");
        }
        catch (ProcessEngineException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)"no processes deployed with key = 'subProcess'"));
        }
    }

    @Test
    public void testFailStartProcessInstanceFromOtherTenantWithLatestBinding() {
        BpmnModelInstance callingProcess = ((CallActivityBuilder)((CallActivityBuilder)Bpmn.createExecutableProcess((String)"callingProcess").startEvent().callActivity().calledElement("subProcess")).camundaCalledElementBinding("latest")).endEvent().done();
        this.testRule.deployForTenant(TENANT_ONE, callingProcess);
        this.testRule.deployForTenant(TENANT_TWO, SUB_PROCESS);
        try {
            this.runtimeService.createProcessInstanceByKey("callingProcess").processDefinitionTenantId(TENANT_ONE).execute();
            Assert.fail((String)"expected exception");
        }
        catch (ProcessEngineException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)"no processes deployed with key 'subProcess'"));
        }
    }

    @Test
    public void testFailStartProcessInstanceFromOtherTenantWithVersionBinding() {
        BpmnModelInstance callingProcess = ((CallActivityBuilder)((CallActivityBuilder)((CallActivityBuilder)Bpmn.createExecutableProcess((String)"callingProcess").startEvent().callActivity().calledElement("subProcess")).camundaCalledElementBinding("version")).camundaCalledElementVersion("2")).endEvent().done();
        this.testRule.deployForTenant(TENANT_ONE, SUB_PROCESS, callingProcess);
        this.testRule.deployForTenant(TENANT_TWO, SUB_PROCESS);
        this.testRule.deployForTenant(TENANT_TWO, SUB_PROCESS);
        try {
            this.runtimeService.createProcessInstanceByKey("callingProcess").processDefinitionTenantId(TENANT_ONE).execute();
            Assert.fail((String)"expected exception");
        }
        catch (ProcessEngineException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)"no processes deployed with key = 'subProcess'"));
        }
    }

    @Test
    public void testFailStartProcessInstanceFromOtherTenantWithVersionTagBinding() {
        BpmnModelInstance callingProcess = this.createCallingProcess("callingProcess", "ver_tag_2");
        this.testRule.deployForTenant(TENANT_ONE, callingProcess);
        this.testRule.deployForTenant(TENANT_TWO, "org/camunda/bpm/engine/test/bpmn/callactivity/subProcessWithVersionTag2.bpmn20.xml");
        try {
            this.runtimeService.createProcessInstanceByKey("callingProcess").processDefinitionTenantId(TENANT_ONE).execute();
            Assert.fail((String)"expected exception");
        }
        catch (ProcessEngineException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)"no processes deployed with key = 'subProcess'"));
        }
    }

    @Test
    public void testStartCaseInstanceWithDeploymentBinding() {
        BpmnModelInstance callingProcess = ((CallActivityBuilder)((CallActivityBuilder)Bpmn.createExecutableProcess((String)"callingProcess").startEvent().callActivity().camundaCaseRef("Case_1")).camundaCaseBinding("deployment")).endEvent().done();
        this.testRule.deployForTenant(TENANT_ONE, callingProcess, CMMN);
        this.testRule.deployForTenant(TENANT_TWO, callingProcess, CMMN);
        this.runtimeService.createProcessInstanceByKey("callingProcess").processDefinitionTenantId(TENANT_ONE).execute();
        this.runtimeService.createProcessInstanceByKey("callingProcess").processDefinitionTenantId(TENANT_TWO).execute();
        CaseInstanceQuery query = this.caseService.createCaseInstanceQuery().caseDefinitionKey("Case_1");
        Assert.assertThat((Object)query.tenantIdIn(new String[]{TENANT_ONE}).count(), (Matcher)CoreMatchers.is((Object)1L));
        Assert.assertThat((Object)query.tenantIdIn(new String[]{TENANT_TWO}).count(), (Matcher)CoreMatchers.is((Object)1L));
    }

    @Test
    public void testStartCaseInstanceWithLatestBindingSameVersion() {
        BpmnModelInstance callingProcess = ((CallActivityBuilder)((CallActivityBuilder)Bpmn.createExecutableProcess((String)"callingProcess").startEvent().callActivity().camundaCaseRef("Case_1")).camundaCaseBinding("latest")).endEvent().done();
        this.testRule.deployForTenant(TENANT_ONE, callingProcess, CMMN);
        this.testRule.deployForTenant(TENANT_TWO, callingProcess, CMMN);
        this.runtimeService.createProcessInstanceByKey("callingProcess").processDefinitionTenantId(TENANT_ONE).execute();
        this.runtimeService.createProcessInstanceByKey("callingProcess").processDefinitionTenantId(TENANT_TWO).execute();
        CaseInstanceQuery query = this.caseService.createCaseInstanceQuery().caseDefinitionKey("Case_1");
        Assert.assertThat((Object)query.tenantIdIn(new String[]{TENANT_ONE}).count(), (Matcher)CoreMatchers.is((Object)1L));
        Assert.assertThat((Object)query.tenantIdIn(new String[]{TENANT_TWO}).count(), (Matcher)CoreMatchers.is((Object)1L));
    }

    @Test
    public void testStartCaseInstanceWithLatestBindingDifferentVersion() {
        BpmnModelInstance callingProcess = ((CallActivityBuilder)((CallActivityBuilder)Bpmn.createExecutableProcess((String)"callingProcess").startEvent().callActivity().camundaCaseRef("Case_1")).camundaCaseBinding("latest")).endEvent().done();
        this.testRule.deployForTenant(TENANT_ONE, callingProcess, CMMN);
        this.testRule.deployForTenant(TENANT_TWO, callingProcess, CMMN);
        this.testRule.deployForTenant(TENANT_TWO, CMMN);
        this.runtimeService.createProcessInstanceByKey("callingProcess").processDefinitionTenantId(TENANT_ONE).execute();
        this.runtimeService.createProcessInstanceByKey("callingProcess").processDefinitionTenantId(TENANT_TWO).execute();
        CaseInstanceQuery query = this.caseService.createCaseInstanceQuery().caseDefinitionKey("Case_1");
        Assert.assertThat((Object)query.tenantIdIn(new String[]{TENANT_ONE}).count(), (Matcher)CoreMatchers.is((Object)1L));
        CaseDefinition latestCaseDefinitionTenantTwo = (CaseDefinition)this.repositoryService.createCaseDefinitionQuery().tenantIdIn(new String[]{TENANT_TWO}).latestVersion().singleResult();
        query = this.caseService.createCaseInstanceQuery().caseDefinitionId(latestCaseDefinitionTenantTwo.getId());
        Assert.assertThat((Object)query.count(), (Matcher)CoreMatchers.is((Object)1L));
    }

    @Test
    public void testStartCaseInstanceWithVersionBinding() {
        BpmnModelInstance callingProcess = ((CallActivityBuilder)((CallActivityBuilder)((CallActivityBuilder)Bpmn.createExecutableProcess((String)"callingProcess").startEvent().callActivity().camundaCaseRef("Case_1")).camundaCaseBinding("version")).camundaCaseVersion("1")).endEvent().done();
        this.testRule.deployForTenant(TENANT_ONE, callingProcess, CMMN);
        this.testRule.deployForTenant(TENANT_TWO, callingProcess, CMMN);
        this.runtimeService.createProcessInstanceByKey("callingProcess").processDefinitionTenantId(TENANT_ONE).execute();
        this.runtimeService.createProcessInstanceByKey("callingProcess").processDefinitionTenantId(TENANT_TWO).execute();
        CaseInstanceQuery query = this.caseService.createCaseInstanceQuery().caseDefinitionKey("Case_1");
        Assert.assertThat((Object)query.tenantIdIn(new String[]{TENANT_ONE}).count(), (Matcher)CoreMatchers.is((Object)1L));
        Assert.assertThat((Object)query.tenantIdIn(new String[]{TENANT_TWO}).count(), (Matcher)CoreMatchers.is((Object)1L));
    }

    @Test
    public void testFailStartCaseInstanceFromOtherTenantWithDeploymentBinding() {
        BpmnModelInstance callingProcess = ((CallActivityBuilder)((CallActivityBuilder)Bpmn.createExecutableProcess((String)"callingProcess").startEvent().callActivity().camundaCaseRef("Case_1")).camundaCaseBinding("deployment")).endEvent().done();
        this.testRule.deployForTenant(TENANT_ONE, callingProcess);
        this.testRule.deployForTenant(TENANT_TWO, CMMN);
        try {
            this.runtimeService.createProcessInstanceByKey("callingProcess").processDefinitionTenantId(TENANT_ONE).execute();
            Assert.fail((String)"expected exception");
        }
        catch (ProcessEngineException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)"no case definition deployed with key = 'Case_1'"));
        }
    }

    @Test
    public void testFailStartCaseInstanceFromOtherTenantWithLatestBinding() {
        BpmnModelInstance callingProcess = ((CallActivityBuilder)((CallActivityBuilder)Bpmn.createExecutableProcess((String)"callingProcess").startEvent().callActivity().camundaCaseRef("Case_1")).camundaCaseBinding("latest")).endEvent().done();
        this.testRule.deployForTenant(TENANT_ONE, callingProcess);
        this.testRule.deployForTenant(TENANT_TWO, CMMN);
        try {
            this.runtimeService.createProcessInstanceByKey("callingProcess").processDefinitionTenantId(TENANT_ONE).execute();
            Assert.fail((String)"expected exception");
        }
        catch (ProcessEngineException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)"no case definition deployed with key 'Case_1'"));
        }
    }

    @Test
    public void testFailStartCaseInstanceFromOtherTenantWithVersionBinding() {
        BpmnModelInstance callingProcess = ((CallActivityBuilder)((CallActivityBuilder)((CallActivityBuilder)Bpmn.createExecutableProcess((String)"callingProcess").startEvent().callActivity().camundaCaseRef("Case_1")).camundaCaseBinding("version")).camundaCaseVersion("2")).endEvent().done();
        this.testRule.deployForTenant(TENANT_ONE, callingProcess, CMMN);
        this.testRule.deployForTenant(TENANT_TWO, CMMN);
        this.testRule.deployForTenant(TENANT_TWO, CMMN);
        try {
            this.runtimeService.createProcessInstanceByKey("callingProcess").processDefinitionTenantId(TENANT_ONE).execute();
            Assert.fail((String)"expected exception");
        }
        catch (ProcessEngineException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)"no case definition deployed with key = 'Case_1'"));
        }
    }

    @Test
    public void testCalledElementTenantIdConstant() {
        BpmnModelInstance callingProcess = ((CallActivityBuilder)((CallActivityBuilder)Bpmn.createExecutableProcess((String)"callingProcess").startEvent().callActivity().calledElement("subProcess")).camundaCalledElementTenantId(TENANT_ONE)).endEvent().done();
        this.testRule.deployForTenant(TENANT_ONE, SUB_PROCESS);
        this.testRule.deploy(callingProcess);
        this.runtimeService.startProcessInstanceByKey("callingProcess");
        ProcessInstanceQuery query = this.runtimeService.createProcessInstanceQuery().processDefinitionKey("subProcess");
        Assert.assertThat((Object)query.tenantIdIn(new String[]{TENANT_ONE}).count(), (Matcher)CoreMatchers.is((Object)1L));
    }

    @Test
    public void testCalledElementTenantIdExpression() {
        BpmnModelInstance callingProcess = ((CallActivityBuilder)((CallActivityBuilder)Bpmn.createExecutableProcess((String)"callingProcess").startEvent().callActivity().calledElement("subProcess")).camundaCalledElementTenantId("${'tenant1'}")).endEvent().done();
        this.testRule.deployForTenant(TENANT_ONE, SUB_PROCESS);
        this.testRule.deploy(callingProcess);
        this.runtimeService.startProcessInstanceByKey("callingProcess");
        ProcessInstanceQuery query = this.runtimeService.createProcessInstanceQuery().processDefinitionKey("subProcess");
        Assert.assertThat((Object)query.tenantIdIn(new String[]{TENANT_ONE}).count(), (Matcher)CoreMatchers.is((Object)1L));
    }

    @Test
    public void testCaseRefTenantIdConstant() {
        BpmnModelInstance callingProcess = ((CallActivityBuilder)((CallActivityBuilder)Bpmn.createExecutableProcess((String)"callingProcess").startEvent().callActivity().camundaCaseRef("Case_1")).camundaCaseTenantId(TENANT_ONE)).endEvent().done();
        this.testRule.deployForTenant(TENANT_ONE, CMMN);
        this.testRule.deploy(callingProcess);
        this.runtimeService.startProcessInstanceByKey("callingProcess");
        CaseInstanceQuery query = this.caseService.createCaseInstanceQuery().caseDefinitionKey("Case_1");
        Assert.assertThat((Object)query.tenantIdIn(new String[]{TENANT_ONE}).count(), (Matcher)CoreMatchers.is((Object)1L));
    }

    @Test
    public void testCaseRefTenantIdExpression() {
        BpmnModelInstance callingProcess = ((CallActivityBuilder)((CallActivityBuilder)Bpmn.createExecutableProcess((String)"callingProcess").startEvent().callActivity().camundaCaseRef("Case_1")).camundaCaseTenantId("${'tenant1'}")).endEvent().done();
        this.testRule.deployForTenant(TENANT_ONE, CMMN);
        this.testRule.deploy(callingProcess);
        this.runtimeService.startProcessInstanceByKey("callingProcess");
        CaseInstanceQuery query = this.caseService.createCaseInstanceQuery().caseDefinitionKey("Case_1");
        Assert.assertThat((Object)query.tenantIdIn(new String[]{TENANT_ONE}).count(), (Matcher)CoreMatchers.is((Object)1L));
    }

    @Test
    public void testCaseRefTenantIdCompositeExpression() {
        BpmnModelInstance callingProcess = ((CallActivityBuilder)((CallActivityBuilder)Bpmn.createExecutableProcess((String)"callingProcess").startEvent().callActivity().camundaCaseRef("Case_1")).camundaCaseTenantId("tenant${'1'}")).endEvent().done();
        this.testRule.deployForTenant(TENANT_ONE, CMMN);
        this.testRule.deploy(callingProcess);
        this.runtimeService.startProcessInstanceByKey("callingProcess");
        CaseInstanceQuery query = this.caseService.createCaseInstanceQuery().caseDefinitionKey("Case_1");
        Assert.assertThat((Object)query.tenantIdIn(new String[]{TENANT_ONE}).count(), (Matcher)CoreMatchers.is((Object)1L));
    }

    protected BpmnModelInstance createCallingProcess(String processId, String versionTagValue) {
        return ((CallActivityBuilder)((CallActivityBuilder)((CallActivityBuilder)Bpmn.createExecutableProcess((String)processId).startEvent().callActivity().calledElement("subProcess")).camundaCalledElementBinding("versionTag")).camundaCalledElementVersionTag(versionTagValue)).endEvent().done();
    }
}

