/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.multitenancy.cmmn.query;

import java.util.Arrays;
import java.util.List;
import org.camunda.bpm.engine.exception.NullValueException;
import org.camunda.bpm.engine.repository.CaseDefinition;
import org.camunda.bpm.engine.repository.CaseDefinitionQuery;
import org.camunda.bpm.engine.runtime.CaseExecution;
import org.camunda.bpm.engine.runtime.CaseExecutionQuery;
import org.camunda.bpm.engine.runtime.CaseInstance;
import org.camunda.bpm.engine.test.util.PluggableProcessEngineTest;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class MultiTenancyCaseExecutionQueryTest
extends PluggableProcessEngineTest {
    protected static final String CMMN_FILE = "org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn";
    protected static final String TENANT_ONE = "tenant1";
    protected static final String TENANT_TWO = "tenant2";

    @Before
    public void setUp() {
        this.testRule.deploy(CMMN_FILE);
        this.testRule.deployForTenant(TENANT_ONE, CMMN_FILE);
        this.testRule.deployForTenant(TENANT_TWO, CMMN_FILE);
        this.createCaseInstance(null);
        this.createCaseInstance(TENANT_ONE);
        this.createCaseInstance(TENANT_TWO);
    }

    @Test
    public void testQueryNoTenantIdSet() {
        CaseExecutionQuery query = this.caseService.createCaseExecutionQuery();
        Assert.assertThat((Object)query.count(), (Matcher)CoreMatchers.is((Object)6L));
    }

    @Test
    public void testQueryByTenantId() {
        CaseExecutionQuery query = this.caseService.createCaseExecutionQuery().tenantIdIn(new String[]{TENANT_ONE});
        Assert.assertThat((Object)query.count(), (Matcher)CoreMatchers.is((Object)2L));
        query = this.caseService.createCaseExecutionQuery().tenantIdIn(new String[]{TENANT_TWO});
        Assert.assertThat((Object)query.count(), (Matcher)CoreMatchers.is((Object)2L));
    }

    @Test
    public void testQueryByTenantIds() {
        CaseExecutionQuery query = this.caseService.createCaseExecutionQuery().tenantIdIn(new String[]{TENANT_ONE, TENANT_TWO});
        Assert.assertThat((Object)query.count(), (Matcher)CoreMatchers.is((Object)4L));
    }

    @Test
    public void testQueryByExecutionsWithoutTenantId() {
        CaseExecutionQuery query = this.caseService.createCaseExecutionQuery().withoutTenantId();
        Assert.assertThat((Object)query.count(), (Matcher)CoreMatchers.is((Object)2L));
    }

    @Test
    public void testQueryByNonExistingTenantId() {
        CaseExecutionQuery query = this.caseService.createCaseExecutionQuery().tenantIdIn(new String[]{"nonExisting"});
        Assert.assertThat((Object)query.count(), (Matcher)CoreMatchers.is((Object)0L));
    }

    @Test
    public void testFailQueryByTenantIdNull() {
        try {
            this.caseService.createCaseExecutionQuery().tenantIdIn(new String[]{null});
            Assert.fail((String)"expected exception");
        }
        catch (NullValueException nullValueException) {
            // empty catch block
        }
    }

    @Test
    public void testQuerySortingAsc() {
        List caseExecutions = ((CaseExecutionQuery)this.caseService.createCaseExecutionQuery().tenantIdIn(new String[]{TENANT_ONE, TENANT_TWO}).orderByTenantId().asc()).list();
        Assert.assertThat((Object)caseExecutions.size(), (Matcher)CoreMatchers.is((Object)4));
        Assert.assertThat((Object)((CaseExecution)caseExecutions.get(0)).getTenantId(), (Matcher)CoreMatchers.is((Object)TENANT_ONE));
        Assert.assertThat((Object)((CaseExecution)caseExecutions.get(1)).getTenantId(), (Matcher)CoreMatchers.is((Object)TENANT_ONE));
        Assert.assertThat((Object)((CaseExecution)caseExecutions.get(2)).getTenantId(), (Matcher)CoreMatchers.is((Object)TENANT_TWO));
        Assert.assertThat((Object)((CaseExecution)caseExecutions.get(3)).getTenantId(), (Matcher)CoreMatchers.is((Object)TENANT_TWO));
    }

    @Test
    public void testQuerySortingDesc() {
        List caseExecutions = ((CaseExecutionQuery)this.caseService.createCaseExecutionQuery().tenantIdIn(new String[]{TENANT_ONE, TENANT_TWO}).orderByTenantId().desc()).list();
        Assert.assertThat((Object)caseExecutions.size(), (Matcher)CoreMatchers.is((Object)4));
        Assert.assertThat((Object)((CaseExecution)caseExecutions.get(0)).getTenantId(), (Matcher)CoreMatchers.is((Object)TENANT_TWO));
        Assert.assertThat((Object)((CaseExecution)caseExecutions.get(1)).getTenantId(), (Matcher)CoreMatchers.is((Object)TENANT_TWO));
        Assert.assertThat((Object)((CaseExecution)caseExecutions.get(2)).getTenantId(), (Matcher)CoreMatchers.is((Object)TENANT_ONE));
        Assert.assertThat((Object)((CaseExecution)caseExecutions.get(3)).getTenantId(), (Matcher)CoreMatchers.is((Object)TENANT_ONE));
    }

    @Test
    public void testQueryNoAuthenticatedTenants() {
        this.identityService.setAuthentication("user", null, null);
        CaseExecutionQuery query = this.caseService.createCaseExecutionQuery();
        Assert.assertThat((Object)query.count(), (Matcher)CoreMatchers.is((Object)2L));
    }

    @Test
    public void testQueryAuthenticatedTenant() {
        this.identityService.setAuthentication("user", null, Arrays.asList(TENANT_ONE));
        CaseExecutionQuery query = this.caseService.createCaseExecutionQuery();
        Assert.assertThat((Object)query.count(), (Matcher)CoreMatchers.is((Object)4L));
        Assert.assertThat((Object)query.tenantIdIn(new String[]{TENANT_ONE}).count(), (Matcher)CoreMatchers.is((Object)2L));
        Assert.assertThat((Object)query.tenantIdIn(new String[]{TENANT_TWO}).count(), (Matcher)CoreMatchers.is((Object)0L));
        Assert.assertThat((Object)query.tenantIdIn(new String[]{TENANT_ONE, TENANT_TWO}).count(), (Matcher)CoreMatchers.is((Object)2L));
    }

    @Test
    public void testQueryAuthenticatedTenants() {
        this.identityService.setAuthentication("user", null, Arrays.asList(TENANT_ONE, TENANT_TWO));
        CaseExecutionQuery query = this.caseService.createCaseExecutionQuery();
        Assert.assertThat((Object)query.count(), (Matcher)CoreMatchers.is((Object)6L));
        Assert.assertThat((Object)query.tenantIdIn(new String[]{TENANT_ONE}).count(), (Matcher)CoreMatchers.is((Object)2L));
        Assert.assertThat((Object)query.tenantIdIn(new String[]{TENANT_TWO}).count(), (Matcher)CoreMatchers.is((Object)2L));
        Assert.assertThat((Object)query.withoutTenantId().count(), (Matcher)CoreMatchers.is((Object)2L));
    }

    @Test
    public void testQueryDisabledTenantCheck() {
        this.processEngineConfiguration.setTenantCheckEnabled(false);
        this.identityService.setAuthentication("user", null, null);
        CaseExecutionQuery query = this.caseService.createCaseExecutionQuery();
        Assert.assertThat((Object)query.count(), (Matcher)CoreMatchers.is((Object)6L));
    }

    protected CaseInstance createCaseInstance(String tenantId) {
        String caseDefinitionId = null;
        CaseDefinitionQuery caseDefinitionQuery = this.repositoryService.createCaseDefinitionQuery().caseDefinitionKey("oneTaskCase");
        caseDefinitionId = tenantId == null ? ((CaseDefinition)caseDefinitionQuery.withoutTenantId().singleResult()).getId() : ((CaseDefinition)caseDefinitionQuery.tenantIdIn(new String[]{tenantId}).singleResult()).getId();
        return this.caseService.withCaseDefinition(caseDefinitionId).create();
    }
}

