/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.runtime;

import java.io.File;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.camunda.bpm.engine.HistoryService;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.RuntimeService;
import org.camunda.bpm.engine.TaskService;
import org.camunda.bpm.engine.delegate.DelegateExecution;
import org.camunda.bpm.engine.delegate.ExecutionListener;
import org.camunda.bpm.engine.delegate.JavaDelegate;
import org.camunda.bpm.engine.history.HistoricVariableInstance;
import org.camunda.bpm.engine.repository.ProcessDefinition;
import org.camunda.bpm.engine.runtime.Execution;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.runtime.ProcessInstantiationBuilder;
import org.camunda.bpm.engine.runtime.VariableInstance;
import org.camunda.bpm.engine.task.Task;
import org.camunda.bpm.engine.task.TaskQuery;
import org.camunda.bpm.engine.test.ProcessEngineRule;
import org.camunda.bpm.engine.test.RequiredHistoryLevel;
import org.camunda.bpm.engine.test.api.runtime.migration.models.ProcessModels;
import org.camunda.bpm.engine.test.util.ProcessEngineTestRule;
import org.camunda.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.camunda.bpm.engine.variable.VariableMap;
import org.camunda.bpm.engine.variable.Variables;
import org.camunda.bpm.engine.variable.value.StringValue;
import org.camunda.bpm.engine.variable.value.TypedValue;
import org.camunda.bpm.model.bpmn.Bpmn;
import org.camunda.bpm.model.bpmn.BpmnModelInstance;
import org.camunda.bpm.model.bpmn.builder.ConditionalEventDefinitionBuilder;
import org.camunda.bpm.model.bpmn.builder.EventBasedGatewayBuilder;
import org.camunda.bpm.model.bpmn.builder.IntermediateCatchEventBuilder;
import org.camunda.bpm.model.bpmn.builder.ParallelGatewayBuilder;
import org.camunda.bpm.model.bpmn.builder.ScriptTaskBuilder;
import org.camunda.bpm.model.bpmn.builder.ServiceTaskBuilder;
import org.camunda.bpm.model.bpmn.builder.StartEventBuilder;
import org.camunda.bpm.model.bpmn.builder.UserTaskBuilder;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;

@RequiredHistoryLevel(value="audit")
public class TransientVariableTest {
    private static final int OUTPUT_VALUE = 2;
    protected ProcessEngineRule engineRule = new ProvidedProcessEngineRule();
    protected ProcessEngineTestRule testRule = new ProcessEngineTestRule(this.engineRule);
    @Rule
    public ExpectedException thrown = ExpectedException.none();
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.engineRule).around((TestRule)this.testRule);
    protected RuntimeService runtimeService;
    protected HistoryService historyService;
    protected TaskService taskService;

    @Before
    public void init() {
        this.runtimeService = this.engineRule.getRuntimeService();
        this.historyService = this.engineRule.getHistoryService();
        this.taskService = this.engineRule.getTaskService();
    }

    @Test
    public void createTransientTypedVariablesUsingVariableMap() throws URISyntaxException {
        BpmnModelInstance instance = ((ServiceTaskBuilder)Bpmn.createExecutableProcess((String)"Process").startEvent().serviceTask().camundaClass(ReadTransientVariablesOfAllTypesDelegate.class.getName())).userTask("user").endEvent().done();
        this.testRule.deploy(instance);
        this.runtimeService.startProcessInstanceByKey("Process", (Map)Variables.createVariables().putValueTyped("a", (TypedValue)Variables.stringValue((String)"bar", (boolean)true)).putValueTyped("b", (TypedValue)Variables.booleanValue((Boolean)true, (boolean)true)).putValueTyped("c", (TypedValue)Variables.byteArrayValue((byte[])"test".getBytes(), (boolean)true)).putValueTyped("d", (TypedValue)Variables.dateValue((Date)new Date(), (boolean)true)).putValueTyped("e", (TypedValue)Variables.doubleValue((Double)20.0, (boolean)true)).putValueTyped("f", (TypedValue)Variables.integerValue((Integer)10, (boolean)true)).putValueTyped("g", (TypedValue)Variables.longValue((Long)10L, (boolean)true)).putValueTyped("h", (TypedValue)Variables.shortValue((Short)10, (boolean)true)).putValueTyped("i", Variables.objectValue((Object)new Integer(100), (boolean)true).create()).putValueTyped("j", Variables.untypedValue(null, (boolean)true)).putValueTyped("k", Variables.untypedValue((Object)Variables.booleanValue((Boolean)true), (boolean)true)).putValueTyped("l", (TypedValue)Variables.fileValue((File)new File(this.getClass().getClassLoader().getResource("org/camunda/bpm/engine/test/standalone/variables/simpleFile.txt").toURI()), (boolean)true)));
        List historicVariableInstances = this.historyService.createHistoricVariableInstanceQuery().list();
        List variableInstances = this.runtimeService.createVariableInstanceQuery().list();
        Assert.assertEquals((long)0L, (long)historicVariableInstances.size());
        Assert.assertEquals((long)0L, (long)variableInstances.size());
    }

    @Test
    public void createTransientVariablesUsingVariableMap() throws URISyntaxException {
        BpmnModelInstance instance = ((ServiceTaskBuilder)Bpmn.createExecutableProcess((String)"Process").startEvent().serviceTask().camundaClass(ReadTransientVariablesOfAllTypesDelegate.class.getName())).userTask("user").endEvent().done();
        this.testRule.deploy(instance);
        this.runtimeService.startProcessInstanceByKey("Process", (Map)Variables.createVariables().putValue("a", (Object)Variables.stringValue((String)"bar", (boolean)true)).putValue("b", (Object)Variables.booleanValue((Boolean)true, (boolean)true)).putValue("c", (Object)Variables.byteArrayValue((byte[])"test".getBytes(), (boolean)true)).putValue("d", (Object)Variables.dateValue((Date)new Date(), (boolean)true)).putValue("e", (Object)Variables.doubleValue((Double)20.0, (boolean)true)).putValue("f", (Object)Variables.integerValue((Integer)10, (boolean)true)).putValue("g", (Object)Variables.longValue((Long)10L, (boolean)true)).putValue("h", (Object)Variables.shortValue((Short)10, (boolean)true)).putValue("i", (Object)Variables.objectValue((Object)new Integer(100), (boolean)true).create()).putValue("j", (Object)Variables.untypedValue(null, (boolean)true)).putValue("k", (Object)Variables.untypedValue((Object)Variables.booleanValue((Boolean)true), (boolean)true)).putValue("l", (Object)Variables.fileValue((File)new File(this.getClass().getClassLoader().getResource("org/camunda/bpm/engine/test/standalone/variables/simpleFile.txt").toURI()), (boolean)true)));
        List historicVariableInstances = this.historyService.createHistoricVariableInstanceQuery().list();
        List variableInstances = this.runtimeService.createVariableInstanceQuery().list();
        Assert.assertEquals((long)0L, (long)historicVariableInstances.size());
        Assert.assertEquals((long)0L, (long)variableInstances.size());
    }

    @Test
    public void createTransientVariablesUsingFluentBuilder() {
        BpmnModelInstance simpleInstanceWithListener = ((StartEventBuilder)Bpmn.createExecutableProcess((String)"Process").startEvent().camundaExecutionListenerClass("end", ReadTransientVariableExecutionListener.class)).userTask().endEvent().done();
        this.testRule.deploy(simpleInstanceWithListener);
        ((ProcessInstantiationBuilder)this.runtimeService.createProcessInstanceByKey("Process").setVariables((Map)Variables.createVariables().putValue("variable", (Object)Variables.stringValue((String)"dlsd", (boolean)true)))).execute();
        List variableInstances = this.runtimeService.createVariableInstanceQuery().list();
        List historicVariableInstances = this.historyService.createHistoricVariableInstanceQuery().list();
        Assert.assertEquals((long)0L, (long)variableInstances.size());
        Assert.assertEquals((long)0L, (long)historicVariableInstances.size());
    }

    @Test
    public void createVariablesUsingVariableMap() {
        BpmnModelInstance simpleInstanceWithListener = ((StartEventBuilder)Bpmn.createExecutableProcess((String)"Process").startEvent().camundaExecutionListenerClass("end", ReadTransientVariableExecutionListener.class)).userTask().endEvent().done();
        this.testRule.deploy(simpleInstanceWithListener);
        VariableMap variables = Variables.createVariables();
        variables.put((Object)"variable", (Object)Variables.untypedValue((Object)true, (boolean)true));
        this.runtimeService.startProcessInstanceByKey("Process", (Map)variables);
        List variableInstances = this.runtimeService.createVariableInstanceQuery().list();
        List historicVariableInstances = this.historyService.createHistoricVariableInstanceQuery().list();
        Assert.assertEquals((long)0L, (long)variableInstances.size());
        Assert.assertEquals((long)0L, (long)historicVariableInstances.size());
    }

    @Test
    public void triggerConditionalEventWithTransientVariable() {
        BpmnModelInstance instance = ((ConditionalEventDefinitionBuilder)((ServiceTaskBuilder)Bpmn.createExecutableProcess((String)"processKey").startEvent().serviceTask().camundaClass(SetVariableTransientDelegate.class.getName())).intermediateCatchEvent("conditionCatch").conditionalEventDefinition().condition("${variable == 1}")).conditionalEventDefinitionDone().endEvent().done();
        this.testRule.deploy(instance);
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("processKey");
        Assert.assertEquals((Object)true, (Object)processInstance.isEnded());
    }

    @Test
    public void testParallelProcessWithSetVariableTransientAfterReachingEventBasedGW() {
        BpmnModelInstance modelInstance = ((ServiceTaskBuilder)((UserTaskBuilder)((ConditionalEventDefinitionBuilder)((ConditionalEventDefinitionBuilder)((EventBasedGatewayBuilder)((ParallelGatewayBuilder)Bpmn.createExecutableProcess((String)"processKey").startEvent().parallelGateway().id("parallel")).userTask("taskBeforeGw").eventBasedGateway().id("evenBased")).intermediateCatchEvent().conditionalEventDefinition().condition("${variable == 1}")).camundaVariableEvents(Arrays.asList("create", "update"))).conditionalEventDefinitionDone().userTask().name("taskAfter")).endEvent().moveToNode("parallel").userTask("taskBefore").serviceTask().camundaClass(SetVariableTransientDelegate.class.getName())).endEvent().done();
        this.testRule.deploy(modelInstance);
        ProcessInstance procInst = this.runtimeService.startProcessInstanceByKey("processKey");
        TaskQuery taskQuery = this.taskService.createTaskQuery().processInstanceId(procInst.getId());
        Task taskBeforeEGW = (Task)this.taskService.createTaskQuery().taskDefinitionKey("taskBeforeGw").singleResult();
        Task taskBeforeServiceTask = (Task)this.taskService.createTaskQuery().taskDefinitionKey("taskBefore").singleResult();
        this.taskService.complete(taskBeforeEGW.getId());
        this.taskService.complete(taskBeforeServiceTask.getId());
        Task task = (Task)taskQuery.singleResult();
        Assert.assertNotNull((Object)task);
        Assert.assertEquals((Object)"taskAfter", (Object)task.getName());
        this.taskService.complete(task.getId());
        Assert.assertNull((Object)taskQuery.singleResult());
        Assert.assertNull((Object)this.runtimeService.createProcessInstanceQuery().singleResult());
    }

    @Test
    public void setVariableTransientInRunningProcessInstance() {
        this.testRule.deploy(ProcessModels.ONE_TASK_PROCESS);
        this.runtimeService.startProcessInstanceByKey("Process");
        Execution execution = (Execution)this.runtimeService.createExecutionQuery().singleResult();
        this.runtimeService.setVariable(execution.getId(), "foo", (Object)Variables.stringValue((String)"bar", (boolean)true));
        List variables = this.runtimeService.createVariableInstanceQuery().list();
        Assert.assertEquals((long)0L, (long)variables.size());
    }

    @Test
    public void setVariableTransientForCase() {
        this.testRule.deploy("org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn");
        this.engineRule.getCaseService().withCaseDefinitionByKey("oneTaskCase").setVariable("foo", (Object)Variables.stringValue((String)"bar", (boolean)true)).create();
        List variables = this.historyService.createHistoricVariableInstanceQuery().list();
        Assert.assertEquals((long)0L, (long)variables.size());
    }

    @Test
    public void testTransientVariableOvewritesPersistedVariableInSameScope() {
        this.testRule.deploy(ProcessModels.ONE_TASK_PROCESS);
        this.runtimeService.startProcessInstanceByKey("Process", (Map)Variables.createVariables().putValue("foo", (Object)"bar"));
        Execution execution = (Execution)this.runtimeService.createExecutionQuery().singleResult();
        try {
            this.runtimeService.setVariable(execution.getId(), "foo", (Object)Variables.stringValue((String)"xyz", (boolean)true));
        }
        catch (ProcessEngineException e) {
            Assertions.assertThat((String)e.getMessage()).contains(new CharSequence[]{"Cannot set transient variable with name foo"});
        }
    }

    @Test
    public void testSameNamesDifferentScopes() {
        this.testRule.deploy(ProcessModels.SUBPROCESS_PROCESS);
        this.runtimeService.startProcessInstanceByKey("Process", (Map)Variables.createVariables().putValue("foo", (Object)Variables.stringValue((String)"bar")));
        Execution execution = (Execution)this.runtimeService.createExecutionQuery().activityId("userTask").singleResult();
        try {
            this.runtimeService.setVariable(execution.getId(), "foo", (Object)Variables.stringValue((String)"xyz", (boolean)true));
        }
        catch (ProcessEngineException e) {
            Assertions.assertThat((String)e.getMessage()).contains(new CharSequence[]{"Cannot set transient variable with name foo"});
        }
    }

    @Test
    public void testFormFieldsWithCustomTransientFlags() {
        this.testRule.deploy("org/camunda/bpm/engine/test/api/form/TransientVariableTest.taskFormFieldsWithTransientFlags.bpmn20.xml");
        this.runtimeService.startProcessInstanceByKey("testProcess");
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        HashMap<String, Object> formValues = new HashMap<String, Object>();
        formValues.put("stringField", Variables.stringValue((String)"foobar", (boolean)true));
        formValues.put("longField", 9L);
        this.engineRule.getFormService().submitTaskForm(task.getId(), formValues);
        List variables = this.runtimeService.createVariableInstanceQuery().list();
        Assert.assertEquals((long)1L, (long)variables.size());
        Assert.assertEquals((Object)((VariableInstance)variables.get(0)).getValue(), (Object)9L);
    }

    @Test
    public void testStartProcessInstanceWithFormsUsingTransientVariables() {
        this.testRule.deploy("org/camunda/bpm/engine/test/api/form/TransientVariableTest.startFormFieldsWithTransientFlags.bpmn20.xml");
        ProcessDefinition processDefinition = (ProcessDefinition)this.engineRule.getRepositoryService().createProcessDefinitionQuery().singleResult();
        HashMap<String, Object> formValues = new HashMap<String, Object>();
        formValues.put("stringField", Variables.stringValue((String)"foobar", (boolean)true));
        formValues.put("longField", 9L);
        this.engineRule.getFormService().submitStartForm(processDefinition.getId(), formValues);
        List variables = this.runtimeService.createVariableInstanceQuery().list();
        Assert.assertEquals((long)1L, (long)variables.size());
        Assert.assertEquals((Object)((VariableInstance)variables.get(0)).getValue(), (Object)9L);
    }

    @Test
    public void testSignalWithTransientVariables() {
        BpmnModelInstance instance = ((ScriptTaskBuilder)((ScriptTaskBuilder)((ScriptTaskBuilder)((IntermediateCatchEventBuilder)Bpmn.createExecutableProcess((String)"Process").startEvent().intermediateCatchEvent("signalCatch").signal("signal")).scriptTask("scriptTask").scriptFormat("javascript")).camundaResultVariable("abc")).scriptText("execution.setVariable('abc', foo);")).endEvent().done();
        this.testRule.deploy(instance);
        this.runtimeService.startProcessInstanceByKey("Process");
        this.runtimeService.signalEventReceived("signal", (Map)Variables.createVariables().putValue("foo", (Object)Variables.stringValue((String)"bar", (boolean)true)));
        List variables = this.historyService.createHistoricVariableInstanceQuery().list();
        Assert.assertEquals((long)1L, (long)variables.size());
        Assert.assertEquals((Object)"abc", (Object)((HistoricVariableInstance)variables.get(0)).getName());
    }

    @Test
    public void testStartMessageCorrelationWithTransientVariable() {
        BpmnModelInstance instance = ((ScriptTaskBuilder)((ScriptTaskBuilder)((ScriptTaskBuilder)((StartEventBuilder)Bpmn.createExecutableProcess((String)"process").startEvent().message("message")).scriptTask("scriptTask").scriptFormat("javascript")).camundaResultVariable("abc")).scriptText("execution.setVariable('abc', foo);")).endEvent().done();
        this.testRule.deploy(instance);
        this.runtimeService.createMessageCorrelation("message").setVariable("foo", (Object)Variables.stringValue((String)"bar", (boolean)true)).correlate();
        List variableInstances = this.runtimeService.createVariableInstanceQuery().list();
        Assert.assertEquals((long)0L, (long)variableInstances.size());
        List historicInstances = this.historyService.createHistoricVariableInstanceQuery().list();
        Assert.assertEquals((long)1L, (long)historicInstances.size());
        Assert.assertEquals((Object)"abc", (Object)((HistoricVariableInstance)historicInstances.get(0)).getName());
        Assert.assertEquals((Object)"bar", (Object)((HistoricVariableInstance)historicInstances.get(0)).getValue());
    }

    @Test
    public void testMessageCorrelationWithTransientVariable() {
        BpmnModelInstance instance = ((ScriptTaskBuilder)((ScriptTaskBuilder)((ScriptTaskBuilder)((IntermediateCatchEventBuilder)Bpmn.createExecutableProcess((String)"process").startEvent().intermediateCatchEvent().message("message")).scriptTask("scriptTask").scriptFormat("javascript")).camundaResultVariable("abc")).scriptText("execution.setVariable('abc', blob);")).endEvent().done();
        this.testRule.deploy(instance);
        this.runtimeService.startProcessInstanceByKey("process", (Map)Variables.createVariables().putValueTyped("foo", (TypedValue)Variables.stringValue((String)"foo", (boolean)false)));
        VariableMap correlationKeys = Variables.createVariables().putValueTyped("foo", (TypedValue)Variables.stringValue((String)"foo", (boolean)true));
        VariableMap variables = Variables.createVariables().putValueTyped("blob", (TypedValue)Variables.stringValue((String)"blob", (boolean)true));
        this.runtimeService.correlateMessage("message", (Map)correlationKeys, (Map)variables);
        VariableInstance variableInstance = (VariableInstance)this.runtimeService.createVariableInstanceQuery().singleResult();
        Assert.assertNull((Object)variableInstance);
        HistoricVariableInstance historicVariableInstance = (HistoricVariableInstance)this.historyService.createHistoricVariableInstanceQuery().variableName("abc").singleResult();
        Assert.assertNotNull((Object)historicVariableInstance);
        Assert.assertEquals((Object)"blob", (Object)historicVariableInstance.getValue());
    }

    @Test
    public void testParallelExecutions() {
        BpmnModelInstance instance = ((ScriptTaskBuilder)((ScriptTaskBuilder)((ScriptTaskBuilder)((ScriptTaskBuilder)((ScriptTaskBuilder)((ScriptTaskBuilder)Bpmn.createExecutableProcess((String)"Process").startEvent().parallelGateway().scriptTask().scriptFormat("javascript")).camundaResultVariable("abc")).scriptText("execution.setVariableLocal('abc', foo);")).endEvent().moveToLastGateway().scriptTask().scriptFormat("javascript")).camundaResultVariable("abc")).scriptText("execution.setVariableLocal('abc', foo);")).endEvent().done();
        this.testRule.deploy(instance);
        this.runtimeService.startProcessInstanceByKey("Process", (Map)Variables.createVariables().putValueTyped("foo", (TypedValue)Variables.stringValue((String)"bar", (boolean)true)));
        List variables = this.runtimeService.createVariableInstanceQuery().list();
        Assert.assertEquals((long)0L, (long)variables.size());
        List historicVariables = this.historyService.createHistoricVariableInstanceQuery().variableName("abc").list();
        Assert.assertEquals((long)2L, (long)historicVariables.size());
    }

    @Test
    public void testExclusiveGateway() {
        this.testRule.deploy("org/camunda/bpm/engine/test/bpmn/gateway/ExclusiveGatewayTest.testDivergingExclusiveGateway.bpmn20.xml");
        this.runtimeService.startProcessInstanceByKey("exclusiveGwDiverging", (Map)Variables.createVariables().putValueTyped("input", (TypedValue)Variables.integerValue((Integer)1, (boolean)true)));
        List variables = this.runtimeService.createVariableInstanceQuery().list();
        Assert.assertEquals((long)0L, (long)variables.size());
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        Assert.assertEquals((Object)"theTask1", (Object)task.getTaskDefinitionKey());
    }

    @Test
    public void testChangeTransientVariable() throws URISyntaxException {
        BpmnModelInstance instance = ((ServiceTaskBuilder)Bpmn.createExecutableProcess((String)"Process").startEvent().serviceTask().camundaClass(ChangeVariableTransientDelegate.class.getName())).userTask("user").endEvent().done();
        this.testRule.deploy(instance);
        String output = "transientVariableOutput";
        HashMap<String, Boolean> variables = new HashMap<String, Boolean>();
        variables.put(output, false);
        this.runtimeService.startProcessInstanceByKey("Process", variables);
        List historicVariableInstances = this.historyService.createHistoricVariableInstanceQuery().list();
        List variableInstances = this.runtimeService.createVariableInstanceQuery().list();
        Assert.assertEquals((long)1L, (long)historicVariableInstances.size());
        Assert.assertEquals((long)1L, (long)variableInstances.size());
        Assert.assertEquals((Object)output, (Object)((VariableInstance)variableInstances.get(0)).getName());
        Assert.assertEquals((Object)2, (Object)((VariableInstance)variableInstances.get(0)).getValue());
    }

    @Test
    public void testSwitchTransientToNonVariable() throws URISyntaxException {
        BpmnModelInstance instance = ((ServiceTaskBuilder)Bpmn.createExecutableProcess((String)"Process").startEvent().serviceTask().camundaClass(SwitchTransientVariableDelegate.class.getName())).userTask("user").endEvent().done();
        this.testRule.deploy(instance);
        HashMap<String, Boolean> variables = new HashMap<String, Boolean>();
        variables.put("transient1", true);
        variables.put("transient2", false);
        this.thrown.expect(ProcessEngineException.class);
        this.thrown.expectMessage("Cannot set transient variable with name variable to non-transient variable and vice versa.");
        this.runtimeService.startProcessInstanceByKey("Process", variables);
    }

    @Test
    public void testSwitchNonToTransientVariable() throws URISyntaxException {
        BpmnModelInstance instance = ((ServiceTaskBuilder)Bpmn.createExecutableProcess((String)"Process").startEvent().serviceTask().camundaClass(SwitchTransientVariableDelegate.class.getName())).userTask("user").endEvent().done();
        this.testRule.deploy(instance);
        HashMap<String, Boolean> variables = new HashMap<String, Boolean>();
        variables.put("transient1", false);
        variables.put("transient2", true);
        this.thrown.expect(ProcessEngineException.class);
        this.thrown.expectMessage("Cannot set transient variable with name variable to non-transient variable and vice versa.");
        this.runtimeService.startProcessInstanceByKey("Process", variables);
    }

    @Test
    public void testSwitchNonToTransientLocalVariable() throws URISyntaxException {
        BpmnModelInstance instance = ((ServiceTaskBuilder)Bpmn.createExecutableProcess((String)"Process").startEvent().serviceTask().camundaClass(SetTransientLocalVariableDelegate.class)).endEvent().done();
        this.testRule.deploy(instance);
        HashMap<String, Boolean> variables = new HashMap<String, Boolean>();
        variables.put("var", false);
        this.thrown.expect(ProcessEngineException.class);
        this.thrown.expectMessage("Cannot set transient variable with name var to non-transient variable and vice versa.");
        this.runtimeService.startProcessInstanceByKey("Process", variables);
    }

    @Test
    public void testKeepTransientIfUntypedValueIsAccessed() {
        BpmnModelInstance modelInstance = ((ServiceTaskBuilder)Bpmn.createExecutableProcess((String)"aProcess").startEvent().serviceTask().camundaClass(ReadTypedTransientVariableDelegate.class)).userTask().endEvent().done();
        this.testRule.deploy(modelInstance);
        String processInstanceId = this.runtimeService.startProcessInstanceByKey("aProcess").getId();
        Object value = this.runtimeService.getVariable(processInstanceId, "var");
        Assertions.assertThat((Object)value).isNull();
    }

    @Test
    @RequiredHistoryLevel(value="full")
    public void testTransientLocalVariable() {
        BpmnModelInstance model = ((ServiceTaskBuilder)Bpmn.createExecutableProcess((String)"process").startEvent().serviceTask().camundaClass(SetTransientLocalVariableDelegate.class)).endEvent().done();
        this.testRule.deploy(model);
        this.runtimeService.startProcessInstanceByKey("process");
        long numHistoricVariables = this.engineRule.getHistoryService().createHistoricVariableInstanceQuery().count();
        Assertions.assertThat((long)numHistoricVariables).isEqualTo(0L);
    }

    public static class SwitchTransientVariableDelegate
    implements JavaDelegate {
        public void execute(DelegateExecution execution) throws Exception {
            Boolean transient1 = (Boolean)execution.getVariable("transient1");
            Boolean transient2 = (Boolean)execution.getVariable("transient2");
            execution.setVariable("variable", (Object)Variables.integerValue((Integer)1, (boolean)transient1));
            execution.setVariable("variable", (Object)Variables.integerValue((Integer)2, (boolean)transient2));
        }
    }

    public static class ChangeVariableTransientDelegate
    implements JavaDelegate {
        public void execute(DelegateExecution execution) throws Exception {
            execution.setVariable("variable", (Object)Variables.integerValue((Integer)1, (boolean)true));
            execution.setVariable("variable", (Object)Variables.integerValue((Integer)2, (boolean)true));
            execution.setVariable("transientVariableOutput", execution.getVariable("variable"));
        }
    }

    public static class ReadTransientVariableExecutionListener
    implements ExecutionListener {
        public void notify(DelegateExecution execution) throws Exception {
            Object variable = execution.getVariable("variable");
            Assert.assertNotNull((Object)variable);
        }
    }

    public static class ReadTransientVariablesOfAllTypesDelegate
    implements JavaDelegate {
        public void execute(DelegateExecution execution) throws Exception {
            for (char i = 'a'; i < 'm'; i = (char)(i + '\u0001')) {
                Object value = execution.getVariable("" + i);
                if (i != 'j') {
                    Assert.assertNotNull((Object)value);
                    continue;
                }
                Assert.assertNull((Object)value);
            }
        }
    }

    public static class SetTransientLocalVariableDelegate
    implements JavaDelegate {
        public void execute(DelegateExecution execution) throws Exception {
            StringValue transientValue = Variables.stringValue((String)"value", (boolean)true);
            execution.setVariableLocal("var", (Object)transientValue);
        }
    }

    public static class SetVariableTransientDelegate
    implements JavaDelegate {
        public void execute(DelegateExecution execution) throws Exception {
            execution.setVariable("variable", (Object)Variables.integerValue((Integer)1, (boolean)true));
        }
    }

    public static class ReadTypedTransientVariableDelegate
    implements JavaDelegate {
        public void execute(DelegateExecution execution) throws Exception {
            execution.setVariable("var", (Object)Variables.untypedValue((Object)Variables.objectValue((Object)"aString"), (boolean)true));
            TypedValue typedValue = execution.getVariableTyped("var");
            Assertions.assertThat((boolean)typedValue.isTransient()).isTrue();
        }
    }
}

