/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.task;

import java.util.List;
import org.assertj.core.api.Assertions;
import org.camunda.bpm.engine.AuthorizationService;
import org.camunda.bpm.engine.IdentityService;
import org.camunda.bpm.engine.RuntimeService;
import org.camunda.bpm.engine.TaskService;
import org.camunda.bpm.engine.authorization.Authorization;
import org.camunda.bpm.engine.authorization.Permission;
import org.camunda.bpm.engine.authorization.ProcessDefinitionPermissions;
import org.camunda.bpm.engine.authorization.Resource;
import org.camunda.bpm.engine.authorization.Resources;
import org.camunda.bpm.engine.authorization.TaskPermissions;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.task.Task;
import org.camunda.bpm.engine.test.util.ProcessEngineBootstrapRule;
import org.camunda.bpm.engine.test.util.ProcessEngineTestRule;
import org.camunda.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.junit.After;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;

public class StandaloneTasksAndCmmnDisabledTest {
    @ClassRule
    public static ProcessEngineBootstrapRule bootstrapRule = new ProcessEngineBootstrapRule(p -> p.setStandaloneTasksEnabled(false).setCmmnEnabled(false));
    public ProvidedProcessEngineRule engineRule = new ProvidedProcessEngineRule(bootstrapRule);
    public ProcessEngineTestRule engineTestRule = new ProcessEngineTestRule(this.engineRule);
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.engineRule).around((TestRule)this.engineTestRule);
    @Rule
    public ExpectedException exception = ExpectedException.none();
    private RuntimeService runtimeService;
    private TaskService taskService;
    private IdentityService identityService;
    private AuthorizationService authorizationService;

    @Before
    public void setUp() throws Exception {
        this.runtimeService = this.engineRule.getRuntimeService();
        this.taskService = this.engineRule.getTaskService();
        this.identityService = this.engineRule.getIdentityService();
        this.authorizationService = this.engineRule.getAuthorizationService();
    }

    @After
    public void tearDown() {
        this.identityService.clearAuthentication();
        this.engineRule.getProcessEngineConfiguration().setAuthorizationEnabled(false);
        this.engineTestRule.deleteAllAuthorizations();
        this.engineTestRule.deleteAllStandaloneTasks();
    }

    @Test
    public void testTaskQueryAuthorization() {
        this.engineTestRule.deploy("org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml");
        this.engineTestRule.deploy("org/camunda/bpm/engine/test/api/twoTasksProcess.bpmn20.xml");
        ProcessInstance instance1 = this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        Task instance1Task = (Task)this.taskService.createTaskQuery().processInstanceId(instance1.getId()).singleResult();
        Authorization processInstanceAuthorization = this.authorizationService.createNewAuthorization(1);
        processInstanceAuthorization.setResource((Resource)Resources.PROCESS_DEFINITION);
        processInstanceAuthorization.setResourceId("oneTaskProcess");
        processInstanceAuthorization.addPermission((Permission)ProcessDefinitionPermissions.READ_TASK);
        processInstanceAuthorization.setUserId("user");
        this.authorizationService.saveAuthorization(processInstanceAuthorization);
        ProcessInstance instance2 = this.runtimeService.startProcessInstanceByKey("twoTasksProcess");
        Task instance2Task = (Task)this.taskService.createTaskQuery().processInstanceId(instance2.getId()).singleResult();
        Authorization standaloneTaskAuthorization = this.authorizationService.createNewAuthorization(1);
        standaloneTaskAuthorization.setResource((Resource)Resources.TASK);
        standaloneTaskAuthorization.setResourceId(instance2Task.getId());
        standaloneTaskAuthorization.addPermission((Permission)TaskPermissions.READ);
        standaloneTaskAuthorization.setUserId("user");
        this.authorizationService.saveAuthorization(standaloneTaskAuthorization);
        this.runtimeService.startProcessInstanceByKey("twoTasksProcess");
        this.identityService.setAuthenticatedUserId("user");
        this.engineRule.getProcessEngineConfiguration().setAuthorizationEnabled(true);
        List tasks = this.taskService.createTaskQuery().list();
        Assertions.assertThat((List)tasks).extracting("id").containsExactlyInAnyOrder(new Object[]{instance1Task.getId(), instance2Task.getId()});
    }

    @Test
    public void testTaskQueryAuthorizationWithProcessDefinitionFilter() {
        this.engineTestRule.deploy("org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml");
        this.engineTestRule.deploy("org/camunda/bpm/engine/test/api/twoTasksProcess.bpmn20.xml");
        ProcessInstance instance1 = this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        Task instance1Task = (Task)this.taskService.createTaskQuery().processInstanceId(instance1.getId()).singleResult();
        Authorization oneTaskAuthorization = this.authorizationService.createNewAuthorization(1);
        oneTaskAuthorization.setResource((Resource)Resources.PROCESS_DEFINITION);
        oneTaskAuthorization.setResourceId("oneTaskProcess");
        oneTaskAuthorization.addPermission((Permission)ProcessDefinitionPermissions.READ_TASK);
        oneTaskAuthorization.setUserId("user");
        this.authorizationService.saveAuthorization(oneTaskAuthorization);
        this.runtimeService.startProcessInstanceByKey("twoTasksProcess");
        this.identityService.setAuthenticatedUserId("user");
        this.engineRule.getProcessEngineConfiguration().setAuthorizationEnabled(true);
        List tasks = this.taskService.createTaskQuery().processDefinitionKey("oneTaskProcess").list();
        Assertions.assertThat((List)tasks).hasSize(1);
        Assertions.assertThat((String)((Task)tasks.get(0)).getId()).isEqualTo((Object)instance1Task.getId());
    }

    @Test
    public void testTaskQueryAuthorizationWithProcessDefinitionFilterInOrQuery() {
        this.engineTestRule.deploy("org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml");
        this.engineTestRule.deploy("org/camunda/bpm/engine/test/api/twoTasksProcess.bpmn20.xml");
        ProcessInstance instance1 = this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        Task instance1Task = (Task)this.taskService.createTaskQuery().processInstanceId(instance1.getId()).singleResult();
        ProcessInstance instance2 = this.runtimeService.startProcessInstanceByKey("twoTasksProcess");
        Task instance2Task = (Task)this.taskService.createTaskQuery().processInstanceId(instance2.getId()).singleResult();
        this.runtimeService.setVariable(instance2.getId(), "markerVar", (Object)"markerValue");
        ProcessInstance instance3 = this.runtimeService.startProcessInstanceByKey("twoTasksProcess");
        this.taskService.createTaskQuery().processInstanceId(instance3.getId()).singleResult();
        Authorization oneTaskAuthorization = this.authorizationService.createNewAuthorization(1);
        oneTaskAuthorization.setResource((Resource)Resources.PROCESS_DEFINITION);
        oneTaskAuthorization.setResourceId("oneTaskProcess");
        oneTaskAuthorization.addPermission((Permission)ProcessDefinitionPermissions.READ_TASK);
        oneTaskAuthorization.setUserId("user");
        this.authorizationService.saveAuthorization(oneTaskAuthorization);
        Authorization twoTasksAuthorization = this.authorizationService.createNewAuthorization(1);
        twoTasksAuthorization.setResource((Resource)Resources.PROCESS_DEFINITION);
        twoTasksAuthorization.setResourceId("twoTasksProcess");
        twoTasksAuthorization.addPermission((Permission)ProcessDefinitionPermissions.READ_TASK);
        twoTasksAuthorization.setUserId("user");
        this.authorizationService.saveAuthorization(twoTasksAuthorization);
        this.identityService.setAuthenticatedUserId("user");
        this.engineRule.getProcessEngineConfiguration().setAuthorizationEnabled(true);
        List tasks = this.taskService.createTaskQuery().or().processDefinitionKey("oneTaskProcess").processVariableValueEquals("markerVar", (Object)"markerValue").endOr().list();
        Assertions.assertThat((List)tasks).extracting("id").containsExactlyInAnyOrder(new Object[]{instance1Task.getId(), instance2Task.getId()});
    }
}

