/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.cmmn.listener;

import org.camunda.bpm.engine.delegate.CaseExecutionListener;
import org.camunda.bpm.engine.runtime.CaseExecution;
import org.camunda.bpm.engine.runtime.VariableInstance;
import org.camunda.bpm.engine.runtime.VariableInstanceQuery;
import org.camunda.bpm.engine.test.Deployment;
import org.camunda.bpm.engine.test.cmmn.CmmnTest;
import org.camunda.bpm.engine.test.cmmn.listener.FieldInjectionCaseExecutionListener;
import org.camunda.bpm.engine.test.cmmn.listener.MyCaseExecutionListener;
import org.camunda.bpm.engine.test.cmmn.listener.MySpecialCaseExecutionListener;
import org.camunda.bpm.engine.test.cmmn.listener.NotCaseExecutionListener;
import org.junit.Assert;
import org.junit.Test;

public class CaseExecutionListenerTest
extends CmmnTest {
    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/listener/CaseExecutionListenerTest.testCreateListenerByClass.cmmn"})
    @Test
    public void testCreateListenerByClass() {
        String caseInstanceId = this.caseService.withCaseDefinitionByKey("case").create().getId();
        String humanTaskId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult()).getId();
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery().caseInstanceIdIn(new String[]{caseInstanceId});
        Assert.assertEquals((long)4L, (long)query.count());
        Assert.assertTrue((boolean)((Boolean)((VariableInstance)query.variableName("create").singleResult()).getValue()));
        Assert.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("createEventCounter").singleResult()).getValue());
        Assert.assertEquals((Object)humanTaskId, (Object)((VariableInstance)query.variableName("createOnCaseExecutionId").singleResult()).getValue());
        Assert.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("eventCounter").singleResult()).getValue());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/listener/CaseExecutionListenerTest.testCreateListenerByDelegateExpression.cmmn"})
    @Test
    public void testCreateListenerByDelegateExpression() {
        String caseInstanceId = this.caseService.withCaseDefinitionByKey("case").setVariable("myListener", (Object)new MySpecialCaseExecutionListener()).create().getId();
        String humanTaskId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult()).getId();
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery().caseInstanceIdIn(new String[]{caseInstanceId});
        Assert.assertEquals((long)5L, (long)query.count());
        Assert.assertTrue((boolean)((Boolean)((VariableInstance)query.variableName("create").singleResult()).getValue()));
        Assert.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("createEventCounter").singleResult()).getValue());
        Assert.assertEquals((Object)humanTaskId, (Object)((VariableInstance)query.variableName("createOnCaseExecutionId").singleResult()).getValue());
        Assert.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("eventCounter").singleResult()).getValue());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/listener/CaseExecutionListenerTest.testCreateListenerByExpression.cmmn"})
    @Test
    public void testCreateListenerByExpression() {
        String caseInstanceId = this.caseService.withCaseDefinitionByKey("case").setVariable("myListener", (Object)new MyCaseExecutionListener()).create().getId();
        String humanTaskId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult()).getId();
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery().caseInstanceIdIn(new String[]{caseInstanceId});
        Assert.assertEquals((long)5L, (long)query.count());
        Assert.assertTrue((boolean)((Boolean)((VariableInstance)query.variableName("create").singleResult()).getValue()));
        Assert.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("createEventCounter").singleResult()).getValue());
        Assert.assertEquals((Object)humanTaskId, (Object)((VariableInstance)query.variableName("createOnCaseExecutionId").singleResult()).getValue());
        Assert.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("eventCounter").singleResult()).getValue());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/listener/CaseExecutionListenerTest.testCreateListenerByScript.cmmn"})
    @Test
    public void testCreateListenerByScript() {
        String caseInstanceId = this.caseService.withCaseDefinitionByKey("case").create().getId();
        String humanTaskId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult()).getId();
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery().caseInstanceIdIn(new String[]{caseInstanceId});
        Assert.assertEquals((long)4L, (long)query.count());
        Assert.assertTrue((boolean)((Boolean)((VariableInstance)query.variableName("create").singleResult()).getValue()));
        Assert.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("createEventCounter").singleResult()).getValue());
        Assert.assertEquals((Object)humanTaskId, (Object)((VariableInstance)query.variableName("createOnCaseExecutionId").singleResult()).getValue());
        Assert.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("eventCounter").singleResult()).getValue());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/listener/CaseExecutionListenerTest.testEnableListenerByClass.cmmn"})
    @Test
    public void testEnableListenerByClass() {
        String caseInstanceId = this.caseService.withCaseDefinitionByKey("case").create().getId();
        String humanTaskId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult()).getId();
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery().caseInstanceIdIn(new String[]{caseInstanceId});
        Assert.assertEquals((long)4L, (long)query.count());
        Assert.assertTrue((boolean)((Boolean)((VariableInstance)query.variableName("enable").singleResult()).getValue()));
        Assert.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("enableEventCounter").singleResult()).getValue());
        Assert.assertEquals((Object)humanTaskId, (Object)((VariableInstance)query.variableName("enableOnCaseExecutionId").singleResult()).getValue());
        Assert.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("eventCounter").singleResult()).getValue());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/listener/CaseExecutionListenerTest.testEnableListenerByDelegateExpression.cmmn"})
    @Test
    public void testEnableListenerByDelegateExpression() {
        String caseInstanceId = this.caseService.withCaseDefinitionByKey("case").setVariable("myListener", (Object)new MySpecialCaseExecutionListener()).create().getId();
        String humanTaskId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult()).getId();
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery().caseInstanceIdIn(new String[]{caseInstanceId});
        Assert.assertEquals((long)5L, (long)query.count());
        Assert.assertTrue((boolean)((Boolean)((VariableInstance)query.variableName("enable").singleResult()).getValue()));
        Assert.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("enableEventCounter").singleResult()).getValue());
        Assert.assertEquals((Object)humanTaskId, (Object)((VariableInstance)query.variableName("enableOnCaseExecutionId").singleResult()).getValue());
        Assert.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("eventCounter").singleResult()).getValue());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/listener/CaseExecutionListenerTest.testEnableListenerByExpression.cmmn"})
    @Test
    public void testEnableListenerByExpression() {
        String caseInstanceId = this.caseService.withCaseDefinitionByKey("case").setVariable("myListener", (Object)new MyCaseExecutionListener()).create().getId();
        String humanTaskId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult()).getId();
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery().caseInstanceIdIn(new String[]{caseInstanceId});
        Assert.assertEquals((long)5L, (long)query.count());
        Assert.assertTrue((boolean)((Boolean)((VariableInstance)query.variableName("enable").singleResult()).getValue()));
        Assert.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("enableEventCounter").singleResult()).getValue());
        Assert.assertEquals((Object)humanTaskId, (Object)((VariableInstance)query.variableName("enableOnCaseExecutionId").singleResult()).getValue());
        Assert.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("eventCounter").singleResult()).getValue());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/listener/CaseExecutionListenerTest.testEnableListenerByScript.cmmn"})
    @Test
    public void testEnableListenerByScript() {
        String caseInstanceId = this.caseService.withCaseDefinitionByKey("case").create().getId();
        String humanTaskId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult()).getId();
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery().caseInstanceIdIn(new String[]{caseInstanceId});
        Assert.assertEquals((long)4L, (long)query.count());
        Assert.assertTrue((boolean)((Boolean)((VariableInstance)query.variableName("enable").singleResult()).getValue()));
        Assert.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("enableEventCounter").singleResult()).getValue());
        Assert.assertEquals((Object)humanTaskId, (Object)((VariableInstance)query.variableName("enableOnCaseExecutionId").singleResult()).getValue());
        Assert.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("eventCounter").singleResult()).getValue());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/listener/CaseExecutionListenerTest.testDisableListenerByClass.cmmn"})
    @Test
    public void testDisableListenerByClass() {
        String caseInstanceId = this.caseService.withCaseDefinitionByKey("case").create().getId();
        String humanTaskId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult()).getId();
        this.caseService.withCaseExecution(humanTaskId).disable();
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery().caseInstanceIdIn(new String[]{caseInstanceId});
        Assert.assertEquals((long)4L, (long)query.count());
        Assert.assertTrue((boolean)((Boolean)((VariableInstance)query.variableName("disable").singleResult()).getValue()));
        Assert.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("disableEventCounter").singleResult()).getValue());
        Assert.assertEquals((Object)humanTaskId, (Object)((VariableInstance)query.variableName("disableOnCaseExecutionId").singleResult()).getValue());
        Assert.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("eventCounter").singleResult()).getValue());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/listener/CaseExecutionListenerTest.testDisableListenerByDelegateExpression.cmmn"})
    @Test
    public void testDisableListenerByDelegateExpression() {
        String caseInstanceId = this.caseService.withCaseDefinitionByKey("case").setVariable("myListener", (Object)new MySpecialCaseExecutionListener()).create().getId();
        String humanTaskId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult()).getId();
        this.caseService.withCaseExecution(humanTaskId).disable();
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery().caseInstanceIdIn(new String[]{caseInstanceId});
        Assert.assertEquals((long)5L, (long)query.count());
        Assert.assertTrue((boolean)((Boolean)((VariableInstance)query.variableName("disable").singleResult()).getValue()));
        Assert.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("disableEventCounter").singleResult()).getValue());
        Assert.assertEquals((Object)humanTaskId, (Object)((VariableInstance)query.variableName("disableOnCaseExecutionId").singleResult()).getValue());
        Assert.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("eventCounter").singleResult()).getValue());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/listener/CaseExecutionListenerTest.testDisableListenerByExpression.cmmn"})
    @Test
    public void testDisableListenerByExpression() {
        String caseInstanceId = this.caseService.withCaseDefinitionByKey("case").setVariable("myListener", (Object)new MyCaseExecutionListener()).create().getId();
        String humanTaskId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult()).getId();
        this.caseService.withCaseExecution(humanTaskId).disable();
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery().caseInstanceIdIn(new String[]{caseInstanceId});
        Assert.assertEquals((long)5L, (long)query.count());
        Assert.assertTrue((boolean)((Boolean)((VariableInstance)query.variableName("disable").singleResult()).getValue()));
        Assert.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("disableEventCounter").singleResult()).getValue());
        Assert.assertEquals((Object)humanTaskId, (Object)((VariableInstance)query.variableName("disableOnCaseExecutionId").singleResult()).getValue());
        Assert.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("eventCounter").singleResult()).getValue());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/listener/CaseExecutionListenerTest.testDisableListenerByScript.cmmn"})
    @Test
    public void testDisableListenerByScript() {
        String caseInstanceId = this.caseService.withCaseDefinitionByKey("case").create().getId();
        String humanTaskId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult()).getId();
        this.caseService.withCaseExecution(humanTaskId).disable();
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery().caseInstanceIdIn(new String[]{caseInstanceId});
        Assert.assertEquals((long)4L, (long)query.count());
        Assert.assertTrue((boolean)((Boolean)((VariableInstance)query.variableName("disable").singleResult()).getValue()));
        Assert.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("disableEventCounter").singleResult()).getValue());
        Assert.assertEquals((Object)humanTaskId, (Object)((VariableInstance)query.variableName("disableOnCaseExecutionId").singleResult()).getValue());
        Assert.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("eventCounter").singleResult()).getValue());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/listener/CaseExecutionListenerTest.testReEnableListenerByClass.cmmn"})
    @Test
    public void testReEnableListenerByClass() {
        String caseInstanceId = this.caseService.withCaseDefinitionByKey("case").create().getId();
        String humanTaskId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult()).getId();
        this.caseService.withCaseExecution(humanTaskId).disable();
        this.caseService.withCaseExecution(humanTaskId).reenable();
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery().caseInstanceIdIn(new String[]{caseInstanceId});
        Assert.assertEquals((long)4L, (long)query.count());
        Assert.assertTrue((boolean)((Boolean)((VariableInstance)query.variableName("reenable").singleResult()).getValue()));
        Assert.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("reenableEventCounter").singleResult()).getValue());
        Assert.assertEquals((Object)humanTaskId, (Object)((VariableInstance)query.variableName("reenableOnCaseExecutionId").singleResult()).getValue());
        Assert.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("eventCounter").singleResult()).getValue());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/listener/CaseExecutionListenerTest.testReEnableListenerByDelegateExpression.cmmn"})
    @Test
    public void testReEnableListenerByDelegateExpression() {
        String caseInstanceId = this.caseService.withCaseDefinitionByKey("case").setVariable("myListener", (Object)new MySpecialCaseExecutionListener()).create().getId();
        String humanTaskId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult()).getId();
        this.caseService.withCaseExecution(humanTaskId).disable();
        this.caseService.withCaseExecution(humanTaskId).reenable();
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery().caseInstanceIdIn(new String[]{caseInstanceId});
        Assert.assertEquals((long)5L, (long)query.count());
        Assert.assertTrue((boolean)((Boolean)((VariableInstance)query.variableName("reenable").singleResult()).getValue()));
        Assert.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("reenableEventCounter").singleResult()).getValue());
        Assert.assertEquals((Object)humanTaskId, (Object)((VariableInstance)query.variableName("reenableOnCaseExecutionId").singleResult()).getValue());
        Assert.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("eventCounter").singleResult()).getValue());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/listener/CaseExecutionListenerTest.testReEnableListenerByExpression.cmmn"})
    @Test
    public void testReEnableListenerByExpression() {
        String caseInstanceId = this.caseService.withCaseDefinitionByKey("case").setVariable("myListener", (Object)new MyCaseExecutionListener()).create().getId();
        String humanTaskId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult()).getId();
        this.caseService.withCaseExecution(humanTaskId).disable();
        this.caseService.withCaseExecution(humanTaskId).reenable();
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery().caseInstanceIdIn(new String[]{caseInstanceId});
        Assert.assertEquals((long)5L, (long)query.count());
        Assert.assertTrue((boolean)((Boolean)((VariableInstance)query.variableName("reenable").singleResult()).getValue()));
        Assert.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("reenableEventCounter").singleResult()).getValue());
        Assert.assertEquals((Object)humanTaskId, (Object)((VariableInstance)query.variableName("reenableOnCaseExecutionId").singleResult()).getValue());
        Assert.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("eventCounter").singleResult()).getValue());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/listener/CaseExecutionListenerTest.testReEnableListenerByScript.cmmn"})
    @Test
    public void testReEnableListenerByScript() {
        String caseInstanceId = this.caseService.withCaseDefinitionByKey("case").create().getId();
        String humanTaskId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult()).getId();
        this.caseService.withCaseExecution(humanTaskId).disable();
        this.caseService.withCaseExecution(humanTaskId).reenable();
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery().caseInstanceIdIn(new String[]{caseInstanceId});
        Assert.assertEquals((long)4L, (long)query.count());
        Assert.assertTrue((boolean)((Boolean)((VariableInstance)query.variableName("reenable").singleResult()).getValue()));
        Assert.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("reenableEventCounter").singleResult()).getValue());
        Assert.assertEquals((Object)humanTaskId, (Object)((VariableInstance)query.variableName("reenableOnCaseExecutionId").singleResult()).getValue());
        Assert.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("eventCounter").singleResult()).getValue());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/listener/CaseExecutionListenerTest.testStartListenerByClass.cmmn"})
    @Test
    public void testStartListenerByClass() {
        String caseInstanceId = this.caseService.withCaseDefinitionByKey("case").create().getId();
        String humanTaskId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult()).getId();
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery().caseInstanceIdIn(new String[]{caseInstanceId});
        Assert.assertEquals((long)4L, (long)query.count());
        Assert.assertTrue((boolean)((Boolean)((VariableInstance)query.variableName("start").singleResult()).getValue()));
        Assert.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("startEventCounter").singleResult()).getValue());
        Assert.assertEquals((Object)humanTaskId, (Object)((VariableInstance)query.variableName("startOnCaseExecutionId").singleResult()).getValue());
        Assert.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("eventCounter").singleResult()).getValue());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/listener/CaseExecutionListenerTest.testStartListenerByDelegateExpression.cmmn"})
    @Test
    public void testStartListenerByDelegateExpression() {
        String caseInstanceId = this.caseService.withCaseDefinitionByKey("case").setVariable("myListener", (Object)new MySpecialCaseExecutionListener()).create().getId();
        String humanTaskId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult()).getId();
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery().caseInstanceIdIn(new String[]{caseInstanceId});
        Assert.assertEquals((long)5L, (long)query.count());
        Assert.assertTrue((boolean)((Boolean)((VariableInstance)query.variableName("start").singleResult()).getValue()));
        Assert.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("startEventCounter").singleResult()).getValue());
        Assert.assertEquals((Object)humanTaskId, (Object)((VariableInstance)query.variableName("startOnCaseExecutionId").singleResult()).getValue());
        Assert.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("eventCounter").singleResult()).getValue());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/listener/CaseExecutionListenerTest.testStartListenerByExpression.cmmn"})
    @Test
    public void testStartListenerByExpression() {
        String caseInstanceId = this.caseService.withCaseDefinitionByKey("case").setVariable("myListener", (Object)new MyCaseExecutionListener()).create().getId();
        String humanTaskId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult()).getId();
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery().caseInstanceIdIn(new String[]{caseInstanceId});
        Assert.assertEquals((long)5L, (long)query.count());
        Assert.assertTrue((boolean)((Boolean)((VariableInstance)query.variableName("start").singleResult()).getValue()));
        Assert.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("startEventCounter").singleResult()).getValue());
        Assert.assertEquals((Object)humanTaskId, (Object)((VariableInstance)query.variableName("startOnCaseExecutionId").singleResult()).getValue());
        Assert.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("eventCounter").singleResult()).getValue());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/listener/CaseExecutionListenerTest.testStartListenerByScript.cmmn"})
    @Test
    public void testStartListenerByScript() {
        String caseInstanceId = this.caseService.withCaseDefinitionByKey("case").create().getId();
        String humanTaskId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult()).getId();
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery().caseInstanceIdIn(new String[]{caseInstanceId});
        Assert.assertEquals((long)4L, (long)query.count());
        Assert.assertTrue((boolean)((Boolean)((VariableInstance)query.variableName("start").singleResult()).getValue()));
        Assert.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("startEventCounter").singleResult()).getValue());
        Assert.assertEquals((Object)humanTaskId, (Object)((VariableInstance)query.variableName("startOnCaseExecutionId").singleResult()).getValue());
        Assert.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("eventCounter").singleResult()).getValue());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/listener/CaseExecutionListenerTest.testManualStartListenerByClass.cmmn"})
    @Test
    public void testManualStartListenerByClass() {
        String caseInstanceId = this.caseService.withCaseDefinitionByKey("case").create().getId();
        String humanTaskId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult()).getId();
        this.caseService.withCaseExecution(humanTaskId).manualStart();
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery().caseInstanceIdIn(new String[]{caseInstanceId});
        Assert.assertEquals((long)4L, (long)query.count());
        Assert.assertTrue((boolean)((Boolean)((VariableInstance)query.variableName("manualStart").singleResult()).getValue()));
        Assert.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("manualStartEventCounter").singleResult()).getValue());
        Assert.assertEquals((Object)humanTaskId, (Object)((VariableInstance)query.variableName("manualStartOnCaseExecutionId").singleResult()).getValue());
        Assert.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("eventCounter").singleResult()).getValue());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/listener/CaseExecutionListenerTest.testManualStartListenerByDelegateExpression.cmmn"})
    @Test
    public void testManualStartListenerByDelegateExpression() {
        String caseInstanceId = this.caseService.withCaseDefinitionByKey("case").setVariable("myListener", (Object)new MySpecialCaseExecutionListener()).create().getId();
        String humanTaskId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult()).getId();
        this.caseService.withCaseExecution(humanTaskId).manualStart();
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery().caseInstanceIdIn(new String[]{caseInstanceId});
        Assert.assertEquals((long)5L, (long)query.count());
        Assert.assertTrue((boolean)((Boolean)((VariableInstance)query.variableName("manualStart").singleResult()).getValue()));
        Assert.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("manualStartEventCounter").singleResult()).getValue());
        Assert.assertEquals((Object)humanTaskId, (Object)((VariableInstance)query.variableName("manualStartOnCaseExecutionId").singleResult()).getValue());
        Assert.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("eventCounter").singleResult()).getValue());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/listener/CaseExecutionListenerTest.testManualStartListenerByExpression.cmmn"})
    @Test
    public void testManualStartListenerByExpression() {
        String caseInstanceId = this.caseService.withCaseDefinitionByKey("case").setVariable("myListener", (Object)new MyCaseExecutionListener()).create().getId();
        String humanTaskId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult()).getId();
        this.caseService.withCaseExecution(humanTaskId).manualStart();
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery().caseInstanceIdIn(new String[]{caseInstanceId});
        Assert.assertEquals((long)5L, (long)query.count());
        Assert.assertTrue((boolean)((Boolean)((VariableInstance)query.variableName("manualStart").singleResult()).getValue()));
        Assert.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("manualStartEventCounter").singleResult()).getValue());
        Assert.assertEquals((Object)humanTaskId, (Object)((VariableInstance)query.variableName("manualStartOnCaseExecutionId").singleResult()).getValue());
        Assert.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("eventCounter").singleResult()).getValue());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/listener/CaseExecutionListenerTest.testManualStartListenerByScript.cmmn"})
    @Test
    public void testManualStartListenerByScript() {
        String caseInstanceId = this.caseService.withCaseDefinitionByKey("case").create().getId();
        String humanTaskId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult()).getId();
        this.caseService.withCaseExecution(humanTaskId).manualStart();
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery().caseInstanceIdIn(new String[]{caseInstanceId});
        Assert.assertEquals((long)4L, (long)query.count());
        Assert.assertTrue((boolean)((Boolean)((VariableInstance)query.variableName("manualStart").singleResult()).getValue()));
        Assert.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("manualStartEventCounter").singleResult()).getValue());
        Assert.assertEquals((Object)humanTaskId, (Object)((VariableInstance)query.variableName("manualStartOnCaseExecutionId").singleResult()).getValue());
        Assert.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("eventCounter").singleResult()).getValue());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/listener/CaseExecutionListenerTest.testCompleteListenerByClass.cmmn"})
    @Test
    public void testCompleteListenerByClass() {
        String caseInstanceId = this.caseService.withCaseDefinitionByKey("case").create().getId();
        String humanTaskId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult()).getId();
        this.caseService.withCaseExecution(humanTaskId).complete();
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery().caseInstanceIdIn(new String[]{caseInstanceId});
        Assert.assertEquals((long)4L, (long)query.count());
        Assert.assertTrue((boolean)((Boolean)((VariableInstance)query.variableName("complete").singleResult()).getValue()));
        Assert.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("completeEventCounter").singleResult()).getValue());
        Assert.assertEquals((Object)humanTaskId, (Object)((VariableInstance)query.variableName("completeOnCaseExecutionId").singleResult()).getValue());
        Assert.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("eventCounter").singleResult()).getValue());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/listener/CaseExecutionListenerTest.testCompleteListenerByDelegateExpression.cmmn"})
    @Test
    public void testCompleteListenerByDelegateExpression() {
        String caseInstanceId = this.caseService.withCaseDefinitionByKey("case").setVariable("myListener", (Object)new MySpecialCaseExecutionListener()).create().getId();
        String humanTaskId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult()).getId();
        this.caseService.withCaseExecution(humanTaskId).complete();
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery().caseInstanceIdIn(new String[]{caseInstanceId});
        Assert.assertEquals((long)5L, (long)query.count());
        Assert.assertTrue((boolean)((Boolean)((VariableInstance)query.variableName("complete").singleResult()).getValue()));
        Assert.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("completeEventCounter").singleResult()).getValue());
        Assert.assertEquals((Object)humanTaskId, (Object)((VariableInstance)query.variableName("completeOnCaseExecutionId").singleResult()).getValue());
        Assert.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("eventCounter").singleResult()).getValue());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/listener/CaseExecutionListenerTest.testCompleteListenerByExpression.cmmn"})
    @Test
    public void testCompleteListenerByExpression() {
        String caseInstanceId = this.caseService.withCaseDefinitionByKey("case").setVariable("myListener", (Object)new MyCaseExecutionListener()).create().getId();
        String humanTaskId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult()).getId();
        this.caseService.withCaseExecution(humanTaskId).complete();
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery().caseInstanceIdIn(new String[]{caseInstanceId});
        Assert.assertEquals((long)5L, (long)query.count());
        Assert.assertTrue((boolean)((Boolean)((VariableInstance)query.variableName("complete").singleResult()).getValue()));
        Assert.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("completeEventCounter").singleResult()).getValue());
        Assert.assertEquals((Object)humanTaskId, (Object)((VariableInstance)query.variableName("completeOnCaseExecutionId").singleResult()).getValue());
        Assert.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("eventCounter").singleResult()).getValue());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/listener/CaseExecutionListenerTest.testCompleteListenerByScript.cmmn"})
    @Test
    public void testCompleteListenerByScript() {
        String caseInstanceId = this.caseService.withCaseDefinitionByKey("case").create().getId();
        String humanTaskId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult()).getId();
        this.caseService.withCaseExecution(humanTaskId).complete();
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery().caseInstanceIdIn(new String[]{caseInstanceId});
        Assert.assertEquals((long)4L, (long)query.count());
        Assert.assertTrue((boolean)((Boolean)((VariableInstance)query.variableName("complete").singleResult()).getValue()));
        Assert.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("completeEventCounter").singleResult()).getValue());
        Assert.assertEquals((Object)humanTaskId, (Object)((VariableInstance)query.variableName("completeOnCaseExecutionId").singleResult()).getValue());
        Assert.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("eventCounter").singleResult()).getValue());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/listener/CaseExecutionListenerTest.testTerminateListenerByClass.cmmn"})
    @Test
    public void testTerminateListenerByClass() {
        String caseInstanceId = this.caseService.withCaseDefinitionByKey("case").create().getId();
        String humanTaskId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult()).getId();
        this.terminate(humanTaskId);
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery().caseInstanceIdIn(new String[]{caseInstanceId});
        Assert.assertEquals((long)4L, (long)query.count());
        Assert.assertTrue((boolean)((Boolean)((VariableInstance)query.variableName("terminate").singleResult()).getValue()));
        Assert.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("terminateEventCounter").singleResult()).getValue());
        Assert.assertEquals((Object)humanTaskId, (Object)((VariableInstance)query.variableName("terminateOnCaseExecutionId").singleResult()).getValue());
        Assert.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("eventCounter").singleResult()).getValue());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/listener/CaseExecutionListenerTest.testTerminateListenerByDelegateExpression.cmmn"})
    @Test
    public void testTerminateListenerByDelegateExpression() {
        String caseInstanceId = this.caseService.withCaseDefinitionByKey("case").setVariable("myListener", (Object)new MySpecialCaseExecutionListener()).create().getId();
        String humanTaskId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult()).getId();
        this.terminate(humanTaskId);
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery().caseInstanceIdIn(new String[]{caseInstanceId});
        Assert.assertEquals((long)5L, (long)query.count());
        Assert.assertTrue((boolean)((Boolean)((VariableInstance)query.variableName("terminate").singleResult()).getValue()));
        Assert.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("terminateEventCounter").singleResult()).getValue());
        Assert.assertEquals((Object)humanTaskId, (Object)((VariableInstance)query.variableName("terminateOnCaseExecutionId").singleResult()).getValue());
        Assert.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("eventCounter").singleResult()).getValue());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/listener/CaseExecutionListenerTest.testTerminateListenerByExpression.cmmn"})
    @Test
    public void testTerminateListenerByExpression() {
        String caseInstanceId = this.caseService.withCaseDefinitionByKey("case").setVariable("myListener", (Object)new MyCaseExecutionListener()).create().getId();
        String humanTaskId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult()).getId();
        this.terminate(humanTaskId);
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery().caseInstanceIdIn(new String[]{caseInstanceId});
        Assert.assertEquals((long)5L, (long)query.count());
        Assert.assertTrue((boolean)((Boolean)((VariableInstance)query.variableName("terminate").singleResult()).getValue()));
        Assert.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("terminateEventCounter").singleResult()).getValue());
        Assert.assertEquals((Object)humanTaskId, (Object)((VariableInstance)query.variableName("terminateOnCaseExecutionId").singleResult()).getValue());
        Assert.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("eventCounter").singleResult()).getValue());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/listener/CaseExecutionListenerTest.testTerminateListenerByScript.cmmn"})
    @Test
    public void testTerminateListenerByScript() {
        String caseInstanceId = this.caseService.withCaseDefinitionByKey("case").create().getId();
        String humanTaskId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult()).getId();
        this.terminate(humanTaskId);
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery().caseInstanceIdIn(new String[]{caseInstanceId});
        Assert.assertEquals((long)4L, (long)query.count());
        Assert.assertTrue((boolean)((Boolean)((VariableInstance)query.variableName("terminate").singleResult()).getValue()));
        Assert.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("terminateEventCounter").singleResult()).getValue());
        Assert.assertEquals((Object)humanTaskId, (Object)((VariableInstance)query.variableName("terminateOnCaseExecutionId").singleResult()).getValue());
        Assert.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("eventCounter").singleResult()).getValue());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/listener/CaseExecutionListenerTest.testExitListenerByClass.cmmn"})
    @Test
    public void testExitListenerByClass() {
        String caseInstanceId = this.caseService.withCaseDefinitionByKey("case").create().getId();
        String humanTaskId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult()).getId();
        this.exit(humanTaskId);
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery().caseInstanceIdIn(new String[]{caseInstanceId});
        Assert.assertEquals((long)4L, (long)query.count());
        Assert.assertTrue((boolean)((Boolean)((VariableInstance)query.variableName("exit").singleResult()).getValue()));
        Assert.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("exitEventCounter").singleResult()).getValue());
        Assert.assertEquals((Object)humanTaskId, (Object)((VariableInstance)query.variableName("exitOnCaseExecutionId").singleResult()).getValue());
        Assert.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("eventCounter").singleResult()).getValue());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/listener/CaseExecutionListenerTest.testExitListenerByDelegateExpression.cmmn"})
    @Test
    public void testExitListenerByDelegateExpression() {
        String caseInstanceId = this.caseService.withCaseDefinitionByKey("case").setVariable("myListener", (Object)new MySpecialCaseExecutionListener()).create().getId();
        String humanTaskId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult()).getId();
        this.exit(humanTaskId);
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery().caseInstanceIdIn(new String[]{caseInstanceId});
        Assert.assertEquals((long)5L, (long)query.count());
        Assert.assertTrue((boolean)((Boolean)((VariableInstance)query.variableName("exit").singleResult()).getValue()));
        Assert.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("exitEventCounter").singleResult()).getValue());
        Assert.assertEquals((Object)humanTaskId, (Object)((VariableInstance)query.variableName("exitOnCaseExecutionId").singleResult()).getValue());
        Assert.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("eventCounter").singleResult()).getValue());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/listener/CaseExecutionListenerTest.testExitListenerByExpression.cmmn"})
    @Test
    public void testExitListenerByExpression() {
        String caseInstanceId = this.caseService.withCaseDefinitionByKey("case").setVariable("myListener", (Object)new MyCaseExecutionListener()).create().getId();
        String humanTaskId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult()).getId();
        this.exit(humanTaskId);
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery().caseInstanceIdIn(new String[]{caseInstanceId});
        Assert.assertEquals((long)5L, (long)query.count());
        Assert.assertTrue((boolean)((Boolean)((VariableInstance)query.variableName("exit").singleResult()).getValue()));
        Assert.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("exitEventCounter").singleResult()).getValue());
        Assert.assertEquals((Object)humanTaskId, (Object)((VariableInstance)query.variableName("exitOnCaseExecutionId").singleResult()).getValue());
        Assert.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("eventCounter").singleResult()).getValue());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/listener/CaseExecutionListenerTest.testExitListenerByScript.cmmn"})
    @Test
    public void testExitListenerByScript() {
        String caseInstanceId = this.caseService.withCaseDefinitionByKey("case").create().getId();
        String humanTaskId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult()).getId();
        this.exit(humanTaskId);
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery().caseInstanceIdIn(new String[]{caseInstanceId});
        Assert.assertEquals((long)4L, (long)query.count());
        Assert.assertTrue((boolean)((Boolean)((VariableInstance)query.variableName("exit").singleResult()).getValue()));
        Assert.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("exitEventCounter").singleResult()).getValue());
        Assert.assertEquals((Object)humanTaskId, (Object)((VariableInstance)query.variableName("exitOnCaseExecutionId").singleResult()).getValue());
        Assert.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("eventCounter").singleResult()).getValue());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/listener/CaseExecutionListenerTest.testParentTerminateListenerByClass.cmmn"})
    @Test
    public void testParentTerminateListenerByClass() {
        String caseInstanceId = this.caseService.withCaseDefinitionByKey("case").create().getId();
        String milestoneId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_Milestone_1").singleResult()).getId();
        this.parentTerminate(milestoneId);
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery().caseInstanceIdIn(new String[]{caseInstanceId});
        Assert.assertEquals((long)4L, (long)query.count());
        Assert.assertTrue((boolean)((Boolean)((VariableInstance)query.variableName("parentTerminate").singleResult()).getValue()));
        Assert.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("parentTerminateEventCounter").singleResult()).getValue());
        Assert.assertEquals((Object)milestoneId, (Object)((VariableInstance)query.variableName("parentTerminateOnCaseExecutionId").singleResult()).getValue());
        Assert.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("eventCounter").singleResult()).getValue());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/listener/CaseExecutionListenerTest.testParentTerminateListenerByDelegateExpression.cmmn"})
    @Test
    public void testParentTerminateListenerByDelegateExpression() {
        String caseInstanceId = this.caseService.withCaseDefinitionByKey("case").setVariable("myListener", (Object)new MySpecialCaseExecutionListener()).create().getId();
        String milestoneId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_Milestone_1").singleResult()).getId();
        this.parentTerminate(milestoneId);
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery().caseInstanceIdIn(new String[]{caseInstanceId});
        Assert.assertEquals((long)5L, (long)query.count());
        Assert.assertTrue((boolean)((Boolean)((VariableInstance)query.variableName("parentTerminate").singleResult()).getValue()));
        Assert.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("parentTerminateEventCounter").singleResult()).getValue());
        Assert.assertEquals((Object)milestoneId, (Object)((VariableInstance)query.variableName("parentTerminateOnCaseExecutionId").singleResult()).getValue());
        Assert.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("eventCounter").singleResult()).getValue());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/listener/CaseExecutionListenerTest.testParentTerminateListenerByExpression.cmmn"})
    @Test
    public void testParentTerminateListenerByExpression() {
        String caseInstanceId = this.caseService.withCaseDefinitionByKey("case").setVariable("myListener", (Object)new MyCaseExecutionListener()).create().getId();
        String milestoneId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_Milestone_1").singleResult()).getId();
        this.parentTerminate(milestoneId);
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery().caseInstanceIdIn(new String[]{caseInstanceId});
        Assert.assertEquals((long)5L, (long)query.count());
        Assert.assertTrue((boolean)((Boolean)((VariableInstance)query.variableName("parentTerminate").singleResult()).getValue()));
        Assert.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("parentTerminateEventCounter").singleResult()).getValue());
        Assert.assertEquals((Object)milestoneId, (Object)((VariableInstance)query.variableName("parentTerminateOnCaseExecutionId").singleResult()).getValue());
        Assert.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("eventCounter").singleResult()).getValue());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/listener/CaseExecutionListenerTest.testParentTerminateListenerByScript.cmmn"})
    @Test
    public void testParentTerminateListenerByScript() {
        String caseInstanceId = this.caseService.withCaseDefinitionByKey("case").create().getId();
        String milestoneId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_Milestone_1").singleResult()).getId();
        this.parentTerminate(milestoneId);
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery().caseInstanceIdIn(new String[]{caseInstanceId});
        Assert.assertEquals((long)4L, (long)query.count());
        Assert.assertTrue((boolean)((Boolean)((VariableInstance)query.variableName("parentTerminate").singleResult()).getValue()));
        Assert.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("parentTerminateEventCounter").singleResult()).getValue());
        Assert.assertEquals((Object)milestoneId, (Object)((VariableInstance)query.variableName("parentTerminateOnCaseExecutionId").singleResult()).getValue());
        Assert.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("eventCounter").singleResult()).getValue());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/listener/CaseExecutionListenerTest.testSuspendListenerByClass.cmmn"})
    @Test
    public void testSuspendListenerByClass() {
        String caseInstanceId = this.caseService.withCaseDefinitionByKey("case").create().getId();
        String humanTaskId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult()).getId();
        this.suspend(humanTaskId);
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery().caseInstanceIdIn(new String[]{caseInstanceId});
        Assert.assertEquals((long)4L, (long)query.count());
        Assert.assertTrue((boolean)((Boolean)((VariableInstance)query.variableName("suspend").singleResult()).getValue()));
        Assert.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("suspendEventCounter").singleResult()).getValue());
        Assert.assertEquals((Object)humanTaskId, (Object)((VariableInstance)query.variableName("suspendOnCaseExecutionId").singleResult()).getValue());
        Assert.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("eventCounter").singleResult()).getValue());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/listener/CaseExecutionListenerTest.testSuspendListenerByDelegateExpression.cmmn"})
    @Test
    public void testSuspendListenerByDelegateExpression() {
        String caseInstanceId = this.caseService.withCaseDefinitionByKey("case").setVariable("myListener", (Object)new MySpecialCaseExecutionListener()).create().getId();
        String humanTaskId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult()).getId();
        this.suspend(humanTaskId);
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery().caseInstanceIdIn(new String[]{caseInstanceId});
        Assert.assertEquals((long)5L, (long)query.count());
        Assert.assertTrue((boolean)((Boolean)((VariableInstance)query.variableName("suspend").singleResult()).getValue()));
        Assert.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("suspendEventCounter").singleResult()).getValue());
        Assert.assertEquals((Object)humanTaskId, (Object)((VariableInstance)query.variableName("suspendOnCaseExecutionId").singleResult()).getValue());
        Assert.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("eventCounter").singleResult()).getValue());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/listener/CaseExecutionListenerTest.testSuspendListenerByExpression.cmmn"})
    @Test
    public void testSuspendListenerByExpression() {
        String caseInstanceId = this.caseService.withCaseDefinitionByKey("case").setVariable("myListener", (Object)new MyCaseExecutionListener()).create().getId();
        String humanTaskId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult()).getId();
        this.suspend(humanTaskId);
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery().caseInstanceIdIn(new String[]{caseInstanceId});
        Assert.assertEquals((long)5L, (long)query.count());
        Assert.assertTrue((boolean)((Boolean)((VariableInstance)query.variableName("suspend").singleResult()).getValue()));
        Assert.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("suspendEventCounter").singleResult()).getValue());
        Assert.assertEquals((Object)humanTaskId, (Object)((VariableInstance)query.variableName("suspendOnCaseExecutionId").singleResult()).getValue());
        Assert.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("eventCounter").singleResult()).getValue());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/listener/CaseExecutionListenerTest.testSuspendListenerByScript.cmmn"})
    @Test
    public void testSuspendListenerByScript() {
        String caseInstanceId = this.caseService.withCaseDefinitionByKey("case").create().getId();
        String humanTaskId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult()).getId();
        this.suspend(humanTaskId);
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery().caseInstanceIdIn(new String[]{caseInstanceId});
        Assert.assertEquals((long)4L, (long)query.count());
        Assert.assertTrue((boolean)((Boolean)((VariableInstance)query.variableName("suspend").singleResult()).getValue()));
        Assert.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("suspendEventCounter").singleResult()).getValue());
        Assert.assertEquals((Object)humanTaskId, (Object)((VariableInstance)query.variableName("suspendOnCaseExecutionId").singleResult()).getValue());
        Assert.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("eventCounter").singleResult()).getValue());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/listener/CaseExecutionListenerTest.testParentSuspendListenerByClass.cmmn"})
    @Test
    public void testParentSuspendListenerByClass() {
        String caseInstanceId = this.caseService.withCaseDefinitionByKey("case").create().getId();
        String humanTaskId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult()).getId();
        this.parentSuspend(humanTaskId);
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery().caseInstanceIdIn(new String[]{caseInstanceId});
        Assert.assertEquals((long)4L, (long)query.count());
        Assert.assertTrue((boolean)((Boolean)((VariableInstance)query.variableName("parentSuspend").singleResult()).getValue()));
        Assert.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("parentSuspendEventCounter").singleResult()).getValue());
        Assert.assertEquals((Object)humanTaskId, (Object)((VariableInstance)query.variableName("parentSuspendOnCaseExecutionId").singleResult()).getValue());
        Assert.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("eventCounter").singleResult()).getValue());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/listener/CaseExecutionListenerTest.testParentSuspendListenerByDelegateExpression.cmmn"})
    @Test
    public void testParentSuspendListenerByDelegateExpression() {
        String caseInstanceId = this.caseService.withCaseDefinitionByKey("case").setVariable("myListener", (Object)new MySpecialCaseExecutionListener()).create().getId();
        String humanTaskId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult()).getId();
        this.parentSuspend(humanTaskId);
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery().caseInstanceIdIn(new String[]{caseInstanceId});
        Assert.assertEquals((long)5L, (long)query.count());
        Assert.assertTrue((boolean)((Boolean)((VariableInstance)query.variableName("parentSuspend").singleResult()).getValue()));
        Assert.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("parentSuspendEventCounter").singleResult()).getValue());
        Assert.assertEquals((Object)humanTaskId, (Object)((VariableInstance)query.variableName("parentSuspendOnCaseExecutionId").singleResult()).getValue());
        Assert.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("eventCounter").singleResult()).getValue());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/listener/CaseExecutionListenerTest.testParentSuspendListenerByExpression.cmmn"})
    @Test
    public void testParentSuspendListenerByExpression() {
        String caseInstanceId = this.caseService.withCaseDefinitionByKey("case").setVariable("myListener", (Object)new MyCaseExecutionListener()).create().getId();
        String humanTaskId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult()).getId();
        this.parentSuspend(humanTaskId);
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery().caseInstanceIdIn(new String[]{caseInstanceId});
        Assert.assertEquals((long)5L, (long)query.count());
        Assert.assertTrue((boolean)((Boolean)((VariableInstance)query.variableName("parentSuspend").singleResult()).getValue()));
        Assert.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("parentSuspendEventCounter").singleResult()).getValue());
        Assert.assertEquals((Object)humanTaskId, (Object)((VariableInstance)query.variableName("parentSuspendOnCaseExecutionId").singleResult()).getValue());
        Assert.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("eventCounter").singleResult()).getValue());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/listener/CaseExecutionListenerTest.testParentSuspendListenerByScript.cmmn"})
    @Test
    public void testParentSuspendListenerByScript() {
        String caseInstanceId = this.caseService.withCaseDefinitionByKey("case").create().getId();
        String humanTaskId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult()).getId();
        this.parentSuspend(humanTaskId);
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery().caseInstanceIdIn(new String[]{caseInstanceId});
        Assert.assertEquals((long)4L, (long)query.count());
        Assert.assertTrue((boolean)((Boolean)((VariableInstance)query.variableName("parentSuspend").singleResult()).getValue()));
        Assert.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("parentSuspendEventCounter").singleResult()).getValue());
        Assert.assertEquals((Object)humanTaskId, (Object)((VariableInstance)query.variableName("parentSuspendOnCaseExecutionId").singleResult()).getValue());
        Assert.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("eventCounter").singleResult()).getValue());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/listener/CaseExecutionListenerTest.testResumeListenerByClass.cmmn"})
    @Test
    public void testResumeListenerByClass() {
        String caseInstanceId = this.caseService.withCaseDefinitionByKey("case").create().getId();
        String humanTaskId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult()).getId();
        this.suspend(humanTaskId);
        this.resume(humanTaskId);
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery().caseInstanceIdIn(new String[]{caseInstanceId});
        Assert.assertEquals((long)4L, (long)query.count());
        Assert.assertTrue((boolean)((Boolean)((VariableInstance)query.variableName("resume").singleResult()).getValue()));
        Assert.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("resumeEventCounter").singleResult()).getValue());
        Assert.assertEquals((Object)humanTaskId, (Object)((VariableInstance)query.variableName("resumeOnCaseExecutionId").singleResult()).getValue());
        Assert.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("eventCounter").singleResult()).getValue());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/listener/CaseExecutionListenerTest.testResumeListenerByDelegateExpression.cmmn"})
    @Test
    public void testResumeListenerByDelegateExpression() {
        String caseInstanceId = this.caseService.withCaseDefinitionByKey("case").setVariable("myListener", (Object)new MySpecialCaseExecutionListener()).create().getId();
        String humanTaskId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult()).getId();
        this.suspend(humanTaskId);
        this.resume(humanTaskId);
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery().caseInstanceIdIn(new String[]{caseInstanceId});
        Assert.assertEquals((long)5L, (long)query.count());
        Assert.assertTrue((boolean)((Boolean)((VariableInstance)query.variableName("resume").singleResult()).getValue()));
        Assert.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("resumeEventCounter").singleResult()).getValue());
        Assert.assertEquals((Object)humanTaskId, (Object)((VariableInstance)query.variableName("resumeOnCaseExecutionId").singleResult()).getValue());
        Assert.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("eventCounter").singleResult()).getValue());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/listener/CaseExecutionListenerTest.testResumeListenerByExpression.cmmn"})
    @Test
    public void testResumeListenerByExpression() {
        String caseInstanceId = this.caseService.withCaseDefinitionByKey("case").setVariable("myListener", (Object)new MyCaseExecutionListener()).create().getId();
        String humanTaskId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult()).getId();
        this.suspend(humanTaskId);
        this.resume(humanTaskId);
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery().caseInstanceIdIn(new String[]{caseInstanceId});
        Assert.assertEquals((long)5L, (long)query.count());
        Assert.assertTrue((boolean)((Boolean)((VariableInstance)query.variableName("resume").singleResult()).getValue()));
        Assert.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("resumeEventCounter").singleResult()).getValue());
        Assert.assertEquals((Object)humanTaskId, (Object)((VariableInstance)query.variableName("resumeOnCaseExecutionId").singleResult()).getValue());
        Assert.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("eventCounter").singleResult()).getValue());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/listener/CaseExecutionListenerTest.testResumeListenerByScript.cmmn"})
    @Test
    public void testResumeListenerByScript() {
        String caseInstanceId = this.caseService.withCaseDefinitionByKey("case").create().getId();
        String humanTaskId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult()).getId();
        this.suspend(humanTaskId);
        this.resume(humanTaskId);
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery().caseInstanceIdIn(new String[]{caseInstanceId});
        Assert.assertEquals((long)4L, (long)query.count());
        Assert.assertTrue((boolean)((Boolean)((VariableInstance)query.variableName("resume").singleResult()).getValue()));
        Assert.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("resumeEventCounter").singleResult()).getValue());
        Assert.assertEquals((Object)humanTaskId, (Object)((VariableInstance)query.variableName("resumeOnCaseExecutionId").singleResult()).getValue());
        Assert.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("eventCounter").singleResult()).getValue());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/listener/CaseExecutionListenerTest.testParentResumeListenerByClass.cmmn"})
    @Test
    public void testParentResumeListenerByClass() {
        String caseInstanceId = this.caseService.withCaseDefinitionByKey("case").create().getId();
        String humanTaskId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult()).getId();
        this.suspend(humanTaskId);
        this.parentResume(humanTaskId);
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery().caseInstanceIdIn(new String[]{caseInstanceId});
        Assert.assertEquals((long)4L, (long)query.count());
        Assert.assertTrue((boolean)((Boolean)((VariableInstance)query.variableName("parentResume").singleResult()).getValue()));
        Assert.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("parentResumeEventCounter").singleResult()).getValue());
        Assert.assertEquals((Object)humanTaskId, (Object)((VariableInstance)query.variableName("parentResumeOnCaseExecutionId").singleResult()).getValue());
        Assert.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("eventCounter").singleResult()).getValue());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/listener/CaseExecutionListenerTest.testParentResumeListenerByDelegateExpression.cmmn"})
    @Test
    public void testParentResumeListenerByDelegateExpression() {
        String caseInstanceId = this.caseService.withCaseDefinitionByKey("case").setVariable("myListener", (Object)new MySpecialCaseExecutionListener()).create().getId();
        String humanTaskId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult()).getId();
        this.suspend(humanTaskId);
        this.parentResume(humanTaskId);
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery().caseInstanceIdIn(new String[]{caseInstanceId});
        Assert.assertEquals((long)5L, (long)query.count());
        Assert.assertTrue((boolean)((Boolean)((VariableInstance)query.variableName("parentResume").singleResult()).getValue()));
        Assert.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("parentResumeEventCounter").singleResult()).getValue());
        Assert.assertEquals((Object)humanTaskId, (Object)((VariableInstance)query.variableName("parentResumeOnCaseExecutionId").singleResult()).getValue());
        Assert.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("eventCounter").singleResult()).getValue());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/listener/CaseExecutionListenerTest.testParentResumeListenerByExpression.cmmn"})
    @Test
    public void testParentResumeListenerByExpression() {
        String caseInstanceId = this.caseService.withCaseDefinitionByKey("case").setVariable("myListener", (Object)new MyCaseExecutionListener()).create().getId();
        String humanTaskId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult()).getId();
        this.suspend(humanTaskId);
        this.parentResume(humanTaskId);
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery().caseInstanceIdIn(new String[]{caseInstanceId});
        Assert.assertEquals((long)5L, (long)query.count());
        Assert.assertTrue((boolean)((Boolean)((VariableInstance)query.variableName("parentResume").singleResult()).getValue()));
        Assert.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("parentResumeEventCounter").singleResult()).getValue());
        Assert.assertEquals((Object)humanTaskId, (Object)((VariableInstance)query.variableName("parentResumeOnCaseExecutionId").singleResult()).getValue());
        Assert.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("eventCounter").singleResult()).getValue());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/listener/CaseExecutionListenerTest.testParentResumeListenerByScript.cmmn"})
    @Test
    public void testParentResumeListenerByScript() {
        String caseInstanceId = this.caseService.withCaseDefinitionByKey("case").create().getId();
        String humanTaskId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult()).getId();
        this.suspend(humanTaskId);
        this.parentResume(humanTaskId);
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery().caseInstanceIdIn(new String[]{caseInstanceId});
        Assert.assertEquals((long)4L, (long)query.count());
        Assert.assertTrue((boolean)((Boolean)((VariableInstance)query.variableName("parentResume").singleResult()).getValue()));
        Assert.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("parentResumeEventCounter").singleResult()).getValue());
        Assert.assertEquals((Object)humanTaskId, (Object)((VariableInstance)query.variableName("parentResumeOnCaseExecutionId").singleResult()).getValue());
        Assert.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("eventCounter").singleResult()).getValue());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/listener/CaseExecutionListenerTest.testOccurListenerByClass.cmmn"})
    @Test
    public void testOccurListenerByClass() {
        String caseInstanceId = this.caseService.withCaseDefinitionByKey("case").create().getId();
        String milestoneId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_Milestone_1").singleResult()).getId();
        this.occur(milestoneId);
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery().caseInstanceIdIn(new String[]{caseInstanceId});
        Assert.assertEquals((long)4L, (long)query.count());
        Assert.assertTrue((boolean)((Boolean)((VariableInstance)query.variableName("occur").singleResult()).getValue()));
        Assert.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("occurEventCounter").singleResult()).getValue());
        Assert.assertEquals((Object)milestoneId, (Object)((VariableInstance)query.variableName("occurOnCaseExecutionId").singleResult()).getValue());
        Assert.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("eventCounter").singleResult()).getValue());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/listener/CaseExecutionListenerTest.testOccurListenerByDelegateExpression.cmmn"})
    @Test
    public void testOccurListenerByDelegateExpression() {
        String caseInstanceId = this.caseService.withCaseDefinitionByKey("case").setVariable("myListener", (Object)new MySpecialCaseExecutionListener()).create().getId();
        String milestoneId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_Milestone_1").singleResult()).getId();
        this.occur(milestoneId);
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery().caseInstanceIdIn(new String[]{caseInstanceId});
        Assert.assertEquals((long)5L, (long)query.count());
        Assert.assertTrue((boolean)((Boolean)((VariableInstance)query.variableName("occur").singleResult()).getValue()));
        Assert.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("occurEventCounter").singleResult()).getValue());
        Assert.assertEquals((Object)milestoneId, (Object)((VariableInstance)query.variableName("occurOnCaseExecutionId").singleResult()).getValue());
        Assert.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("eventCounter").singleResult()).getValue());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/listener/CaseExecutionListenerTest.testOccurListenerByExpression.cmmn"})
    @Test
    public void testOccurListenerByExpression() {
        String caseInstanceId = this.caseService.withCaseDefinitionByKey("case").setVariable("myListener", (Object)new MyCaseExecutionListener()).create().getId();
        String milestoneId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_Milestone_1").singleResult()).getId();
        this.occur(milestoneId);
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery().caseInstanceIdIn(new String[]{caseInstanceId});
        Assert.assertEquals((long)5L, (long)query.count());
        Assert.assertTrue((boolean)((Boolean)((VariableInstance)query.variableName("occur").singleResult()).getValue()));
        Assert.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("occurEventCounter").singleResult()).getValue());
        Assert.assertEquals((Object)milestoneId, (Object)((VariableInstance)query.variableName("occurOnCaseExecutionId").singleResult()).getValue());
        Assert.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("eventCounter").singleResult()).getValue());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/listener/CaseExecutionListenerTest.testOccurListenerByScript.cmmn"})
    @Test
    public void testOccurListenerByScript() {
        String caseInstanceId = this.caseService.withCaseDefinitionByKey("case").create().getId();
        String milestoneId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_Milestone_1").singleResult()).getId();
        this.occur(milestoneId);
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery().caseInstanceIdIn(new String[]{caseInstanceId});
        Assert.assertEquals((long)4L, (long)query.count());
        Assert.assertTrue((boolean)((Boolean)((VariableInstance)query.variableName("occur").singleResult()).getValue()));
        Assert.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("occurEventCounter").singleResult()).getValue());
        Assert.assertEquals((Object)milestoneId, (Object)((VariableInstance)query.variableName("occurOnCaseExecutionId").singleResult()).getValue());
        Assert.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("eventCounter").singleResult()).getValue());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/listener/CaseExecutionListenerTest.testAllListenerByClass.cmmn"})
    @Test
    public void testAllListenerByClass() {
        String caseInstanceId = this.caseService.withCaseDefinitionByKey("case").create().getId();
        String humanTaskId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult()).getId();
        this.caseService.withCaseExecution(humanTaskId).disable();
        this.caseService.withCaseExecution(humanTaskId).reenable();
        this.caseService.withCaseExecution(humanTaskId).manualStart();
        this.suspend(humanTaskId);
        this.resume(humanTaskId);
        this.caseService.withCaseExecution(humanTaskId).complete();
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery().caseInstanceIdIn(new String[]{caseInstanceId});
        Assert.assertEquals((long)25L, (long)query.count());
        Assert.assertTrue((boolean)((Boolean)((VariableInstance)query.variableName("create").singleResult()).getValue()));
        Assert.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("createEventCounter").singleResult()).getValue());
        Assert.assertEquals((Object)humanTaskId, (Object)((VariableInstance)query.variableName("createOnCaseExecutionId").singleResult()).getValue());
        Assert.assertTrue((boolean)((Boolean)((VariableInstance)query.variableName("enable").singleResult()).getValue()));
        Assert.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("enableEventCounter").singleResult()).getValue());
        Assert.assertEquals((Object)humanTaskId, (Object)((VariableInstance)query.variableName("enableOnCaseExecutionId").singleResult()).getValue());
        Assert.assertTrue((boolean)((Boolean)((VariableInstance)query.variableName("disable").singleResult()).getValue()));
        Assert.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("disableEventCounter").singleResult()).getValue());
        Assert.assertEquals((Object)humanTaskId, (Object)((VariableInstance)query.variableName("disableOnCaseExecutionId").singleResult()).getValue());
        Assert.assertTrue((boolean)((Boolean)((VariableInstance)query.variableName("reenable").singleResult()).getValue()));
        Assert.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("reenableEventCounter").singleResult()).getValue());
        Assert.assertEquals((Object)humanTaskId, (Object)((VariableInstance)query.variableName("reenableOnCaseExecutionId").singleResult()).getValue());
        Assert.assertTrue((boolean)((Boolean)((VariableInstance)query.variableName("manualStart").singleResult()).getValue()));
        Assert.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("manualStartEventCounter").singleResult()).getValue());
        Assert.assertEquals((Object)humanTaskId, (Object)((VariableInstance)query.variableName("manualStartOnCaseExecutionId").singleResult()).getValue());
        Assert.assertTrue((boolean)((Boolean)((VariableInstance)query.variableName("suspend").singleResult()).getValue()));
        Assert.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("suspendEventCounter").singleResult()).getValue());
        Assert.assertEquals((Object)humanTaskId, (Object)((VariableInstance)query.variableName("suspendOnCaseExecutionId").singleResult()).getValue());
        Assert.assertTrue((boolean)((Boolean)((VariableInstance)query.variableName("resume").singleResult()).getValue()));
        Assert.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("resumeEventCounter").singleResult()).getValue());
        Assert.assertEquals((Object)humanTaskId, (Object)((VariableInstance)query.variableName("resumeOnCaseExecutionId").singleResult()).getValue());
        Assert.assertTrue((boolean)((Boolean)((VariableInstance)query.variableName("complete").singleResult()).getValue()));
        Assert.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("completeEventCounter").singleResult()).getValue());
        Assert.assertEquals((Object)humanTaskId, (Object)((VariableInstance)query.variableName("completeOnCaseExecutionId").singleResult()).getValue());
        Assert.assertEquals((Object)8, (Object)((VariableInstance)query.variableName("eventCounter").singleResult()).getValue());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/listener/CaseExecutionListenerTest.testAllListenerByDelegateExpression.cmmn"})
    @Test
    public void testAllListenerByDelegateExpression() {
        String caseInstanceId = this.caseService.withCaseDefinitionByKey("case").setVariable("myListener", (Object)new MySpecialCaseExecutionListener()).create().getId();
        String humanTaskId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult()).getId();
        this.caseService.withCaseExecution(humanTaskId).disable();
        this.caseService.withCaseExecution(humanTaskId).reenable();
        this.caseService.withCaseExecution(humanTaskId).manualStart();
        this.suspend(humanTaskId);
        this.resume(humanTaskId);
        this.caseService.withCaseExecution(humanTaskId).complete();
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery().caseInstanceIdIn(new String[]{caseInstanceId});
        Assert.assertEquals((long)26L, (long)query.count());
        Assert.assertTrue((boolean)((Boolean)((VariableInstance)query.variableName("create").singleResult()).getValue()));
        Assert.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("createEventCounter").singleResult()).getValue());
        Assert.assertEquals((Object)humanTaskId, (Object)((VariableInstance)query.variableName("createOnCaseExecutionId").singleResult()).getValue());
        Assert.assertTrue((boolean)((Boolean)((VariableInstance)query.variableName("enable").singleResult()).getValue()));
        Assert.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("enableEventCounter").singleResult()).getValue());
        Assert.assertEquals((Object)humanTaskId, (Object)((VariableInstance)query.variableName("enableOnCaseExecutionId").singleResult()).getValue());
        Assert.assertTrue((boolean)((Boolean)((VariableInstance)query.variableName("disable").singleResult()).getValue()));
        Assert.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("disableEventCounter").singleResult()).getValue());
        Assert.assertEquals((Object)humanTaskId, (Object)((VariableInstance)query.variableName("disableOnCaseExecutionId").singleResult()).getValue());
        Assert.assertTrue((boolean)((Boolean)((VariableInstance)query.variableName("reenable").singleResult()).getValue()));
        Assert.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("reenableEventCounter").singleResult()).getValue());
        Assert.assertEquals((Object)humanTaskId, (Object)((VariableInstance)query.variableName("reenableOnCaseExecutionId").singleResult()).getValue());
        Assert.assertTrue((boolean)((Boolean)((VariableInstance)query.variableName("manualStart").singleResult()).getValue()));
        Assert.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("manualStartEventCounter").singleResult()).getValue());
        Assert.assertEquals((Object)humanTaskId, (Object)((VariableInstance)query.variableName("manualStartOnCaseExecutionId").singleResult()).getValue());
        Assert.assertTrue((boolean)((Boolean)((VariableInstance)query.variableName("suspend").singleResult()).getValue()));
        Assert.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("suspendEventCounter").singleResult()).getValue());
        Assert.assertEquals((Object)humanTaskId, (Object)((VariableInstance)query.variableName("suspendOnCaseExecutionId").singleResult()).getValue());
        Assert.assertTrue((boolean)((Boolean)((VariableInstance)query.variableName("resume").singleResult()).getValue()));
        Assert.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("resumeEventCounter").singleResult()).getValue());
        Assert.assertEquals((Object)humanTaskId, (Object)((VariableInstance)query.variableName("resumeOnCaseExecutionId").singleResult()).getValue());
        Assert.assertTrue((boolean)((Boolean)((VariableInstance)query.variableName("complete").singleResult()).getValue()));
        Assert.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("completeEventCounter").singleResult()).getValue());
        Assert.assertEquals((Object)humanTaskId, (Object)((VariableInstance)query.variableName("completeOnCaseExecutionId").singleResult()).getValue());
        Assert.assertEquals((Object)8, (Object)((VariableInstance)query.variableName("eventCounter").singleResult()).getValue());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/listener/CaseExecutionListenerTest.testAllListenerByExpression.cmmn"})
    @Test
    public void testAllListenerByExpression() {
        String caseInstanceId = this.caseService.withCaseDefinitionByKey("case").setVariable("myListener", (Object)new MyCaseExecutionListener()).create().getId();
        String humanTaskId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult()).getId();
        this.caseService.withCaseExecution(humanTaskId).disable();
        this.caseService.withCaseExecution(humanTaskId).reenable();
        this.caseService.withCaseExecution(humanTaskId).manualStart();
        this.suspend(humanTaskId);
        this.resume(humanTaskId);
        this.caseService.withCaseExecution(humanTaskId).complete();
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery().caseInstanceIdIn(new String[]{caseInstanceId});
        Assert.assertEquals((long)26L, (long)query.count());
        Assert.assertTrue((boolean)((Boolean)((VariableInstance)query.variableName("create").singleResult()).getValue()));
        Assert.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("createEventCounter").singleResult()).getValue());
        Assert.assertEquals((Object)humanTaskId, (Object)((VariableInstance)query.variableName("createOnCaseExecutionId").singleResult()).getValue());
        Assert.assertTrue((boolean)((Boolean)((VariableInstance)query.variableName("enable").singleResult()).getValue()));
        Assert.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("enableEventCounter").singleResult()).getValue());
        Assert.assertEquals((Object)humanTaskId, (Object)((VariableInstance)query.variableName("enableOnCaseExecutionId").singleResult()).getValue());
        Assert.assertTrue((boolean)((Boolean)((VariableInstance)query.variableName("disable").singleResult()).getValue()));
        Assert.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("disableEventCounter").singleResult()).getValue());
        Assert.assertEquals((Object)humanTaskId, (Object)((VariableInstance)query.variableName("disableOnCaseExecutionId").singleResult()).getValue());
        Assert.assertTrue((boolean)((Boolean)((VariableInstance)query.variableName("reenable").singleResult()).getValue()));
        Assert.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("reenableEventCounter").singleResult()).getValue());
        Assert.assertEquals((Object)humanTaskId, (Object)((VariableInstance)query.variableName("reenableOnCaseExecutionId").singleResult()).getValue());
        Assert.assertTrue((boolean)((Boolean)((VariableInstance)query.variableName("manualStart").singleResult()).getValue()));
        Assert.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("manualStartEventCounter").singleResult()).getValue());
        Assert.assertEquals((Object)humanTaskId, (Object)((VariableInstance)query.variableName("manualStartOnCaseExecutionId").singleResult()).getValue());
        Assert.assertTrue((boolean)((Boolean)((VariableInstance)query.variableName("suspend").singleResult()).getValue()));
        Assert.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("suspendEventCounter").singleResult()).getValue());
        Assert.assertEquals((Object)humanTaskId, (Object)((VariableInstance)query.variableName("suspendOnCaseExecutionId").singleResult()).getValue());
        Assert.assertTrue((boolean)((Boolean)((VariableInstance)query.variableName("resume").singleResult()).getValue()));
        Assert.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("resumeEventCounter").singleResult()).getValue());
        Assert.assertEquals((Object)humanTaskId, (Object)((VariableInstance)query.variableName("resumeOnCaseExecutionId").singleResult()).getValue());
        Assert.assertTrue((boolean)((Boolean)((VariableInstance)query.variableName("complete").singleResult()).getValue()));
        Assert.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("completeEventCounter").singleResult()).getValue());
        Assert.assertEquals((Object)humanTaskId, (Object)((VariableInstance)query.variableName("completeOnCaseExecutionId").singleResult()).getValue());
        Assert.assertEquals((Object)8, (Object)((VariableInstance)query.variableName("eventCounter").singleResult()).getValue());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/listener/CaseExecutionListenerTest.testAllListenerByScript.cmmn"})
    @Test
    public void testAllListenerByScript() {
        String caseInstanceId = this.caseService.withCaseDefinitionByKey("case").create().getId();
        String humanTaskId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult()).getId();
        this.caseService.withCaseExecution(humanTaskId).disable();
        this.caseService.withCaseExecution(humanTaskId).reenable();
        this.caseService.withCaseExecution(humanTaskId).manualStart();
        this.suspend(humanTaskId);
        this.resume(humanTaskId);
        this.caseService.withCaseExecution(humanTaskId).complete();
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery().caseInstanceIdIn(new String[]{caseInstanceId});
        Assert.assertEquals((long)25L, (long)query.count());
        Assert.assertTrue((boolean)((Boolean)((VariableInstance)query.variableName("create").singleResult()).getValue()));
        Assert.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("createEventCounter").singleResult()).getValue());
        Assert.assertEquals((Object)humanTaskId, (Object)((VariableInstance)query.variableName("createOnCaseExecutionId").singleResult()).getValue());
        Assert.assertTrue((boolean)((Boolean)((VariableInstance)query.variableName("enable").singleResult()).getValue()));
        Assert.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("enableEventCounter").singleResult()).getValue());
        Assert.assertEquals((Object)humanTaskId, (Object)((VariableInstance)query.variableName("enableOnCaseExecutionId").singleResult()).getValue());
        Assert.assertTrue((boolean)((Boolean)((VariableInstance)query.variableName("disable").singleResult()).getValue()));
        Assert.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("disableEventCounter").singleResult()).getValue());
        Assert.assertEquals((Object)humanTaskId, (Object)((VariableInstance)query.variableName("disableOnCaseExecutionId").singleResult()).getValue());
        Assert.assertTrue((boolean)((Boolean)((VariableInstance)query.variableName("reenable").singleResult()).getValue()));
        Assert.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("reenableEventCounter").singleResult()).getValue());
        Assert.assertEquals((Object)humanTaskId, (Object)((VariableInstance)query.variableName("reenableOnCaseExecutionId").singleResult()).getValue());
        Assert.assertTrue((boolean)((Boolean)((VariableInstance)query.variableName("manualStart").singleResult()).getValue()));
        Assert.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("manualStartEventCounter").singleResult()).getValue());
        Assert.assertEquals((Object)humanTaskId, (Object)((VariableInstance)query.variableName("manualStartOnCaseExecutionId").singleResult()).getValue());
        Assert.assertTrue((boolean)((Boolean)((VariableInstance)query.variableName("suspend").singleResult()).getValue()));
        Assert.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("suspendEventCounter").singleResult()).getValue());
        Assert.assertEquals((Object)humanTaskId, (Object)((VariableInstance)query.variableName("suspendOnCaseExecutionId").singleResult()).getValue());
        Assert.assertTrue((boolean)((Boolean)((VariableInstance)query.variableName("resume").singleResult()).getValue()));
        Assert.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("resumeEventCounter").singleResult()).getValue());
        Assert.assertEquals((Object)humanTaskId, (Object)((VariableInstance)query.variableName("resumeOnCaseExecutionId").singleResult()).getValue());
        Assert.assertTrue((boolean)((Boolean)((VariableInstance)query.variableName("complete").singleResult()).getValue()));
        Assert.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("completeEventCounter").singleResult()).getValue());
        Assert.assertEquals((Object)humanTaskId, (Object)((VariableInstance)query.variableName("completeOnCaseExecutionId").singleResult()).getValue());
        Assert.assertEquals((Object)8, (Object)((VariableInstance)query.variableName("eventCounter").singleResult()).getValue());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/listener/CaseExecutionListenerTest.testFieldInjectionByClass.cmmn"})
    @Test
    public void testFieldInjectionByClass() {
        String caseInstanceId = this.caseService.withCaseDefinitionByKey("case").create().getId();
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery().caseInstanceIdIn(new String[]{caseInstanceId});
        Assert.assertEquals((long)4L, (long)query.count());
        Assert.assertEquals((Object)"Hello from The Case", (Object)((VariableInstance)query.variableName("greeting").singleResult()).getValue());
        Assert.assertEquals((Object)"Hello World", (Object)((VariableInstance)query.variableName("helloWorld").singleResult()).getValue());
        Assert.assertEquals((Object)"cam", (Object)((VariableInstance)query.variableName("prefix").singleResult()).getValue());
        Assert.assertEquals((Object)"unda", (Object)((VariableInstance)query.variableName("suffix").singleResult()).getValue());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/listener/CaseExecutionListenerTest.testFieldInjectionByDelegateExpression.cmmn"})
    @Test
    public void testFieldInjectionByDelegateExpression() {
        String caseInstanceId = this.caseService.withCaseDefinitionByKey("case").setVariable("myListener", (Object)new FieldInjectionCaseExecutionListener()).create().getId();
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery().caseInstanceIdIn(new String[]{caseInstanceId});
        Assert.assertEquals((long)5L, (long)query.count());
        Assert.assertEquals((Object)"Hello from The Case", (Object)((VariableInstance)query.variableName("greeting").singleResult()).getValue());
        Assert.assertEquals((Object)"Hello World", (Object)((VariableInstance)query.variableName("helloWorld").singleResult()).getValue());
        Assert.assertEquals((Object)"cam", (Object)((VariableInstance)query.variableName("prefix").singleResult()).getValue());
        Assert.assertEquals((Object)"unda", (Object)((VariableInstance)query.variableName("suffix").singleResult()).getValue());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/listener/CaseExecutionListenerTest.testListenerByScriptResource.cmmn", "org/camunda/bpm/engine/test/cmmn/listener/caseExecutionListener.groovy"})
    @Test
    public void testListenerByScriptResource() {
        String caseInstanceId = this.caseService.withCaseDefinitionByKey("case").create().getId();
        String humanTaskId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult()).getId();
        this.caseService.withCaseExecution(humanTaskId).disable();
        this.caseService.withCaseExecution(humanTaskId).reenable();
        this.caseService.withCaseExecution(humanTaskId).manualStart();
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery().caseInstanceIdIn(new String[]{caseInstanceId});
        Assert.assertEquals((long)10L, (long)query.count());
        Assert.assertTrue((boolean)((Boolean)((VariableInstance)query.variableName("disable").singleResult()).getValue()));
        Assert.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("disableEventCounter").singleResult()).getValue());
        Assert.assertEquals((Object)humanTaskId, (Object)((VariableInstance)query.variableName("disableOnCaseExecutionId").singleResult()).getValue());
        Assert.assertTrue((boolean)((Boolean)((VariableInstance)query.variableName("reenable").singleResult()).getValue()));
        Assert.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("reenableEventCounter").singleResult()).getValue());
        Assert.assertEquals((Object)humanTaskId, (Object)((VariableInstance)query.variableName("reenableOnCaseExecutionId").singleResult()).getValue());
        Assert.assertTrue((boolean)((Boolean)((VariableInstance)query.variableName("manualStart").singleResult()).getValue()));
        Assert.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("manualStartEventCounter").singleResult()).getValue());
        Assert.assertEquals((Object)humanTaskId, (Object)((VariableInstance)query.variableName("manualStartOnCaseExecutionId").singleResult()).getValue());
        Assert.assertEquals((Object)3, (Object)((VariableInstance)query.variableName("eventCounter").singleResult()).getValue());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/listener/CaseExecutionListenerTest.testDoesNotImplementCaseExecutionListenerInterfaceByClass.cmmn"})
    @Test
    public void testDoesNotImplementCaseExecutionListenerInterfaceByClass() {
        try {
            this.caseService.withCaseDefinitionByKey("case").create();
        }
        catch (Exception e) {
            String message = e.getMessage();
            this.testRule.assertTextPresent("ENGINE-05016 Class 'org.camunda.bpm.engine.test.cmmn.listener.NotCaseExecutionListener' doesn't implement '" + CaseExecutionListener.class.getName() + "'", message);
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/listener/CaseExecutionListenerTest.testDoesNotImplementCaseExecutionListenerInterfaceByDelegateExpression.cmmn"})
    @Test
    public void testDoesNotImplementCaseExecutionListenerInterfaceByDelegateExpression() {
        try {
            this.caseService.withCaseDefinitionByKey("case").setVariable("myListener", (Object)new NotCaseExecutionListener()).create();
        }
        catch (Exception e) {
            String message = e.getMessage();
            this.testRule.assertTextPresent("Delegate expression ${myListener} did not resolve to an implementation of interface " + CaseExecutionListener.class.getName(), message);
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/listener/CaseExecutionListenerTest.testListenerDoesNotExist.cmmn"})
    @Test
    public void testListenerDoesNotExist() {
        try {
            this.caseService.withCaseDefinitionByKey("case").create().getId();
        }
        catch (Exception e) {
            String message = e.getMessage();
            this.testRule.assertTextPresent("Exception while instantiating class 'org.camunda.bpm.engine.test.cmmn.listener.NotExistingCaseExecutionListener'", message);
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/listener/CaseExecutionListenerTest.testBusinessKeyAsCaseBusinessKey.cmmn"})
    @Test
    public void testBusinessKeyAsCaseBusinessKey() {
        this.caseService.withCaseDefinitionByKey("case").businessKey("myBusinessKey").create().getId();
        VariableInstance v1 = (VariableInstance)this.runtimeService.createVariableInstanceQuery().variableName("businessKey").singleResult();
        VariableInstance v2 = (VariableInstance)this.runtimeService.createVariableInstanceQuery().variableName("caseBusinessKey").singleResult();
        Assert.assertNotNull((Object)v1);
        Assert.assertNotNull((Object)v2);
        Assert.assertEquals((Object)"myBusinessKey", (Object)v1.getValue());
        Assert.assertEquals((Object)v1.getValue(), (Object)v2.getValue());
    }
}

