/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.history.dmn;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.camunda.bpm.dmn.engine.impl.DefaultDmnEngineConfiguration;
import org.camunda.bpm.engine.history.HistoricActivityInstance;
import org.camunda.bpm.engine.history.HistoricCaseActivityInstance;
import org.camunda.bpm.engine.history.HistoricDecisionInputInstance;
import org.camunda.bpm.engine.history.HistoricDecisionInstance;
import org.camunda.bpm.engine.history.HistoricDecisionInstanceQuery;
import org.camunda.bpm.engine.history.HistoricDecisionOutputInstance;
import org.camunda.bpm.engine.impl.history.event.HistoricDecisionInstanceEntity;
import org.camunda.bpm.engine.impl.util.ClockUtil;
import org.camunda.bpm.engine.repository.CaseDefinition;
import org.camunda.bpm.engine.repository.DecisionDefinition;
import org.camunda.bpm.engine.repository.DecisionRequirementsDefinition;
import org.camunda.bpm.engine.repository.ProcessDefinition;
import org.camunda.bpm.engine.runtime.CaseExecution;
import org.camunda.bpm.engine.runtime.CaseInstance;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.test.Deployment;
import org.camunda.bpm.engine.test.RequiredHistoryLevel;
import org.camunda.bpm.engine.test.history.DecisionServiceDelegate;
import org.camunda.bpm.engine.test.util.PluggableProcessEngineTest;
import org.camunda.bpm.engine.test.util.ResetDmnConfigUtil;
import org.camunda.bpm.engine.variable.VariableMap;
import org.camunda.bpm.engine.variable.Variables;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.joda.time.DateTime;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

@RequiredHistoryLevel(value="full")
public class HistoricDecisionInstanceTest
extends PluggableProcessEngineTest {
    public static final String DECISION_CASE = "org/camunda/bpm/engine/test/history/HistoricDecisionInstanceTest.caseWithDecisionTask.cmmn";
    public static final String DECISION_CASE_WITH_DECISION_SERVICE = "org/camunda/bpm/engine/test/history/HistoricDecisionInstanceTest.testCaseDecisionEvaluatedWithDecisionServiceInsideDelegate.cmmn";
    public static final String DECISION_CASE_WITH_DECISION_SERVICE_INSIDE_RULE = "org/camunda/bpm/engine/test/history/HistoricDecisionInstanceTest.testManualActivationRuleEvaluatesDecision.cmmn";
    public static final String DECISION_CASE_WITH_DECISION_SERVICE_INSIDE_IF_PART = "org/camunda/bpm/engine/test/history/HistoricDecisionInstanceTest.testIfPartEvaluatesDecision.cmmn";
    public static final String DECISION_PROCESS = "org/camunda/bpm/engine/test/history/HistoricDecisionInstanceTest.processWithBusinessRuleTask.bpmn20.xml";
    public static final String DECISION_SINGLE_OUTPUT_DMN = "org/camunda/bpm/engine/test/history/HistoricDecisionInstanceTest.decisionSingleOutput.dmn11.xml";
    public static final String DECISION_MULTIPLE_OUTPUT_DMN = "org/camunda/bpm/engine/test/history/HistoricDecisionInstanceTest.decisionMultipleOutput.dmn11.xml";
    public static final String DECISION_COMPOUND_OUTPUT_DMN = "org/camunda/bpm/engine/test/history/HistoricDecisionInstanceTest.decisionCompoundOutput.dmn11.xml";
    public static final String DECISION_MULTIPLE_INPUT_DMN = "org/camunda/bpm/engine/test/history/HistoricDecisionInstanceTest.decisionMultipleInput.dmn11.xml";
    public static final String DECISION_COLLECT_SUM_DMN = "org/camunda/bpm/engine/test/history/HistoricDecisionInstanceTest.decisionCollectSum.dmn11.xml";
    public static final String DECISION_RETURNS_TRUE = "org/camunda/bpm/engine/test/history/HistoricDecisionInstanceTest.returnsTrue.dmn11.xml";
    public static final String DECISION_LITERAL_EXPRESSION_DMN = "org/camunda/bpm/engine/test/api/dmn/DecisionWithLiteralExpression.dmn";
    public static final String DRG_DMN = "org/camunda/bpm/engine/test/dmn/deployment/drdDish.dmn11.xml";
    public static final String DECISION_DEFINITION_KEY = "testDecision";

    @Before
    public void setUp() throws Exception {
        DefaultDmnEngineConfiguration dmnEngineConfiguration = this.processEngineConfiguration.getDmnEngineConfiguration();
        ResetDmnConfigUtil.reset(dmnEngineConfiguration).enableFeelLegacyBehavior(true).init();
    }

    @After
    public void tearDown() throws Exception {
        DefaultDmnEngineConfiguration dmnEngineConfiguration = this.processEngineConfiguration.getDmnEngineConfiguration();
        ResetDmnConfigUtil.reset(dmnEngineConfiguration).enableFeelLegacyBehavior(false).init();
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/history/HistoricDecisionInstanceTest.processWithBusinessRuleTask.bpmn20.xml", "org/camunda/bpm/engine/test/history/HistoricDecisionInstanceTest.decisionSingleOutput.dmn11.xml"})
    @Test
    public void testDecisionInstanceProperties() {
        this.startProcessInstanceAndEvaluateDecision();
        ProcessInstance processInstance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().singleResult();
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().processDefinitionId(processInstance.getProcessDefinitionId()).singleResult();
        String decisionDefinitionId = ((DecisionDefinition)this.repositoryService.createDecisionDefinitionQuery().decisionDefinitionKey(DECISION_DEFINITION_KEY).singleResult()).getId();
        String activityInstanceId = ((HistoricActivityInstance)this.historyService.createHistoricActivityInstanceQuery().activityId("task").singleResult()).getId();
        HistoricDecisionInstance historicDecisionInstance = (HistoricDecisionInstance)this.historyService.createHistoricDecisionInstanceQuery().singleResult();
        Assert.assertThat((Object)historicDecisionInstance, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Assert.assertThat((Object)historicDecisionInstance.getDecisionDefinitionId(), (Matcher)CoreMatchers.is((Object)decisionDefinitionId));
        Assert.assertThat((Object)historicDecisionInstance.getDecisionDefinitionKey(), (Matcher)CoreMatchers.is((Object)DECISION_DEFINITION_KEY));
        Assert.assertThat((Object)historicDecisionInstance.getDecisionDefinitionName(), (Matcher)CoreMatchers.is((Object)"sample decision"));
        Assert.assertThat((Object)historicDecisionInstance.getProcessDefinitionKey(), (Matcher)CoreMatchers.is((Object)processDefinition.getKey()));
        Assert.assertThat((Object)historicDecisionInstance.getProcessDefinitionId(), (Matcher)CoreMatchers.is((Object)processDefinition.getId()));
        Assert.assertThat((Object)historicDecisionInstance.getProcessInstanceId(), (Matcher)CoreMatchers.is((Object)processInstance.getId()));
        Assert.assertThat((Object)historicDecisionInstance.getCaseDefinitionKey(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        Assert.assertThat((Object)historicDecisionInstance.getCaseDefinitionId(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        Assert.assertThat((Object)historicDecisionInstance.getCaseInstanceId(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        Assert.assertThat((Object)historicDecisionInstance.getActivityId(), (Matcher)CoreMatchers.is((Object)"task"));
        Assert.assertThat((Object)historicDecisionInstance.getActivityInstanceId(), (Matcher)CoreMatchers.is((Object)activityInstanceId));
        Assert.assertThat((Object)historicDecisionInstance.getRootDecisionInstanceId(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        Assert.assertThat((Object)historicDecisionInstance.getDecisionRequirementsDefinitionId(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        Assert.assertThat((Object)historicDecisionInstance.getDecisionRequirementsDefinitionKey(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        Assert.assertThat((Object)historicDecisionInstance.getEvaluationTime(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/history/HistoricDecisionInstanceTest.caseWithDecisionTask.cmmn", "org/camunda/bpm/engine/test/history/HistoricDecisionInstanceTest.decisionSingleOutput.dmn11.xml"})
    @Test
    public void testCaseDecisionInstanceProperties() {
        CaseInstance caseInstance = this.createCaseInstanceAndEvaluateDecision();
        CaseDefinition caseDefinition = (CaseDefinition)this.repositoryService.createCaseDefinitionQuery().caseDefinitionId(caseInstance.getCaseDefinitionId()).singleResult();
        String decisionDefinitionId = ((DecisionDefinition)this.repositoryService.createDecisionDefinitionQuery().decisionDefinitionKey(DECISION_DEFINITION_KEY).singleResult()).getId();
        String activityInstanceId = ((HistoricCaseActivityInstance)this.historyService.createHistoricCaseActivityInstanceQuery().caseActivityId("PI_DecisionTask_1").singleResult()).getId();
        HistoricDecisionInstance historicDecisionInstance = (HistoricDecisionInstance)this.historyService.createHistoricDecisionInstanceQuery().singleResult();
        Assert.assertThat((Object)historicDecisionInstance, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Assert.assertThat((Object)historicDecisionInstance.getDecisionDefinitionId(), (Matcher)CoreMatchers.is((Object)decisionDefinitionId));
        Assert.assertThat((Object)historicDecisionInstance.getDecisionDefinitionKey(), (Matcher)CoreMatchers.is((Object)DECISION_DEFINITION_KEY));
        Assert.assertThat((Object)historicDecisionInstance.getDecisionDefinitionName(), (Matcher)CoreMatchers.is((Object)"sample decision"));
        Assert.assertThat((Object)historicDecisionInstance.getProcessDefinitionKey(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        Assert.assertThat((Object)historicDecisionInstance.getProcessDefinitionId(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        Assert.assertThat((Object)historicDecisionInstance.getProcessInstanceId(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        Assert.assertThat((Object)historicDecisionInstance.getCaseDefinitionKey(), (Matcher)CoreMatchers.is((Object)caseDefinition.getKey()));
        Assert.assertThat((Object)historicDecisionInstance.getCaseDefinitionId(), (Matcher)CoreMatchers.is((Object)caseDefinition.getId()));
        Assert.assertThat((Object)historicDecisionInstance.getCaseInstanceId(), (Matcher)CoreMatchers.is((Object)caseInstance.getId()));
        Assert.assertThat((Object)historicDecisionInstance.getActivityId(), (Matcher)CoreMatchers.is((Object)"PI_DecisionTask_1"));
        Assert.assertThat((Object)historicDecisionInstance.getActivityInstanceId(), (Matcher)CoreMatchers.is((Object)activityInstanceId));
        Assert.assertThat((Object)historicDecisionInstance.getEvaluationTime(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/history/HistoricDecisionInstanceTest.processWithBusinessRuleTask.bpmn20.xml", "org/camunda/bpm/engine/test/history/HistoricDecisionInstanceTest.decisionSingleOutput.dmn11.xml"})
    @Test
    public void testDecisionInputInstanceProperties() {
        this.startProcessInstanceAndEvaluateDecision();
        HistoricDecisionInstance historicDecisionInstance = (HistoricDecisionInstance)this.historyService.createHistoricDecisionInstanceQuery().includeInputs().singleResult();
        List inputs = historicDecisionInstance.getInputs();
        Assert.assertThat((Object)inputs, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Assert.assertThat((Object)inputs.size(), (Matcher)CoreMatchers.is((Object)1));
        HistoricDecisionInputInstance input = (HistoricDecisionInputInstance)inputs.get(0);
        Assert.assertThat((Object)input.getDecisionInstanceId(), (Matcher)CoreMatchers.is((Object)historicDecisionInstance.getId()));
        Assert.assertThat((Object)input.getClauseId(), (Matcher)CoreMatchers.is((Object)"in"));
        Assert.assertThat((Object)input.getClauseName(), (Matcher)CoreMatchers.is((Object)"input"));
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/history/HistoricDecisionInstanceTest.processWithBusinessRuleTask.bpmn20.xml", "org/camunda/bpm/engine/test/history/HistoricDecisionInstanceTest.decisionSingleOutput.dmn11.xml"})
    @Test
    public void testMultipleDecisionInstances() {
        this.startProcessInstanceAndEvaluateDecision("a");
        this.waitASignificantAmountOfTime();
        this.startProcessInstanceAndEvaluateDecision("b");
        List historicDecisionInstances = ((HistoricDecisionInstanceQuery)this.historyService.createHistoricDecisionInstanceQuery().includeInputs().orderByEvaluationTime().asc()).list();
        Assert.assertThat((Object)historicDecisionInstances.size(), (Matcher)CoreMatchers.is((Object)2));
        List inputsOfFirstDecision = ((HistoricDecisionInstance)historicDecisionInstances.get(0)).getInputs();
        Assert.assertThat((Object)inputsOfFirstDecision.size(), (Matcher)CoreMatchers.is((Object)1));
        Assert.assertThat((Object)((HistoricDecisionInputInstance)inputsOfFirstDecision.get(0)).getValue(), (Matcher)CoreMatchers.is((Object)"a"));
        List inputsOfSecondDecision = ((HistoricDecisionInstance)historicDecisionInstances.get(1)).getInputs();
        Assert.assertThat((Object)inputsOfSecondDecision.size(), (Matcher)CoreMatchers.is((Object)1));
        Assert.assertThat((Object)((HistoricDecisionInputInstance)inputsOfSecondDecision.get(0)).getValue(), (Matcher)CoreMatchers.is((Object)"b"));
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/history/HistoricDecisionInstanceTest.processWithBusinessRuleTask.bpmn20.xml", "org/camunda/bpm/engine/test/history/HistoricDecisionInstanceTest.decisionMultipleInput.dmn11.xml"})
    @Test
    public void testMultipleDecisionInputInstances() {
        HashMap<String, Object> variables = new HashMap<String, Object>();
        variables.put("input1", "a");
        variables.put("input2", 1);
        this.runtimeService.startProcessInstanceByKey("testProcess", variables);
        HistoricDecisionInstance historicDecisionInstance = (HistoricDecisionInstance)this.historyService.createHistoricDecisionInstanceQuery().includeInputs().singleResult();
        List inputs = historicDecisionInstance.getInputs();
        Assert.assertThat((Object)inputs.size(), (Matcher)CoreMatchers.is((Object)2));
        Assert.assertThat((Object)((HistoricDecisionInputInstance)inputs.get(0)).getValue(), (Matcher)CoreMatchers.is((Object)"a"));
        Assert.assertThat((Object)((HistoricDecisionInputInstance)inputs.get(1)).getValue(), (Matcher)CoreMatchers.is((Object)1));
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/history/HistoricDecisionInstanceTest.processWithBusinessRuleTask.bpmn20.xml", "org/camunda/bpm/engine/test/history/HistoricDecisionInstanceTest.decisionSingleOutput.dmn11.xml"})
    @Test
    public void testDisableDecisionInputInstanceByteValue() {
        byte[] bytes = "object".getBytes();
        this.startProcessInstanceAndEvaluateDecision(bytes);
        HistoricDecisionInstance historicDecisionInstance = (HistoricDecisionInstance)this.historyService.createHistoricDecisionInstanceQuery().includeInputs().disableBinaryFetching().singleResult();
        List inputs = historicDecisionInstance.getInputs();
        Assert.assertThat((Object)inputs.size(), (Matcher)CoreMatchers.is((Object)1));
        HistoricDecisionInputInstance input = (HistoricDecisionInputInstance)inputs.get(0);
        Assert.assertThat((Object)input.getTypeName(), (Matcher)CoreMatchers.is((Object)"bytes"));
        Assert.assertThat((Object)input.getValue(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/history/HistoricDecisionInstanceTest.processWithBusinessRuleTask.bpmn20.xml", "org/camunda/bpm/engine/test/history/HistoricDecisionInstanceTest.decisionSingleOutput.dmn11.xml"})
    @Test
    public void testDecisionOutputInstanceProperties() {
        this.startProcessInstanceAndEvaluateDecision();
        HistoricDecisionInstance historicDecisionInstance = (HistoricDecisionInstance)this.historyService.createHistoricDecisionInstanceQuery().includeOutputs().singleResult();
        List outputs = historicDecisionInstance.getOutputs();
        Assert.assertThat((Object)outputs, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Assert.assertThat((Object)outputs.size(), (Matcher)CoreMatchers.is((Object)1));
        HistoricDecisionOutputInstance output = (HistoricDecisionOutputInstance)outputs.get(0);
        Assert.assertThat((Object)output.getDecisionInstanceId(), (Matcher)CoreMatchers.is((Object)historicDecisionInstance.getId()));
        Assert.assertThat((Object)output.getClauseId(), (Matcher)CoreMatchers.is((Object)"out"));
        Assert.assertThat((Object)output.getClauseName(), (Matcher)CoreMatchers.is((Object)"output"));
        Assert.assertThat((Object)output.getRuleId(), (Matcher)CoreMatchers.is((Object)"rule"));
        Assert.assertThat((Object)output.getRuleOrder(), (Matcher)CoreMatchers.is((Object)1));
        Assert.assertThat((Object)output.getVariableName(), (Matcher)CoreMatchers.is((Object)"result"));
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/history/HistoricDecisionInstanceTest.processWithBusinessRuleTask.bpmn20.xml", "org/camunda/bpm/engine/test/history/HistoricDecisionInstanceTest.decisionMultipleOutput.dmn11.xml"})
    @Test
    public void testMultipleDecisionOutputInstances() {
        this.startProcessInstanceAndEvaluateDecision();
        HistoricDecisionInstance historicDecisionInstance = (HistoricDecisionInstance)this.historyService.createHistoricDecisionInstanceQuery().includeOutputs().singleResult();
        List outputs = historicDecisionInstance.getOutputs();
        Assert.assertThat((Object)outputs.size(), (Matcher)CoreMatchers.is((Object)2));
        HistoricDecisionOutputInstance firstOutput = (HistoricDecisionOutputInstance)outputs.get(0);
        Assert.assertThat((Object)firstOutput.getClauseId(), (Matcher)CoreMatchers.is((Object)"out1"));
        Assert.assertThat((Object)firstOutput.getRuleId(), (Matcher)CoreMatchers.is((Object)"rule1"));
        Assert.assertThat((Object)firstOutput.getRuleOrder(), (Matcher)CoreMatchers.is((Object)1));
        Assert.assertThat((Object)firstOutput.getVariableName(), (Matcher)CoreMatchers.is((Object)"result1"));
        Assert.assertThat((Object)firstOutput.getValue(), (Matcher)CoreMatchers.is((Object)"okay"));
        HistoricDecisionOutputInstance secondOutput = (HistoricDecisionOutputInstance)outputs.get(1);
        Assert.assertThat((Object)secondOutput.getClauseId(), (Matcher)CoreMatchers.is((Object)"out1"));
        Assert.assertThat((Object)secondOutput.getRuleId(), (Matcher)CoreMatchers.is((Object)"rule2"));
        Assert.assertThat((Object)secondOutput.getRuleOrder(), (Matcher)CoreMatchers.is((Object)2));
        Assert.assertThat((Object)secondOutput.getVariableName(), (Matcher)CoreMatchers.is((Object)"result1"));
        Assert.assertThat((Object)secondOutput.getValue(), (Matcher)CoreMatchers.is((Object)"not okay"));
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/history/HistoricDecisionInstanceTest.processWithBusinessRuleTask.bpmn20.xml", "org/camunda/bpm/engine/test/history/HistoricDecisionInstanceTest.decisionCompoundOutput.dmn11.xml"})
    @Test
    public void testCompoundDecisionOutputInstances() {
        this.startProcessInstanceAndEvaluateDecision();
        HistoricDecisionInstance historicDecisionInstance = (HistoricDecisionInstance)this.historyService.createHistoricDecisionInstanceQuery().includeOutputs().singleResult();
        List outputs = historicDecisionInstance.getOutputs();
        Assert.assertThat((Object)outputs.size(), (Matcher)CoreMatchers.is((Object)2));
        HistoricDecisionOutputInstance firstOutput = (HistoricDecisionOutputInstance)outputs.get(0);
        Assert.assertThat((Object)firstOutput.getClauseId(), (Matcher)CoreMatchers.is((Object)"out1"));
        Assert.assertThat((Object)firstOutput.getRuleId(), (Matcher)CoreMatchers.is((Object)"rule1"));
        Assert.assertThat((Object)firstOutput.getRuleOrder(), (Matcher)CoreMatchers.is((Object)1));
        Assert.assertThat((Object)firstOutput.getVariableName(), (Matcher)CoreMatchers.is((Object)"result1"));
        Assert.assertThat((Object)firstOutput.getValue(), (Matcher)CoreMatchers.is((Object)"okay"));
        HistoricDecisionOutputInstance secondOutput = (HistoricDecisionOutputInstance)outputs.get(1);
        Assert.assertThat((Object)secondOutput.getClauseId(), (Matcher)CoreMatchers.is((Object)"out2"));
        Assert.assertThat((Object)secondOutput.getRuleId(), (Matcher)CoreMatchers.is((Object)"rule1"));
        Assert.assertThat((Object)secondOutput.getRuleOrder(), (Matcher)CoreMatchers.is((Object)1));
        Assert.assertThat((Object)secondOutput.getVariableName(), (Matcher)CoreMatchers.is((Object)"result2"));
        Assert.assertThat((Object)secondOutput.getValue(), (Matcher)CoreMatchers.is((Object)"not okay"));
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/history/HistoricDecisionInstanceTest.processWithBusinessRuleTask.bpmn20.xml", "org/camunda/bpm/engine/test/history/HistoricDecisionInstanceTest.decisionCollectSum.dmn11.xml"})
    @Test
    public void testCollectResultValue() {
        this.startProcessInstanceAndEvaluateDecision();
        HistoricDecisionInstance historicDecisionInstance = (HistoricDecisionInstance)this.historyService.createHistoricDecisionInstanceQuery().singleResult();
        Assert.assertThat((Object)historicDecisionInstance.getCollectResultValue(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Assert.assertThat((Object)historicDecisionInstance.getCollectResultValue(), (Matcher)CoreMatchers.is((Object)3.0));
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/dmn/DecisionWithLiteralExpression.dmn"})
    @Test
    public void testDecisionInstancePropertiesOfDecisionLiteralExpression() {
        DecisionDefinition decisionDefinition = (DecisionDefinition)this.repositoryService.createDecisionDefinitionQuery().singleResult();
        this.decisionService.evaluateDecisionByKey("decision").variables((Map)Variables.createVariables().putValue("sum", (Object)2205)).evaluate();
        HistoricDecisionInstanceQuery query = this.historyService.createHistoricDecisionInstanceQuery().includeInputs().includeOutputs();
        Assert.assertThat((Object)query.count(), (Matcher)CoreMatchers.is((Object)1L));
        HistoricDecisionInstance historicDecisionInstance = (HistoricDecisionInstance)query.singleResult();
        Assert.assertThat((Object)historicDecisionInstance.getDecisionDefinitionId(), (Matcher)CoreMatchers.is((Object)decisionDefinition.getId()));
        Assert.assertThat((Object)historicDecisionInstance.getDecisionDefinitionKey(), (Matcher)CoreMatchers.is((Object)"decision"));
        Assert.assertThat((Object)historicDecisionInstance.getDecisionDefinitionName(), (Matcher)CoreMatchers.is((Object)"Decision with Literal Expression"));
        Assert.assertThat((Object)historicDecisionInstance.getEvaluationTime(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Assert.assertThat((Object)historicDecisionInstance.getInputs().size(), (Matcher)CoreMatchers.is((Object)0));
        List outputs = historicDecisionInstance.getOutputs();
        Assert.assertThat((Object)outputs.size(), (Matcher)CoreMatchers.is((Object)1));
        HistoricDecisionOutputInstance output = (HistoricDecisionOutputInstance)outputs.get(0);
        Assert.assertThat((Object)output.getVariableName(), (Matcher)CoreMatchers.is((Object)"result"));
        Assert.assertThat((Object)output.getTypeName(), (Matcher)CoreMatchers.is((Object)"string"));
        Assert.assertThat((Object)((String)output.getValue()), (Matcher)CoreMatchers.is((Object)"ok"));
        Assert.assertThat((Object)output.getClauseId(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        Assert.assertThat((Object)output.getClauseName(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        Assert.assertThat((Object)output.getRuleId(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        Assert.assertThat((Object)output.getRuleOrder(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/dmn/deployment/drdDish.dmn11.xml"})
    @Test
    public void testDecisionInstancePropertiesOfDrdDecision() {
        this.decisionService.evaluateDecisionTableByKey("dish-decision").variables((Map)Variables.createVariables().putValue("temperature", (Object)21).putValue("dayType", (Object)"Weekend")).evaluate();
        DecisionRequirementsDefinition decisionRequirementsDefinition = (DecisionRequirementsDefinition)this.repositoryService.createDecisionRequirementsDefinitionQuery().singleResult();
        HistoricDecisionInstanceQuery query = this.historyService.createHistoricDecisionInstanceQuery();
        Assert.assertThat((Object)query.count(), (Matcher)CoreMatchers.is((Object)3L));
        HistoricDecisionInstance rootHistoricDecisionInstance = (HistoricDecisionInstance)query.decisionDefinitionKey("dish-decision").singleResult();
        HistoricDecisionInstance requiredHistoricDecisionInstance1 = (HistoricDecisionInstance)query.decisionDefinitionKey("season").singleResult();
        HistoricDecisionInstance requiredHistoricDecisionInstance2 = (HistoricDecisionInstance)query.decisionDefinitionKey("guestCount").singleResult();
        Assert.assertThat((Object)rootHistoricDecisionInstance.getRootDecisionInstanceId(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        Assert.assertThat((Object)rootHistoricDecisionInstance.getDecisionRequirementsDefinitionId(), (Matcher)CoreMatchers.is((Object)decisionRequirementsDefinition.getId()));
        Assert.assertThat((Object)rootHistoricDecisionInstance.getDecisionRequirementsDefinitionKey(), (Matcher)CoreMatchers.is((Object)decisionRequirementsDefinition.getKey()));
        Assert.assertThat((Object)requiredHistoricDecisionInstance1.getRootDecisionInstanceId(), (Matcher)CoreMatchers.is((Object)rootHistoricDecisionInstance.getId()));
        Assert.assertThat((Object)requiredHistoricDecisionInstance1.getDecisionRequirementsDefinitionId(), (Matcher)CoreMatchers.is((Object)decisionRequirementsDefinition.getId()));
        Assert.assertThat((Object)requiredHistoricDecisionInstance1.getDecisionRequirementsDefinitionKey(), (Matcher)CoreMatchers.is((Object)decisionRequirementsDefinition.getKey()));
        Assert.assertThat((Object)requiredHistoricDecisionInstance2.getRootDecisionInstanceId(), (Matcher)CoreMatchers.is((Object)rootHistoricDecisionInstance.getId()));
        Assert.assertThat((Object)requiredHistoricDecisionInstance2.getDecisionRequirementsDefinitionId(), (Matcher)CoreMatchers.is((Object)decisionRequirementsDefinition.getId()));
        Assert.assertThat((Object)requiredHistoricDecisionInstance2.getDecisionRequirementsDefinitionKey(), (Matcher)CoreMatchers.is((Object)decisionRequirementsDefinition.getKey()));
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/history/HistoricDecisionInstanceTest.processWithBusinessRuleTask.bpmn20.xml", "org/camunda/bpm/engine/test/history/HistoricDecisionInstanceTest.decisionSingleOutput.dmn11.xml"})
    @Test
    public void testDeleteHistoricDecisionInstances() {
        HistoricDecisionInstanceQuery query = this.historyService.createHistoricDecisionInstanceQuery().decisionDefinitionKey(DECISION_DEFINITION_KEY);
        this.startProcessInstanceAndEvaluateDecision();
        Assert.assertThat((Object)query.count(), (Matcher)CoreMatchers.is((Object)1L));
        DecisionDefinition decisionDefinition = (DecisionDefinition)this.repositoryService.createDecisionDefinitionQuery().singleResult();
        this.historyService.deleteHistoricDecisionInstanceByDefinitionId(decisionDefinition.getId());
        Assert.assertThat((Object)query.count(), (Matcher)CoreMatchers.is((Object)0L));
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/history/HistoricDecisionInstanceTest.processWithBusinessRuleTask.bpmn20.xml", "org/camunda/bpm/engine/test/history/HistoricDecisionInstanceTest.decisionSingleOutput.dmn11.xml"})
    @Test
    public void testDeleteHistoricDecisionInstanceByInstanceId() {
        this.startProcessInstanceAndEvaluateDecision();
        HistoricDecisionInstanceQuery query = this.historyService.createHistoricDecisionInstanceQuery().decisionDefinitionKey(DECISION_DEFINITION_KEY);
        Assert.assertThat((Object)query.count(), (Matcher)CoreMatchers.is((Object)1L));
        HistoricDecisionInstance historicDecisionInstance = (HistoricDecisionInstance)query.includeInputs().includeOutputs().singleResult();
        this.historyService.deleteHistoricDecisionInstanceByInstanceId(historicDecisionInstance.getId());
        Assert.assertThat((Object)query.count(), (Matcher)CoreMatchers.is((Object)0L));
    }

    @Test
    public void testDeleteHistoricDecisionInstanceByUndeployment() {
        String firstDeploymentId = this.repositoryService.createDeployment().addClasspathResource(DECISION_PROCESS).addClasspathResource(DECISION_SINGLE_OUTPUT_DMN).deploy().getId();
        this.startProcessInstanceAndEvaluateDecision();
        String secondDeploymentId = this.repositoryService.createDeployment().addClasspathResource(DECISION_PROCESS).addClasspathResource(DECISION_MULTIPLE_OUTPUT_DMN).deploy().getId();
        HistoricDecisionInstanceQuery query = this.historyService.createHistoricDecisionInstanceQuery();
        Assert.assertThat((Object)query.count(), (Matcher)CoreMatchers.is((Object)1L));
        this.repositoryService.deleteDeployment(secondDeploymentId, true);
        Assert.assertThat((Object)query.count(), (Matcher)CoreMatchers.is((Object)1L));
        this.repositoryService.deleteDeployment(firstDeploymentId, true);
        Assert.assertThat((Object)query.count(), (Matcher)CoreMatchers.is((Object)0L));
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/history/HistoricDecisionInstanceTest.decisionSingleOutput.dmn11.xml"})
    @Test
    public void testDecisionEvaluatedWithDecisionService() {
        HashMap<String, String> variables = new HashMap<String, String>();
        variables.put("input1", "test");
        this.decisionService.evaluateDecisionTableByKey(DECISION_DEFINITION_KEY, variables);
        String decisionDefinitionId = ((DecisionDefinition)this.repositoryService.createDecisionDefinitionQuery().decisionDefinitionKey(DECISION_DEFINITION_KEY).singleResult()).getId();
        HistoricDecisionInstance historicDecisionInstance = (HistoricDecisionInstance)this.historyService.createHistoricDecisionInstanceQuery().singleResult();
        Assert.assertThat((Object)historicDecisionInstance, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Assert.assertThat((Object)historicDecisionInstance.getDecisionDefinitionId(), (Matcher)CoreMatchers.is((Object)decisionDefinitionId));
        Assert.assertThat((Object)historicDecisionInstance.getDecisionDefinitionKey(), (Matcher)CoreMatchers.is((Object)DECISION_DEFINITION_KEY));
        Assert.assertThat((Object)historicDecisionInstance.getDecisionDefinitionName(), (Matcher)CoreMatchers.is((Object)"sample decision"));
        Assert.assertThat((Object)historicDecisionInstance.getEvaluationTime(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Assert.assertThat((Object)historicDecisionInstance.getProcessDefinitionKey(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        Assert.assertThat((Object)historicDecisionInstance.getProcessDefinitionId(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        Assert.assertThat((Object)historicDecisionInstance.getProcessInstanceId(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        Assert.assertThat((Object)historicDecisionInstance.getActivityId(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        Assert.assertThat((Object)historicDecisionInstance.getActivityInstanceId(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        Assert.assertThat((Object)historicDecisionInstance.getUserId(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/history/HistoricDecisionInstanceTest.decisionSingleOutput.dmn11.xml"})
    @Test
    public void testDecisionEvaluatedWithAuthenticatedUser() {
        this.identityService.setAuthenticatedUserId("demo");
        VariableMap variables = Variables.putValue((String)"input1", (Object)"test");
        this.decisionService.evaluateDecisionTableByKey(DECISION_DEFINITION_KEY, (Map)variables);
        HistoricDecisionInstance historicDecisionInstance = (HistoricDecisionInstance)this.historyService.createHistoricDecisionInstanceQuery().singleResult();
        Assert.assertThat((Object)historicDecisionInstance, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Assert.assertThat((Object)historicDecisionInstance.getUserId(), (Matcher)CoreMatchers.is((Object)"demo"));
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/history/HistoricDecisionInstanceTest.processWithBusinessRuleTask.bpmn20.xml", "org/camunda/bpm/engine/test/history/HistoricDecisionInstanceTest.decisionSingleOutput.dmn11.xml"})
    @Test
    public void testDecisionEvaluatedWithAuthenticatedUserFromProcess() {
        this.identityService.setAuthenticatedUserId("demo");
        this.startProcessInstanceAndEvaluateDecision();
        HistoricDecisionInstance historicDecisionInstance = (HistoricDecisionInstance)this.historyService.createHistoricDecisionInstanceQuery().singleResult();
        Assert.assertThat((Object)historicDecisionInstance, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Assert.assertThat((Object)historicDecisionInstance.getUserId(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/history/HistoricDecisionInstanceTest.testCaseDecisionEvaluatedWithDecisionServiceInsideDelegate.cmmn", "org/camunda/bpm/engine/test/history/HistoricDecisionInstanceTest.decisionSingleOutput.dmn11.xml"})
    @Test
    public void testDecisionEvaluatedWithAuthenticatedUserFromCase() {
        this.identityService.setAuthenticatedUserId("demo");
        this.createCaseInstanceAndEvaluateDecision();
        HistoricDecisionInstance historicDecisionInstance = (HistoricDecisionInstance)this.historyService.createHistoricDecisionInstanceQuery().singleResult();
        Assert.assertThat((Object)historicDecisionInstance, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Assert.assertThat((Object)historicDecisionInstance.getUserId(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/history/HistoricDecisionInstanceTest.testCaseDecisionEvaluatedWithDecisionServiceInsideDelegate.cmmn", "org/camunda/bpm/engine/test/history/HistoricDecisionInstanceTest.decisionSingleOutput.dmn11.xml"})
    @Test
    public void testCaseDecisionEvaluatedWithDecisionServiceInsideDelegate() {
        CaseInstance caseInstance = this.createCaseInstanceAndEvaluateDecision();
        CaseDefinition caseDefinition = (CaseDefinition)this.repositoryService.createCaseDefinitionQuery().caseDefinitionId(caseInstance.getCaseDefinitionId()).singleResult();
        String decisionDefinitionId = ((DecisionDefinition)this.repositoryService.createDecisionDefinitionQuery().decisionDefinitionKey(DECISION_DEFINITION_KEY).singleResult()).getId();
        String activityInstanceId = ((HistoricCaseActivityInstance)this.historyService.createHistoricCaseActivityInstanceQuery().caseActivityId("PI_HumanTask_1").singleResult()).getId();
        HistoricDecisionInstance historicDecisionInstance = (HistoricDecisionInstance)this.historyService.createHistoricDecisionInstanceQuery().singleResult();
        Assert.assertThat((Object)historicDecisionInstance, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Assert.assertThat((Object)historicDecisionInstance.getDecisionDefinitionId(), (Matcher)CoreMatchers.is((Object)decisionDefinitionId));
        Assert.assertThat((Object)historicDecisionInstance.getDecisionDefinitionKey(), (Matcher)CoreMatchers.is((Object)DECISION_DEFINITION_KEY));
        Assert.assertThat((Object)historicDecisionInstance.getDecisionDefinitionName(), (Matcher)CoreMatchers.is((Object)"sample decision"));
        Assert.assertThat((Object)historicDecisionInstance.getProcessDefinitionKey(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        Assert.assertThat((Object)historicDecisionInstance.getProcessDefinitionId(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        Assert.assertThat((Object)historicDecisionInstance.getProcessInstanceId(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        Assert.assertThat((Object)historicDecisionInstance.getCaseDefinitionKey(), (Matcher)CoreMatchers.is((Object)caseDefinition.getKey()));
        Assert.assertThat((Object)historicDecisionInstance.getCaseDefinitionId(), (Matcher)CoreMatchers.is((Object)caseDefinition.getId()));
        Assert.assertThat((Object)historicDecisionInstance.getCaseInstanceId(), (Matcher)CoreMatchers.is((Object)caseInstance.getId()));
        Assert.assertThat((Object)historicDecisionInstance.getActivityId(), (Matcher)CoreMatchers.is((Object)"PI_HumanTask_1"));
        Assert.assertThat((Object)historicDecisionInstance.getActivityInstanceId(), (Matcher)CoreMatchers.is((Object)activityInstanceId));
        Assert.assertThat((Object)historicDecisionInstance.getEvaluationTime(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/history/HistoricDecisionInstanceTest.testManualActivationRuleEvaluatesDecision.cmmn", "org/camunda/bpm/engine/test/history/HistoricDecisionInstanceTest.returnsTrue.dmn11.xml"})
    @Test
    public void testManualActivationRuleEvaluatesDecision() {
        CaseInstance caseInstance = this.caseService.withCaseDefinitionByKey("case").setVariable("input1", null).setVariable("myBean", (Object)new DecisionServiceDelegate()).create();
        CaseDefinition caseDefinition = (CaseDefinition)this.repositoryService.createCaseDefinitionQuery().caseDefinitionId(caseInstance.getCaseDefinitionId()).singleResult();
        String decisionDefinitionId = ((DecisionDefinition)this.repositoryService.createDecisionDefinitionQuery().decisionDefinitionKey(DECISION_DEFINITION_KEY).singleResult()).getId();
        String activityInstanceId = ((HistoricCaseActivityInstance)this.historyService.createHistoricCaseActivityInstanceQuery().caseActivityId("PI_HumanTask_1").singleResult()).getId();
        HistoricDecisionInstance historicDecisionInstance = (HistoricDecisionInstance)this.historyService.createHistoricDecisionInstanceQuery().singleResult();
        Assert.assertThat((Object)historicDecisionInstance, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Assert.assertThat((Object)historicDecisionInstance.getDecisionDefinitionId(), (Matcher)CoreMatchers.is((Object)decisionDefinitionId));
        Assert.assertThat((Object)historicDecisionInstance.getDecisionDefinitionKey(), (Matcher)CoreMatchers.is((Object)DECISION_DEFINITION_KEY));
        Assert.assertThat((Object)historicDecisionInstance.getDecisionDefinitionName(), (Matcher)CoreMatchers.is((Object)"sample decision"));
        Assert.assertThat((Object)historicDecisionInstance.getProcessDefinitionKey(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        Assert.assertThat((Object)historicDecisionInstance.getProcessDefinitionId(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        Assert.assertThat((Object)historicDecisionInstance.getProcessInstanceId(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        Assert.assertThat((Object)historicDecisionInstance.getCaseDefinitionKey(), (Matcher)CoreMatchers.is((Object)caseDefinition.getKey()));
        Assert.assertThat((Object)historicDecisionInstance.getCaseDefinitionId(), (Matcher)CoreMatchers.is((Object)caseDefinition.getId()));
        Assert.assertThat((Object)historicDecisionInstance.getCaseInstanceId(), (Matcher)CoreMatchers.is((Object)caseInstance.getId()));
        Assert.assertThat((Object)historicDecisionInstance.getActivityId(), (Matcher)CoreMatchers.is((Object)"PI_HumanTask_1"));
        Assert.assertThat((Object)historicDecisionInstance.getActivityInstanceId(), (Matcher)CoreMatchers.is((Object)activityInstanceId));
        Assert.assertThat((Object)historicDecisionInstance.getEvaluationTime(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/history/HistoricDecisionInstanceTest.testIfPartEvaluatesDecision.cmmn", "org/camunda/bpm/engine/test/history/HistoricDecisionInstanceTest.returnsTrue.dmn11.xml"})
    @Test
    public void testIfPartEvaluatesDecision() {
        CaseInstance caseInstance = this.caseService.withCaseDefinitionByKey("case").setVariable("input1", null).setVariable("myBean", (Object)new DecisionServiceDelegate()).create();
        String humanTask1 = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult()).getId();
        this.caseService.completeCaseExecution(humanTask1);
        CaseDefinition caseDefinition = (CaseDefinition)this.repositoryService.createCaseDefinitionQuery().caseDefinitionId(caseInstance.getCaseDefinitionId()).singleResult();
        String decisionDefinitionId = ((DecisionDefinition)this.repositoryService.createDecisionDefinitionQuery().decisionDefinitionKey(DECISION_DEFINITION_KEY).singleResult()).getId();
        String activityInstanceId = ((HistoricCaseActivityInstance)this.historyService.createHistoricCaseActivityInstanceQuery().caseActivityId("PI_HumanTask_1").singleResult()).getId();
        HistoricDecisionInstance historicDecisionInstance = (HistoricDecisionInstance)this.historyService.createHistoricDecisionInstanceQuery().singleResult();
        Assert.assertThat((Object)historicDecisionInstance, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Assert.assertThat((Object)historicDecisionInstance.getDecisionDefinitionId(), (Matcher)CoreMatchers.is((Object)decisionDefinitionId));
        Assert.assertThat((Object)historicDecisionInstance.getDecisionDefinitionKey(), (Matcher)CoreMatchers.is((Object)DECISION_DEFINITION_KEY));
        Assert.assertThat((Object)historicDecisionInstance.getDecisionDefinitionName(), (Matcher)CoreMatchers.is((Object)"sample decision"));
        Assert.assertThat((Object)historicDecisionInstance.getProcessDefinitionKey(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        Assert.assertThat((Object)historicDecisionInstance.getProcessDefinitionId(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        Assert.assertThat((Object)historicDecisionInstance.getProcessInstanceId(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        Assert.assertThat((Object)historicDecisionInstance.getCaseDefinitionKey(), (Matcher)CoreMatchers.is((Object)caseDefinition.getKey()));
        Assert.assertThat((Object)historicDecisionInstance.getCaseDefinitionId(), (Matcher)CoreMatchers.is((Object)caseDefinition.getId()));
        Assert.assertThat((Object)historicDecisionInstance.getCaseInstanceId(), (Matcher)CoreMatchers.is((Object)caseInstance.getId()));
        Assert.assertThat((Object)historicDecisionInstance.getActivityId(), (Matcher)CoreMatchers.is((Object)"PI_HumanTask_1"));
        Assert.assertThat((Object)historicDecisionInstance.getActivityInstanceId(), (Matcher)CoreMatchers.is((Object)activityInstanceId));
        Assert.assertThat((Object)historicDecisionInstance.getEvaluationTime(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
    }

    @Test
    public void testTableNames() {
        String tablePrefix = this.processEngineConfiguration.getDatabaseTablePrefix();
        Assert.assertThat((Object)this.managementService.getTableName(HistoricDecisionInstance.class), (Matcher)CoreMatchers.is((Object)(tablePrefix + "ACT_HI_DECINST")));
        Assert.assertThat((Object)this.managementService.getTableName(HistoricDecisionInstanceEntity.class), (Matcher)CoreMatchers.is((Object)(tablePrefix + "ACT_HI_DECINST")));
    }

    protected ProcessInstance startProcessInstanceAndEvaluateDecision() {
        return this.startProcessInstanceAndEvaluateDecision(null);
    }

    protected ProcessInstance startProcessInstanceAndEvaluateDecision(Object input) {
        return this.runtimeService.startProcessInstanceByKey("testProcess", (Map)this.getVariables(input));
    }

    protected CaseInstance createCaseInstanceAndEvaluateDecision() {
        return this.caseService.withCaseDefinitionByKey("case").setVariables((Map)this.getVariables("test")).create();
    }

    protected VariableMap getVariables(Object input) {
        VariableMap variables = Variables.createVariables();
        variables.put((Object)"input1", input);
        return variables;
    }

    protected void waitASignificantAmountOfTime() {
        DateTime now = new DateTime((Object)ClockUtil.getCurrentTime());
        ClockUtil.setCurrentTime((Date)now.plusSeconds(10).toDate());
    }
}

