/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.jobexecutor;

import java.util.List;
import org.camunda.bpm.engine.impl.persistence.entity.AcquirableJobEntity;
import org.camunda.bpm.engine.runtime.Job;
import org.camunda.bpm.engine.test.Deployment;
import org.camunda.bpm.engine.test.jobexecutor.AbstractJobExecutorAcquireJobsTest;
import org.camunda.bpm.engine.test.util.ClockTestUtil;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class JobExecutorAcquireJobsByPriorityTest
extends AbstractJobExecutorAcquireJobsTest {
    @Before
    public void prepareProcessEngineConfiguration() {
        this.configuration.setJobExecutorAcquireByPriority(true);
    }

    @Test
    public void testProcessEngineConfiguration() {
        Assert.assertFalse((boolean)this.configuration.isJobExecutorPreferTimerJobs());
        Assert.assertFalse((boolean)this.configuration.isJobExecutorAcquireByDueDate());
        Assert.assertTrue((boolean)this.configuration.isJobExecutorAcquireByPriority());
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/jobexecutor/jobPrioProcess.bpmn20.xml", "org/camunda/bpm/engine/test/jobexecutor/timerJobPrioProcess.bpmn20.xml"})
    public void testAcquisitionByPriority() {
        int i;
        this.startProcess("jobPrioProcess", "task1", 5);
        this.startProcess("jobPrioProcess", "task2", 5);
        this.startProcess("timerJobPrioProcess", "timer1", 5);
        this.startProcess("timerJobPrioProcess", "timer2", 5);
        ClockTestUtil.incrementClock(61L);
        List<AcquirableJobEntity> acquirableJobs = this.findAcquirableJobs();
        Assert.assertEquals((long)20L, (long)acquirableJobs.size());
        for (i = 0; i < 5; ++i) {
            Assert.assertEquals((long)10L, (long)this.findJobById(acquirableJobs.get(i).getId()).getPriority());
        }
        for (i = 5; i < 10; ++i) {
            Assert.assertEquals((long)8L, (long)this.findJobById(acquirableJobs.get(i).getId()).getPriority());
        }
        for (i = 10; i < 15; ++i) {
            Assert.assertEquals((long)5L, (long)this.findJobById(acquirableJobs.get(i).getId()).getPriority());
        }
        for (i = 15; i < 20; ++i) {
            Assert.assertEquals((long)4L, (long)this.findJobById(acquirableJobs.get(i).getId()).getPriority());
        }
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/jobexecutor/jobPrioProcess.bpmn20.xml"})
    public void testMixedPriorityAcquisition() {
        this.startProcess("jobPrioProcess", "task1", 5);
        this.startProcess("jobPrioProcess", "task2", 5);
    }

    protected Job findJobById(String id) {
        return (Job)this.managementService.createJobQuery().jobId(id).singleResult();
    }
}

