/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.jobexecutor;

import java.util.HashMap;
import java.util.Map;
import org.camunda.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.camunda.bpm.engine.impl.jobexecutor.ExecuteJobHelper;
import org.camunda.bpm.engine.runtime.Job;
import org.camunda.bpm.engine.test.ProcessEngineRule;
import org.camunda.bpm.engine.test.util.ProcessEngineTestRule;
import org.camunda.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.camunda.bpm.model.bpmn.Bpmn;
import org.camunda.bpm.model.bpmn.BpmnModelInstance;
import org.camunda.bpm.model.bpmn.builder.ServiceTaskBuilder;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;

public class JobExecutorExceptionLoggingHandlerTest {
    public ProcessEngineRule engineRule = new ProvidedProcessEngineRule();
    public ProcessEngineTestRule testRule = new ProcessEngineTestRule(this.engineRule);
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.engineRule).around((TestRule)this.testRule);
    protected ProcessEngineConfigurationImpl processEngineConfiguration;
    protected ExecuteJobHelper.ExceptionLoggingHandler originalHandler;

    @Before
    public void init() {
        this.processEngineConfiguration = this.engineRule.getProcessEngineConfiguration();
        this.originalHandler = ExecuteJobHelper.LOGGING_HANDLER;
    }

    @After
    public void tearDown() {
        ExecuteJobHelper.LOGGING_HANDLER = this.originalHandler;
    }

    @Test
    public void shouldBeAbleToReplaceLoggingHandler() {
        CollectingHandler collectingHandler = new CollectingHandler();
        ExecuteJobHelper.LOGGING_HANDLER = collectingHandler;
        BpmnModelInstance modelInstance = ((ServiceTaskBuilder)((ServiceTaskBuilder)Bpmn.createExecutableProcess((String)"failingDelegate").startEvent().serviceTask().camundaClass("org.camunda.bpm.engine.test.jobexecutor.FailingDelegate")).camundaAsyncBefore()).done();
        this.testRule.deploy(modelInstance);
        this.engineRule.getRuntimeService().startProcessInstanceByKey("failingDelegate");
        String jobId = ((Job)this.engineRule.getManagementService().createJobQuery().singleResult()).getId();
        this.processEngineConfiguration.getJobExecutor().start();
        this.testRule.waitForJobExecutorToProcessAllJobs();
        this.processEngineConfiguration.getJobExecutor().shutdown();
        Throwable collectedException = collectingHandler.collectedExceptions.get(jobId);
        Assert.assertTrue((boolean)(collectedException instanceof RuntimeException));
        Assert.assertThat((Object)collectedException.getMessage(), (Matcher)CoreMatchers.is((Object)"Expected Exception"));
    }

    static class CollectingHandler
    implements ExecuteJobHelper.ExceptionLoggingHandler {
        Map<String, Throwable> collectedExceptions = new HashMap<String, Throwable>();

        CollectingHandler() {
        }

        public void exceptionWhileExecutingJob(String jobId, Throwable exception) {
            this.collectedExceptions.put(jobId, exception);
        }
    }
}

