/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.cmd;

import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import org.camunda.bpm.engine.BadUserRequestException;
import org.camunda.bpm.engine.delegate.DelegateExecution;
import org.camunda.bpm.engine.impl.ProcessInstanceModificationBuilderImpl;
import org.camunda.bpm.engine.impl.cfg.CommandChecker;
import org.camunda.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.camunda.bpm.engine.impl.context.Context;
import org.camunda.bpm.engine.impl.history.HistoryLevel;
import org.camunda.bpm.engine.impl.history.event.HistoryEvent;
import org.camunda.bpm.engine.impl.history.event.HistoryEventProcessor;
import org.camunda.bpm.engine.impl.history.event.HistoryEventTypes;
import org.camunda.bpm.engine.impl.history.producer.HistoryEventProducer;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.persistence.entity.ExecutionEntity;
import org.camunda.bpm.engine.impl.persistence.entity.ExecutionManager;
import org.camunda.bpm.engine.impl.persistence.entity.PropertyChange;
import org.camunda.bpm.engine.impl.util.EnsureUtil;
import org.camunda.bpm.engine.runtime.ProcessInstance;

public abstract class AbstractDeleteProcessInstanceCmd {
    protected boolean externallyTerminated;
    protected String deleteReason;
    protected boolean skipCustomListeners;
    protected boolean skipSubprocesses;
    protected boolean failIfNotExists = true;

    protected void checkDeleteProcessInstance(ExecutionEntity execution, CommandContext commandContext) {
        for (CommandChecker checker : commandContext.getProcessEngineConfiguration().getCommandCheckers()) {
            checker.checkDeleteProcessInstance(execution);
        }
    }

    protected void deleteProcessInstance(final CommandContext commandContext, String processInstanceId, final String deleteReason, final boolean skipCustomListeners, final boolean externallyTerminated, final boolean skipIoMappings, boolean skipSubprocesses) {
        ExecutionEntity superExecution;
        EnsureUtil.ensureNotNull(BadUserRequestException.class, "processInstanceId is null", "processInstanceId", (Object)processInstanceId);
        ExecutionManager executionManager = commandContext.getExecutionManager();
        ExecutionEntity execution = executionManager.findExecutionById(processInstanceId);
        if (!this.failIfNotExists && execution == null) {
            return;
        }
        EnsureUtil.ensureNotNull(BadUserRequestException.class, "No process instance found for id '" + processInstanceId + "'", "processInstance", (Object)execution);
        this.checkDeleteProcessInstance(execution, commandContext);
        commandContext.getExecutionManager().deleteProcessInstance(processInstanceId, deleteReason, false, skipCustomListeners, externallyTerminated, skipIoMappings, skipSubprocesses);
        if (skipSubprocesses) {
            List<ProcessInstance> superProcesslist = commandContext.getProcessEngineConfiguration().getRuntimeService().createProcessInstanceQuery().superProcessInstanceId(processInstanceId).list();
            this.triggerHistoryEvent(superProcesslist);
        }
        if ((superExecution = execution.getSuperExecution()) != null) {
            commandContext.runWithoutAuthorization(new Callable<Void>(){

                @Override
                public Void call() {
                    ProcessInstanceModificationBuilderImpl builder = (ProcessInstanceModificationBuilderImpl)new ProcessInstanceModificationBuilderImpl(commandContext, superExecution.getProcessInstanceId(), deleteReason).cancellationSourceExternal(externallyTerminated).cancelActivityInstance(superExecution.getActivityInstanceId());
                    builder.execute(false, skipCustomListeners, skipIoMappings);
                    return null;
                }
            });
        }
        commandContext.getOperationLogManager().logProcessInstanceOperation("Delete", processInstanceId, null, null, Collections.singletonList(PropertyChange.EMPTY_CHANGE));
    }

    public void triggerHistoryEvent(List<ProcessInstance> subProcesslist) {
        ProcessEngineConfigurationImpl configuration = Context.getProcessEngineConfiguration();
        HistoryLevel historyLevel = configuration.getHistoryLevel();
        for (final ProcessInstance processInstance : subProcesslist) {
            if (!historyLevel.isHistoryEventProduced(HistoryEventTypes.PROCESS_INSTANCE_UPDATE, processInstance)) continue;
            HistoryEventProcessor.processHistoryEvents(new HistoryEventProcessor.HistoryEventCreator(){

                @Override
                public HistoryEvent createHistoryEvent(HistoryEventProducer producer) {
                    return producer.createProcessInstanceUpdateEvt((DelegateExecution)((Object)processInstance));
                }
            });
        }
    }
}

