/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.cmmn.behavior;

import org.camunda.bpm.engine.impl.cmmn.behavior.TaskActivityBehavior;
import org.camunda.bpm.engine.impl.cmmn.execution.CmmnActivityExecution;
import org.camunda.bpm.engine.impl.context.Context;
import org.camunda.bpm.engine.impl.el.ExpressionManager;
import org.camunda.bpm.engine.impl.persistence.entity.SuspensionState;
import org.camunda.bpm.engine.impl.persistence.entity.TaskEntity;
import org.camunda.bpm.engine.impl.task.TaskDecorator;
import org.camunda.bpm.engine.impl.task.TaskDefinition;

public class HumanTaskActivityBehavior
extends TaskActivityBehavior {
    protected TaskDecorator taskDecorator;

    @Override
    protected void performStart(CmmnActivityExecution execution) {
        execution.createTask(this.taskDecorator);
    }

    @Override
    protected void performTerminate(CmmnActivityExecution execution) {
        this.terminating(execution);
        super.performTerminate(execution);
    }

    @Override
    protected void performExit(CmmnActivityExecution execution) {
        this.terminating(execution);
        super.performExit(execution);
    }

    protected void terminating(CmmnActivityExecution execution) {
        TaskEntity task = this.getTask(execution);
        if (task != null) {
            task.delete("terminated", false);
        }
    }

    @Override
    protected void completing(CmmnActivityExecution execution) {
        TaskEntity task = this.getTask(execution);
        if (task != null) {
            task.caseExecutionCompleted();
        }
    }

    @Override
    protected void manualCompleting(CmmnActivityExecution execution) {
        this.completing(execution);
    }

    protected void suspending(CmmnActivityExecution execution) {
        String id = execution.getId();
        Context.getCommandContext().getTaskManager().updateTaskSuspensionStateByCaseExecutionId(id, SuspensionState.SUSPENDED);
    }

    @Override
    protected void resuming(CmmnActivityExecution execution) {
        String id = execution.getId();
        Context.getCommandContext().getTaskManager().updateTaskSuspensionStateByCaseExecutionId(id, SuspensionState.ACTIVE);
    }

    protected TaskEntity getTask(CmmnActivityExecution execution) {
        return Context.getCommandContext().getTaskManager().findTaskByCaseExecutionId(execution.getId());
    }

    @Override
    protected String getTypeName() {
        return "human task";
    }

    public TaskDecorator getTaskDecorator() {
        return this.taskDecorator;
    }

    public void setTaskDecorator(TaskDecorator taskDecorator) {
        this.taskDecorator = taskDecorator;
    }

    public TaskDefinition getTaskDefinition() {
        return this.taskDecorator.getTaskDefinition();
    }

    public ExpressionManager getExpressionManager() {
        return this.taskDecorator.getExpressionManager();
    }
}

