/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.telemetry;

import java.util.HashMap;
import java.util.Map;
import org.camunda.bpm.engine.impl.telemetry.CommandCounter;
import org.camunda.bpm.engine.impl.telemetry.dto.ApplicationServer;
import org.camunda.bpm.engine.impl.telemetry.dto.LicenseKeyData;

public class TelemetryRegistry {
    public static final String UNIQUE_TASK_WORKERS = "unique-task-workers";
    protected Map<String, CommandCounter> commands = new HashMap<String, CommandCounter>();
    protected ApplicationServer applicationServer;
    protected LicenseKeyData licenseKey;
    protected String camundaIntegration;
    protected boolean isCollectingTelemetryDataEnabled = false;

    public synchronized ApplicationServer getApplicationServer() {
        return this.applicationServer;
    }

    public synchronized void setApplicationServer(ApplicationServer applicationServer) {
        this.applicationServer = applicationServer;
    }

    public synchronized void setApplicationServer(String applicationServerVersion) {
        this.applicationServer = new ApplicationServer(applicationServerVersion);
    }

    public Map<String, CommandCounter> getCommands() {
        return this.commands;
    }

    public String getCamundaIntegration() {
        return this.camundaIntegration;
    }

    public void setCamundaIntegration(String camundaIntegration) {
        this.camundaIntegration = camundaIntegration;
    }

    public LicenseKeyData getLicenseKey() {
        return this.licenseKey;
    }

    public void setLicenseKey(LicenseKeyData licenseKey) {
        this.licenseKey = licenseKey;
    }

    public boolean isCollectingTelemetryDataEnabled() {
        return this.isCollectingTelemetryDataEnabled;
    }

    public void setCollectingTelemetryDataEnabled(boolean isTelemetryEnabled) {
        this.isCollectingTelemetryDataEnabled = isTelemetryEnabled;
    }

    public void markOccurrence(String name) {
        this.markOccurrence(name, 1L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void markOccurrence(String name, long times) {
        CommandCounter counter = this.commands.get(name);
        if (counter == null) {
            Map<String, CommandCounter> map = this.commands;
            synchronized (map) {
                if (counter == null) {
                    counter = new CommandCounter(name);
                    this.commands.put(name, counter);
                }
            }
        }
        counter.mark(times);
    }

    public void clear() {
        this.commands.clear();
        this.licenseKey = null;
        this.applicationServer = null;
    }
}

