/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.camunda.bpm.engine.HistoryService;
import org.camunda.bpm.engine.ManagementService;
import org.camunda.bpm.engine.RuntimeService;
import org.camunda.bpm.engine.batch.Batch;
import org.camunda.bpm.engine.history.HistoricTaskInstance;
import org.camunda.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.camunda.bpm.engine.runtime.Job;
import org.camunda.bpm.engine.test.ProcessEngineRule;
import org.camunda.bpm.engine.test.api.runtime.BatchHelper;
import org.camunda.bpm.engine.test.util.ProcessEngineTestRule;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.After;
import org.junit.Assert;

public abstract class AbstractAsyncOperationsTest {
    public static final String ONE_TASK_PROCESS = "oneTaskProcess";
    public static final String TESTING_INSTANCE_DELETE = "testing instance delete";
    protected RuntimeService runtimeService;
    protected ManagementService managementService;
    protected HistoryService historyService;
    protected BatchHelper helper;
    protected ProcessEngineConfigurationImpl engineConfiguration;
    protected int defaultBatchJobsPerSeed;
    protected int defaultInvocationsPerBatchJob;

    protected void initDefaults(ProcessEngineRule engineRule) {
        this.runtimeService = engineRule.getRuntimeService();
        this.managementService = engineRule.getManagementService();
        this.historyService = engineRule.getHistoryService();
        this.engineConfiguration = engineRule.getProcessEngineConfiguration();
        this.defaultBatchJobsPerSeed = this.engineConfiguration.getBatchJobsPerSeed();
        this.defaultInvocationsPerBatchJob = this.engineConfiguration.getInvocationsPerBatchJob();
    }

    @After
    public void cleanUpBatches() {
        this.managementService.createBatchQuery().list().forEach(b -> this.managementService.deleteBatch(b.getId(), true));
        this.historyService.createHistoricBatchQuery().list().forEach(b -> this.historyService.deleteHistoricBatch(b.getId()));
        this.engineConfiguration.setBatchJobsPerSeed(this.defaultBatchJobsPerSeed);
        this.engineConfiguration.setInvocationsPerBatchJob(this.defaultInvocationsPerBatchJob);
    }

    protected List<String> getJobIdsByDeployment(List<Job> jobs, String deploymentId) {
        return jobs.stream().filter(j -> deploymentId.equals(j.getDeploymentId())).map(Job::getId).collect(Collectors.toList());
    }

    protected void completeSeedJobs(Batch batch) {
        while (this.getSeedJob(batch) != null) {
            this.executeSeedJob(batch);
        }
    }

    protected void executeSeedJob(Batch batch) {
        Job seedJob = this.getSeedJob(batch);
        Assert.assertNotNull((Object)seedJob);
        this.managementService.executeJob(seedJob.getId());
    }

    protected void executeSeedJobs(Batch batch, int expectedSeedJobsCount) {
        for (int i = 0; i < expectedSeedJobsCount; ++i) {
            this.executeSeedJob(batch);
        }
        Assert.assertNull((Object)this.getSeedJob(batch));
    }

    protected Job getSeedJob(Batch batch) {
        String seedJobDefinitionId = batch.getSeedJobDefinitionId();
        Job seedJob = (Job)this.managementService.createJobQuery().jobDefinitionId(seedJobDefinitionId).singleResult();
        return seedJob;
    }

    protected List<Exception> executeBatchJobs(Batch batch) {
        String batchJobDefinitionId = batch.getBatchJobDefinitionId();
        List batchJobs = this.managementService.createJobQuery().jobDefinitionId(batchJobDefinitionId).list();
        Assert.assertFalse((boolean)batchJobs.isEmpty());
        ArrayList<Exception> catchedExceptions = new ArrayList<Exception>();
        for (Job batchJob : batchJobs) {
            try {
                this.managementService.executeJob(batchJob.getId());
            }
            catch (Exception e) {
                catchedExceptions.add(e);
            }
        }
        return catchedExceptions;
    }

    protected List<String> startTestProcesses(int numberOfProcesses) {
        ArrayList<String> ids = new ArrayList<String>();
        for (int i = 0; i < numberOfProcesses; ++i) {
            ids.add(this.runtimeService.startProcessInstanceByKey(ONE_TASK_PROCESS).getProcessInstanceId());
        }
        return ids;
    }

    protected void assertHistoricTaskDeletionPresent(List<String> processIds, String deleteReason, ProcessEngineTestRule testRule) {
        if (!testRule.isHistoryLevelNone()) {
            for (String processId : processIds) {
                HistoricTaskInstance historicTaskInstance = (HistoricTaskInstance)this.historyService.createHistoricTaskInstanceQuery().processInstanceId(processId).singleResult();
                Assert.assertThat((Object)historicTaskInstance.getDeleteReason(), (Matcher)CoreMatchers.is((Object)deleteReason));
            }
        }
    }

    protected void assertHistoricBatchExists(ProcessEngineTestRule testRule) {
        if (testRule.isHistoryLevelFull()) {
            Assert.assertThat((Object)this.historyService.createHistoricBatchQuery().count(), (Matcher)CoreMatchers.is((Object)1L));
        }
    }
}

