/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.history.removaltime.cleanup;

import java.util.Date;
import org.apache.commons.lang3.time.DateUtils;
import org.camunda.bpm.engine.IdentityService;
import org.camunda.bpm.engine.RuntimeService;
import org.camunda.bpm.engine.TaskService;
import org.camunda.bpm.engine.impl.history.event.HistoryEventTypes;
import org.camunda.bpm.engine.impl.util.ClockUtil;
import org.camunda.bpm.engine.runtime.Job;
import org.camunda.bpm.engine.test.api.history.removaltime.cleanup.AbstractHistoryCleanupSchedulerTest;
import org.camunda.bpm.engine.test.util.ProcessEngineBootstrapRule;
import org.camunda.bpm.engine.test.util.ProcessEngineTestRule;
import org.camunda.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.camunda.bpm.model.bpmn.Bpmn;
import org.camunda.bpm.model.bpmn.BpmnModelInstance;
import org.camunda.bpm.model.bpmn.builder.ProcessBuilder;
import org.camunda.bpm.model.bpmn.builder.StartEventBuilder;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;

public class HistoryCleanupSchedulerUserOperationLogsTest
extends AbstractHistoryCleanupSchedulerTest {
    @ClassRule
    public static ProcessEngineBootstrapRule bootstrapRule = new ProcessEngineBootstrapRule(configuration -> HistoryCleanupSchedulerUserOperationLogsTest.configure(configuration, HistoryEventTypes.USER_OPERATION_LOG));
    protected ProvidedProcessEngineRule engineRule = new ProvidedProcessEngineRule(bootstrapRule);
    protected ProcessEngineTestRule testRule = new ProcessEngineTestRule(this.engineRule);
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.engineRule).around((TestRule)this.testRule);
    protected RuntimeService runtimeService;
    protected TaskService taskService;
    protected IdentityService identityService;
    protected final String PROCESS_KEY = "process";
    protected final BpmnModelInstance PROCESS = ((StartEventBuilder)((ProcessBuilder)Bpmn.createExecutableProcess((String)"process").camundaHistoryTimeToLive(Integer.valueOf(5))).startEvent().camundaAsyncBefore()).endEvent().done();

    @Before
    public void init() {
        engineConfiguration = this.engineRule.getProcessEngineConfiguration();
        this.initEngineConfiguration(engineConfiguration);
        this.historyService = this.engineRule.getHistoryService();
        this.managementService = this.engineRule.getManagementService();
        this.runtimeService = this.engineRule.getRuntimeService();
        this.taskService = this.engineRule.getTaskService();
        this.identityService = this.engineRule.getIdentityService();
    }

    @Test
    public void shouldScheduleToNow() {
        this.testRule.deploy(this.PROCESS);
        ClockUtil.setCurrentTime((Date)this.END_DATE);
        this.runtimeService.startProcessInstanceByKey("process");
        String jobId = ((Job)this.managementService.createJobQuery().singleResult()).getId();
        for (int i = 0; i < 5; ++i) {
            this.identityService.setAuthenticatedUserId("aUserId");
            this.managementService.setJobRetries(jobId, 65);
            this.identityService.clearAuthentication();
        }
        this.managementService.executeJob(jobId);
        engineConfiguration.setHistoryCleanupBatchSize(5);
        engineConfiguration.initHistoryCleanup();
        Date removalTime = DateUtils.addDays((Date)this.END_DATE, (int)5);
        ClockUtil.setCurrentTime((Date)removalTime);
        this.runHistoryCleanup();
        Job job = (Job)this.historyService.findHistoryCleanupJobs().get(0);
        Assert.assertThat((Object)job.getDuedate(), (Matcher)Is.is((Object)removalTime));
    }

    @Test
    public void shouldScheduleToLater() {
        this.testRule.deploy(this.PROCESS);
        ClockUtil.setCurrentTime((Date)this.END_DATE);
        this.runtimeService.startProcessInstanceByKey("process");
        String jobId = ((Job)this.managementService.createJobQuery().singleResult()).getId();
        for (int i = 0; i < 5; ++i) {
            this.identityService.setAuthenticatedUserId("aUserId");
            this.managementService.setJobRetries(jobId, 65);
            this.identityService.clearAuthentication();
        }
        this.managementService.executeJob(jobId);
        engineConfiguration.setHistoryCleanupBatchSize(6);
        engineConfiguration.initHistoryCleanup();
        Date removalTime = DateUtils.addDays((Date)this.END_DATE, (int)5);
        ClockUtil.setCurrentTime((Date)removalTime);
        this.runHistoryCleanup();
        Job job = (Job)this.historyService.findHistoryCleanupJobs().get(0);
        Assert.assertThat((Object)job.getDuedate(), (Matcher)Is.is((Object)DateUtils.addSeconds((Date)removalTime, (int)10)));
    }
}

