/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.mgmt;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.impl.interceptor.Command;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.interceptor.CommandExecutor;
import org.camunda.bpm.engine.impl.util.ClockUtil;
import org.camunda.bpm.engine.management.JobDefinition;
import org.camunda.bpm.engine.management.JobDefinitionQuery;
import org.camunda.bpm.engine.repository.ProcessDefinition;
import org.camunda.bpm.engine.repository.ProcessDefinitionQuery;
import org.camunda.bpm.engine.runtime.Job;
import org.camunda.bpm.engine.runtime.JobQuery;
import org.camunda.bpm.engine.test.Deployment;
import org.camunda.bpm.engine.test.util.PluggableProcessEngineTest;
import org.camunda.bpm.engine.variable.Variables;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;

public class SuspendJobDefinitionTest
extends PluggableProcessEngineTest {
    @After
    public void tearDown() throws Exception {
        CommandExecutor commandExecutor = this.processEngineConfiguration.getCommandExecutorTxRequired();
        commandExecutor.execute((Command)new Command<Object>(){

            public Object execute(CommandContext commandContext) {
                commandContext.getHistoricJobLogManager().deleteHistoricJobLogsByHandlerType("suspend-job-definition");
                return null;
            }
        });
    }

    @Test
    public void testSuspensionById_shouldThrowProcessEngineException() {
        try {
            this.managementService.suspendJobDefinitionById(null);
            Assert.fail((String)"A ProcessEngineException was expected.");
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    @Test
    public void testSuspensionByIdAndSuspendJobsFlag_shouldThrowProcessEngineException() {
        try {
            this.managementService.suspendJobDefinitionById(null, false);
            Assert.fail((String)"A ProcessEngineException was expected.");
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
        try {
            this.managementService.suspendJobDefinitionById(null, true);
            Assert.fail((String)"A ProcessEngineException was expected.");
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    @Test
    public void testSuspensionByIdAndSuspendJobsFlagAndExecutionDate_shouldThrowProcessEngineException() {
        try {
            this.managementService.suspendJobDefinitionById(null, false, null);
            Assert.fail((String)"A ProcessEngineException was expected.");
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
        try {
            this.managementService.suspendJobDefinitionById(null, true, null);
            Assert.fail((String)"A ProcessEngineException was expected.");
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
        try {
            this.managementService.suspendJobDefinitionById(null, false, new Date());
            Assert.fail((String)"A ProcessEngineException was expected.");
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
        try {
            this.managementService.suspendJobDefinitionById(null, true, new Date());
            Assert.fail((String)"A ProcessEngineException was expected.");
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/mgmt/SuspensionTest.testBase.bpmn"})
    @Test
    public void testSuspensionById_shouldRetainJobs() {
        HashMap<String, Boolean> params = new HashMap<String, Boolean>();
        params.put("fail", Boolean.TRUE);
        this.runtimeService.startProcessInstanceByKey("suspensionProcess", params);
        JobDefinition jobDefinition = (JobDefinition)this.managementService.createJobDefinitionQuery().singleResult();
        this.managementService.suspendJobDefinitionById(jobDefinition.getId());
        JobDefinitionQuery jobDefinitionQuery = this.managementService.createJobDefinitionQuery().suspended();
        Assert.assertEquals((long)1L, (long)jobDefinitionQuery.count());
        JobDefinition suspendedJobDefinition = (JobDefinition)jobDefinitionQuery.singleResult();
        Assert.assertEquals((Object)jobDefinition.getId(), (Object)suspendedJobDefinition.getId());
        jobDefinitionQuery = this.managementService.createJobDefinitionQuery().active();
        Assert.assertTrue((boolean)jobDefinitionQuery.list().isEmpty());
        JobQuery jobQuery = this.managementService.createJobQuery().active();
        Assert.assertEquals((long)1L, (long)jobQuery.count());
        Job activeJob = (Job)jobQuery.singleResult();
        Assert.assertEquals((Object)jobDefinition.getId(), (Object)activeJob.getJobDefinitionId());
        Assert.assertFalse((boolean)activeJob.isSuspended());
        jobQuery = this.managementService.createJobQuery().suspended();
        Assert.assertEquals((long)0L, (long)jobQuery.count());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/mgmt/SuspensionTest.testBase.bpmn"})
    @Test
    public void testSuspensionByIdAndSuspendJobsFlag_shouldRetainJobs() {
        HashMap<String, Boolean> params = new HashMap<String, Boolean>();
        params.put("fail", Boolean.TRUE);
        this.runtimeService.startProcessInstanceByKey("suspensionProcess", params);
        JobDefinition jobDefinition = (JobDefinition)this.managementService.createJobDefinitionQuery().singleResult();
        this.managementService.suspendJobDefinitionById(jobDefinition.getId(), false);
        JobDefinitionQuery jobDefinitionQuery = this.managementService.createJobDefinitionQuery().suspended();
        Assert.assertEquals((long)1L, (long)jobDefinitionQuery.count());
        JobDefinition suspendedJobDefinition = (JobDefinition)jobDefinitionQuery.singleResult();
        Assert.assertEquals((Object)jobDefinition.getId(), (Object)suspendedJobDefinition.getId());
        Assert.assertTrue((boolean)suspendedJobDefinition.isSuspended());
        JobQuery jobQuery = this.managementService.createJobQuery().active();
        Assert.assertEquals((long)1L, (long)jobQuery.count());
        Job activeJob = (Job)jobQuery.singleResult();
        Assert.assertEquals((Object)jobDefinition.getId(), (Object)activeJob.getJobDefinitionId());
        Assert.assertFalse((boolean)activeJob.isSuspended());
        jobQuery = this.managementService.createJobQuery().suspended();
        Assert.assertEquals((long)0L, (long)jobQuery.count());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/mgmt/SuspensionTest.testBase.bpmn"})
    @Test
    public void testSuspensionByIdAndSuspendJobsFlag_shouldSuspendJobs() {
        HashMap<String, Boolean> params = new HashMap<String, Boolean>();
        params.put("fail", Boolean.TRUE);
        this.runtimeService.startProcessInstanceByKey("suspensionProcess", params);
        JobDefinition jobDefinition = (JobDefinition)this.managementService.createJobDefinitionQuery().singleResult();
        this.managementService.suspendJobDefinitionById(jobDefinition.getId(), true);
        JobDefinitionQuery jobDefinitionQuery = this.managementService.createJobDefinitionQuery().suspended();
        Assert.assertEquals((long)1L, (long)jobDefinitionQuery.count());
        JobDefinition suspendedJobDefinition = (JobDefinition)jobDefinitionQuery.singleResult();
        Assert.assertEquals((Object)jobDefinition.getId(), (Object)suspendedJobDefinition.getId());
        Assert.assertTrue((boolean)suspendedJobDefinition.isSuspended());
        JobQuery jobQuery = this.managementService.createJobQuery().suspended();
        Assert.assertEquals((long)1L, (long)jobQuery.count());
        Job suspendedJob = (Job)jobQuery.singleResult();
        Assert.assertEquals((Object)jobDefinition.getId(), (Object)suspendedJob.getJobDefinitionId());
        Assert.assertTrue((boolean)suspendedJob.isSuspended());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/mgmt/SuspensionTest.testBase.bpmn"})
    @Test
    public void testSuspensionById_shouldExecuteImmediatelyAndRetainJobs() {
        HashMap<String, Boolean> params = new HashMap<String, Boolean>();
        params.put("fail", Boolean.TRUE);
        this.runtimeService.startProcessInstanceByKey("suspensionProcess", params);
        JobDefinition jobDefinition = (JobDefinition)this.managementService.createJobDefinitionQuery().singleResult();
        this.managementService.suspendJobDefinitionById(jobDefinition.getId(), false, null);
        JobDefinitionQuery jobDefinitionQuery = this.managementService.createJobDefinitionQuery().suspended();
        Assert.assertEquals((long)1L, (long)jobDefinitionQuery.count());
        JobDefinition suspendedJobDefinition = (JobDefinition)jobDefinitionQuery.singleResult();
        Assert.assertEquals((Object)jobDefinition.getId(), (Object)suspendedJobDefinition.getId());
        Assert.assertTrue((boolean)suspendedJobDefinition.isSuspended());
        JobQuery jobQuery = this.managementService.createJobQuery().active();
        Assert.assertEquals((long)1L, (long)jobQuery.count());
        Job activeJob = (Job)jobQuery.singleResult();
        Assert.assertEquals((Object)jobDefinition.getId(), (Object)activeJob.getJobDefinitionId());
        Assert.assertFalse((boolean)activeJob.isSuspended());
        jobQuery = this.managementService.createJobQuery().suspended();
        Assert.assertEquals((long)0L, (long)jobQuery.count());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/mgmt/SuspensionTest.testBase.bpmn"})
    @Test
    public void testSuspensionById_shouldExecuteImmediatelyAndSuspendJobs() {
        HashMap<String, Boolean> params = new HashMap<String, Boolean>();
        params.put("fail", Boolean.TRUE);
        this.runtimeService.startProcessInstanceByKey("suspensionProcess", params);
        JobDefinition jobDefinition = (JobDefinition)this.managementService.createJobDefinitionQuery().singleResult();
        this.managementService.suspendJobDefinitionById(jobDefinition.getId(), true, null);
        JobDefinitionQuery jobDefinitionQuery = this.managementService.createJobDefinitionQuery().suspended();
        Assert.assertEquals((long)1L, (long)jobDefinitionQuery.count());
        JobDefinition suspendedJobDefinition = (JobDefinition)jobDefinitionQuery.singleResult();
        Assert.assertEquals((Object)jobDefinition.getId(), (Object)suspendedJobDefinition.getId());
        Assert.assertTrue((boolean)suspendedJobDefinition.isSuspended());
        JobQuery jobQuery = this.managementService.createJobQuery().suspended();
        Assert.assertEquals((long)1L, (long)jobQuery.count());
        Job suspendedJob = (Job)jobQuery.singleResult();
        Assert.assertEquals((Object)jobDefinition.getId(), (Object)suspendedJob.getJobDefinitionId());
        Assert.assertTrue((boolean)suspendedJob.isSuspended());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/mgmt/SuspensionTest.testBase.bpmn"})
    @Test
    public void testSuspensionById_shouldExecuteDelayedAndRetainJobs() {
        HashMap<String, Boolean> params = new HashMap<String, Boolean>();
        params.put("fail", Boolean.TRUE);
        this.runtimeService.startProcessInstanceByKey("suspensionProcess", params);
        JobDefinition jobDefinition = (JobDefinition)this.managementService.createJobDefinitionQuery().singleResult();
        this.managementService.suspendJobDefinitionById(jobDefinition.getId(), false, this.oneWeekLater());
        JobDefinitionQuery jobDefinitionQuery = this.managementService.createJobDefinitionQuery();
        Assert.assertEquals((long)1L, (long)jobDefinitionQuery.active().count());
        Assert.assertEquals((long)0L, (long)jobDefinitionQuery.suspended().count());
        JobQuery jobQuery = this.managementService.createJobQuery();
        Job delayedSuspensionJob = (Job)jobQuery.timers().active().singleResult();
        Assert.assertNotNull((Object)delayedSuspensionJob);
        String deploymentId = ((ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().processDefinitionId(jobDefinition.getProcessDefinitionId()).singleResult()).getDeploymentId();
        Assert.assertThat((Object)delayedSuspensionJob.getDeploymentId(), (Matcher)CoreMatchers.is((Object)deploymentId));
        this.managementService.executeJob(delayedSuspensionJob.getId());
        Assert.assertEquals((long)0L, (long)jobDefinitionQuery.active().count());
        Assert.assertEquals((long)1L, (long)jobDefinitionQuery.suspended().count());
        JobDefinition suspendedJobDefinition = (JobDefinition)jobDefinitionQuery.suspended().singleResult();
        Assert.assertEquals((Object)jobDefinition.getId(), (Object)suspendedJobDefinition.getId());
        Assert.assertTrue((boolean)suspendedJobDefinition.isSuspended());
        jobQuery = this.managementService.createJobQuery().active();
        Assert.assertEquals((long)1L, (long)jobQuery.count());
        Job activeJob = (Job)jobQuery.singleResult();
        Assert.assertEquals((Object)jobDefinition.getId(), (Object)activeJob.getJobDefinitionId());
        Assert.assertFalse((boolean)activeJob.isSuspended());
        jobQuery = this.managementService.createJobQuery().suspended();
        Assert.assertEquals((long)0L, (long)jobQuery.count());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/mgmt/SuspensionTest.testBase.bpmn"})
    @Test
    public void testSuspensionById_shouldExecuteDelayedAndSuspendJobs() {
        HashMap<String, Boolean> params = new HashMap<String, Boolean>();
        params.put("fail", Boolean.TRUE);
        this.runtimeService.startProcessInstanceByKey("suspensionProcess", params);
        JobDefinition jobDefinition = (JobDefinition)this.managementService.createJobDefinitionQuery().singleResult();
        this.managementService.suspendJobDefinitionById(jobDefinition.getId(), true, this.oneWeekLater());
        JobDefinitionQuery jobDefinitionQuery = this.managementService.createJobDefinitionQuery();
        Assert.assertEquals((long)1L, (long)jobDefinitionQuery.active().count());
        Assert.assertEquals((long)0L, (long)jobDefinitionQuery.suspended().count());
        JobQuery jobQuery = this.managementService.createJobQuery();
        Job delayedSuspensionJob = (Job)jobQuery.timers().active().singleResult();
        Assert.assertNotNull((Object)delayedSuspensionJob);
        String deploymentId = ((ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().processDefinitionId(jobDefinition.getProcessDefinitionId()).singleResult()).getDeploymentId();
        Assert.assertThat((Object)delayedSuspensionJob.getDeploymentId(), (Matcher)CoreMatchers.is((Object)deploymentId));
        this.managementService.executeJob(delayedSuspensionJob.getId());
        Assert.assertEquals((long)0L, (long)jobDefinitionQuery.active().count());
        Assert.assertEquals((long)1L, (long)jobDefinitionQuery.suspended().count());
        JobDefinition suspendedJobDefinition = (JobDefinition)jobDefinitionQuery.suspended().singleResult();
        Assert.assertEquals((Object)jobDefinition.getId(), (Object)suspendedJobDefinition.getId());
        Assert.assertTrue((boolean)suspendedJobDefinition.isSuspended());
        jobQuery = this.managementService.createJobQuery().suspended();
        Assert.assertEquals((long)1L, (long)jobQuery.count());
        Job suspendedJob = (Job)jobQuery.singleResult();
        Assert.assertEquals((Object)jobDefinition.getId(), (Object)suspendedJob.getJobDefinitionId());
        Assert.assertTrue((boolean)suspendedJob.isSuspended());
        jobQuery = this.managementService.createJobQuery().active();
        Assert.assertEquals((long)0L, (long)jobQuery.count());
    }

    @Test
    public void testSuspensionByProcessDefinitionId_shouldThrowProcessEngineException() {
        try {
            this.managementService.suspendJobDefinitionByProcessDefinitionId(null);
            Assert.fail((String)"A ProcessEngineException was expected.");
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    @Test
    public void testSuspensionByProcessDefinitionIdAndSuspendJobsFlag_shouldThrowProcessEngineException() {
        try {
            this.managementService.suspendJobDefinitionByProcessDefinitionId(null, false);
            Assert.fail((String)"A ProcessEngineException was expected.");
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
        try {
            this.managementService.suspendJobDefinitionByProcessDefinitionId(null, true);
            Assert.fail((String)"A ProcessEngineException was expected.");
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    @Test
    public void testSuspensionByProcessDefinitionIdAndSuspendJobsFlagAndExecutionDate_shouldThrowProcessEngineException() {
        try {
            this.managementService.suspendJobDefinitionByProcessDefinitionId(null, false, null);
            Assert.fail((String)"A ProcessEngineException was expected.");
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
        try {
            this.managementService.suspendJobDefinitionByProcessDefinitionId(null, true, null);
            Assert.fail((String)"A ProcessEngineException was expected.");
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
        try {
            this.managementService.suspendJobDefinitionByProcessDefinitionId(null, false, new Date());
            Assert.fail((String)"A ProcessEngineException was expected.");
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
        try {
            this.managementService.suspendJobDefinitionByProcessDefinitionId(null, true, new Date());
            Assert.fail((String)"A ProcessEngineException was expected.");
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/mgmt/SuspensionTest.testBase.bpmn"})
    @Test
    public void testSuspensionByProcessDefinitionId_shouldRetainJobs() {
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().singleResult();
        HashMap<String, Boolean> params = new HashMap<String, Boolean>();
        params.put("fail", Boolean.TRUE);
        this.runtimeService.startProcessInstanceByKey("suspensionProcess", params);
        JobDefinition jobDefinition = (JobDefinition)this.managementService.createJobDefinitionQuery().singleResult();
        this.managementService.suspendJobDefinitionByProcessDefinitionId(processDefinition.getId());
        JobDefinitionQuery jobDefinitionQuery = this.managementService.createJobDefinitionQuery().suspended();
        Assert.assertEquals((long)1L, (long)jobDefinitionQuery.count());
        JobDefinition suspendedJobDefinition = (JobDefinition)jobDefinitionQuery.singleResult();
        Assert.assertEquals((Object)jobDefinition.getId(), (Object)suspendedJobDefinition.getId());
        jobDefinitionQuery = this.managementService.createJobDefinitionQuery().active();
        Assert.assertTrue((boolean)jobDefinitionQuery.list().isEmpty());
        JobQuery jobQuery = this.managementService.createJobQuery().active();
        Assert.assertEquals((long)1L, (long)jobQuery.count());
        Job activeJob = (Job)jobQuery.singleResult();
        Assert.assertEquals((Object)jobDefinition.getId(), (Object)activeJob.getJobDefinitionId());
        Assert.assertFalse((boolean)activeJob.isSuspended());
        jobQuery = this.managementService.createJobQuery().suspended();
        Assert.assertEquals((long)0L, (long)jobQuery.count());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/mgmt/SuspensionTest.testBase.bpmn"})
    @Test
    public void testSuspensionByProcessDefinitionIdAndSuspendJobsFlag_shouldRetainJobs() {
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().singleResult();
        HashMap<String, Boolean> params = new HashMap<String, Boolean>();
        params.put("fail", Boolean.TRUE);
        this.runtimeService.startProcessInstanceByKey("suspensionProcess", params);
        JobDefinition jobDefinition = (JobDefinition)this.managementService.createJobDefinitionQuery().singleResult();
        this.managementService.suspendJobDefinitionByProcessDefinitionId(processDefinition.getId(), false);
        JobDefinitionQuery jobDefinitionQuery = this.managementService.createJobDefinitionQuery().suspended();
        Assert.assertEquals((long)1L, (long)jobDefinitionQuery.count());
        JobDefinition suspendedJobDefinition = (JobDefinition)jobDefinitionQuery.singleResult();
        Assert.assertEquals((Object)jobDefinition.getId(), (Object)suspendedJobDefinition.getId());
        Assert.assertTrue((boolean)suspendedJobDefinition.isSuspended());
        JobQuery jobQuery = this.managementService.createJobQuery().active();
        Assert.assertEquals((long)1L, (long)jobQuery.count());
        Job activeJob = (Job)jobQuery.singleResult();
        Assert.assertEquals((Object)jobDefinition.getId(), (Object)activeJob.getJobDefinitionId());
        Assert.assertFalse((boolean)activeJob.isSuspended());
        jobQuery = this.managementService.createJobQuery().suspended();
        Assert.assertEquals((long)0L, (long)jobQuery.count());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/mgmt/SuspensionTest.testBase.bpmn"})
    @Test
    public void testSuspensionByProcessDefinitionIdAndSuspendJobsFlag_shouldSuspendJobs() {
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().singleResult();
        HashMap<String, Boolean> params = new HashMap<String, Boolean>();
        params.put("fail", Boolean.TRUE);
        this.runtimeService.startProcessInstanceByKey("suspensionProcess", params);
        JobDefinition jobDefinition = (JobDefinition)this.managementService.createJobDefinitionQuery().singleResult();
        this.managementService.suspendJobDefinitionByProcessDefinitionId(processDefinition.getId(), true);
        JobDefinitionQuery jobDefinitionQuery = this.managementService.createJobDefinitionQuery().suspended();
        Assert.assertEquals((long)1L, (long)jobDefinitionQuery.count());
        JobDefinition suspendedJobDefinition = (JobDefinition)jobDefinitionQuery.singleResult();
        Assert.assertEquals((Object)jobDefinition.getId(), (Object)suspendedJobDefinition.getId());
        Assert.assertTrue((boolean)suspendedJobDefinition.isSuspended());
        JobQuery jobQuery = this.managementService.createJobQuery().suspended();
        Assert.assertEquals((long)1L, (long)jobQuery.count());
        Job suspendedJob = (Job)jobQuery.singleResult();
        Assert.assertEquals((Object)jobDefinition.getId(), (Object)suspendedJob.getJobDefinitionId());
        Assert.assertTrue((boolean)suspendedJob.isSuspended());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/mgmt/SuspensionTest.testBase.bpmn"})
    @Test
    public void testSuspensionByProcessDefinitionId_shouldExecuteImmediatelyAndRetainJobs() {
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().singleResult();
        HashMap<String, Boolean> params = new HashMap<String, Boolean>();
        params.put("fail", Boolean.TRUE);
        this.runtimeService.startProcessInstanceByKey("suspensionProcess", params);
        JobDefinition jobDefinition = (JobDefinition)this.managementService.createJobDefinitionQuery().singleResult();
        this.managementService.suspendJobDefinitionByProcessDefinitionId(processDefinition.getId(), false, null);
        JobDefinitionQuery jobDefinitionQuery = this.managementService.createJobDefinitionQuery().suspended();
        Assert.assertEquals((long)1L, (long)jobDefinitionQuery.count());
        JobDefinition suspendedJobDefinition = (JobDefinition)jobDefinitionQuery.singleResult();
        Assert.assertEquals((Object)jobDefinition.getId(), (Object)suspendedJobDefinition.getId());
        Assert.assertTrue((boolean)suspendedJobDefinition.isSuspended());
        JobQuery jobQuery = this.managementService.createJobQuery();
        Assert.assertEquals((long)0L, (long)jobQuery.suspended().count());
        Assert.assertEquals((long)1L, (long)jobQuery.active().count());
        Job activeJob = (Job)jobQuery.active().singleResult();
        Assert.assertEquals((Object)jobDefinition.getId(), (Object)activeJob.getJobDefinitionId());
        Assert.assertFalse((boolean)activeJob.isSuspended());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/mgmt/SuspensionTest.testBase.bpmn"})
    @Test
    public void testSuspensionByProcessDefinitionId_shouldExecuteImmediatelyAndSuspendJobs() {
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().singleResult();
        HashMap<String, Boolean> params = new HashMap<String, Boolean>();
        params.put("fail", Boolean.TRUE);
        this.runtimeService.startProcessInstanceByKey("suspensionProcess", params);
        JobDefinition jobDefinition = (JobDefinition)this.managementService.createJobDefinitionQuery().singleResult();
        this.managementService.suspendJobDefinitionByProcessDefinitionId(processDefinition.getId(), true, null);
        JobDefinitionQuery jobDefinitionQuery = this.managementService.createJobDefinitionQuery().suspended();
        Assert.assertEquals((long)1L, (long)jobDefinitionQuery.count());
        JobDefinition suspendedJobDefinition = (JobDefinition)jobDefinitionQuery.singleResult();
        Assert.assertEquals((Object)jobDefinition.getId(), (Object)suspendedJobDefinition.getId());
        Assert.assertTrue((boolean)suspendedJobDefinition.isSuspended());
        JobQuery jobQuery = this.managementService.createJobQuery().suspended();
        Assert.assertEquals((long)1L, (long)jobQuery.count());
        Job suspendedJob = (Job)jobQuery.singleResult();
        Assert.assertEquals((Object)jobDefinition.getId(), (Object)suspendedJob.getJobDefinitionId());
        Assert.assertTrue((boolean)suspendedJob.isSuspended());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/mgmt/SuspensionTest.testBase.bpmn"})
    @Test
    public void testSuspensionByProcessDefinitionId_shouldExecuteDelayedAndRetainJobs() {
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().singleResult();
        HashMap<String, Boolean> params = new HashMap<String, Boolean>();
        params.put("fail", Boolean.TRUE);
        this.runtimeService.startProcessInstanceByKey("suspensionProcess", params);
        JobDefinition jobDefinition = (JobDefinition)this.managementService.createJobDefinitionQuery().singleResult();
        this.managementService.suspendJobDefinitionByProcessDefinitionId(processDefinition.getId(), false, this.oneWeekLater());
        JobDefinitionQuery jobDefinitionQuery = this.managementService.createJobDefinitionQuery();
        Assert.assertEquals((long)1L, (long)jobDefinitionQuery.active().count());
        Assert.assertEquals((long)0L, (long)jobDefinitionQuery.suspended().count());
        JobQuery jobQuery = this.managementService.createJobQuery();
        Job delayedSuspensionJob = (Job)jobQuery.timers().active().singleResult();
        Assert.assertNotNull((Object)delayedSuspensionJob);
        Assert.assertThat((Object)delayedSuspensionJob.getDeploymentId(), (Matcher)CoreMatchers.is((Object)processDefinition.getDeploymentId()));
        this.managementService.executeJob(delayedSuspensionJob.getId());
        Assert.assertEquals((long)0L, (long)jobDefinitionQuery.active().count());
        Assert.assertEquals((long)1L, (long)jobDefinitionQuery.suspended().count());
        JobDefinition suspendedJobDefinition = (JobDefinition)jobDefinitionQuery.suspended().singleResult();
        Assert.assertEquals((Object)jobDefinition.getId(), (Object)suspendedJobDefinition.getId());
        Assert.assertTrue((boolean)suspendedJobDefinition.isSuspended());
        jobQuery = this.managementService.createJobQuery().active();
        Assert.assertEquals((long)1L, (long)jobQuery.count());
        Job activeJob = (Job)jobQuery.singleResult();
        Assert.assertEquals((Object)jobDefinition.getId(), (Object)activeJob.getJobDefinitionId());
        Assert.assertFalse((boolean)activeJob.isSuspended());
        jobQuery = this.managementService.createJobQuery().suspended();
        Assert.assertEquals((long)0L, (long)jobQuery.count());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/mgmt/SuspensionTest.testBase.bpmn"})
    @Test
    public void testSuspensionByProcessDefinitionId_shouldExecuteDelayedAndSuspendJobs() {
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().singleResult();
        HashMap<String, Boolean> params = new HashMap<String, Boolean>();
        params.put("fail", Boolean.TRUE);
        this.runtimeService.startProcessInstanceByKey("suspensionProcess", params);
        JobDefinition jobDefinition = (JobDefinition)this.managementService.createJobDefinitionQuery().singleResult();
        this.managementService.suspendJobDefinitionByProcessDefinitionId(processDefinition.getId(), true, this.oneWeekLater());
        JobDefinitionQuery jobDefinitionQuery = this.managementService.createJobDefinitionQuery();
        Assert.assertEquals((long)1L, (long)jobDefinitionQuery.active().count());
        Assert.assertEquals((long)0L, (long)jobDefinitionQuery.suspended().count());
        JobQuery jobQuery = this.managementService.createJobQuery();
        Job delayedSuspensionJob = (Job)jobQuery.timers().active().singleResult();
        Assert.assertNotNull((Object)delayedSuspensionJob);
        Assert.assertThat((Object)delayedSuspensionJob.getDeploymentId(), (Matcher)CoreMatchers.is((Object)processDefinition.getDeploymentId()));
        this.managementService.executeJob(delayedSuspensionJob.getId());
        Assert.assertEquals((long)0L, (long)jobDefinitionQuery.active().count());
        Assert.assertEquals((long)1L, (long)jobDefinitionQuery.suspended().count());
        JobDefinition suspendedJobDefinition = (JobDefinition)jobDefinitionQuery.suspended().singleResult();
        Assert.assertEquals((Object)jobDefinition.getId(), (Object)suspendedJobDefinition.getId());
        Assert.assertTrue((boolean)suspendedJobDefinition.isSuspended());
        jobQuery = this.managementService.createJobQuery();
        Assert.assertEquals((long)0L, (long)jobQuery.active().count());
        Assert.assertEquals((long)1L, (long)jobQuery.suspended().count());
        Job suspendedJob = (Job)jobQuery.suspended().singleResult();
        Assert.assertEquals((Object)jobDefinition.getId(), (Object)suspendedJob.getJobDefinitionId());
        Assert.assertTrue((boolean)suspendedJob.isSuspended());
    }

    @Test
    public void testSuspensionByProcessDefinitionKey_shouldThrowProcessEngineException() {
        try {
            this.managementService.suspendJobDefinitionByProcessDefinitionKey(null);
            Assert.fail((String)"A ProcessEngineException was expected.");
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    @Test
    public void testSuspensionByProcessDefinitionKeyAndSuspendJobsFlag_shouldThrowProcessEngineException() {
        try {
            this.managementService.suspendJobDefinitionByProcessDefinitionKey(null, false);
            Assert.fail((String)"A ProcessEngineException was expected.");
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
        try {
            this.managementService.suspendJobDefinitionByProcessDefinitionKey(null, true);
            Assert.fail((String)"A ProcessEngineException was expected.");
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    @Test
    public void testSuspensionByProcessDefinitionKeyAndSuspendJobsFlagAndExecutionDate_shouldThrowProcessEngineException() {
        try {
            this.managementService.suspendJobDefinitionByProcessDefinitionKey(null, false, null);
            Assert.fail((String)"A ProcessEngineException was expected.");
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
        try {
            this.managementService.suspendJobDefinitionByProcessDefinitionKey(null, true, null);
            Assert.fail((String)"A ProcessEngineException was expected.");
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
        try {
            this.managementService.suspendJobDefinitionByProcessDefinitionKey(null, false, new Date());
            Assert.fail((String)"A ProcessEngineException was expected.");
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
        try {
            this.managementService.suspendJobDefinitionByProcessDefinitionKey(null, true, new Date());
            Assert.fail((String)"A ProcessEngineException was expected.");
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/mgmt/SuspensionTest.testBase.bpmn"})
    @Test
    public void testSuspensionByProcessDefinitionKey_shouldRetainJobs() {
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().singleResult();
        HashMap<String, Boolean> params = new HashMap<String, Boolean>();
        params.put("fail", Boolean.TRUE);
        this.runtimeService.startProcessInstanceByKey("suspensionProcess", params);
        JobDefinition jobDefinition = (JobDefinition)this.managementService.createJobDefinitionQuery().singleResult();
        this.managementService.suspendJobDefinitionByProcessDefinitionKey(processDefinition.getKey());
        JobDefinitionQuery jobDefinitionQuery = this.managementService.createJobDefinitionQuery().suspended();
        Assert.assertEquals((long)1L, (long)jobDefinitionQuery.count());
        JobDefinition suspendedJobDefinition = (JobDefinition)jobDefinitionQuery.singleResult();
        Assert.assertEquals((Object)jobDefinition.getId(), (Object)suspendedJobDefinition.getId());
        jobDefinitionQuery = this.managementService.createJobDefinitionQuery().active();
        Assert.assertTrue((boolean)jobDefinitionQuery.list().isEmpty());
        JobQuery jobQuery = this.managementService.createJobQuery();
        Assert.assertEquals((long)0L, (long)jobQuery.suspended().count());
        Assert.assertEquals((long)1L, (long)jobQuery.active().count());
        Job activeJob = (Job)jobQuery.active().singleResult();
        Assert.assertEquals((Object)jobDefinition.getId(), (Object)activeJob.getJobDefinitionId());
        Assert.assertFalse((boolean)activeJob.isSuspended());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/mgmt/SuspensionTest.testBase.bpmn"})
    @Test
    public void testSuspensionByProcessDefinitionKeyAndSuspendJobsFlag_shouldRetainJobs() {
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().singleResult();
        HashMap<String, Boolean> params = new HashMap<String, Boolean>();
        params.put("fail", Boolean.TRUE);
        this.runtimeService.startProcessInstanceByKey("suspensionProcess", params);
        JobDefinition jobDefinition = (JobDefinition)this.managementService.createJobDefinitionQuery().singleResult();
        this.managementService.suspendJobDefinitionByProcessDefinitionKey(processDefinition.getKey(), false);
        JobDefinitionQuery jobDefinitionQuery = this.managementService.createJobDefinitionQuery().suspended();
        Assert.assertEquals((long)1L, (long)jobDefinitionQuery.count());
        JobDefinition suspendedJobDefinition = (JobDefinition)jobDefinitionQuery.singleResult();
        Assert.assertEquals((Object)jobDefinition.getId(), (Object)suspendedJobDefinition.getId());
        Assert.assertTrue((boolean)suspendedJobDefinition.isSuspended());
        JobQuery jobQuery = this.managementService.createJobQuery();
        Assert.assertEquals((long)0L, (long)jobQuery.suspended().count());
        Assert.assertEquals((long)1L, (long)jobQuery.active().count());
        Job activeJob = (Job)jobQuery.active().singleResult();
        Assert.assertEquals((Object)jobDefinition.getId(), (Object)activeJob.getJobDefinitionId());
        Assert.assertFalse((boolean)activeJob.isSuspended());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/mgmt/SuspensionTest.testBase.bpmn"})
    @Test
    public void testSuspensionByProcessDefinitionKeyAndSuspendJobsFlag_shouldSuspendJobs() {
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().singleResult();
        HashMap<String, Boolean> params = new HashMap<String, Boolean>();
        params.put("fail", Boolean.TRUE);
        this.runtimeService.startProcessInstanceByKey("suspensionProcess", params);
        JobDefinition jobDefinition = (JobDefinition)this.managementService.createJobDefinitionQuery().singleResult();
        this.managementService.suspendJobDefinitionByProcessDefinitionKey(processDefinition.getKey(), true);
        JobDefinitionQuery jobDefinitionQuery = this.managementService.createJobDefinitionQuery().suspended();
        Assert.assertEquals((long)1L, (long)jobDefinitionQuery.count());
        JobDefinition suspendedJobDefinition = (JobDefinition)jobDefinitionQuery.singleResult();
        Assert.assertEquals((Object)jobDefinition.getId(), (Object)suspendedJobDefinition.getId());
        Assert.assertTrue((boolean)suspendedJobDefinition.isSuspended());
        JobQuery jobQuery = this.managementService.createJobQuery().suspended();
        Assert.assertEquals((long)1L, (long)jobQuery.count());
        Job suspendedJob = (Job)jobQuery.singleResult();
        Assert.assertEquals((Object)jobDefinition.getId(), (Object)suspendedJob.getJobDefinitionId());
        Assert.assertTrue((boolean)suspendedJob.isSuspended());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/mgmt/SuspensionTest.testBase.bpmn"})
    @Test
    public void testSuspensionByProcessDefinitionKey_shouldExecuteImmediatelyAndRetainJobs() {
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().singleResult();
        HashMap<String, Boolean> params = new HashMap<String, Boolean>();
        params.put("fail", Boolean.TRUE);
        this.runtimeService.startProcessInstanceByKey("suspensionProcess", params);
        JobDefinition jobDefinition = (JobDefinition)this.managementService.createJobDefinitionQuery().singleResult();
        this.managementService.suspendJobDefinitionByProcessDefinitionKey(processDefinition.getKey(), false, null);
        JobDefinitionQuery jobDefinitionQuery = this.managementService.createJobDefinitionQuery().suspended();
        Assert.assertEquals((long)1L, (long)jobDefinitionQuery.count());
        JobDefinition suspendedJobDefinition = (JobDefinition)jobDefinitionQuery.singleResult();
        Assert.assertEquals((Object)jobDefinition.getId(), (Object)suspendedJobDefinition.getId());
        Assert.assertTrue((boolean)suspendedJobDefinition.isSuspended());
        JobQuery jobQuery = this.managementService.createJobQuery();
        Assert.assertEquals((long)0L, (long)jobQuery.suspended().count());
        Assert.assertEquals((long)1L, (long)jobQuery.active().count());
        Job activeJob = (Job)jobQuery.active().singleResult();
        Assert.assertEquals((Object)jobDefinition.getId(), (Object)activeJob.getJobDefinitionId());
        Assert.assertFalse((boolean)activeJob.isSuspended());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/mgmt/SuspensionTest.testBase.bpmn"})
    @Test
    public void testSuspensionByProcessDefinitionKey_shouldExecuteImmediatelyAndSuspendJobs() {
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().singleResult();
        HashMap<String, Boolean> params = new HashMap<String, Boolean>();
        params.put("fail", Boolean.TRUE);
        this.runtimeService.startProcessInstanceByKey("suspensionProcess", params);
        JobDefinition jobDefinition = (JobDefinition)this.managementService.createJobDefinitionQuery().singleResult();
        this.managementService.suspendJobDefinitionByProcessDefinitionKey(processDefinition.getKey(), true, null);
        JobDefinitionQuery jobDefinitionQuery = this.managementService.createJobDefinitionQuery().suspended();
        Assert.assertEquals((long)1L, (long)jobDefinitionQuery.count());
        JobDefinition suspendedJobDefinition = (JobDefinition)jobDefinitionQuery.singleResult();
        Assert.assertEquals((Object)jobDefinition.getId(), (Object)suspendedJobDefinition.getId());
        Assert.assertTrue((boolean)suspendedJobDefinition.isSuspended());
        JobQuery jobQuery = this.managementService.createJobQuery().suspended();
        Assert.assertEquals((long)1L, (long)jobQuery.count());
        Job suspendedJob = (Job)jobQuery.singleResult();
        Assert.assertEquals((Object)jobDefinition.getId(), (Object)suspendedJob.getJobDefinitionId());
        Assert.assertTrue((boolean)suspendedJob.isSuspended());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/mgmt/SuspensionTest.testBase.bpmn"})
    @Test
    public void testSuspensionByProcessDefinitionKey_shouldExecuteDelayedAndRetainJobs() {
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().singleResult();
        HashMap<String, Boolean> params = new HashMap<String, Boolean>();
        params.put("fail", Boolean.TRUE);
        this.runtimeService.startProcessInstanceByKey("suspensionProcess", params);
        JobDefinition jobDefinition = (JobDefinition)this.managementService.createJobDefinitionQuery().singleResult();
        this.managementService.suspendJobDefinitionByProcessDefinitionKey(processDefinition.getKey(), false, this.oneWeekLater());
        JobDefinitionQuery jobDefinitionQuery = this.managementService.createJobDefinitionQuery();
        Assert.assertEquals((long)1L, (long)jobDefinitionQuery.active().count());
        Assert.assertEquals((long)0L, (long)jobDefinitionQuery.suspended().count());
        JobQuery jobQuery = this.managementService.createJobQuery();
        Job delayedSuspensionJob = (Job)jobQuery.timers().active().singleResult();
        Assert.assertNotNull((Object)delayedSuspensionJob);
        Assert.assertThat((Object)delayedSuspensionJob.getDeploymentId(), (Matcher)CoreMatchers.is((Object)processDefinition.getDeploymentId()));
        this.managementService.executeJob(delayedSuspensionJob.getId());
        Assert.assertEquals((long)0L, (long)jobDefinitionQuery.active().count());
        Assert.assertEquals((long)1L, (long)jobDefinitionQuery.suspended().count());
        JobDefinition suspendedJobDefinition = (JobDefinition)jobDefinitionQuery.suspended().singleResult();
        Assert.assertEquals((Object)jobDefinition.getId(), (Object)suspendedJobDefinition.getId());
        Assert.assertTrue((boolean)suspendedJobDefinition.isSuspended());
        jobQuery = this.managementService.createJobQuery();
        Assert.assertEquals((long)0L, (long)jobQuery.suspended().count());
        Assert.assertEquals((long)1L, (long)jobQuery.active().count());
        Job activeJob = (Job)jobQuery.active().singleResult();
        Assert.assertEquals((Object)jobDefinition.getId(), (Object)activeJob.getJobDefinitionId());
        Assert.assertFalse((boolean)activeJob.isSuspended());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/mgmt/SuspensionTest.testBase.bpmn"})
    @Test
    public void testSuspensionByProcessDefinitionKey_shouldExecuteDelayedAndSuspendJobs() {
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().singleResult();
        HashMap<String, Boolean> params = new HashMap<String, Boolean>();
        params.put("fail", Boolean.TRUE);
        this.runtimeService.startProcessInstanceByKey("suspensionProcess", params);
        JobDefinition jobDefinition = (JobDefinition)this.managementService.createJobDefinitionQuery().singleResult();
        this.managementService.suspendJobDefinitionByProcessDefinitionKey(processDefinition.getKey(), true, this.oneWeekLater());
        JobDefinitionQuery jobDefinitionQuery = this.managementService.createJobDefinitionQuery();
        Assert.assertEquals((long)1L, (long)jobDefinitionQuery.active().count());
        Assert.assertEquals((long)0L, (long)jobDefinitionQuery.suspended().count());
        JobQuery jobQuery = this.managementService.createJobQuery();
        Job delayedSuspensionJob = (Job)jobQuery.timers().active().singleResult();
        Assert.assertNotNull((Object)delayedSuspensionJob);
        Assert.assertThat((Object)delayedSuspensionJob.getDeploymentId(), (Matcher)CoreMatchers.is((Object)processDefinition.getDeploymentId()));
        this.managementService.executeJob(delayedSuspensionJob.getId());
        Assert.assertEquals((long)0L, (long)jobDefinitionQuery.active().count());
        Assert.assertEquals((long)1L, (long)jobDefinitionQuery.suspended().count());
        JobDefinition suspendedJobDefinition = (JobDefinition)jobDefinitionQuery.suspended().singleResult();
        Assert.assertEquals((Object)jobDefinition.getId(), (Object)suspendedJobDefinition.getId());
        Assert.assertTrue((boolean)suspendedJobDefinition.isSuspended());
        jobQuery = this.managementService.createJobQuery();
        Assert.assertEquals((long)0L, (long)jobQuery.active().count());
        Assert.assertEquals((long)1L, (long)jobQuery.suspended().count());
        Job suspendedJob = (Job)jobQuery.suspended().singleResult();
        Assert.assertEquals((Object)jobDefinition.getId(), (Object)suspendedJob.getJobDefinitionId());
        Assert.assertTrue((boolean)suspendedJob.isSuspended());
    }

    @Test
    public void testMultipleSuspensionByProcessDefinitionKey_shouldRetainJobs() {
        String key = "suspensionProcess";
        int nrOfProcessDefinitions = 3;
        for (int i = 0; i < nrOfProcessDefinitions; ++i) {
            this.repositoryService.createDeployment().addClasspathResource("org/camunda/bpm/engine/test/api/mgmt/SuspensionTest.testBase.bpmn").deploy();
            HashMap<String, Boolean> params = new HashMap<String, Boolean>();
            params.put("fail", Boolean.TRUE);
            this.runtimeService.startProcessInstanceByKey(key, params);
        }
        this.managementService.suspendJobDefinitionByProcessDefinitionKey(key);
        JobDefinitionQuery jobDefinitionQuery = this.managementService.createJobDefinitionQuery();
        Assert.assertEquals((long)3L, (long)jobDefinitionQuery.suspended().count());
        Assert.assertEquals((long)0L, (long)jobDefinitionQuery.active().count());
        JobQuery jobQuery = this.managementService.createJobQuery();
        Assert.assertEquals((long)0L, (long)jobQuery.suspended().count());
        Assert.assertEquals((long)3L, (long)jobQuery.active().count());
        for (org.camunda.bpm.engine.repository.Deployment deployment : this.repositoryService.createDeploymentQuery().list()) {
            this.repositoryService.deleteDeployment(deployment.getId(), true);
        }
    }

    @Test
    public void testMultipleSuspensionByProcessDefinitionKeyAndSuspendJobsFlag_shouldRetainJobs() {
        String key = "suspensionProcess";
        int nrOfProcessDefinitions = 3;
        for (int i = 0; i < nrOfProcessDefinitions; ++i) {
            this.repositoryService.createDeployment().addClasspathResource("org/camunda/bpm/engine/test/api/mgmt/SuspensionTest.testBase.bpmn").deploy();
            HashMap<String, Boolean> params = new HashMap<String, Boolean>();
            params.put("fail", Boolean.TRUE);
            this.runtimeService.startProcessInstanceByKey(key, params);
        }
        this.managementService.suspendJobDefinitionByProcessDefinitionKey(key, false);
        JobDefinitionQuery jobDefinitionQuery = this.managementService.createJobDefinitionQuery();
        Assert.assertEquals((long)3L, (long)jobDefinitionQuery.suspended().count());
        Assert.assertEquals((long)0L, (long)jobDefinitionQuery.active().count());
        JobQuery jobQuery = this.managementService.createJobQuery();
        Assert.assertEquals((long)0L, (long)jobQuery.suspended().count());
        Assert.assertEquals((long)3L, (long)jobQuery.active().count());
        for (org.camunda.bpm.engine.repository.Deployment deployment : this.repositoryService.createDeploymentQuery().list()) {
            this.repositoryService.deleteDeployment(deployment.getId(), true);
        }
    }

    @Test
    public void testMultipleSuspensionByProcessDefinitionKeyAndSuspendJobsFlag_shouldSuspendJobs() {
        String key = "suspensionProcess";
        int nrOfProcessDefinitions = 3;
        for (int i = 0; i < nrOfProcessDefinitions; ++i) {
            this.repositoryService.createDeployment().addClasspathResource("org/camunda/bpm/engine/test/api/mgmt/SuspensionTest.testBase.bpmn").deploy();
            HashMap<String, Boolean> params = new HashMap<String, Boolean>();
            params.put("fail", Boolean.TRUE);
            this.runtimeService.startProcessInstanceByKey(key, params);
        }
        this.managementService.suspendJobDefinitionByProcessDefinitionKey(key, true);
        JobDefinitionQuery jobDefinitionQuery = this.managementService.createJobDefinitionQuery();
        Assert.assertEquals((long)3L, (long)jobDefinitionQuery.suspended().count());
        Assert.assertEquals((long)0L, (long)jobDefinitionQuery.active().count());
        JobQuery jobQuery = this.managementService.createJobQuery();
        Assert.assertEquals((long)3L, (long)jobQuery.suspended().count());
        Assert.assertEquals((long)0L, (long)jobQuery.active().count());
        for (org.camunda.bpm.engine.repository.Deployment deployment : this.repositoryService.createDeploymentQuery().list()) {
            this.repositoryService.deleteDeployment(deployment.getId(), true);
        }
    }

    @Test
    public void testMultipleSuspensionByProcessDefinitionKey_shouldExecuteImmediatelyAndRetainJobs() {
        String key = "suspensionProcess";
        int nrOfProcessDefinitions = 3;
        for (int i = 0; i < nrOfProcessDefinitions; ++i) {
            this.repositoryService.createDeployment().addClasspathResource("org/camunda/bpm/engine/test/api/mgmt/SuspensionTest.testBase.bpmn").deploy();
            HashMap<String, Boolean> params = new HashMap<String, Boolean>();
            params.put("fail", Boolean.TRUE);
            this.runtimeService.startProcessInstanceByKey(key, params);
        }
        this.managementService.suspendJobDefinitionByProcessDefinitionKey(key, false, null);
        JobDefinitionQuery jobDefinitionQuery = this.managementService.createJobDefinitionQuery();
        Assert.assertEquals((long)3L, (long)jobDefinitionQuery.suspended().count());
        Assert.assertEquals((long)0L, (long)jobDefinitionQuery.active().count());
        JobQuery jobQuery = this.managementService.createJobQuery();
        Assert.assertEquals((long)0L, (long)jobQuery.suspended().count());
        Assert.assertEquals((long)3L, (long)jobQuery.active().count());
        for (org.camunda.bpm.engine.repository.Deployment deployment : this.repositoryService.createDeploymentQuery().list()) {
            this.repositoryService.deleteDeployment(deployment.getId(), true);
        }
    }

    @Test
    public void testMultipleSuspensionByProcessDefinitionKey_shouldExecuteImmediatelyAndSuspendJobs() {
        String key = "suspensionProcess";
        int nrOfProcessDefinitions = 3;
        for (int i = 0; i < nrOfProcessDefinitions; ++i) {
            this.repositoryService.createDeployment().addClasspathResource("org/camunda/bpm/engine/test/api/mgmt/SuspensionTest.testBase.bpmn").deploy();
            HashMap<String, Boolean> params = new HashMap<String, Boolean>();
            params.put("fail", Boolean.TRUE);
            this.runtimeService.startProcessInstanceByKey(key, params);
        }
        this.managementService.suspendJobDefinitionByProcessDefinitionKey(key, true, null);
        JobDefinitionQuery jobDefinitionQuery = this.managementService.createJobDefinitionQuery();
        Assert.assertEquals((long)3L, (long)jobDefinitionQuery.suspended().count());
        Assert.assertEquals((long)0L, (long)jobDefinitionQuery.active().count());
        JobQuery jobQuery = this.managementService.createJobQuery();
        Assert.assertEquals((long)3L, (long)jobQuery.suspended().count());
        Assert.assertEquals((long)0L, (long)jobQuery.active().count());
        for (org.camunda.bpm.engine.repository.Deployment deployment : this.repositoryService.createDeploymentQuery().list()) {
            this.repositoryService.deleteDeployment(deployment.getId(), true);
        }
    }

    @Test
    public void testMultipleSuspensionByProcessDefinitionKey_shouldExecuteDelayedAndRetainJobs() {
        String key = "suspensionProcess";
        int nrOfProcessDefinitions = 3;
        for (int i = 0; i < nrOfProcessDefinitions; ++i) {
            this.repositoryService.createDeployment().addClasspathResource("org/camunda/bpm/engine/test/api/mgmt/SuspensionTest.testBase.bpmn").deploy();
            HashMap<String, Boolean> params = new HashMap<String, Boolean>();
            params.put("fail", Boolean.TRUE);
            this.runtimeService.startProcessInstanceByKey(key, params);
        }
        this.managementService.suspendJobDefinitionByProcessDefinitionKey(key, false, this.oneWeekLater());
        JobDefinitionQuery jobDefinitionQuery = this.managementService.createJobDefinitionQuery();
        Assert.assertEquals((long)3L, (long)jobDefinitionQuery.active().count());
        Assert.assertEquals((long)0L, (long)jobDefinitionQuery.suspended().count());
        JobQuery jobQuery = this.managementService.createJobQuery();
        Job delayedSuspensionJob = (Job)jobQuery.timers().active().singleResult();
        Assert.assertNotNull((Object)delayedSuspensionJob);
        String expectedDeploymentId = ((ProcessDefinition)((ProcessDefinitionQuery)this.repositoryService.createProcessDefinitionQuery().orderByProcessDefinitionVersion().desc()).list().get(0)).getDeploymentId();
        Assert.assertThat((Object)delayedSuspensionJob.getDeploymentId(), (Matcher)CoreMatchers.is((Object)expectedDeploymentId));
        this.managementService.executeJob(delayedSuspensionJob.getId());
        Assert.assertEquals((long)0L, (long)jobDefinitionQuery.active().count());
        Assert.assertEquals((long)3L, (long)jobDefinitionQuery.suspended().count());
        jobQuery = this.managementService.createJobQuery();
        Assert.assertEquals((long)0L, (long)jobQuery.suspended().count());
        Assert.assertEquals((long)3L, (long)jobQuery.active().count());
        for (org.camunda.bpm.engine.repository.Deployment deployment : this.repositoryService.createDeploymentQuery().list()) {
            this.repositoryService.deleteDeployment(deployment.getId(), true);
        }
    }

    @Test
    public void testMultipleSuspensionByProcessDefinitionKey_shouldExecuteDelayedAndSuspendJobs() {
        String key = "suspensionProcess";
        int nrOfProcessDefinitions = 3;
        for (int i = 0; i < nrOfProcessDefinitions; ++i) {
            this.repositoryService.createDeployment().addClasspathResource("org/camunda/bpm/engine/test/api/mgmt/SuspensionTest.testBase.bpmn").deploy();
            HashMap<String, Boolean> params = new HashMap<String, Boolean>();
            params.put("fail", Boolean.TRUE);
            this.runtimeService.startProcessInstanceByKey(key, params);
        }
        this.managementService.suspendJobDefinitionByProcessDefinitionKey(key, true, this.oneWeekLater());
        JobDefinitionQuery jobDefinitionQuery = this.managementService.createJobDefinitionQuery();
        Assert.assertEquals((long)3L, (long)jobDefinitionQuery.active().count());
        Assert.assertEquals((long)0L, (long)jobDefinitionQuery.suspended().count());
        JobQuery jobQuery = this.managementService.createJobQuery();
        Job delayedSuspensionJob = (Job)jobQuery.timers().active().singleResult();
        Assert.assertNotNull((Object)delayedSuspensionJob);
        String expectedDeploymentId = ((ProcessDefinition)((ProcessDefinitionQuery)this.repositoryService.createProcessDefinitionQuery().orderByProcessDefinitionVersion().desc()).list().get(0)).getDeploymentId();
        Assert.assertThat((Object)delayedSuspensionJob.getDeploymentId(), (Matcher)CoreMatchers.is((Object)expectedDeploymentId));
        this.managementService.executeJob(delayedSuspensionJob.getId());
        Assert.assertEquals((long)0L, (long)jobDefinitionQuery.active().count());
        Assert.assertEquals((long)3L, (long)jobDefinitionQuery.suspended().count());
        jobQuery = this.managementService.createJobQuery();
        Assert.assertEquals((long)0L, (long)jobQuery.active().count());
        Assert.assertEquals((long)3L, (long)jobQuery.suspended().count());
        for (org.camunda.bpm.engine.repository.Deployment deployment : this.repositoryService.createDeploymentQuery().list()) {
            this.repositoryService.deleteDeployment(deployment.getId(), true);
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/mgmt/SuspensionTest.testBase.bpmn"})
    @Test
    public void testSuspensionByIdUsingBuilder() {
        this.runtimeService.startProcessInstanceByKey("suspensionProcess", (Map)Variables.createVariables().putValue("fail", (Object)true));
        JobDefinitionQuery query = this.managementService.createJobDefinitionQuery();
        JobDefinition jobDefinition = (JobDefinition)query.singleResult();
        Assert.assertFalse((boolean)jobDefinition.isSuspended());
        this.managementService.updateJobDefinitionSuspensionState().byJobDefinitionId(jobDefinition.getId()).suspend();
        Assert.assertEquals((long)1L, (long)query.suspended().count());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/mgmt/SuspensionTest.testBase.bpmn"})
    @Test
    public void testSuspensionByProcessDefinitionIdUsingBuilder() {
        this.runtimeService.startProcessInstanceByKey("suspensionProcess", (Map)Variables.createVariables().putValue("fail", (Object)true));
        JobDefinitionQuery query = this.managementService.createJobDefinitionQuery();
        JobDefinition jobDefinition = (JobDefinition)query.singleResult();
        Assert.assertFalse((boolean)jobDefinition.isSuspended());
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().singleResult();
        this.managementService.updateJobDefinitionSuspensionState().byProcessDefinitionId(processDefinition.getId()).suspend();
        Assert.assertEquals((long)1L, (long)query.suspended().count());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/mgmt/SuspensionTest.testBase.bpmn"})
    @Test
    public void testSuspensionByProcessDefinitionKeyUsingBuilder() {
        this.runtimeService.startProcessInstanceByKey("suspensionProcess", (Map)Variables.createVariables().putValue("fail", (Object)true));
        JobDefinitionQuery query = this.managementService.createJobDefinitionQuery();
        JobDefinition jobDefinition = (JobDefinition)query.singleResult();
        Assert.assertFalse((boolean)jobDefinition.isSuspended());
        this.managementService.updateJobDefinitionSuspensionState().byProcessDefinitionKey("suspensionProcess").suspend();
        Assert.assertEquals((long)1L, (long)query.suspended().count());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/mgmt/SuspensionTest.testBase.bpmn"})
    @Test
    public void testSuspensionJobDefinitionIncludeJobsdUsingBuilder() {
        this.runtimeService.startProcessInstanceByKey("suspensionProcess", (Map)Variables.createVariables().putValue("fail", (Object)true));
        JobDefinitionQuery query = this.managementService.createJobDefinitionQuery();
        JobDefinition jobDefinition = (JobDefinition)query.singleResult();
        Assert.assertFalse((boolean)jobDefinition.isSuspended());
        JobQuery jobQuery = this.managementService.createJobQuery();
        Assert.assertEquals((long)0L, (long)jobQuery.suspended().count());
        Assert.assertEquals((long)1L, (long)jobQuery.active().count());
        this.managementService.updateJobDefinitionSuspensionState().byJobDefinitionId(jobDefinition.getId()).includeJobs(true).suspend();
        Assert.assertEquals((long)1L, (long)query.suspended().count());
        Assert.assertEquals((long)1L, (long)jobQuery.suspended().count());
        Assert.assertEquals((long)0L, (long)jobQuery.active().count());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/mgmt/SuspensionTest.testBase.bpmn"})
    @Test
    public void testDelayedSuspensionUsingBuilder() {
        this.runtimeService.startProcessInstanceByKey("suspensionProcess", (Map)Variables.createVariables().putValue("fail", (Object)true));
        JobDefinitionQuery query = this.managementService.createJobDefinitionQuery();
        JobDefinition jobDefinition = (JobDefinition)query.singleResult();
        this.managementService.updateJobDefinitionSuspensionState().byJobDefinitionId(jobDefinition.getId()).executionDate(this.oneWeekLater()).suspend();
        Assert.assertEquals((long)1L, (long)query.active().count());
        Assert.assertEquals((long)0L, (long)query.suspended().count());
        Job delayedSuspensionJob = (Job)this.managementService.createJobQuery().timers().active().singleResult();
        Assert.assertNotNull((Object)delayedSuspensionJob);
        String expectedDeploymentId = ((ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().processDefinitionId(jobDefinition.getProcessDefinitionId()).singleResult()).getDeploymentId();
        Assert.assertThat((Object)delayedSuspensionJob.getDeploymentId(), (Matcher)CoreMatchers.is((Object)expectedDeploymentId));
        this.managementService.executeJob(delayedSuspensionJob.getId());
        Assert.assertEquals((long)0L, (long)query.active().count());
        Assert.assertEquals((long)1L, (long)query.suspended().count());
    }

    protected Date oneWeekLater() {
        Date startTime = new Date();
        ClockUtil.setCurrentTime((Date)startTime);
        long oneWeekFromStartTime = startTime.getTime() + 604800000L;
        return new Date(oneWeekFromStartTime);
    }
}

